package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.WarehouseIssueStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseIssueStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseIssueTotalStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
 * 仓库出库统计服务接口
 *
 * @author 天泽
 * @since 2022-08-24
 */
@Api(tags = {"仓库出库统计服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IWarehouseIssueStatisticsQueryApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/warehouseIssueStatistics",
        url = "${tcbj.center.report.api:}"
)
public interface IWarehouseIssueStatisticsQueryApi {

    /**
     * 根据id查询仓库出库统计
     *
     * @param id 仓库出库统计id
     * @return 仓库出库统计数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓库出库统计", notes = "根据id查询仓库出库统计")
    RestResponse<WarehouseIssueStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 仓库出库统计分页数据
     *
     * @param filter   仓库出库统计查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 仓库出库统计分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "仓库出库统计分页数据", notes = "根据filter查询条件查询仓库出库统计数据，filter=WarehouseIssueStatisticsReqDto")
    RestResponse<PageInfo<WarehouseIssueStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 仓库出库统计更新时间
     *
     * @return 仓库出库统计更新时间
     */
    @GetMapping("/query/updateTime")
    @ApiOperation(value = "仓库出库统计更新时间", notes = "仓库出库统计更新时间")
    RestResponse<String> queryUpdateTime();

    /**
     * 仓库出库统计更新时间
     *
     * @return 仓库出库统计更新时间
     */
    @GetMapping("/query/updateTimeExt")
    @ApiOperation(value = "仓库出库统计更新时间", notes = "仓库出库统计更新时间")
    RestResponse<String> queryUpdateTimeExt();
    /**
     * 仓库出库统计-合计
     *
     * @return 仓库出库统计-合计
     */
    @GetMapping("/query/TotalStatistics")
    @ApiOperation(value = "仓库出库统计-合计", notes = "仓库出库统计-合计")
    RestResponse<WarehouseIssueTotalStatisticsRespDto> queryTotalStatistics();

    /**
     * 仓库出库统计-合计
     *
     * @return 仓库出库统计-合计
     */
    @GetMapping("/query/TotalStatisticsExt/{type}")
    @ApiOperation(value = "仓库出库统计-合计", notes = "仓库出库统计-合计")
    RestResponse<WarehouseIssueTotalStatisticsRespDto> queryTotalStatisticsExt(@PathVariable("type") String type);

}
