package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description:
 * @since 2022-01-11 14:20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "RebateDetailRespDto", description = "折扣汇总")
public class RebateDetailRespDto extends ReportBrandBaseRespDto {

    @ApiModelProperty(name = "balanceBroughtForward", value = "上期结转")
    private BigDecimal balanceBroughtForward;

    @ApiModelProperty(name = "discountPay", value = "折扣充值")
    private BigDecimal discountPay;

    @ApiModelProperty(name = "useDiscountAmount", value = "折扣使用")
    private BigDecimal useDiscountAmount;

    @ApiModelProperty(name = "discountOverdue", value = "折扣过期")
    private BigDecimal discountOverdue;

    @ApiModelProperty(name = "discountAmount", value = "折扣金额")
    private BigDecimal discountAmount;

    @ApiModelProperty(name = "remainderAllowUseDiscountAmount", value = "剩余可用折扣")
    private BigDecimal remainderAllowUseDiscountAmount;

    private BigDecimal orderUse;//订单抵扣

    private BigDecimal orderCancel;//订单取消

    private BigDecimal tradeAmount;

    private Integer type;
}
