package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.OtherStorageOrderRelInspectionOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

@Api(tags = {"其他出入口表服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        url = "${tcbj.center.report.api:}",
        path = "/v1/otherStorage"
)
public interface ICsOtherStorageOrderQueryApi {

    @PostMapping("/queryRelInspectionOrderList/{longCode}/{batch}")
    @ApiOperation(value = "查询待检出库（其他出库信息）", notes = "查询待检出库（其他出库信息）")
    RestResponse<List<OtherStorageOrderRelInspectionOrderRespDto>> queryRelInspectionOrderList(@PathVariable("longCode") String longCode, @PathVariable("batch") String batch);
}
