package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StrategyAutoCheckRuleReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.StrategyAutoCheckRuleReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 服务接口
 *
 * @author shuyi
 * @since 2022-04-07
 */
@Api(tags = {"订单自动审核策略"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/strategyAutoCheckRuleReport", url = "${tcbj.center.report.api:}")
public interface IStrategyAutoCheckRuleReportQueryApi {

    /**
     * 分页数据
     *
     * @param strategyAutoCheckRuleReportReqDto 查询条件
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=StrategyAutoCheckRuleReqDto")
    RestResponse<PageInfo<StrategyAutoCheckRuleReportRespDto>> queryByPage(@RequestBody StrategyAutoCheckRuleReportReqDto strategyAutoCheckRuleReportReqDto);


}
