package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
* 物理仓库存表Eo对象
*
* @author wude
* @since 2022-03-07
*/
@ApiModel(value = "PhysicsInventoryRespDto", description = "物理仓库存表Eo对象")
public class PhysicsInventoryCountDto extends ResponseDto{

    /**
    *  总库存
    */
    @ApiModelProperty(name = "countBalance", value = "总库存")
    private BigDecimal countBalance;
    /**
    *  预占库存
    */
    @ApiModelProperty(name = "countPreempt", value = "预占库存")
    private BigDecimal countPreempt;
    /**
    *  已分配库存
    */
    @ApiModelProperty(name = "countAllocate", value = "已分配库存")
    private BigDecimal countAllocate;
    /**
    *  活动分配库存
    */
    @ApiModelProperty(name = "countActivityAllocate", value = "活动分配库存")
    private BigDecimal countActivityAllocate;
    /**
    *  在途库存
    */
    @ApiModelProperty(name = "countIntransit", value = "在途库存")
    private BigDecimal countIntransit;
    /**
    *  已调拨库存
    */
    @ApiModelProperty(name = "countTransfer", value = "已调拨库存")
    private BigDecimal countTransfer;
    /**
    *  已完成库存
    */
    @ApiModelProperty(name = "countCompleted", value = "已完成库存")
    private BigDecimal countCompleted;
    /**
    *  可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存
    */
    @ApiModelProperty(name = "countAvailable", value = "可用库存,可用库存 = 总库存 + 在途库存 - 已完成库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal countAvailable;
    /**
     *  待收库存
     */
    @ApiModelProperty(name = "countFutureIn", value = "待收库存")
    private BigDecimal countFutureIn;
    /**
     *  合计总数
     */
    @ApiModelProperty(name = "totalCount", value = "合计总数")
    private BigDecimal totalCount;
    public BigDecimal getCountBalance() {
        return countBalance;
    }

    public void setCountBalance(BigDecimal countBalance) {
        this.countBalance = countBalance;
    }

    public BigDecimal getCountPreempt() {
        return countPreempt;
    }

    public void setCountPreempt(BigDecimal countPreempt) {
        this.countPreempt = countPreempt;
    }

    public BigDecimal getCountAllocate() {
        return countAllocate;
    }

    public void setCountAllocate(BigDecimal countAllocate) {
        this.countAllocate = countAllocate;
    }

    public BigDecimal getCountActivityAllocate() {
        return countActivityAllocate;
    }

    public void setCountActivityAllocate(BigDecimal countActivityAllocate) {
        this.countActivityAllocate = countActivityAllocate;
    }

    public BigDecimal getCountIntransit() {
        return countIntransit;
    }

    public void setCountIntransit(BigDecimal countIntransit) {
        this.countIntransit = countIntransit;
    }

    public BigDecimal getCountTransfer() {
        return countTransfer;
    }

    public void setCountTransfer(BigDecimal countTransfer) {
        this.countTransfer = countTransfer;
    }

    public BigDecimal getCountCompleted() {
        return countCompleted;
    }

    public void setCountCompleted(BigDecimal countCompleted) {
        this.countCompleted = countCompleted;
    }

    public BigDecimal getCountAvailable() {
        return countAvailable;
    }

    public void setCountAvailable(BigDecimal countAvailable) {
        this.countAvailable = countAvailable;
    }

    public BigDecimal getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(BigDecimal totalCount) {
        this.totalCount = totalCount;
    }

    public BigDecimal getCountFutureIn() {
        return countFutureIn;
    }

    public void setCountFutureIn(BigDecimal countFutureIn) {
        this.countFutureIn = countFutureIn;
    }
}
