package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "ConsignmentOrderReportReDto", description = "运单Eo对象")
@Data
public class ConsignmentOrderReportReDto {
    /**
     *  主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     *  运单号
     */
    @ApiModelProperty(name = "consignmentNo", value = "运单号/托运单号")
    private String consignmentNo;

    @ApiModelProperty(name = "consignmentNoList", value = "运单号/托运单号")
    private List<String> consignmentNoList;

    @ApiModelProperty(name = "transferConsignmentNoList", value = "转运运单号集合")
    private List<String> transferConsignmentNoList;

    @ApiModelProperty(name = "businessNo", value = "业务单号/出库结果单号/出库通知单号")
    private String businessNo;

    @ApiModelProperty(name = "carrierName", value = "承运商名称")
    private String carrierName;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "carrierType", value = "承运方式")
    private String carrierType;

    /**
     *  业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    @ApiModelProperty(name = "consignmentType", value = "运单类型：1:原单 2:转运单")
    private Integer consignmentType;
    @ApiModelProperty(name = "physicsWarehouseName", value = "发货物理仓名称")
    private String physicsWarehouseName;
    @ApiModelProperty(name = "transportPhysicsWarehouseName", value = "转运物理仓")
    private String transportPhysicsWarehouseName;
    @ApiModelProperty(name="orderStatus",value = "运单状态")
    private Integer orderStatus;
    @ApiModelProperty(name="ifTransport",value = "是否转运,0是 1否")
    private Integer ifTransport;
    @ApiModelProperty(name = "carLicenseNo", value = "车牌号")
    private String carLicenseNo;
    @ApiModelProperty(name = "updateTime", value = "创建时间开始")
    private String createStartTime;
    @ApiModelProperty(name = "updateTime", value = "创建时间结束")
    private String createEndTime;

    private Integer pageNum;
    private Integer pageSize;
}
