/**
 * @(#)CsLogicInventoryTotalRespDto.java 1.0 2022/01/12 09:18
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Description CsLogicInventoryTotalRespDto
 *
 * @author jingran
 * @Date: 2022/01/12 09:18
 * @since 1.0.0
 */
@ApiModel(value = "csLogicInventoryTotalRespDto", description = "返回信息Dto")
@Data
public class CsLogicInventoryTotalRespDto extends BaseRespDto {

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;


    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品长编码 */
    @ApiModelProperty(name="longCode",value = "货品长编码")
    private String longCode;
    /** 总库存 */
    @ApiModelProperty(name="balance",value = "总库存")
    private BigDecimal balance;
    /** 预占库存 */
    @ApiModelProperty(name="preempt",value = "预占库存")
    private BigDecimal preempt;
    /** 已分配库存 */
    @ApiModelProperty(name="allocate",value = "已分配库存")
    private BigDecimal allocate;
    /** 活动分配库存 */
    @ApiModelProperty(name="activityAllocate",value = "活动分配库存")
    private BigDecimal activityAllocate;
    /** 在途库存 */
    @ApiModelProperty(name="intransit",value = "在途库存")
    private BigDecimal intransit;
    /** 已调拨库存 */
    @ApiModelProperty(name="transfer",value = "已调拨库存")
    private BigDecimal transfer;
    /** 已完成库存 */
    @ApiModelProperty(name="completed",value = "已完成库存")
    private BigDecimal completed;
    /** 可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存 */
    @ApiModelProperty(name="available",value = "可用库存,可用库存 = 总库存 + 在途库存  - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;

    @ApiModelProperty(name = "lock_inventory", value = "锁定库存")
    private BigDecimal lockInventory;

    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

}
