
package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.ShInventoryPageQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.RelShareInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShInventoryPreemptionRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* 供货仓库存表服务接口
*/
@Api(tags = {"供货仓库存表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/virtualInventory", url = "${tcbj.center.report.api:}")
public interface IVirtualInventoryQueryApi {


    @PostMapping("/queryRelLogicInventory/{virtualWarehouseCode}/{cargoCode}")
    @ApiOperation(value = "查询关联逻辑仓库存", notes = "查询关联逻辑仓库存")
    RestResponse<List<RelShareInventoryRespDto>> queryRelLogicInventory(@PathVariable("virtualWarehouseCode") String virtualWarehouseCode,
                                                            @PathVariable("cargoCode") String cargoCode);

    @PostMapping("/queryModelLogicInventory/{virtualWarehouseCode}/{cargoCode}")
    @ApiOperation(value = "四层模型查询关联逻辑仓库存", notes = "查询关联逻辑仓库存")
    RestResponse<List<RelShareInventoryRespDto>> queryModelLogicInventory(@PathVariable("virtualWarehouseCode") String virtualWarehouseCode,
                                                                        @PathVariable("cargoCode") String cargoCode);
}
