package com.dtyunxi.tcbj.api.dto.constant.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author minyue
 * @description: 订单售后单枚举
 * @since 2022-01-06 16:47
 */
public enum OrderStatisticsServiceEnum {

    ORDER_SERVICE(1, "orderQueryServiceImpl", "订单"),
    AFTER_SERVICE(2, "afterSaleQueryServiceImpl", "售后单");

    private Integer code;

    private String name;

    private String desc;

    OrderStatisticsServiceEnum(Integer code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public static String getNameByCode(Integer code) {
        return Objects.requireNonNull(Arrays.stream(OrderStatisticsServiceEnum.values()).filter(enums -> enums.getCode().equals(code)).findFirst().orElse(null)).getName();
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

}
