package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.WarehouseIssueStatisticsReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 仓库出库统计服务接口
 *
 * @author 天泽
 * @since 2022-08-24
 */
@Api(tags = {"仓库出库统计服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IWarehouseIssueStatisticsApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/warehouseIssueStatistics",
        url = "${tcbj.center.report.api:}"
)
public interface IWarehouseIssueStatisticsApi {

    /**
     * 新增仓库出库统计
     *
     * @param addReqDto 仓库出库统计请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增仓库出库统计", notes = "新增仓库出库统计")
    RestResponse<Long> addWarehouseIssueStatistics(@RequestBody WarehouseIssueStatisticsReqDto addReqDto);

    /**
     * 刷新出库统计
     *
     * @return 处理结果
     */
    @GetMapping("/refresh")
    @ApiOperation(value = "刷新出库统计", notes = "刷新出库统计")
    RestResponse<Void> refreshWarehouseIssueStatistics();
    /**
     * 刷新出库统计
     *
     * @return 处理结果
     */
    @GetMapping("/refresh/ext")
    @ApiOperation(value = "刷新出库统计", notes = "刷新出库统计")
    RestResponse<Void> refreshWarehouseIssueStatisticsExt();

    /**
     * 修改仓库出库统计
     *
     * @param modifyReqDto 仓库出库统计请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改仓库出库统计", notes = "修改仓库出库统计")
    RestResponse<Void> modifyWarehouseIssueStatistics(@RequestBody WarehouseIssueStatisticsReqDto modifyReqDto);

    /**
     * 删除仓库出库统计
     *
     * @param ids        仓库出库统计删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除仓库出库统计", notes = "删除仓库出库统计")
    RestResponse<Void> removeWarehouseIssueStatistics(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);


}
