package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsMonitorIgnoreReqDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorApiResponseDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorSystemResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(tags = {"监控平台报表"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/monitorReport",
        url = "${tcbj.center.report.api:}")
public interface IMonitorReportQueryApi {

    @GetMapping("/monitorSystemCount")
    @ApiOperation(value = "监控平台，系统监控统计", notes = "监控平台，系统监控统计")
    RestResponse<List<MonitorSystemResponseDto>> monitorSystemCount();

    @GetMapping("/monitorSystemCountByCode")
    @ApiOperation(value = "监控平台，系统监控统计，根据系统编号查询", notes = "监控平台，系统监控统计，根据系统编号查询")
    RestResponse<MonitorSystemResponseDto> monitorSystemCountByCode(@RequestParam("systemCode") String systemCode);

    @GetMapping("/queryApiMonitor")
    @ApiOperation(value = "监控平台，系统监控统计，根据接口编号查询", notes = "")
    RestResponse<MonitorApiResponseDto> queryApiMonitor(@RequestParam("apiCode") String apiCode);


    @PostMapping("/monitorIgnore")
    @ApiOperation(value = "监控平台，忽略功能", notes = "监控平台，忽略功能")
    RestResponse<Void> monitorIgnore(@RequestBody List<CsMonitorIgnoreReqDto> dtoList);


}
