package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import javax.annotation.Resource;
import java.util.List;

/**
* 发货结果单服务接口
*
* @author wude
* @since 2022-03-08
*/
@Api(tags = {"发货结果单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/deliveryResultOrder", url = "${tcbj.center.report.api:}")
public interface IDeliveryResultOrderQueryApi {

    /**
    * 根据id查询发货结果单
    *
    * @param id 发货结果单id
    * @return   发货结果单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询发货结果单", notes = "根据id查询发货结果单")
    RestResponse<DeliveryResultOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 发货结果单分页数据
    *
    * @param filter   发货结果单查询条件
    * @return 发货结果单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "发货结果单分页数据", notes = "根据filter查询条件查询发货结果单数据，filter=DeliveryResultOrderReqDto")
    RestResponse<PageInfo<DeliveryResultOrderRespDto>> queryByPage(@RequestBody DeliveryResultOrderReqDto filter);

    /**
     * 查询销售结果分页信息（财务中台拉单专用）
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/querySaleOrderResultInfoPage")
    @ApiOperation(value = "查询销售结果分页信息（财务中台拉单专用）", notes = "查询销售结果分页信息（财务中台拉单专用）")
    RestResponse<PageInfo<SaleOrderResultOfFinanceRespDto>> querySaleOrderResultInfoPage(@RequestBody SaleOrderResultReqDto reqDto);

    @PostMapping("/sapQuerySaleOrderResultInfoPage")
    @ApiOperation(value = "SAP查询收发货结果信息", notes = "SAP查询收发货结果信息")
    RestResponse<PageInfo<SaleOrderResultOfFinanceRespDto>> sapQuerySaleOrderResultInfoPage(@RequestBody SaleOrderResultReqDto reqDto);

    /**
     * 销售单收发结果分页信息
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/querySaleReceiveDeliveryResultInfoPage")
    @ApiOperation(value = "销售单收发结果分页信息", notes = "销售单收发结果分页信息")
    RestResponse<PageInfo<SaleResultOrderRespDto>> querySaleReceiveDeliveryResultInfoPage(@RequestBody SaleOrderResultReqDto reqDto);

    @PostMapping("/saleOrderDetailApportion")
    @ApiOperation(value = "销售结果分摊", notes = "销售结果分摊")
    RestResponse<Void> saleOrderDetailApportion(@RequestBody List<String> saleOrders);

    @PostMapping("/orderDetailApportionBase")
    @ApiOperation(value = "销售结果分摊", notes = "销售结果分摊")
    RestResponse<Void> orderDetailApportionBase(@RequestBody List<String> saleOrders,@RequestParam("type") String type);

    @PostMapping("/queryOrderDetailApportion")
    @ApiOperation(value = "销售结果查询", notes = "销售结果查询")
    RestResponse<List<SaleOrderResultOfFinanceDetailRespDto>> queryOrderDetailApportion(@RequestBody List<String> documentNos);

    @PostMapping("/orderDetailApportionRetry")
    @ApiOperation(value = "销售结果分摊重试", notes = "销售结果分摊重试")
    RestResponse<Void> orderDetailApportionRetry();

    @GetMapping("/easTransferOrderApportion")
    @ApiOperation(value = "eas调拨收发结果分摊", notes = "eas调拨收发结果分摊")
    RestResponse<List<SaleOrderResultOfFinanceDetailRespDto>> easTransferOrderApportion(@RequestParam("transferOrderNo") String transferOrderNo, @RequestParam("documentNo") String documentNo);

}
