/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseLogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryListReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicalInventoryListPageParams;
import com.dtyunxi.tcbj.api.dto.request.PhysicalInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.SkuInventoryBatchReqDto;
import com.dtyunxi.tcbj.api.dto.request.SkuInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseLogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryListRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicalInventoryCountPageVO;
import com.dtyunxi.tcbj.api.dto.response.PhysicalInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicalInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.RpAllotLoseEfficacyConfigRespDto;
import com.dtyunxi.tcbj.api.dto.response.SkuInventoryBatchRespDto;
import com.dtyunxi.tcbj.api.dto.response.SkuInventoryRespDto;
import com.dtyunxi.tcbj.biz.service.ILogicInventoryService;
import com.dtyunxi.tcbj.biz.service.IRpAllotLoseEfficacyConfigService;
import com.dtyunxi.tcbj.dao.das.CsLogicInventoryTotalDas;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.das.LogicInventorySnapDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.eo.CsLogicInventoryTotalEo;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventoryEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventorySnapEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.PhysicsWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.RelWarehouseEo;
import com.dtyunxi.tcbj.dao.mapper.LogicInventoryMapper;
import com.dtyunxi.tcbj.dao.mapper.PhysicsWarehouseMapper;
import com.dtyunxi.tcbj.dao.mapper.RelWarehouseMapper;
import com.dtyunxi.tcbj.dao.vo.LogicInventoryRespVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualInventoryEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicInventoryServiceImpl
implements ILogicInventoryService {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryServiceImpl.class);
    @Resource
    private LogicInventoryDas logicInventoryDas;
    @Resource
    private CsLogicInventoryTotalDas csLogicInventoryTotalDas;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private IRpAllotLoseEfficacyConfigService rpAllotLoseEfficacyConfigService;
    @Resource
    private PhysicsWarehouseMapper physicsWarehouseMapper;
    @Resource
    private RelWarehouseMapper relWarehouseMapper;
    @Resource
    private LogicInventorySnapDas logicInventorySnapDas;
    @Autowired
    LogicInventoryMapper logicInventoryMapper;

    @Override
    public Long addLogicInventory(LogicInventoryReqDto addReqDto) {
        LogicInventoryEo logicInventoryEo = new LogicInventoryEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)logicInventoryEo);
        this.logicInventoryDas.insert((BaseEo)logicInventoryEo);
        return logicInventoryEo.getId();
    }

    @Override
    public void modifyLogicInventory(LogicInventoryReqDto modifyReqDto) {
        LogicInventoryEo logicInventoryEo = new LogicInventoryEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)logicInventoryEo);
        this.logicInventoryDas.updateSelective((BaseEo)logicInventoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLogicInventory(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.logicInventoryDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public LogicInventoryRespDto queryById(Long id) {
        LogicInventoryEo logicInventoryEo = (LogicInventoryEo)this.logicInventoryDas.selectByPrimaryKey(id);
        LogicInventoryRespDto logicInventoryRespDto = new LogicInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)logicInventoryEo, (BaseVo)logicInventoryRespDto);
        return logicInventoryRespDto;
    }

    @Override
    public LogicInventoryCountDto queryByCount(LogicInventoryReqDto filter) {
        return this.logicInventoryDas.queryByCount(filter);
    }

    @Override
    public PageInfo<LogicInventoryRespDto> queryTotalByPage(LogicInventoryReqDto filter) {
        this.setDataLimit(filter);
        if (StringUtils.isNotBlank((CharSequence)filter.getWarehouseCode()) && filter.getWarehouseCode().contains(",")) {
            filter.setWarehouseCodeList(Stream.of(filter.getWarehouseCode().split(",")).collect(Collectors.toList()));
            filter.setWarehouseCode(null);
        }
        Page logicInventoryRespVos = this.logicWarehouseDas.queryTotalByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)logicInventoryRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List logicInventoryRespVoList = logicInventoryRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryRespVoList)) {
            Map itemMap = Optional.of(logicInventoryRespVos.stream().map(LogicInventoryRespVo::getItemLongCode).collect(Collectors.toSet())).filter(CollectionUtils::isNotEmpty).map(longCodes -> ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", (Collection)longCodes)).list().stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity(), (o, o1) -> o))).orElse(Maps.newHashMap());
            boolean splitFlag = Objects.equals(filter.getQueryType(), 2);
            List respDto = logicInventoryRespVoList.stream().map(vo -> {
                LogicInventoryRespDto logicInventoryRespDto = (LogicInventoryRespDto)BeanUtil.copyProperties((Object)vo, LogicInventoryRespDto.class, (String[])new String[0]);
                if (splitFlag) {
                    logicInventoryRespDto.setWarehouseName(Optional.ofNullable(vo.getWarehouseName()).filter(StringUtils::isNotBlank).map(s -> String.join((CharSequence)",", Arrays.stream(s.split(",")).map(r -> r.substring(0, r.length() - 1)).collect(Collectors.toSet()))).orElse(""));
                }
                logicInventoryRespDto.setUnitId(itemMap.getOrDefault(vo.getItemLongCode(), new ItemExtendEo()).getUnitId());
                logicInventoryRespDto.setSpecification(itemMap.getOrDefault(vo.getItemLongCode(), new ItemExtendEo()).getSpecification());
                return logicInventoryRespDto;
            }).collect(Collectors.toList());
            respDtoPageInfo.setList(respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public LogicInventoryCountDto queryTotalByCount(LogicInventoryReqDto filter) {
        this.setDataLimit(filter);
        if (StringUtils.isNotBlank((CharSequence)filter.getWarehouseCode()) && filter.getWarehouseCode().contains(",")) {
            filter.setWarehouseCodeList(Stream.of(filter.getWarehouseCode().split(",")).collect(Collectors.toList()));
            filter.setWarehouseCode(null);
        }
        return this.csLogicInventoryTotalDas.queryTotalByCount(filter);
    }

    @Override
    public PageInfo<PhysicalInventoryRespDto> queryPhysicalByPage(PhysicalInventoryReqDto filter) {
        PageInfo pageInfo = this.csLogicInventoryTotalDas.queryPhysicalByPage(filter);
        return pageInfo;
    }

    @Override
    public PhysicalInventoryCountDto queryPhysicalByCount(PhysicalInventoryReqDto filter) {
        return this.csLogicInventoryTotalDas.queryPhysicalByCount(filter);
    }

    @Override
    public LogicalInventoryCountPageVO queryLogicInventoryByCount(LogicalInventoryListPageParams filter) {
        this.settingQueryWarehouseInventoryLimit();
        if (ObjectUtils.isNotEmpty((Object)filter.getLogicalWarehouseAttr())) {
            String warehouseAttrCHN = "";
            switch (filter.getLogicalWarehouseAttr()) {
                case "finished_product": {
                    warehouseAttrCHN = "\u4ea7\u6210\u54c1";
                    break;
                }
                case "semi_finished_product": {
                    warehouseAttrCHN = "\u534a\u6210\u54c1";
                    break;
                }
                case "shoppe": {
                    warehouseAttrCHN = "\u4e13\u67dc";
                    break;
                }
                case "third_party": {
                    warehouseAttrCHN = "\u7b2c\u4e09\u65b9";
                    break;
                }
                case "promotionp_boring": {
                    warehouseAttrCHN = "\u4fc3\u9500\u7269\u6599";
                    break;
                }
                default: {
                    warehouseAttrCHN = filter.getLogicalWarehouseAttr();
                }
            }
            filter.setLogicalWarehouseAttrCHN(warehouseAttrCHN);
        }
        return this.logicInventoryDas.queryLogicInventoryByCount(filter);
    }

    private void settingQueryWarehouseInventoryLimit() {
        ServiceContext.getContext().set("data_limit_authority_selector", (Object)LogicWarehouseEo.class.getTypeName());
        ServiceContext.getContext().set("data_limit_authority_selector_counter", (Object)"2");
    }

    private void setDataLimit(LogicInventoryReqDto filter) {
        int vir = 3;
        int vir2 = 2;
        if (Objects.equals(filter.getQueryType(), vir) || Objects.equals(filter.getQueryType(), vir2)) {
            ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "2");
            ServiceContext.getContext().setAttachment("data_limit_authority_selector", DgVirtualInventoryEo.class.getTypeName());
        } else {
            ServiceContext.getContext().setAttachment("data_limit_authority_selector_counter", "2");
            ServiceContext.getContext().setAttachment("data_limit_authority_selector", CsLogicInventoryTotalEo.class.getTypeName());
        }
    }

    @Override
    public List<LogicInventoryRespDto> queryInventoryByCargo(List<CargoInventoryReqDto> cargoInventoryReqDtos) {
        if (CollectionUtils.isEmpty(cargoInventoryReqDtos)) {
            return Lists.newArrayList();
        }
        ExtQueryChainWrapper filter = this.logicInventoryDas.filter().select(new String[]{"warehouse_code", "sku_code", "batch", "available"});
        filter.and(wrapper -> {
            for (int i = 0; i < cargoInventoryReqDtos.size(); ++i) {
                CargoInventoryReqDto cr = (CargoInventoryReqDto)cargoInventoryReqDtos.get(i);
                if (i == 0) {
                    this.addCondition((AbstractWrapper)wrapper, cr);
                    continue;
                }
                wrapper.or(or -> this.addCondition((AbstractWrapper)or, cr));
            }
        });
        List list = filter.list();
        return cargoInventoryReqDtos.stream().map(re -> {
            LogicInventoryRespDto respDto = new LogicInventoryRespDto();
            respDto.setBatch(re.getBatch());
            respDto.setWarehouseCode(re.getWarehouseCode());
            respDto.setItemLongCode(re.getCargoCode());
            respDto.setAvailable(list.stream().filter(d -> Optional.ofNullable(re.getBatch()).filter(StringUtils::isNotBlank).map(r -> r.equals(d.getBatch())).orElse(true) != false && Optional.ofNullable(re.getCargoCode()).filter(StringUtils::isNotBlank).map(r -> r.equals(d.getSkuCode())).orElse(true) != false && Optional.ofNullable(re.getWarehouseCode()).filter(StringUtils::isNotBlank).map(r -> r.equals(d.getWarehouseCode())).orElse(true) != false).map(LogicInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add));
            return respDto;
        }).collect(Collectors.toList());
    }

    private void addCondition(AbstractWrapper w, CargoInventoryReqDto cr) {
        w.eq(StringUtils.isNotBlank((CharSequence)cr.getWarehouseCode()), (Object)"warehouse_code", (Object)cr.getWarehouseCode()).eq(StringUtils.isNotBlank((CharSequence)cr.getBatch()), (Object)"batch", (Object)cr.getBatch()).eq(StringUtils.isNotBlank((CharSequence)cr.getCargoCode()), (Object)"sku_code", (Object)cr.getCargoCode());
    }

    @Override
    public BigDecimal queryByIntransit(String itemLongCode, String physicsWarehouseCode) {
        return this.csLogicInventoryTotalDas.queryByIntransit(itemLongCode, physicsWarehouseCode);
    }

    @Override
    public List<LogicInventoryListRespDto> queryLogicInventoryList(LogicInventoryListReqDto filter) {
        if (YesOrNoEnum.YES.getCode().equals(filter.getQuerySnap())) {
            Date time = this.logicInventorySnapDas.queryNewsetTime();
            QueryWrapper<LogicInventorySnapEo> queryWrapper = this.getSnapQueryWrapper(filter);
            if (Objects.isNull(queryWrapper)) {
                return null;
            }
            queryWrapper.eq((Object)"statistical_time", (Object)time);
            return this.logicInventorySnapDas.getMapper().selectList(queryWrapper).stream().map(li -> {
                LogicInventoryListRespDto logicInventoryListRespDto = (LogicInventoryListRespDto)BeanUtil.copyProperties((Object)li, LogicInventoryListRespDto.class, (String[])new String[0]);
                logicInventoryListRespDto.setSkuCode(li.getLongCode());
                logicInventoryListRespDto.setSkuName(li.getCargoName());
                return logicInventoryListRespDto;
            }).collect(Collectors.toList());
        }
        QueryWrapper<LogicInventoryEo> queryWrapper = this.getQueryWrapper(filter);
        if (Objects.isNull(queryWrapper)) {
            return null;
        }
        return this.logicInventoryDas.getMapper().selectList(queryWrapper).stream().map(li -> {
            LogicInventoryListRespDto logicInventoryListRespDto = (LogicInventoryListRespDto)BeanUtil.copyProperties((Object)li, LogicInventoryListRespDto.class, (String[])new String[0]);
            logicInventoryListRespDto.setSkuCode(li.getSkuCode());
            logicInventoryListRespDto.setSkuName(li.getSkuName());
            return logicInventoryListRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<SkuInventoryRespDto> queryInventoryByParamList(List<SkuInventoryReqDto> skuInventoryReqDtos) {
        Map<String, BigDecimal> actualInventoryMap = this.logicInventoryDas.queryInventoryByParamList(skuInventoryReqDtos).stream().collect(Collectors.toMap(k -> this.getQueryKey((SkuInventoryRespDto)k, k.getWarehouseQuality()), SkuInventoryRespDto::getAvailableInventory));
        Map<String, List<SkuInventoryRespDto>> physicsInventoryMap = this.logicInventoryDas.queryInventorySnapByParamList(skuInventoryReqDtos).stream().collect(Collectors.groupingBy(SkuInventoryRespDto::getSkuCode));
        return skuInventoryReqDtos.stream().map(skuInventoryReqDto -> {
            SkuInventoryRespDto resp = (SkuInventoryRespDto)BeanUtil.copyProperties((Object)skuInventoryReqDto, SkuInventoryRespDto.class, (String[])new String[0]);
            resp.setQualifiedInventory((BigDecimal)actualInventoryMap.get(this.getQueryKey(resp, "qualified")));
            resp.setWaitInspInventory((BigDecimal)actualInventoryMap.get(this.getQueryKey(resp, "wait_inspection")));
            Optional.ofNullable(skuInventoryReqDto.getPhysicsWarehouseCode()).filter(r -> StringUtils.isNotBlank((CharSequence)r) && physicsInventoryMap.containsKey(skuInventoryReqDto.getSkuCode())).ifPresent(code -> resp.setReplenishmentInventory((BigDecimal)((List)physicsInventoryMap.get(skuInventoryReqDto.getSkuCode())).stream().filter(warehouse -> Objects.equals(code, warehouse.getPhysicsWarehouseCode())).findFirst().map(SkuInventoryRespDto::getAvailableInventory).orElse(null)));
            resp.setAllInventory((BigDecimal)Optional.ofNullable(physicsInventoryMap.get(skuInventoryReqDto.getSkuCode())).filter(CollectionUtils::isNotEmpty).map(r -> r.stream().map(SkuInventoryRespDto::getAvailableInventory).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(null));
            return resp;
        }).collect(Collectors.toList());
    }

    @Override
    public List<SkuInventoryBatchRespDto> queryLogicInventoryListByBatch(SkuInventoryBatchReqDto skuInventoryBatchReqDto) {
        if (StringUtils.isNotBlank((CharSequence)skuInventoryBatchReqDto.getSkuCode())) {
            skuInventoryBatchReqDto.setSkuCodeList((List)Lists.newArrayList((Object[])new String[]{skuInventoryBatchReqDto.getSkuCode()}));
        }
        if (StringUtils.isNotBlank((CharSequence)skuInventoryBatchReqDto.getOrganizationCode())) {
            skuInventoryBatchReqDto.setOrganizationCodeList((List)Lists.newArrayList((Object[])new String[]{skuInventoryBatchReqDto.getOrganizationCode()}));
        }
        if (StringUtils.isNotBlank((CharSequence)skuInventoryBatchReqDto.getPhysicsWarehouseCode())) {
            skuInventoryBatchReqDto.setPhysicsWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{skuInventoryBatchReqDto.getPhysicsWarehouseCode()}));
        }
        return Optional.ofNullable(this.logicInventoryDas.queryLogicInventoryListByBatch(skuInventoryBatchReqDto)).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().collect(Collectors.groupingBy(k -> k.getSkuCode() + "_" + DateUtil.formatDate((DatePattern)DatePattern.MONTH_PATTERN, (Date)k.getProduceTime()))).entrySet()).map(list -> list.stream().map(entry -> {
            List value = (List)entry.getValue();
            SkuInventoryRespDto skuInventoryRespDto = (SkuInventoryRespDto)value.get(0);
            SkuInventoryBatchRespDto respDto = new SkuInventoryBatchRespDto();
            respDto.setSkuCode(skuInventoryRespDto.getSkuCode());
            respDto.setBatchMonth(DateUtil.formatDate((DatePattern)DatePattern.MONTH_PATTERN, (Date)skuInventoryRespDto.getProduceTime()));
            respDto.setOrganizationCode(skuInventoryRespDto.getOrganizationCode());
            respDto.setDetailList(value.stream().map(d -> (SkuInventoryBatchRespDto.Detail)BeanUtil.copyProperties((Object)d, SkuInventoryBatchRespDto.Detail.class, (String[])new String[0])).collect(Collectors.toList()));
            respDto.setAllInventory(value.stream().map(SkuInventoryRespDto::getAvailableInventory).reduce(BigDecimal.ZERO, BigDecimal::add));
            Optional.ofNullable(skuInventoryBatchReqDto.getPhysicsWarehouseCode()).filter(StringUtils::isNotBlank).map(code -> value.stream().filter(r -> Objects.equals(r.getPhysicsWarehouseCode(), code))).ifPresent(r -> {
                respDto.setPhysicsWarehouseCode(skuInventoryRespDto.getPhysicsWarehouseCode());
                respDto.setReplenishmentInventory(r.map(SkuInventoryRespDto::getAvailableInventory).reduce(BigDecimal.ZERO, BigDecimal::add));
            });
            return respDto;
        }).sorted(Comparator.comparing(SkuInventoryBatchRespDto::getBatchMonth).reversed()).collect(Collectors.toList())).orElse(Lists.newArrayList());
    }

    @Override
    public PageInfo<InspectionReleaseLogicInventoryRespDto> queryInspectionReleaseInventory(InspectionReleaseLogicInventoryReqDto reqDto) {
        log.info("queryInspectionReleaseInventory: {}", (Object)JSON.toJSONString((Object)reqDto));
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        return new PageInfo(this.logicInventoryMapper.queryInspectionReleaseInventory(reqDto));
    }

    @Override
    public Long queryInspectionReleaseInventoryCount(InspectionReleaseLogicInventoryReqDto reqDto) {
        if (null != reqDto.getReleaseBeginTime() || null != reqDto.getReleaseEndTIme()) {
            return 0L;
        }
        log.info("queryInspectionReleaseInventoryCount: {}", (Object)JSON.toJSONString((Object)reqDto));
        return this.logicInventoryMapper.queryInspectionReleaseInventoryCount(reqDto);
    }

    @Override
    public List<LogicInventoryRespDto> queryList(LogicInventoryListReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getSkuCode()) && StringUtils.isBlank((CharSequence)reqDto.getBatch()) && StringUtils.isBlank((CharSequence)reqDto.getLongCode()) && StringUtils.isBlank((CharSequence)reqDto.getSkuName()) && StringUtils.isBlank((CharSequence)reqDto.getLogicWarehouseQuality()) && StringUtils.isBlank((CharSequence)reqDto.getLogicWarehouseClassify()) && StringUtils.isBlank((CharSequence)reqDto.getLogicWarehouseCode()) && CollectionUtils.isEmpty((Collection)reqDto.getBatchList()) && CollectionUtils.isEmpty((Collection)reqDto.getLongCodes()) && CollectionUtils.isEmpty((Collection)reqDto.getSkuCodeList()) && CollectionUtils.isEmpty((Collection)reqDto.getLogicWarehouseCodeList()) && CollectionUtils.isEmpty((Collection)reqDto.getOrganizationCodeList()) && CollectionUtils.isEmpty((Collection)reqDto.getLogicWarehouseQualityList()) && CollectionUtils.isEmpty((Collection)reqDto.getNotSkuCodeList())) {
            throw new BizException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getSkuCode())) {
            reqDto.setLongCode(reqDto.getSkuCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            reqDto.setLongCodes(reqDto.getSkuCodeList());
        }
        return this.logicInventoryMapper.queryList(reqDto);
    }

    private String getQueryKey(SkuInventoryRespDto s, String warehouseQuality) {
        return s.getSkuCode() + "_" + s.getOrganizationCode() + "_" + warehouseQuality;
    }

    private QueryWrapper<LogicInventorySnapEo> getSnapQueryWrapper(LogicInventoryListReqDto queryDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)"0");
        if (queryDto.getLogicWarehouseId() != null) {
            wrapper.eq((Object)"warehouse_id", (Object)queryDto.getLogicWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLogicWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getLogicWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getSkuCode()})) {
            wrapper.like((Object)"cargo_code", (Object)queryDto.getSkuCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getSkuName()})) {
            wrapper.like((Object)"cargo_name", (Object)("%" + queryDto.getSkuName() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.like((Object)"long_code", (Object)("%" + queryDto.getLongCode() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            wrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLongCodes())) {
            wrapper.in((Object)"long_code", (Collection)queryDto.getLongCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getBatchList())) {
            wrapper.in((Object)"batch", (Collection)queryDto.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrganizationCodeList()) || CollectionUtils.isNotEmpty((Collection)queryDto.getPhysicsWarehouseCodeList()) || StringUtils.isNotEmpty((CharSequence)queryDto.getLogicWarehouseQuality()) || StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseStatus()) || StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseType()) || Objects.nonNull(queryDto.getIsRdc())) {
            List<String> warehouseCodeList = Optional.ofNullable(queryDto.getLogicWarehouseCodeList()).filter(CollectionUtils::isNotEmpty).orElseGet(Lists::newArrayList);
            List physicsWarehouseCodeList = Optional.ofNullable(queryDto.getPhysicsWarehouseCodeList()).orElseGet(Lists::newArrayList);
            if ((warehouseCodeList = this.getLogicWarehouseCodes(queryDto, warehouseCodeList, physicsWarehouseCodeList)) == null) {
                return null;
            }
            queryDto.setLogicWarehouseCodeList(warehouseCodeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLogicWarehouseCodeList())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getLogicWarehouseCodeList());
        }
        if (Boolean.TRUE.equals(queryDto.getFilterGtZero())) {
            wrapper.gt((Object)"available", (Object)0);
        }
        return wrapper;
    }

    private QueryWrapper<LogicInventoryEo> getQueryWrapper(LogicInventoryListReqDto queryDto) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)"0");
        if (queryDto.getLogicWarehouseId() != null) {
            wrapper.eq((Object)"warehouse_id", (Object)queryDto.getLogicWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLogicWarehouseCode()})) {
            wrapper.eq((Object)"warehouse_code", (Object)queryDto.getLogicWarehouseCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getSkuCode()})) {
            wrapper.like((Object)"sku_code", (Object)queryDto.getSkuCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getSkuName()})) {
            wrapper.like((Object)"sku_name", (Object)("%" + queryDto.getSkuName() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getLongCode()})) {
            wrapper.like((Object)"sku_code", (Object)("%" + queryDto.getLongCode() + "%"));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            wrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLongCodes())) {
            wrapper.in((Object)"sku_code", (Collection)queryDto.getLongCodes());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getBatchList())) {
            wrapper.in((Object)"batch", (Collection)queryDto.getBatchList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrganizationCodeList()) || CollectionUtils.isNotEmpty((Collection)queryDto.getPhysicsWarehouseCodeList()) || StringUtils.isNotEmpty((CharSequence)queryDto.getLogicWarehouseQuality()) || StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseStatus()) || StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseType()) || Objects.nonNull(queryDto.getIsRdc())) {
            List<String> warehouseCodeList = Optional.ofNullable(queryDto.getLogicWarehouseCodeList()).filter(CollectionUtils::isNotEmpty).orElseGet(Lists::newArrayList);
            List physicsWarehouseCodeList = Optional.ofNullable(queryDto.getPhysicsWarehouseCodeList()).orElseGet(Lists::newArrayList);
            if ((warehouseCodeList = this.getLogicWarehouseCodes(queryDto, warehouseCodeList, physicsWarehouseCodeList)) == null) {
                return null;
            }
            queryDto.setLogicWarehouseCodeList(warehouseCodeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getLogicWarehouseCodeList())) {
            wrapper.in((Object)"warehouse_code", (Collection)queryDto.getLogicWarehouseCodeList());
        }
        if (Boolean.TRUE.equals(queryDto.getFilterGtZero())) {
            wrapper.gt((Object)"available", (Object)0);
        }
        return wrapper;
    }

    private List<String> getLogicWarehouseCodes(LogicInventoryListReqDto queryDto, List<String> warehouseCodeList, List<String> physicsWarehouseCodeList) {
        List newWarehouseCodeList;
        if (CollectionUtils.isNotEmpty(physicsWarehouseCodeList) || StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseStatus()) || StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseType()) || Objects.nonNull(queryDto.getIsRdc())) {
            physicsWarehouseCodeList.addAll(this.physicsWarehouseMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query((Object)new PhysicsWarehouseEo()).in(CollectionUtils.isNotEmpty(physicsWarehouseCodeList), (Object)"warehouse_code", physicsWarehouseCodeList)).eq(StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseStatus()), (Object)"warehouse_status", (Object)queryDto.getPhysicsWarehouseStatus())).eq(StringUtils.isNotEmpty((CharSequence)queryDto.getPhysicsWarehouseType()), (Object)"warehouse_type", (Object)queryDto.getPhysicsWarehouseType())).eq(Objects.nonNull(queryDto.getIsRdc()), (Object)"rdc_flag", (Object)queryDto.getIsRdc())).eq((Object)"dr", (Object)YesOrNoEnum.NO.getCode())).stream().map(PhysicsWarehouseEo::getWarehouseCode).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(physicsWarehouseCodeList)) {
                return null;
            }
            newWarehouseCodeList = this.relWarehouseMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)Wrappers.query((Object)new RelWarehouseEo()).eq((Object)"ref_warehouse_code", physicsWarehouseCodeList)).in(CollectionUtils.isNotEmpty(warehouseCodeList), (Object)"warehouse_code", warehouseCodeList)).eq((Object)"valid_flag", (Object)"enable")).stream().map(RelWarehouseEo::getWarehouseCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(newWarehouseCodeList)) {
                return null;
            }
            warehouseCodeList = newWarehouseCodeList;
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrganizationCodeList()) || StringUtils.isNotEmpty((CharSequence)queryDto.getLogicWarehouseQuality())) {
            newWarehouseCodeList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDas.filter().in(CollectionUtils.isNotEmpty((Collection)queryDto.getOrganizationCodeList()), (Object)"organization_code", (Collection)queryDto.getOrganizationCodeList())).in(CollectionUtils.isNotEmpty(warehouseCodeList), (Object)"warehouse_code", warehouseCodeList)).eq(StringUtils.isNotEmpty((CharSequence)queryDto.getLogicWarehouseQuality()), (Object)"warehouse_quality", (Object)queryDto.getLogicWarehouseQuality())).list().stream().map(LogicWarehouseEo::getWarehouseCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(newWarehouseCodeList)) {
                return null;
            }
            warehouseCodeList = newWarehouseCodeList;
        }
        return warehouseCodeList;
    }

    @Override
    public PageInfo<LogicInventoryRespDto> queryByPage(LogicInventoryReqDto filter) {
        RpAllotLoseEfficacyConfigRespDto rpAllotLoseEfficacyConfigRespDto;
        log.info("\u903b\u8f91\u4ed3\u5e93\u5b58\u8868\u5206\u9875\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)filter));
        this.settingQueryWarehouseInventoryLimit();
        if (Objects.equals(filter.getEnableEffectiveLoseQuery(), 1) && !Objects.equals((rpAllotLoseEfficacyConfigRespDto = this.rpAllotLoseEfficacyConfigService.queryDefault(1)).getWarehoueFlag(), 1)) {
            if (rpAllotLoseEfficacyConfigRespDto.getAllotLoseEfficacyWarehouseRespDtoPageInfo().getTotal() == 0L) {
                return new PageInfo();
            }
            filter.setEnableEffectiveLoseWarehouse(Integer.valueOf(1));
            filter.setConfigId(rpAllotLoseEfficacyConfigRespDto.getId());
            log.info("\u62c9\u53d6\u5230\u914d\u7f6e\u4fe1\u606f");
        }
        Page logicInventoryRespVos = this.logicInventoryDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)logicInventoryRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List logicInventoryRespVoList = logicInventoryRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)logicInventoryRespVoList)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)logicInventoryRespVoList, LogicInventoryRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }
}

