/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordExtReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.OilLinkQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderInfoDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilChangeQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.finance.api.query.ILogisticQueryApi;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.dao.das.AppointAreaDas;
import com.dtyunxi.tcbj.dao.das.LogisticsRecordDas;
import com.dtyunxi.tcbj.dao.eo.AppointAreaEo;
import com.dtyunxi.tcbj.dao.eo.LogisticsRecordEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogisticBaseService<K> {
    private static Logger logger = LoggerFactory.getLogger(LogisticBaseService.class);
    @Resource
    private ILogisticQueryApi logisticQueryApi;
    @Resource
    private LogisticsRecordDas logisticsRecordDas;
    @Resource
    private AppointAreaDas appointAreaDas;
    private static final String SPECIAL_CHARACTERS = "\u00b7  @ # \uffe5 % \u2026 & * \uff08\uff09 - =   {  } |  , \u201d \u201c \uff1a \u300b \u300a  \uff1f?";

    public FinLogisticsReportDto execute(K request) {
        return this.handle(request);
    }

    protected abstract FinLogisticsReportDto handle(K var1);

    public void setAbnormalCauses(FinLogisticsReportDto msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getAbnormalCauses())) {
            msgDto.setAbnormalCauses(errorMsg);
        } else {
            msgDto.setAbnormalCauses(String.format("%s\u3001%s", msgDto.getAbnormalCauses(), errorMsg));
        }
    }

    public LogisticRecordQueryRespDto selectLogisticMode(String warehouseCode, String logisticCompany, String transportType, Date outWarehouseTime, Long contractId) {
        logger.info("selectLogisticMode====={},{},{},{},{}", new Object[]{warehouseCode, logisticCompany, transportType, outWarehouseTime, contractId});
        if (contractId != null) {
            LogisticsRecordEo logisticsRecordEo = (LogisticsRecordEo)this.logisticsRecordDas.selectByPrimaryKey(contractId);
            if (logisticsRecordEo == null) {
                return null;
            }
            LogisticRecordQueryRespDto recordQueryRespDto = new LogisticRecordQueryRespDto();
            DtoHelper.eo2Dto((BaseEo)logisticsRecordEo, (BaseVo)recordQueryRespDto);
            return recordQueryRespDto;
        }
        LogisticRecordExtReqDto queryReqDto = new LogisticRecordExtReqDto();
        queryReqDto.setWhCode(warehouseCode);
        queryReqDto.setLogisticCompany(logisticCompany);
        queryReqDto.setTransportType(transportType);
        queryReqDto.setOutWarehouseTime(outWarehouseTime);
        ArrayList list = Lists.newArrayList();
        list.add(queryReqDto);
        RestResponse response = this.logisticQueryApi.queryList((List)list);
        if ("0".equals(response.getResultCode()) && CollectionUtil.isNotEmpty((Collection)((Collection)response.getData())) && ((List)response.getData()).size() > 0) {
            return (LogisticRecordQueryRespDto)((List)response.getData()).get(0);
        }
        return null;
    }

    private void assembleVolumeLadder(AppointAreaQueryRespDto respDto, String volumeLadder) {
        if (StringUtils.isBlank((CharSequence)volumeLadder)) {
            return;
        }
        List details = JSON.parseArray((String)volumeLadder, VolumeLadderInfoDto.class);
        details = details.stream().sorted(Comparator.comparing(VolumeLadderInfoDto::getSort)).collect(Collectors.toList());
        respDto.setDetails(details);
    }

    public AppointAreaQueryRespDto selectAppointArea(String templateId, String province, String city, String area) {
        if (StringUtil.isBlank((CharSequence)templateId) || StringUtils.isBlank((CharSequence)province)) {
            return null;
        }
        AppointAreaQueryRespDto respDto = new AppointAreaQueryRespDto();
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)templateId)).likeRight((Object)"province", (Object)province);
        if (StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)area)) {
            AppointAreaEo eo = (AppointAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)filter.likeRight((Object)"city", (Object)city)).likeRight((Object)"area", (Object)area)).last("limit 1")).one();
            if (eo != null) {
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
                this.assembleVolumeLadder(respDto, eo.getVolumeLadder());
                return respDto;
            }
            AppointAreaEo one = (AppointAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)templateId)).likeRight((Object)"province", (Object)province)).likeRight((Object)"city", (Object)city)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"area")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one();
            if (one != null) {
                DtoHelper.eo2Dto((BaseEo)one, (BaseVo)respDto);
                this.assembleVolumeLadder(respDto, one.getVolumeLadder());
                return respDto;
            }
            AppointAreaEo appointAreaEo = (AppointAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)templateId)).likeRight((Object)"province", (Object)province)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"city")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"city", (Object)"");
                });
            })).and(n -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)n.isNull((Object)"area")).or(m -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)m.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one();
            if (appointAreaEo != null) {
                DtoHelper.eo2Dto((BaseEo)appointAreaEo, (BaseVo)respDto);
                this.assembleVolumeLadder(respDto, appointAreaEo.getVolumeLadder());
                return respDto;
            }
        } else {
            AppointAreaEo eo;
            if (StringUtils.isNotBlank((CharSequence)city) && StringUtils.isBlank((CharSequence)area) && (eo = (AppointAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)templateId)).eq((Object)"province", (Object)province)).eq((Object)"city", (Object)city)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"area")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one()) != null) {
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
                this.assembleVolumeLadder(respDto, eo.getVolumeLadder());
                return respDto;
            }
            eo = (AppointAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)templateId)).eq((Object)"province", (Object)province)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"city")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"city", (Object)"");
                });
            })).and(n -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)n.isNull((Object)"area")).or(m -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)m.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one();
            if (eo != null) {
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
                this.assembleVolumeLadder(respDto, eo.getVolumeLadder());
                return respDto;
            }
        }
        return null;
    }

    public OilLinkQueryRespDto selectOilLink(String warehouseName, Date lastTime) {
        OilLinkQueryReqDto reqDto = new OilLinkQueryReqDto();
        reqDto.setWarehouseName(warehouseName);
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(10));
        reqDto.setLastTime(lastTime);
        logger.info("\u67e5\u8be2\u6cb9\u4ef7\u8054\u52a8:{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponse response = this.logisticQueryApi.queryOilLinkList(reqDto);
        if ("0".equals(response.getResultCode()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)response.getData()).getList())) {
            return (OilLinkQueryRespDto)((PageInfo)response.getData()).getList().get(0);
        }
        return null;
    }

    public List<OilChangeQueryRespDto> selectOilChange(String type) {
        RestResponse response = this.logisticQueryApi.queryByType(type);
        if ("0".equals(response.getResultCode()) && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            return (List)response.getData();
        }
        return null;
    }

    public BigDecimal setOilChangeData(BigDecimal scope) {
        logger.info("\u67e5\u8be2\u6cb9\u4ef7\u5e45\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)scope));
        if (scope.compareTo(BigDecimal.ZERO) > 0) {
            List<OilChangeQueryRespDto> respDtoList = this.selectOilChange(SeasonTypeEnum.OFF_OR_PEAK.getType().toString());
            return this.selectScope(respDtoList, scope);
        }
        List<OilChangeQueryRespDto> respDtoList = this.selectOilChange(SeasonTypeEnum.COMMON.getType().toString());
        return this.selectScope(respDtoList, scope.abs());
    }

    public String getRangeOilPrice(BigDecimal bigDecimal) {
        logger.info("\u83b7\u53d6\u6cb9\u4ef7\u5e45\u5ea6");
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        percentInstance.setMinimumFractionDigits(2);
        return percentInstance.format(bigDecimal);
    }

    private BigDecimal selectScope(List<OilChangeQueryRespDto> respDtoList, BigDecimal scope) {
        logger.info("\u5339\u914d\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6\uff1a{}\uff0c{}", (Object)scope, (Object)JSON.toJSONString(respDtoList));
        scope = scope.multiply(new BigDecimal("100"));
        if (scope.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal("1");
        }
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            for (OilChangeQueryRespDto respDto : respDtoList) {
                if (!(null != respDto.getMinScope() && null != respDto.getMaxScope() ? scope.compareTo(new BigDecimal(respDto.getMinScope())) > 0 && scope.compareTo(new BigDecimal(respDto.getMaxScope())) <= 0 : (null == respDto.getMinScope() && null != respDto.getMaxScope() ? scope.compareTo(new BigDecimal(respDto.getMaxScope())) <= 0 : null != respDto.getMinScope() && null == respDto.getMaxScope() && scope.compareTo(new BigDecimal(respDto.getMinScope())) > 0))) continue;
                return respDto.getScope();
            }
        }
        return null;
    }

    public static String handleAddress(String address) {
        try {
            char[] chars;
            int last;
            int index;
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(address);
            String trim = m.replaceAll("").trim();
            if (StringUtils.isNotBlank((CharSequence)trim)) {
                address = address.substring(0, address.indexOf(trim.substring(0, 1)));
            }
            if (address.contains("(") && address.contains(")")) {
                index = address.indexOf("(");
                last = address.indexOf(")");
                if (last > index) {
                    String source = address;
                    address = address.substring(0, index) + source.substring(-1, last);
                }
            }
            if (address.contains("\uff08") && address.contains(")")) {
                index = address.indexOf("(");
                last = address.indexOf(")");
                if (last > index) {
                    String source1 = address;
                    address = address.substring(0, index) + source1.substring(-1, last);
                }
            }
            for (char aChar : chars = address.toCharArray()) {
                String s3 = String.valueOf(aChar);
                if (!SPECIAL_CHARACTERS.contains(s3)) continue;
                address = address.replace(s3, "");
            }
        }
        catch (Exception e) {
            logger.error("\u5730\u5740\u5904\u7406\u9519\u8bef:{}", (Object)address);
            return address;
        }
        return address;
    }

    private static List<OilChangeQueryRespDto> oilChangeQueryRespDto() {
        String json = "[\n    {\n        \"createPerson\":\"uat01\",\n        \"createTime\":1662125808000,\n        \"extFields\":{\n\n        },\n        \"id\":\"1317845427910920374\",\n        \"maxScope\":5,\n        \"minScope\":0,\n        \"scope\":1,\n        \"type\":1,\n        \"updatePerson\":\"uat01\",\n        \"updateTime\":1665387262000\n    },\n    {\n        \"createPerson\":\"miyao\",\n        \"createTime\":1662255912000,\n        \"extFields\":{\n\n        },\n        \"id\":\"1317981852304197815\",\n        \"maxScope\":10,\n        \"scope\":1.01,\n        \"type\":1,\n        \"updatePerson\":\"miyao\",\n        \"minScope\":5,\n        \"updateTime\":1662255912000\n    },\n    {\n        \"createPerson\":\"miyao\",\n        \"createTime\":1662255939000,\n        \"extFields\":{\n\n        },\n        \"id\":\"1317981879753820344\",\n        \"maxScope\":15,\n        \"minScope\":10,\n        \"scope\":1.015,\n        \"type\":1,\n        \"updatePerson\":\"miyao\",\n        \"updateTime\":1662255939000\n    },\n    {\n        \"createPerson\":\"miyao\",\n        \"createTime\":1662255954000,\n        \"extFields\":{\n\n        },\n        \"id\":\"1317981896092731577\",\n        \"maxScope\":20,\n        \"minScope\":15,\n        \"scope\":1.02,\n        \"type\":1,\n        \"updatePerson\":\"miyao\",\n        \"updateTime\":1662255954000\n    },\n    {\n        \"createPerson\":\"miyao\",\n        \"createTime\":1662255966000,\n        \"extFields\":{\n\n        },\n        \"id\":\"1317981908808812730\",\n        \"maxScope\":21,\n        \"minScope\":20,\n        \"scope\":1.025,\n        \"type\":1,\n        \"updatePerson\":\"wenyi\",\n        \"updateTime\":1665368847000\n    },\n    {\n        \"createPerson\":\"miyao\",\n        \"createTime\":1662255966000,\n        \"extFields\":{\n\n        },\n        \"id\":\"1317981908808812730\",\n        \"maxScope\":60,\n        \"minScope\":20,\n        \"scope\":1.025,\n        \"type\":1,\n        \"updatePerson\":\"wenyi\",\n        \"updateTime\":1665368847000\n    }\n]";
        return JSON.parseArray((String)json, OilChangeQueryRespDto.class);
    }

    public static void main(String[] args) {
        String address = "\u5e7f\u4e1c\u7701\u5e7f\u5dde\u5e02\u9ec4\u57d4\u533a\u8305\u5c97\u5357\u8def,";
        String s = LogisticBaseService.handleAddress(address);
        System.out.println(s);
    }

    private static BigDecimal selectScope1(List<OilChangeQueryRespDto> respDtoList, BigDecimal scope) {
        logger.info("\u6cb9\u4ef7\u8c03\u6574\u533a\u95f4respDtoList:{}", (Object)JSON.toJSONString(respDtoList));
        logger.info("\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope:{}", (Object)JSON.toJSONString((Object)scope));
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            for (OilChangeQueryRespDto respDto : respDtoList) {
                if (null != respDto.getMinScope() && null != respDto.getMaxScope()) {
                    if (scope.compareTo(new BigDecimal(respDto.getMinScope()).divide(BigDecimal.valueOf(100L))) < 0 || new BigDecimal(respDto.getMaxScope()).divide(BigDecimal.valueOf(100L)).compareTo(scope) <= 0) continue;
                    return respDto.getScope();
                }
                if (null != respDto.getMinScope() && null == respDto.getMaxScope()) {
                    BigDecimal minScope = new BigDecimal(respDto.getMinScope()).divide(new BigDecimal(100));
                    if (scope.compareTo(minScope) <= 0) continue;
                    return respDto.getScope();
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }
}

