/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.task;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.biz.service.IStorageChargeDetailService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.data.redis.core.CustomStringRedisTemplate;

public class InnerTradeOrderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InnerTradeOrderTask.class);
    private ICacheService cacheService;
    private IStorageChargeDetailService storageChargeDetailService;
    private CustomStringRedisTemplate stringRedisTemplate;
    private ILockService lockService;

    public InnerTradeOrderTask(IStorageChargeDetailService storageChargeDetailService, ICacheService cacheService, CustomStringRedisTemplate stringRedisTemplate, ILockService lockService) {
        this.storageChargeDetailService = storageChargeDetailService;
        this.cacheService = cacheService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealInnerTradeOrder(String preOrderNo) {
        Mutex mutex = null;
        try {
            String LOCK_KEY = "DEAL_INNER_TRADE_ORDER";
            mutex = this.lockService.lock(LOCK_KEY, LOCK_KEY, 15);
            if (null == mutex) {
                throw new BizException("\u5185\u90e8\u4ea4\u6613\u4ed3\u50a8\u660e\u7ec6\u751f\u6210\u5f02\u5e38\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            if (StringUtils.isNotBlank((CharSequence)preOrderNo)) {
                TimeUnit.MILLISECONDS.sleep(10000L);
                LOGGER.info("\u5185\u90e8\u4ea4\u6613\u4ed3\u50a8\u660e\u7ec6\u751f\u6210\uff1a{}", (Object)preOrderNo);
                Boolean bl = this.storageChargeDetailService.createInnerTradeOrderDetail(preOrderNo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5904\u7406\u5f02\u5e38\uff0c\u91cd\u65b0\u653e\u56deredis\uff1a{}", (Object)preOrderNo);
            this.stringRedisTemplate.opsForList().rightPush((Object)(this.cacheService.getDefaultGroup() + ":" + "innerTradeOrderNotice"), (Object)preOrderNo);
        }
        finally {
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
                LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u5185\u90e8\u4ea4\u6613\u7f13\u5b58 > \u7f13\u5b58\u6807\u8bc6key\u4e3a => {}", (Object)"innerTradeOrderNotice");
                String preOrderNo = this.cacheService.blpop(30, "innerTradeOrderNotice");
                LOGGER.info("\u5f00\u59cb\u83b7\u53d6\u5185\u90e8\u4ea4\u6613\u7f13\u5b58 > \u51fa\u961f => {}", (Object)preOrderNo);
                this.dealInnerTradeOrder(preOrderNo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

