/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.WarehouseTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.InResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.InResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.InResultOrderRespDto;
import com.dtyunxi.tcbj.biz.service.IInResultOrderService;
import com.dtyunxi.tcbj.dao.das.InResultOrderDas;
import com.dtyunxi.tcbj.dao.das.InResultOrderDetailDas;
import com.dtyunxi.tcbj.dao.eo.InResultOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.InResultOrderEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InResultOrderServiceImpl
implements IInResultOrderService {
    @Resource
    private InResultOrderDas inResultOrderDas;
    @Resource
    private InResultOrderDetailDas inResultOrderDetailDas;

    @Override
    public Long addInResultOrder(InResultOrderReqDto addReqDto) {
        InResultOrderEo inResultOrderEo = new InResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inResultOrderEo);
        this.inResultOrderDas.insert((BaseEo)inResultOrderEo);
        return inResultOrderEo.getId();
    }

    @Override
    public void modifyInResultOrder(InResultOrderReqDto modifyReqDto) {
        InResultOrderEo inResultOrderEo = new InResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inResultOrderEo);
        this.inResultOrderDas.updateSelective((BaseEo)inResultOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInResultOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inResultOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InResultOrderRespDto queryById(Long id) {
        InResultOrderEo inResultOrderEo = (InResultOrderEo)this.inResultOrderDas.selectByPrimaryKey(id);
        InResultOrderRespDto inResultOrderRespDto = new InResultOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)inResultOrderEo, (BaseVo)inResultOrderRespDto);
        return inResultOrderRespDto;
    }

    @Override
    public PageInfo<InResultOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InResultOrderReqDto inResultOrderReqDto = (InResultOrderReqDto)JSON.parseObject((String)filter, InResultOrderReqDto.class);
        InResultOrderEo inResultOrderEo = new InResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)inResultOrderReqDto, (BaseEo)inResultOrderEo);
        PageInfo eoPageInfo = this.inResultOrderDas.selectPage((BaseEo)inResultOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InResultOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<InResultOrderRespDto> queryByWarehouse(List<String> warehouseCodes, Date detailDate) {
        Assert.notNull(warehouseCodes, (String)"0001", (String)"\u6307\u5b9a\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)detailDate, (String)"0001", (String)"\u6307\u5b9a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        InResultOrderEo inResultOrderEo = new InResultOrderEo();
        inResultOrderEo.setWarehouseClassify(WarehouseTypeEnum.LOGIC.getKey());
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"warehouse_code", warehouseCodes));
        sqlFilters.add(SqlFilter.lt((String)"create_time", (Object)detailDate));
        sqlFilters.add(SqlFilter.gt((String)"create_time", (Object)DateUtil.offsetDay((Date)detailDate, (int)-1)));
        List collect = this.inResultOrderDas.select((BaseEo)inResultOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)collect)) {
            ArrayList inResultOrderRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)collect, (Collection)inResultOrderRespDtos, InResultOrderRespDto.class);
            List documentNos = collect.stream().map(c -> c.getDocumentNo()).collect(Collectors.toList());
            InResultOrderDetailEo inResultOrderDetailEo = new InResultOrderDetailEo();
            inResultOrderDetailEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"document_no", documentNos)}));
            List inResultOrderDetailEos = this.inResultOrderDetailDas.select((BaseEo)inResultOrderDetailEo);
            Assert.notNull((Object)inResultOrderDetailEos, (String)"0001", (String)"\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38");
            ArrayList inResultOrderDetailRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)inResultOrderDetailEos, (Collection)inResultOrderDetailRespDtos, InResultOrderDetailRespDto.class);
            Map<String, List<InResultOrderDetailRespDto>> mapGroupByDocumentNo = inResultOrderDetailRespDtos.stream().collect(Collectors.groupingBy(InResultOrderDetailRespDto::getDocumentNo));
            inResultOrderRespDtos.forEach(c -> {
                List orDefault = mapGroupByDocumentNo.getOrDefault(c.getDocumentNo(), null);
                Assert.notNull((Object)orDefault, (String)"0001", (String)(c.getDocumentNo() + "\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38"));
                c.setInResultOrderDetailRespDtoList(orDefault);
            });
            return inResultOrderRespDtos;
        }
        return null;
    }
}

