/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.schedule;

import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.biz.service.IDeliveryResultOrderService;
import com.dtyunxi.tcbj.dao.das.SaleOrderApportionDas;
import com.dtyunxi.tcbj.dao.eo.SaleOrderApportionEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="saleOrderApportionDataSchedule")
@Scope(value="prototype")
public class SaleOrderApportionDataSchedule
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderApportionDataSchedule.class);
    @Resource
    private IDeliveryResultOrderService deliveryResultOrderService;
    @Resource
    private SaleOrderApportionDas saleOrderApportionDas;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u5206\u644a\u6570\u636e\u91cd\u65b0\u89e6\u53d1\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            List saleOrderApportionEoList = this.saleOrderApportionDas.queryUnapportionedWithinDays(30);
            if (CollectionUtils.isEmpty((Collection)saleOrderApportionEoList)) {
                log.info("\u67e5\u8be2\u5206\u644a\u6570\u636e\u4e3a\u7a7a\u4e0d\u9700\u8981\u91cd\u65b0\u89e6\u53d1");
                return true;
            }
            for (SaleOrderApportionEo eo : saleOrderApportionEoList) {
                this.deliveryResultOrderService.orderDetailApportionBase(eo.getOrderNo(), eo.getType());
            }
        }
        catch (Exception e) {
            log.error("\u5206\u644a\u6570\u636e\u91cd\u65b0\u89e6\u53d1\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8:{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u5206\u644a\u6570\u636e\u91cd\u65b0\u89e6\u53d1\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
    }
}

