/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IWarehouseIssueStatisticsApi;
import com.dtyunxi.tcbj.api.dto.request.WarehouseIssueStatisticsReqDto;
import com.dtyunxi.tcbj.biz.service.IWarehouseIssueStatisticsService;
import com.dtyunxi.util.DateUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WarehouseIssueStatisticsApiImpl
implements IWarehouseIssueStatisticsApi {
    private static final Logger log = LoggerFactory.getLogger(WarehouseIssueStatisticsApiImpl.class);
    @Resource
    private IWarehouseIssueStatisticsService warehouseIssueStatisticsService;
    @Resource
    private ICacheService cacheService;

    public RestResponse<Long> addWarehouseIssueStatistics(WarehouseIssueStatisticsReqDto addReqDto) {
        return new RestResponse((Object)this.warehouseIssueStatisticsService.addWarehouseIssueStatistics(addReqDto));
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> refreshWarehouseIssueStatistics() {
        String updateTime = DateUtil.format((Date)new Date(), (String)DatePattern.DATETIME_PATTERN.getPattern());
        log.info("\u624b\u52a8\u5237\u65b0\u4ed3\u5e93\u51fa\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
        this.warehouseIssueStatisticsService.syncWarehouseIssueStatics();
        this.cacheService.setCache("warehouse_issue_statistics_update_time", (Object)updateTime);
        return RestResponse.VOID;
    }

    public RestResponse<Void> refreshWarehouseIssueStatisticsExt() {
        String updateTime = DateUtil.format((Date)new Date(), (String)DatePattern.DATETIME_PATTERN.getPattern());
        log.info("\u624b\u52a8\u5237\u65b0\u4ed3\u5e93\u51fa\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb\u3010\u975e\u9500\u552e\u7c7b\u3011");
        this.warehouseIssueStatisticsService.syncWarehouseIssueStaticsExt();
        this.cacheService.setCache("warehouse_issue_statistics_update_time_ext", (Object)updateTime);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyWarehouseIssueStatistics(WarehouseIssueStatisticsReqDto modifyReqDto) {
        this.warehouseIssueStatisticsService.modifyWarehouseIssueStatistics(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeWarehouseIssueStatistics(String ids, Long instanceId) {
        this.warehouseIssueStatisticsService.removeWarehouseIssueStatistics(ids, instanceId);
        return RestResponse.VOID;
    }
}

