/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.biz.service.IWarehouseIssueStatisticsService;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="warehouseIssueStatisticsTask")
@Scope(value="prototype")
public class WarehouseIssueStatisticsTask
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(WarehouseIssueStatisticsTask.class);
    @Resource
    private IWarehouseIssueStatisticsService warehouseIssueStatisticsService;
    @Resource
    private ICacheService cacheService;

    public void before(TaskMsg taskMsg) {
        logger.info("\u4ed3\u5e93\u51fa\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            String updateTime = DateUtil.format((Date)new Date(), (String)DatePattern.DATETIME_PATTERN.getPattern());
            logger.error("\u4ed3\u5e93\u51fa\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
            this.warehouseIssueStatisticsService.syncWarehouseIssueStatics();
            this.cacheService.setCache("warehouse_issue_statistics_update_time", (Object)updateTime);
        }
        catch (Exception e) {
            logger.error("\u4ed3\u5e93\u51fa\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb\u5f02\u5e38", (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u4ed3\u5e93\u51fa\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f");
    }
}

