/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.constant.ReInsuranceBillTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceFlagEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumExceptionDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumDetailRespDto;
import com.dtyunxi.tcbj.biz.enums.ExpressBusinessTypeEnum;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumDetailService;
import com.dtyunxi.tcbj.dao.das.ReInsuranceBillDas;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumDetailDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsuranceBillEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumDetailEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumEo;
import com.dtyunxi.tcbj.dao.vo.InsuranceCustomerInfoVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReInsurancePremiumDetailServiceImpl
implements IReInsurancePremiumDetailService {
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumDetailServiceImpl.class);
    @Resource
    private ReInsurancePremiumDetailDas das;
    @Resource
    private ReInsuranceBillDas reInsuranceBillDas;
    @Resource
    private IReInsuranceBillService billService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;

    @Override
    public Long addReInsurancePremium(ReInsurancePremiumDetailReqDto addReqDto) {
        ReInsurancePremiumDetailEo reInsurancePremiumEo = new ReInsurancePremiumDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reInsurancePremiumEo);
        this.das.insert((BaseEo)reInsurancePremiumEo);
        return reInsurancePremiumEo.getId();
    }

    @Override
    public void modifyReInsurancePremium(ReInsurancePremiumDetailReqDto modifyReqDto) {
        ReInsurancePremiumDetailEo reInsurancePremiumEo = new ReInsurancePremiumDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reInsurancePremiumEo);
        this.das.updateSelective((BaseEo)reInsurancePremiumEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReInsurancePremium(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.das.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ReInsurancePremiumDetailRespDto queryById(Long id) {
        ReInsurancePremiumDetailEo reInsurancePremiumEo = (ReInsurancePremiumDetailEo)this.das.selectByPrimaryKey(id);
        ReInsurancePremiumDetailRespDto reInsurancePremiumRespDto = new ReInsurancePremiumDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)reInsurancePremiumEo, (BaseVo)reInsurancePremiumRespDto);
        return reInsurancePremiumRespDto;
    }

    @Override
    public PageInfo<ReInsurancePremiumDetailRespDto> queryByPage(ReInsurancePremiumDetailReqDto reqDto, Integer pageNum, Integer pageSize) {
        List eos;
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.setDate(reqDto);
        reqDto.setPageNum(pageNum);
        reqDto.setPageSize(pageSize);
        PageInfo dtoPageInfo = this.das.queryByPage(reqDto);
        List relevanceNos = dtoPageInfo.getList().stream().map(ReInsurancePremiumDetailRespDto::getRelevanceNo).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(relevanceNos) && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", relevanceNos)).isNotNull((Object)"pre_order_no")).list()))) {
            Map<String, String> stringMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getPreOrderNo, (k1, k2) -> k1));
            map.putAll(stringMap);
        }
        List dtoList = dtoPageInfo.getList().stream().map(eo -> {
            eo.setBillType(ReInsuranceBillTypeEnum.getNameByCode((String)eo.getBillType()));
            eo.setFlagName(InsuranceFlagEnum.getValueByCode((Integer)eo.getFlag()));
            eo.setShippingTypeName(eo.getShippingType());
            if (StringUtils.isNotBlank((CharSequence)eo.getBusinessType())) {
                eo.setBusinessTypeName(eo.getBusinessType());
                if (StringUtils.isNotBlank((CharSequence)ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()))) {
                    eo.setBusinessTypeName(ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getRelevanceNo()) && StringUtils.isBlank((CharSequence)eo.getExternalOrderNo()) && map.containsKey(eo.getRelevanceNo())) {
                eo.setExternalOrderNo((String)map.get(eo.getRelevanceNo()));
                Object[] externalOrderArray = eo.getExternalOrderNo().split(",");
                eo.setExternalOrderNo((String)Lists.newArrayList((Object[])externalOrderArray).stream().sorted().findFirst().get());
            }
            return eo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ReInsuranceBillCountDto queryFlagCount(ReInsurancePremiumDetailReqDto reqDto) {
        return this.das.queryFlagCount(reqDto);
    }

    private void setDate(ReInsurancePremiumDetailReqDto reInsurancePremiumReqDto) {
        try {
            if (ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeEnd())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String begin = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeBegin()) + " 00:00:00";
                String end = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeEnd()) + " 23:59:59";
                reInsurancePremiumReqDto.setInOutTimeBegin(simpleDateFormat.parse(begin));
                reInsurancePremiumReqDto.setInOutTimeEnd(simpleDateFormat.parse(end));
            }
        }
        catch (Exception e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String generateInsuranceReportNew(ReInsurancePremiumDetailReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210generateInsuranceReportNew\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return "00000";
    }

    @Override
    public String generateInsuranceReport(Date generateDate) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210\uff1a{}", (Object)generateDate);
        return "00000";
    }

    @Override
    public String updateInsuranceExceptionReport(ReInsurancePremiumExceptionDto exceptionDto) {
        this.logger.info("\u66f4\u65b0\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5f02\u5e38\u6570\u636e\uff1a{},{},{},{},{}", new Object[]{exceptionDto.getBeginDate(), exceptionDto.getEndDate(), exceptionDto.getShippingCompanyCode(), exceptionDto.getShippingType(), exceptionDto.getInsuranceCompany()});
        return "00000";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> updateInsuranceByLogistics(ReInsurancePremiumReportUpdateReqDto dto) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u66f4\u65b0\uff1a{}", (Object)dto);
        return new RestResponse((Object)"00000");
    }

    private void getCommonOtherData(ReInsuranceBillEo insuranceBillEo, Map<String, InsuranceCustomerInfoVo> physicsWareMap, Map<String, String> startPlaceMap) {
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)insuranceBillEo.getBusinessType());
        switch (typeEnum) {
            case ORDER_SALES_OUT: 
            case BAIJIAN_DIRECT_SALES: 
            case AGENCY_ORDER: {
                InsuranceCustomerInfoVo cusInfoVo = this.das.getOrderSalesOutData(insuranceBillEo.getRelevanceNo());
                if (cusInfoVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)cusInfoVo, (String[])new String[0]);
                break;
            }
            case OTHER_OUT: {
                InsuranceCustomerInfoVo otherOutVo = this.das.getOtherOutData(insuranceBillEo.getRelevanceNo());
                if (otherOutVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)otherOutVo, (String[])new String[0]);
                break;
            }
            case OUTSOURCE_REFUND: 
            case PURCHASE_REFUND: {
                InsuranceCustomerInfoVo refundVo = this.das.getOutResourceAndPurchaseRefundData(insuranceBillEo.getRelevanceNo());
                if (refundVo == null) break;
                insuranceBillEo.setOrderRemark(refundVo.getOrderRemark());
                insuranceBillEo.setExternalOrderNo(refundVo.getExternalOrderNo());
                break;
            }
            case ALLOT_OUT: 
            case ALLOT_OUT_ONLY: {
                InsuranceCustomerInfoVo allotOutVo = this.das.getAllotOutData(insuranceBillEo.getRelevanceNo(), physicsWareMap);
                if (allotOutVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)allotOutVo, (String[])new String[0]);
                break;
            }
            default: {
                insuranceBillEo.setRemark("\u83b7\u53d6\u5ba2\u6237\u5730\u5740\u3001\u5ba2\u6237\u540d\u79f0\u3001\u5916\u90e8\u5355\u53f7\u7b49\u6269\u5c55\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7c7b\u578b\u9519\u8bef\uff0c\u8be5\u7c7b\u578b\u3010" + insuranceBillEo.getBusinessType() + "\u3011\u4e0d\u5b58\u5728");
            }
        }
        insuranceBillEo.setStartPlace(this.das.getStartPlace(insuranceBillEo.getOutLogicWarehouseCode(), startPlaceMap));
        if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getDocumentNo())) {
            ConsignmentOrderAddressEo addressEo = this.das.queryAddress(insuranceBillEo.getDocumentNo());
            if (ObjectUtils.isNotEmpty((Object)addressEo)) {
                insuranceBillEo.setCustomerAddress(addressEo.getDetailAddress());
            } else {
                insuranceBillEo.setCustomerAddress(null);
            }
        }
    }

    @Override
    public String clearInsuranceByDate(ReInsurancePremiumDetailReqDto reqDto) {
        List billEoList;
        List premiumEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).list();
        if (CollectionUtils.isNotEmpty((Collection)premiumEoList)) {
            List ids = premiumEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.das.logicDeleteByIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(billEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsuranceBillDas.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).list()))) {
            List ids = billEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsuranceBillDas.logicDeleteByIds(ids);
        }
        return null;
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumDetailEo updateEo = new ReInsurancePremiumDetailEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List reInsurancePremiumEos = this.das.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = reInsurancePremiumEos.stream().filter(e -> e.getPlacedFlag() == null || e.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.das.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        this.logger.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillOrg(ReInsurancePremiumDetailReqDto reqDto) {
        this.logger.info("\u4fee\u6539\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u8ba1\u8d39\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumDetailEo premiumEo = (ReInsurancePremiumDetailEo)this.das.selectByPrimaryKey(reqDto.getId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)premiumEo), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        ReInsuranceBillEo billEo = (ReInsuranceBillEo)this.reInsuranceBillDas.selectByPrimaryKey(premiumEo.getBillId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)premiumEo), (String)"\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        billEo.setBillOrgCode(reqDto.getBillOrgCode());
        billEo.setBillOrgName(reqDto.getBillOrgName());
        billEo.setOrderRemark(reqDto.getOrderRemark());
        billEo.setRemark(reqDto.getOrderRemark());
        this.reInsuranceBillDas.updateSelective((BaseEo)billEo);
        premiumEo.setOrderRemark(reqDto.getOrderRemark());
        premiumEo.setRemark(reqDto.getOrderRemark());
        this.das.updateSelective((BaseEo)premiumEo);
    }

    @Override
    public void generateInsuranceReportImport(ReInsuranceBillReqDto billReqDto) {
        this.logger.info("\u5bfc\u5165\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u548c\u8d26\u5355\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)billReqDto));
        this.billService.addInsurePremiumAndBill(Lists.newArrayList());
    }

    @Override
    public List<InsuranceItemVo> getPcpItemByLongCode(List<String> longCodes) {
        return this.das.getPcpItemByLongCode(longCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByIds(List<Long> ids) {
        this.logger.info("\u5220\u9664\u4fdd\u8d39\u8d39\u7528\uff1a{}", ids);
        List premiumEoList = this.das.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)premiumEoList)) {
            return;
        }
        List placedFlagList = premiumEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(placedFlagList), (String)"\u5b58\u5728\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u5220\u9664");
        premiumEoList.forEach(premiumEo -> {
            if (ObjectUtils.isNotEmpty((Object)premiumEo.getBillId())) {
                List premiumEos;
                ReInsuranceBillEo billEo = (ReInsuranceBillEo)this.reInsuranceBillDas.selectByPrimaryKey(premiumEo.getBillId());
                if (ObjectUtils.isNotEmpty((Object)billEo)) {
                    this.reInsuranceBillDas.logicDeleteById(billEo.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)(premiumEos = ((ExtQueryChainWrapper)this.das.filter().eq((Object)"bill_id", (Object)premiumEo.getBillId())).list()))) {
                    List pIds = premiumEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.das.logicDeleteByIds(pIds);
                }
            } else {
                this.das.logicDeleteById(premiumEo.getId());
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ignoreExcByIds(List<Long> ids) {
        this.logger.info("\u5ffd\u7565\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(ids));
        List premiumEoList = this.das.selectByIds(ids);
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)premiumEoList), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        List placedFlagList = premiumEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(placedFlagList), (String)"\u5b58\u5728\u660e\u7ec6\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        List billIds = premiumEoList.stream().map(ReInsurancePremiumDetailEo::getBillId).filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
        List billEoList = this.reInsuranceBillDas.selectByIds(billIds);
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            List billPlacedFlagList = billEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
            AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(billPlacedFlagList), (String)"\u5b58\u5728\u5355\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        premiumEoList.forEach(eo -> {
            eo.setReason("");
            eo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
            this.das.updateSelective((BaseEo)eo);
        });
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            billEoList.forEach(eo -> {
                eo.setReason("");
                eo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                this.reInsuranceBillDas.updateSelective((BaseEo)eo);
            });
        }
    }

    @Override
    public void insertBatch(List<ReInsurancePremiumEo> premiumEoList) {
        if (CollUtil.isEmpty(premiumEoList)) {
            this.logger.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List detailEos = premiumEoList.stream().map(eo -> {
            ReInsurancePremiumDetailEo detailEo = new ReInsurancePremiumDetailEo();
            BeanUtil.copyProperties((Object)eo, (Object)detailEo, (String[])new String[]{"id"});
            detailEo.setFeeId(eo.getId());
            return detailEo;
        }).collect(Collectors.toList());
        this.das.insertBatch(detailEos);
    }
}

