/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.cube.component.track.commons.vo.pcp.ExternalDispatchBaseVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.tcbj.api.dto.request.NutritionCollectReqDto;
import com.dtyunxi.tcbj.api.dto.response.NutritionCollectRespDto;
import com.dtyunxi.tcbj.api.dto.response.NutritionOrderCollectDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.NutritionOrderCollectRespDto;
import com.dtyunxi.tcbj.biz.service.INutritionCollectService;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASBillReqDto;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NutritionCollectServiceImpl
implements INutritionCollectService {
    private Logger logger = LoggerFactory.getLogger(NutritionCollectServiceImpl.class);
    private final String[] orderTypes = new String[]{SaleOrderTypeEnum.ACTIVITY_ORDER.getType(), SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType()};
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public List<NutritionOrderCollectRespDto> execute(NutritionCollectReqDto reqDto) {
        List nutritionCollectRespList;
        this.logger.info("\u8425\u517b\u5bb6\u6c47\u603b\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (ObjectUtil.isEmpty((Object)reqDto.getStartTime()) || ObjectUtil.isEmpty((Object)reqDto.getEndTime())) {
            throw new BizException("-1", "\u65f6\u95f4\u8303\u56f4\u5fc5\u586b");
        }
        if (CollectionUtil.isEmpty((Collection)reqDto.getOrderTypes())) {
            reqDto.setOrderTypes(Arrays.asList((Object[])this.orderTypes.clone()));
        }
        if (CollectionUtil.isEmpty((Collection)(nutritionCollectRespList = this.saleOrderDas.nutritionCollectList(reqDto)))) {
            this.logger.info("\u65e0\u6c47\u603b\u6570\u636e");
            return null;
        }
        Map<String, List<NutritionCollectRespDto>> collect = nutritionCollectRespList.stream().collect(Collectors.groupingBy(NutritionCollectRespDto::getPlatformParentOrderNo));
        List platformOrderList = this.saleOrderDas.queryPlatformOrderList(new ArrayList<String>(collect.keySet()));
        Map<Object, Object> parentPlatformOrderMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)platformOrderList)) {
            parentPlatformOrderMap = platformOrderList.stream().collect(Collectors.toMap(NutritionCollectRespDto::getPlatformOrderNo, Function.identity(), (a1, a2) -> a2));
        }
        Map<String, List<String>> saleOrderMap = this.disposeSaleOrderNos(collect);
        ArrayList<NutritionOrderCollectRespDto> bills = new ArrayList<NutritionOrderCollectRespDto>();
        Map<Object, Object> finalParentPlatformOrderMap = parentPlatformOrderMap;
        collect.forEach((key, value) -> {
            NutritionCollectRespDto parent = (NutritionCollectRespDto)finalParentPlatformOrderMap.get(key);
            NutritionCollectRespDto dto = (NutritionCollectRespDto)value.get(0);
            NutritionOrderCollectRespDto bill = new NutritionOrderCollectRespDto();
            try {
                bill.setSeq(this.buildNo(dto.getPlatformParentOrderNo(), reqDto.getStartTime()));
            }
            catch (Exception e) {
                throw new BizException("-1", "\u751f\u6210seq\u5355\u53f7\u5f02\u5e38");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            bill.setBizDate(simpleDateFormat.format(dto.getCreateTime()));
            bill.setStorageOrgUnit(dto.getStorageOrgUnit());
            bill.setDescription(dto.getRemark());
            bill.setAddress(dto.getReceiveAddress());
            bill.setTell(dto.getReceivePhone());
            bill.setLinkMan(dto.getReceiveName());
            bill.setTransactionType("TC011");
            bill.setDescription(ObjectUtil.isNotEmpty((Object)parent) ? parent.getRemark() : "");
            bill.setAddress("\u603b\u5355");
            bill.setLinkMan("\u603b\u5355");
            bill.setTell("4000916916");
            bill.setCostCenterOrgUnit("0110010300");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pcpNumber", bill.getSeq());
            bill.setExtendsJsonMap(JSON.toJSONString(map));
            bill.setSaleOrderNoList((List)saleOrderMap.get(key));
            ArrayList entries = new ArrayList();
            value.forEach(detail -> {
                NutritionOrderCollectDetailRespDto billEntry = new NutritionOrderCollectDetailRespDto();
                billEntry.setMfg(detail.getMfg() != null ? simpleDateFormat.format(detail.getMfg()) : null);
                billEntry.setExp(detail.getExp() != null ? simpleDateFormat.format(detail.getExp()) : null);
                billEntry.setLot(detail.getBatch());
                billEntry.setQty(Long.valueOf(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? 0L : detail.getQuantity()));
                billEntry.setBaseQty(billEntry.getQty());
                billEntry.setWarehouse(dto.getWarehouseCode());
                billEntry.setMaterial(detail.getLongCode());
                entries.add(billEntry);
            });
            bill.setEntrys(entries);
            bills.add(bill);
        });
        return bills;
    }

    private void send(EASBillReqDto easBillReqDto) {
        this.logger.info("\u6c47\u603b\u6570\u636e\u63a8\u9001\u81f3EAS\u8bf7\u6c42\u670d\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)easBillReqDto));
        ExternalDispatchBaseVo baseVo = new ExternalDispatchBaseVo();
        baseVo.setExternalDispatchBaseEnum(ExternalDispatchBaseEnum.API_EAS010);
        baseVo.setData((Object)easBillReqDto);
        this.logger.info("\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)baseVo, (SerializeFilter)new PascalNameFilter(), (SerializerFeature[])new SerializerFeature[0]));
        this.commonsMqService.sendSingleMessage(ExternalDispatchBaseEnum.API_EAS010.getTopicKey(), ExternalDispatchBaseEnum.API_EAS010.getTagKey(), (Object)JSON.toJSONString((Object)baseVo));
    }

    private String buildNo(String no, String date) throws ParseException {
        this.logger.info("\u751f\u6210seq\u5355\u53f7\uff1a{}=={}", (Object)no, (Object)date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormatNo = new SimpleDateFormat("yyyyMMdd");
        return no + "_" + simpleDateFormatNo.format(simpleDateFormat.parse(date));
    }

    private Map<String, List<String>> disposeSaleOrderNos(Map<String, List<NutritionCollectRespDto>> collect) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        collect.forEach((key, value) -> {
            ArrayList orders = new ArrayList();
            value.forEach(v -> {
                String[] split = v.getSaleOrderNos().split(",");
                orders.addAll(Arrays.asList(split));
            });
            result.put((String)key, orders.stream().distinct().collect(Collectors.toList()));
        });
        return result;
    }
}

