/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOperateLogReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseRecordReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionHasReleaseTransferRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionPreemptNotReleaseRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionPreemptRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOperateLogRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseRecordRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionResultOrderSumRespDto;
import com.dtyunxi.tcbj.api.query.IInspectionReleaseOrderQueryApi;
import com.dtyunxi.tcbj.biz.service.IInspectionReleaseOperateLogService;
import com.dtyunxi.tcbj.biz.service.IInspectionReleaseOrderService;
import com.dtyunxi.tcbj.dao.das.InspectionReleaseOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InspectionReleaseOrderQueryApiImpl
implements IInspectionReleaseOrderQueryApi {
    @Resource
    private IInspectionReleaseOrderService inspectionReleaseOrderService;
    @Resource
    private IInspectionReleaseOperateLogService inspectionReleaseOperateLogService;
    @Autowired
    InspectionReleaseOrderDas inspectionReleaseOrderDas;

    public RestResponse<InspectionReleaseOrderRespDto> queryById(Long id) {
        return new RestResponse((Object)this.inspectionReleaseOrderService.queryById(id));
    }

    public RestResponse<PageInfo<InspectionReleaseOrderRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.inspectionReleaseOrderService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<InspectionReleaseRecordRespDto>> queryPage(InspectionReleaseRecordReqDto dto) {
        return new RestResponse(this.inspectionReleaseOrderService.queryPage(dto));
    }

    public RestResponse<InspectionReleaseCountRespDto> queryPageCount(InspectionReleaseRecordReqDto dto) {
        return new RestResponse((Object)this.inspectionReleaseOrderService.queryPageCount(dto));
    }

    public RestResponse<List<InspectionHasReleaseTransferRespDto>> queryHasReleaseTransferList(String longCode, String batch) {
        return new RestResponse(this.inspectionReleaseOrderService.queryHasReleaseTransferList(longCode, batch));
    }

    public RestResponse<PageInfo<InspectionReleaseOperateLogRespDto>> queryByLogPage(InspectionReleaseOperateLogReqDto dto) {
        return new RestResponse(this.inspectionReleaseOrderService.queryByLogPage(dto));
    }

    public RestResponse<List<InspectionPreemptNotReleaseRespDto>> queryPreemptNotRelease(String longCode, String batch) {
        List dtoList = this.inspectionReleaseOrderDas.queryPreemptNotRelease(longCode, batch);
        for (InspectionPreemptNotReleaseRespDto dto : dtoList) {
            Arrays.stream(CsOtherStorageOrderStatusEnum.OUT.values()).filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)dto.getOrderStatus())).findFirst().ifPresent(statusEnum -> dto.setOrderStatusName(statusEnum.getDesc()));
            CsPcpBusinessTypeEnum sourceTypeEnum = CsPcpBusinessTypeEnum.getByCode((String)dto.getSourceType());
            if (null == sourceTypeEnum) continue;
            dto.setSourceTypeName(sourceTypeEnum.getDesc());
        }
        return new RestResponse((Object)dtoList);
    }

    public RestResponse<List<InspectionPreemptRespDto>> queryPreemptList(String longCode, String batch) {
        List dtoList = this.inspectionReleaseOrderDas.queryPreemptList(longCode, batch);
        for (InspectionPreemptRespDto dto : dtoList) {
            Arrays.stream(CsOtherStorageOrderStatusEnum.OUT.values()).filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)dto.getOrderStatus()) && StringUtils.equals((CharSequence)dto.getSourceType(), (CharSequence)CsPcpBusinessTypeEnum.OTHER_OUT.getCode())).findFirst().ifPresent(statusEnum -> dto.setOrderStatusName(statusEnum.getDesc()));
            Arrays.stream(CsTransferOrderEnum.Status.values()).filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)dto.getOrderStatus()) && StringUtils.equals((CharSequence)dto.getSourceType(), (CharSequence)CsPcpBusinessTypeEnum.ALLOT_OUT.getCode())).findFirst().ifPresent(statusEnum -> dto.setOrderStatusName(statusEnum.getDesc()));
            CsPcpBusinessTypeEnum sourceTypeEnum = CsPcpBusinessTypeEnum.getByCode((String)dto.getSourceType());
            if (null == sourceTypeEnum) continue;
            dto.setSourceTypeName(sourceTypeEnum.getDesc());
        }
        return new RestResponse((Object)dtoList);
    }

    public RestResponse<PageInfo<InspectionResultOrderRespDto>> queryResultOrderList(InspectionResultOrderReqDto reqDto) {
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        PageInfo pageInfo = new PageInfo(this.inspectionReleaseOrderDas.queryResultOrderList(reqDto.getLongCode(), reqDto.getBatch()));
        Iterator iterator = pageInfo.getList().iterator();
        while (iterator.hasNext()) {
            InspectionResultOrderRespDto dto;
            dto.setOrderTypeName("in".equals((dto = (InspectionResultOrderRespDto)iterator.next()).getOrderType()) ? "\u5165\u5e93" : "\u51fa\u5e93");
        }
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<InspectionResultOrderSumRespDto> queryResultOrderListSum(String longCode, String batch) {
        return new RestResponse((Object)this.inspectionReleaseOrderDas.queryResultOrderListSum(longCode, batch));
    }

    public RestResponse<List<String>> querySubBatch(String longCode, String batch) {
        return new RestResponse((Object)this.inspectionReleaseOrderDas.querySubBatch(longCode, batch));
    }
}

