/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrganizationRespDto;
import com.dtyunxi.finance.api.query.IApportionmentConfigQueryApi;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingReportDto;
import com.dtyunxi.tcbj.api.dto.SortingExpenseChargingReportPageReqDto;
import com.dtyunxi.tcbj.api.dto.UpdateBillOrgDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseChargingService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.dao.das.ISortingExpenseDetailDas;
import com.dtyunxi.tcbj.dao.das.LogicWarehouseDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.das.SortingExpenseDas;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseChargingEo;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseEo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SortingExpenseChargingServiceImpl
implements ISortingExpenseChargingService {
    private static final Logger log = LoggerFactory.getLogger(SortingExpenseChargingServiceImpl.class);
    @Resource
    private ISortingExpenseDetailDas das;
    @Resource
    private LogicWarehouseDas logicWarehouseDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private ExecutorService statisticsExecutor;
    @Resource
    private IApportionmentConfigQueryApi apportionmentConfigQueryApi;
    @Resource
    private SortingExpenseDas sortingExpenseDas;
    private static List<String> transferOrderBusinessType = Lists.newArrayList();

    @Override
    public PageInfo<SortingExpenseChargingReportDto> page(SortingExpenseChargingReportPageReqDto dto) {
        Set<String> transferOrderNoList;
        List inWarehouseCodes;
        log.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo page = this.das.getPage(dto);
        PageInfo pageInfo = new PageInfo();
        if (ObjectUtils.isEmpty((Object)page) || CollectionUtil.isEmpty((Collection)page.getList())) {
            return pageInfo;
        }
        List transferBizList = page.getList().stream().filter(o -> transferOrderBusinessType.contains(o.getBusinessType())).collect(Collectors.toList());
        Map<Object, Object> transferOrderEoMap = Maps.newHashMap();
        Map<Object, Object> transferInLogicWarehouseEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(transferBizList) && CollectionUtil.isNotEmpty(inWarehouseCodes = (transferOrderEoMap = this.queryTransferOrder(transferOrderNoList = transferBizList.stream().map(SortingExpenseChargingDto::getRelevanceNo).collect(Collectors.toSet()))).values().stream().map(CsTransferOrderEo::getInLogicWarehouseCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList()))) {
            List inLogicWarehouseEos = this.logicWarehouseDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getWarehouseCode, inWarehouseCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            transferInLogicWarehouseEoMap = inLogicWarehouseEos.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        }
        Long abnormalNum = page.getList().stream().filter(item -> item.getAbnormal() == 1).count();
        BeanUtils.copyProperties((Object)page, (Object)pageInfo, (String[])new String[]{"list"});
        ArrayList respDtoList = Lists.newArrayList();
        for (SortingExpenseChargingDto resp : page.getList()) {
            LogicWarehouseEo logicWarehouseEo;
            CsTransferOrderEo csTransferOrderEo;
            SortingExpenseChargingReportDto respDto = new SortingExpenseChargingReportDto();
            BeanUtils.copyProperties((Object)resp, (Object)respDto);
            respDto.setOutWarehouseTimeStr(DateUtil.format((Date)resp.getOutWarehouseTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            respDto.setWmsDocumentNo(resp.getWmsOrderNo());
            respDto.setDocumentNo(resp.getDocumentNo());
            respDto.setBusinessType(resp.getBusinessType());
            respDto.setOutWarehouse(resp.getOutLogicWarehouseName());
            respDto.setOutOrgName(resp.getOutOrganizationName());
            respDto.setInWarehouse(resp.getInLogicWarehouseName());
            respDto.setInOrgName(resp.getInOrganizationName());
            respDto.setCostAttribution(resp.getExpenseOrganizationName());
            respDto.setOutQuantity(ObjectUtils.isEmpty((Object)resp.getDoneQuantity()) ? null : String.valueOf(resp.getDoneQuantity().intValue()));
            respDto.setPackageNum(ObjectUtils.isEmpty((Object)resp.getBigRatio()) ? null : String.valueOf(resp.getBigRatio()));
            respDto.setSmallPackageNum(ObjectUtils.isEmpty((Object)resp.getSmallRatio()) ? null : String.valueOf(resp.getSmallRatio()));
            respDto.setLargeBox(ObjectUtils.isEmpty((Object)resp.getBigBoxNum()) ? null : String.valueOf(resp.getBigBoxNum().intValue()));
            respDto.setNumber(ObjectUtils.isEmpty((Object)resp.getBoxNum()) ? null : String.valueOf(resp.getBoxNum().intValue()));
            respDto.setSmallBox(ObjectUtils.isEmpty((Object)resp.getSmallBoxNum()) ? null : String.valueOf(resp.getSmallBoxNum().intValue()));
            respDto.setAdjustType(ObjectUtils.isEmpty((Object)resp.getAdjustType()) ? null : resp.getAdjustType());
            respDto.setPlatformAdjustAmount(ObjectUtils.isEmpty((Object)resp.getAdjustNum()) ? null : String.valueOf(resp.getAdjustNum().setScale(2, 4)));
            respDto.setCostTypeName(DailyDeliveryReportCostBelongDetailCostTypeEnum.getDesc((String)resp.getCostType()));
            respDto.setRemark(resp.getAdjustRemarks());
            if (resp.getSortingNum() == null) {
                resp.setSortingNum(BigDecimal.ZERO);
            }
            Long adjustType = resp.getAdjustType();
            BigDecimal sortingNum = resp.getSortingNum();
            if (Objects.equals(1L, adjustType) && null != resp.getAdjustNum()) {
                sortingNum = sortingNum.add(resp.getAdjustNum());
            }
            if (Objects.equals(2L, adjustType) && null != resp.getAdjustNum()) {
                sortingNum = sortingNum.subtract(resp.getAdjustNum());
            }
            respDto.setTotalSortingFee(sortingNum.setScale(2, 4).toString());
            respDto.setImportUpdatePerson(resp.getImportUpdatePerson());
            if (!ObjectUtils.isEmpty((Object)resp.getImportUpdateTime())) {
                respDto.setImportUpdateTimeStr(DateUtil.format((Date)resp.getImportUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            respDto.setAbnormal(resp.getAbnormal());
            respDto.setAbnormalCauses(resp.getAbnormalCauses());
            respDto.setAbnormalNum(abnormalNum);
            respDto.setGoodsLongCode(resp.getLongCode());
            respDto.setGoodsName(resp.getCargoName());
            if (resp.getAbnormal() == null || Objects.equals(resp.getAbnormal(), 1)) {
                if (resp.getAdjustNum() == null) {
                    respDto.setPlatformAdjustAmount("/");
                }
                if (StringUtils.isBlank((CharSequence)resp.getAdjustRemarks())) {
                    respDto.setRemark("/");
                }
                respDto.setTotalSortingFee("/");
            }
            respDto.setExternalOrderNo(resp.getExternalOrderNo());
            respDto.setId(resp.getId());
            if (transferOrderBusinessType.contains(resp.getBusinessType()) && null != (csTransferOrderEo = (CsTransferOrderEo)transferOrderEoMap.get(resp.getRelevanceNo())) && null != (logicWarehouseEo = (LogicWarehouseEo)transferInLogicWarehouseEoMap.get(csTransferOrderEo.getInLogicWarehouseCode()))) {
                respDto.setInWarehouseCode(logicWarehouseEo.getWarehouseCode());
                respDto.setInWarehouse(logicWarehouseEo.getWarehouseName());
                respDto.setInOrgName(logicWarehouseEo.getOrganizationName());
            }
            respDto.setUpdateTime(resp.getUpdateTime());
            respDto.setUpdatePerson(resp.getUpdatePerson());
            respDtoList.add(respDto);
        }
        pageInfo.setList((List)respDtoList);
        return pageInfo;
    }

    @Override
    public void updateBillOrg(UpdateBillOrgDto reqDto) {
        this.das.updateBillOrg(reqDto);
    }

    private Map<String, CsTransferOrderEo> queryTransferOrder(Set<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Maps.newHashMap();
        }
        List<CsTransferOrderEo> eos = this.asyncQueryTransferOrder(orderNos);
        if (CollectionUtil.isEmpty(eos)) {
            return Maps.newHashMap();
        }
        return eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, Function.identity(), (k1, k2) -> k1));
    }

    private List<CsTransferOrderEo> asyncQueryTransferOrder(Set<String> orderNos) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.getTransferOrder(orderNos), this.statisticsExecutor);
        try {
            return future.get();
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u67e5\u8be2\u8c03\u62e8\u5355\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<CsTransferOrderEo> getTransferOrder(Set<String> orderNos) {
        List eos = ((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        return eos;
    }

    @Override
    public void insertBatchByConfig(List<SortingExpenseEo> sortingExpenseEos) {
        if (CollUtil.isEmpty(sortingExpenseEos)) {
            log.info("\u5206\u62e3\u8d39\u7528\u62a5\u8868\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        String code = DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode();
        ApportionmentConfigExtRespDto config = (ApportionmentConfigExtRespDto)RestResponseHelper.extractData((RestResponse)this.apportionmentConfigQueryApi.queryByCostModuleCode(code));
        if (Objects.isNull(config)) {
            log.info("\u5206\u644a\u57fa\u7840\u914d\u7f6e\u4e3a\u7a7a\uff0c\u4e0d\u751f\u6210\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6");
            return;
        }
        log.info("\u5206\u644a\u57fa\u7840\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)config));
        Integer isShareholdingApportionment = config.getIsShareholdingApportionment();
        List organizationList = config.getOrganizationList();
        if (Objects.equals(isShareholdingApportionment, 0) || CollUtil.isEmpty((Collection)organizationList)) {
            for (SortingExpenseEo insertEo : sortingExpenseEos) {
                insertEo.setIfApportion(Integer.valueOf(0));
                insertEo.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            }
        } else {
            Map configOrganizationMap = organizationList.stream().collect(Collectors.toMap(ApportionmentOrganizationRespDto::getOrganizationCode, Function.identity(), (k1, k2) -> k1));
            Iterator<SortingExpenseEo> iterator = sortingExpenseEos.iterator();
            while (iterator.hasNext()) {
                SortingExpenseEo insertEo;
                String expenseOrganizationId = (insertEo = iterator.next()).getExpenseOrganizationId();
                insertEo.setIfApportion(Integer.valueOf(configOrganizationMap.containsKey(expenseOrganizationId) ? 1 : 0));
            }
        }
        this.insertBatchJoinStockApportion(sortingExpenseEos, true);
    }

    @Override
    public void insertBatchJoinStockApportion(List<SortingExpenseEo> sortingExpenseEos, boolean stockApportionInsert) {
        List<SortingExpenseChargingEo> detailEos = sortingExpenseEos.stream().filter(eo -> StrUtil.isNotBlank((CharSequence)eo.getCostType())).map(eo -> {
            SortingExpenseChargingEo detailEo = new SortingExpenseChargingEo();
            BeanUtil.copyProperties((Object)eo, (Object)detailEo, (String[])new String[]{"id"});
            detailEo.setFeeId(eo.getId());
            detailEo.setBillingOrgCode(eo.getExpenseOrganizationId());
            detailEo.setBillingOrgName(eo.getExpenseOrganizationName());
            detailEo.setAllocationQuantity((BigDecimal)ObjectUtils.defaultIfNull((Object)eo.getApportionNum(), (Object)eo.getDoneQuantity()));
            detailEo.setApportionFee((BigDecimal)ObjectUtils.defaultIfNull((Object)eo.getApportionFee(), (Object)eo.getSortingNum()));
            return detailEo;
        }).collect(Collectors.toList());
        this.insertBatch(detailEos);
        List apportionIds = sortingExpenseEos.stream().filter(eo -> Objects.equals(eo.getIfApportion(), 1)).map(BaseEo::getId).collect(Collectors.toList());
        this.sortingExpenseDas.updateIfApportionByIds(apportionIds, Integer.valueOf(1));
        List notApportionIds = detailEos.stream().filter(eo -> Objects.equals(eo.getIfApportion(), 0)).map(SortingExpenseChargingEo::getFeeId).collect(Collectors.toList());
        this.sortingExpenseDas.updateIfApportionByIds(notApportionIds, Integer.valueOf(0));
        List apportionDtos = detailEos.stream().filter(eo -> Objects.equals(eo.getIfApportion(), 1)).map(detailEo -> {
            DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
            apportionDto.setBookkeepingMonth(DateTimeUtils.formatDate(detailEo.getOutWarehouseTime(), "yyyy-MM"));
            apportionDto.setReportId(detailEo.getLinkDailyReportId());
            apportionDto.setFeeId(detailEo.getFeeId());
            apportionDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
            apportionDto.setApportionStatus("NOT_APPORTION");
            apportionDto.setApportionTotal(detailEo.getDoneQuantity());
            apportionDto.setApportionAlready(BigDecimal.ZERO);
            return apportionDto;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(apportionDtos) && stockApportionInsert) {
            IDailyDeliveryReportStockApportionService apportionService = (IDailyDeliveryReportStockApportionService)SpringBeanUtil.getBean(IDailyDeliveryReportStockApportionService.class);
            apportionService.insertBatch(apportionDtos);
        }
    }

    public void insertBatch(List<SortingExpenseChargingEo> detailEos) {
        if (CollUtil.isEmpty(detailEos)) {
            log.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        this.das.insertBatch(detailEos);
    }

    static {
        transferOrderBusinessType.add("allot_out_only");
        transferOrderBusinessType.add("allot_out");
        transferOrderBusinessType.add("bc_allot");
    }
}

