/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseChargingService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseJobService;
import com.dtyunxi.tcbj.dao.das.ISortingExpenseDetailDas;
import com.dtyunxi.tcbj.dao.das.SortingExpenseDas;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.dto.entity.FeeRegenerateDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SortingExpenseJobServiceImpl
implements ISortingExpenseJobService {
    private final Logger LOGGER = LoggerFactory.getLogger(SortingExpenseJobServiceImpl.class);
    @Resource
    private SortingExpenseDas sortingExpenseDas;
    @Resource
    private ISortingExpenseChargingService sortingExpenseChargingService;
    @Resource
    private ISortingExpenseDetailDas sortingExpenseDetailDas;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService costBelongDetailService;

    @Override
    public void generateBySortingFee(FeeRegenerateDto reqDto) {
        String orderShippingTime = reqDto.getOrderShippingTime();
        AssertUtils.notBlank((String)orderShippingTime, (String)"orderShippingTime\u53c2\u6570\u6709\u8bef");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        YearMonth yearMonthObject = YearMonth.parse(orderShippingTime);
        LocalDateTime startOfMonth = yearMonthObject.atDay(1).atStartOfDay();
        LocalDateTime endOfMonth = yearMonthObject.atEndOfMonth().atTime(23, 59, 59);
        Date startDate = Date.from(startOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(endOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        String startDateStr = sdf.format(startDate);
        String endDateStr = sdf.format(endDate);
        DailyDeliveryReportStockApportionDto apportionDto = (DailyDeliveryReportStockApportionDto)BeanUtil.copyProperties((Object)reqDto, DailyDeliveryReportStockApportionDto.class, (String[])new String[0]);
        apportionDto.setOrderShippingTimeStart(startDateStr);
        apportionDto.setOrderShippingTimeEnd(endDateStr);
        this.generateBySortingFee(apportionDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBySortingFee(DailyDeliveryReportStockApportionDto reqDto) {
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{reqDto.getOrderShippingTimeStart(), reqDto.getOrderShippingTimeEnd()})) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        List costTypeList = reqDto.getCostTypeList();
        List chargingEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDetailDas.filter().ge(StringUtils.isNotBlank((CharSequence)reqDto.getOrderShippingTimeStart()), (Object)"out_warehouse_time", (Object)reqDto.getOrderShippingTimeStart())).le(StringUtils.isNotBlank((CharSequence)reqDto.getOrderShippingTimeEnd()), (Object)"out_warehouse_time", (Object)reqDto.getOrderShippingTimeEnd())).in(CollUtil.isNotEmpty((Collection)reqDto.getPhysicalWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getPhysicalWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)costTypeList), (Object)"bill_type", (Collection)costTypeList)).list();
        if (CollUtil.isNotEmpty((Collection)chargingEos)) {
            List delIds = chargingEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.LOGGER.info("\u5220\u9664\u65e7\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(delIds));
            this.sortingExpenseDetailDas.logicDeleteByIds(delIds);
        }
        if (CollUtil.isNotEmpty((Collection)costTypeList) && costTypeList.contains(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            List sortingExpenseList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().ge(StringUtils.isNotBlank((CharSequence)reqDto.getOrderShippingTimeStart()), (Object)"out_warehouse_time", (Object)reqDto.getOrderShippingTimeStart())).le(StringUtils.isNotBlank((CharSequence)reqDto.getOrderShippingTimeEnd()), (Object)"out_warehouse_time", (Object)reqDto.getOrderShippingTimeEnd())).in(CollUtil.isNotEmpty((Collection)reqDto.getPhysicalWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getPhysicalWarehouseCodeList())).list();
            for (SortingExpenseEo sortingExpenseEo : sortingExpenseList) {
                sortingExpenseEo.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
                sortingExpenseEo.setIfApportion(Integer.valueOf(1));
            }
            this.sortingExpenseChargingService.insertBatchJoinStockApportion(sortingExpenseList, false);
        }
        if (CollUtil.isNotEmpty((Collection)costTypeList) && !costTypeList.contains(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            int pageNum = 1;
            DailyDeliveryReportCostBelongDetailDto belongDetailDto = new DailyDeliveryReportCostBelongDetailDto();
            belongDetailDto.setPageSize(Integer.valueOf(2000));
            belongDetailDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
            belongDetailDto.setOrderShippingTimeStart(reqDto.getOrderShippingTime());
            belongDetailDto.setOrderShippingTimeStart(reqDto.getOrderShippingTimeStart());
            belongDetailDto.setOrderShippingTimeEnd(reqDto.getOrderShippingTimeEnd());
            belongDetailDto.setPhysicalWarehouseCodeList(reqDto.getPhysicalWarehouseCodeList());
            belongDetailDto.setCostTypeList(costTypeList);
            while (true) {
                belongDetailDto.setPageNum(Integer.valueOf(pageNum));
                PageInfo pageInfo = this.costBelongDetailService.queryPage(belongDetailDto);
                List costBelongDetailList = pageInfo.getList();
                if (CollUtil.isEmpty((Collection)costBelongDetailList)) {
                    this.LOGGER.info("\u8d39\u7528\u5f52\u5c5e\u6570\u636e\u4e3a\u7a7a pageNum\uff1a {}", (Object)pageNum);
                    break;
                }
                this.LOGGER.info("\u5206\u9875\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e\u6570\u636e pageNum\uff1a {} pageInfo\uff1a {}", (Object)pageNum, (Object)JSON.toJSONString((Object)costBelongDetailList));
                ++pageNum;
                List feeIds = costBelongDetailList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollUtil.isEmpty(feeIds)) continue;
                List sortingExpenseEos = ((ExtQueryChainWrapper)this.sortingExpenseDas.filter().in((Object)"id", feeIds)).list();
                Map sortingExpenseEoMap = sortingExpenseEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
                List<SortingExpenseEo> expenseEos = costBelongDetailList.stream().filter(belongDetail -> sortingExpenseEoMap.containsKey(belongDetail.getFeeId())).map(belongDetail -> {
                    SortingExpenseEo sortingExpenseEo = (SortingExpenseEo)sortingExpenseEoMap.get(belongDetail.getFeeId());
                    SortingExpenseEo expenseEo = (SortingExpenseEo)BeanUtil.copyProperties((Object)sortingExpenseEo, SortingExpenseEo.class, (String[])new String[0]);
                    expenseEo.setCostType(belongDetail.getCostType());
                    expenseEo.setApportionFee(this.apportionSortingExpense(sortingExpenseEo, (DailyDeliveryReportCostBelongDetailDto)belongDetail));
                    expenseEo.setApportionNum(belongDetail.getApportionNum());
                    expenseEo.setExpenseOrganizationId(belongDetail.getCostOrgCode());
                    expenseEo.setExpenseOrganizationName(belongDetail.getCostOrgName());
                    sortingExpenseEo.setIfApportion(Integer.valueOf(1));
                    return expenseEo;
                }).collect(Collectors.toList());
                this.sortingExpenseChargingService.insertBatchJoinStockApportion(expenseEos, false);
            }
        }
    }

    private BigDecimal apportionSortingExpense(SortingExpenseEo sortingExpenseEo, DailyDeliveryReportCostBelongDetailDto costBelongDetailDto) {
        if (Objects.isNull(sortingExpenseEo) || Objects.isNull(costBelongDetailDto)) {
            return BigDecimal.ZERO;
        }
        BigDecimal doneQuantity = sortingExpenseEo.getDoneQuantity();
        BigDecimal sortingNum = sortingExpenseEo.getSortingNum();
        if (BigDecimalUtils.leZero((BigDecimal)doneQuantity).booleanValue() || BigDecimalUtils.leZero((BigDecimal)sortingNum).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal apportionNum = costBelongDetailDto.getApportionNum();
        if (BigDecimalUtils.leZero((BigDecimal)apportionNum).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal apportionProportion = NumberUtil.div((Number)apportionNum, (Number)doneQuantity, (int)2);
        return NumberUtil.mul((Number)apportionProportion, (Number)sortingNum);
    }
}

