/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.ShipmentStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.LargeDataScreenRespDto;
import com.dtyunxi.tcbj.api.dto.response.ShipmentStatisticsRespDto;
import com.dtyunxi.tcbj.biz.service.IShipmentStatisticsService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.dao.das.ShipmentStatisticsDas;
import com.dtyunxi.tcbj.dao.eo.ShipmentStatisticsEo;
import com.dtyunxi.tcbj.dao.vo.LargeDataScreenVo;
import com.dtyunxi.tcbj.dao.vo.QueryStatisticVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShipmentStatisticsServiceImpl
implements IShipmentStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(ShipmentStatisticsServiceImpl.class);
    @Resource
    private ShipmentStatisticsDas shipmentStatisticsDas;

    @Override
    public Long addShipmentStatistics(ShipmentStatisticsReqDto addReqDto) {
        ShipmentStatisticsEo shipmentStatisticsEo = new ShipmentStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shipmentStatisticsEo);
        this.shipmentStatisticsDas.insert((BaseEo)shipmentStatisticsEo);
        return shipmentStatisticsEo.getId();
    }

    @Override
    public void modifyShipmentStatistics(ShipmentStatisticsReqDto modifyReqDto) {
        ShipmentStatisticsEo shipmentStatisticsEo = new ShipmentStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)shipmentStatisticsEo);
        this.shipmentStatisticsDas.updateSelective((BaseEo)shipmentStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShipmentStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.shipmentStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ShipmentStatisticsRespDto queryById(Long id) {
        this.syncShipmentStatisticsData();
        ShipmentStatisticsEo shipmentStatisticsEo = (ShipmentStatisticsEo)this.shipmentStatisticsDas.selectByPrimaryKey(id);
        ShipmentStatisticsRespDto shipmentStatisticsRespDto = new ShipmentStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)shipmentStatisticsEo, (BaseVo)shipmentStatisticsRespDto);
        return shipmentStatisticsRespDto;
    }

    @Override
    public PageInfo<ShipmentStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ShipmentStatisticsReqDto shipmentStatisticsReqDto = (ShipmentStatisticsReqDto)JSON.parseObject((String)filter, ShipmentStatisticsReqDto.class);
        ShipmentStatisticsEo shipmentStatisticsEo = new ShipmentStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)shipmentStatisticsReqDto, (BaseEo)shipmentStatisticsEo);
        PageInfo eoPageInfo = this.shipmentStatisticsDas.selectPage((BaseEo)shipmentStatisticsEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ShipmentStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncShipmentStatisticsData() {
        List<ShipmentStatisticsEo> saleOrderEos = this.queryOrder(1);
        List<ShipmentStatisticsEo> transferOrderEos = this.queryOrder(2);
        HashSet keys = Sets.newHashSet();
        Map<String, List<ShipmentStatisticsEo>> saleOrderMap = null;
        Map<String, List<ShipmentStatisticsEo>> transferOrderMap = null;
        if (CollectionUtil.isNotEmpty(saleOrderEos)) {
            saleOrderMap = saleOrderEos.stream().collect(Collectors.groupingBy(ShipmentStatisticsEo::getUniqueKey));
            keys.addAll(saleOrderMap.keySet());
        }
        if (CollectionUtil.isNotEmpty(transferOrderEos)) {
            transferOrderMap = transferOrderEos.stream().collect(Collectors.groupingBy(ShipmentStatisticsEo::getUniqueKey));
            keys.addAll(transferOrderMap.keySet());
        }
        if (CollectionUtil.isEmpty((Collection)keys)) {
            return;
        }
        ArrayList eos = Lists.newArrayList();
        for (String key : keys) {
            eos.add(this.assembleData(saleOrderMap.get(key), transferOrderMap.get(key)));
        }
        log.info("\u8fd17\u5929\u5df2\u53d1\u8d27\u7edf\u8ba1eos:{}", (Object)JSON.toJSONString((Object)eos));
        this.save(eos);
    }

    @Override
    public ShipmentStatisticsRespDto queryTotal(ShipmentStatisticsReqDto queryDto) {
        ShipmentStatisticsEo eo = this.shipmentStatisticsDas.queryTotalCount(queryDto.getWarehouseCode(), queryDto.getOrgCode());
        ShipmentStatisticsRespDto dto = new ShipmentStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    public List<LargeDataScreenRespDto> queryOrderProportion(Integer type) {
        BigDecimal totalCount;
        String startTime = DateTimeUtils.getDateStr(-7);
        if (Objects.equals(type, 2)) {
            startTime = String.format("%s 01", DateTimeUtils.formatDate(new Date(), "yyyy-MM"));
        }
        if ((totalCount = this.shipmentStatisticsDas.queryOrderTotalCountByStartTime(startTime)) == null) {
            return Lists.newArrayList();
        }
        List vos = this.shipmentStatisticsDas.queryOrderCountByStartTime(startTime);
        ArrayList dtoList = Lists.newArrayList();
        BigDecimal allProportion = BigDecimal.ZERO;
        for (int i = 0; i < vos.size(); ++i) {
            LargeDataScreenVo vo = (LargeDataScreenVo)vos.get(i);
            LargeDataScreenRespDto dto = new LargeDataScreenRespDto();
            BigDecimal count = vo.getCount();
            dto.setCount(count);
            dto.setWarehouseCode(vo.getWarehouseCode());
            dto.setWarehouseName(vo.getWarehouseName());
            if (count != null) {
                if (BigDecimal.ONE.compareTo(allProportion) > 0) {
                    if (i == vos.size()) {
                        dto.setProportion(BigDecimal.ONE.subtract(allProportion));
                    } else {
                        BigDecimal ratio = count.divide(totalCount, 3, 1);
                        if (BigDecimal.ONE.compareTo(allProportion = allProportion.add(ratio)) > 0) {
                            dto.setProportion(BigDecimal.ONE.subtract(allProportion));
                        } else {
                            dto.setProportion(ratio);
                        }
                    }
                } else {
                    dto.setProportion(BigDecimal.ZERO);
                }
            }
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Transactional(rollbackFor={Exception.class})
    private void save(List<ShipmentStatisticsEo> eos) {
        this.shipmentStatisticsDas.deleteAll();
        this.shipmentStatisticsDas.insertBatch(eos);
    }

    private ShipmentStatisticsEo assembleData(List<ShipmentStatisticsEo> saleOrders, List<ShipmentStatisticsEo> transferOrders) {
        ShipmentStatisticsEo eo;
        ShipmentStatisticsEo shipmentStatisticsEo = new ShipmentStatisticsEo();
        Long num = 0L;
        BigDecimal volume = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(saleOrders)) {
            eo = saleOrders.get(0);
            shipmentStatisticsEo.setWarehouseCode(eo.getWarehouseCode());
            shipmentStatisticsEo.setWarehouseName(eo.getWarehouseName());
            shipmentStatisticsEo.setOrg(eo.getOrg());
            shipmentStatisticsEo.setOrgCode(eo.getOrgCode());
            for (ShipmentStatisticsEo saleOrder : saleOrders) {
                num = num + 1L;
                volume = volume.add(saleOrder.getVolume());
            }
        }
        if (CollectionUtil.isNotEmpty(transferOrders)) {
            eo = transferOrders.get(0);
            shipmentStatisticsEo.setWarehouseCode(eo.getWarehouseCode());
            shipmentStatisticsEo.setWarehouseName(eo.getWarehouseName());
            shipmentStatisticsEo.setOrg(eo.getOrg());
            shipmentStatisticsEo.setOrgCode(eo.getOrgCode());
            for (ShipmentStatisticsEo transferOrder : transferOrders) {
                num = num + 1L;
                volume = volume.add(transferOrder.getVolume());
            }
        }
        shipmentStatisticsEo.setNum(num);
        shipmentStatisticsEo.setVolume(volume);
        return shipmentStatisticsEo;
    }

    private List<ShipmentStatisticsEo> queryOrder(Integer type) {
        ArrayList list = Lists.newArrayList();
        Integer pageNum = 1;
        Integer pageSize = 10000;
        QueryStatisticVo queryStatisticVo = new QueryStatisticVo();
        queryStatisticVo.setPageSize(pageSize);
        while (true) {
            queryStatisticVo.setPageNum(pageNum);
            List eos = Objects.equals(type, 1) ? this.shipmentStatisticsDas.querySaleOrderShipmentList(queryStatisticVo) : this.shipmentStatisticsDas.queryTransferOrderShipmentList(queryStatisticVo);
            if (!CollectionUtil.isNotEmpty((Collection)eos)) break;
            list.addAll(eos);
            if (CollectionUtil.isNotEmpty((Collection)eos) && eos.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return list;
    }
}

