/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.dtyunxi.tcbj.api.dto.request.CsMonitorIgnoreReqDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorApiResponseDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorIntransitInventoryOverchargeRespDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorIntransitOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorIntransitOutAndInNumRespDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorResultNoNumRespDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorSapErrorOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorSystemResponseDto;
import com.dtyunxi.tcbj.api.dto.response.MonitorTransferOrderInTimeOutRespDto;
import com.dtyunxi.tcbj.api.dto.response.PcpOpenapiLogRespDto;
import com.dtyunxi.tcbj.biz.enums.MonitorEnum;
import com.dtyunxi.tcbj.biz.service.IMonitorReportService;
import com.dtyunxi.tcbj.dao.das.CsMonitorIgnoreDas;
import com.dtyunxi.tcbj.dao.das.MonitorDas;
import com.dtyunxi.tcbj.dao.eo.CsMonitorIgnoreEo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorReportServiceImpl
implements IMonitorReportService {
    private static final Logger logger = LoggerFactory.getLogger(MonitorReportServiceImpl.class);
    private static final String SYS_EAS = "EAS";
    private static final String SYS_WMS = "WMS";
    private static final String SYS_FINANCE = "FINANCE";
    private static final String SYS_OCS = "OCS";
    private static final String SYS_TIME_OUT = "TIMEOUT";
    private static final String SYS_SAP = "SAP";
    @Autowired
    private MonitorDas monitorDas;
    @Resource
    private CsMonitorIgnoreDas csMonitorIgnoreDas;

    @Override
    public List<MonitorSystemResponseDto> monitorSystemCount() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0c\u7cfb\u7edf\u76d1\u63a7\u7edf\u8ba1");
        ArrayList<MonitorSystemResponseDto> list = new ArrayList<MonitorSystemResponseDto>();
        list.add(this.monitorWmsCount());
        list.add(this.clearList(this.monitorFinanceList()));
        list.add(this.clearList(this.monitorEasList()));
        list.add(this.clearList(this.monitorSapList()));
        list.add(this.clearList(this.monitorOcsList()));
        list.add(this.clearList(this.monitorTimeOutList()));
        return list;
    }

    private MonitorSystemResponseDto clearList(MonitorSystemResponseDto dto) {
        dto.setMonitorApiList(null);
        return dto;
    }

    @Override
    public MonitorSystemResponseDto monitorSystemCountByCode(String systemCode) {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0c\u7cfb\u7edf\u76d1\u63a7\u7edf\u8ba1\uff0c\u6839\u636e\u7cfb\u7edf\u7f16\u53f7\u67e5\u8be2\uff1a{}", (Object)systemCode);
        switch (systemCode) {
            case "EAS": {
                return this.monitorEasList();
            }
            case "WMS": {
                return this.monitorWmsList();
            }
            case "FINANCE": {
                return this.monitorFinanceList();
            }
            case "OCS": {
                return this.monitorOcsList();
            }
            case "TIMEOUT": {
                return this.monitorTimeOutList();
            }
            case "SAP": {
                return this.monitorSapList();
            }
        }
        throw new BizException("-1", "\u672a\u77e5\u7cfb\u7edf\u7f16\u53f7");
    }

    @Override
    public void monitorIgnore(List<CsMonitorIgnoreReqDto> dtoList) {
        List noList = dtoList.stream().map(CsMonitorIgnoreReqDto::getRelevanceNo).collect(Collectors.toList());
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty(noList), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = ((ExtQueryChainWrapper)this.csMonitorIgnoreDas.filter().in((Object)"relevance_no", noList)).list();
        AssertUtil.isTrue((boolean)CollectionUtil.isEmpty((Collection)eos), (String)"\u8be5\u5355\u53f7\u5df2\u7ecf\u5ffd\u7565");
        ArrayList eoList = new ArrayList();
        CubeBeanUtils.copyCollection(eoList, dtoList, CsMonitorIgnoreEo.class);
        this.csMonitorIgnoreDas.insertBatch(eoList);
    }

    private Long monitorListToCount(List<MonitorApiResponseDto> list) {
        if (CollectionUtil.isEmpty(list)) {
            return 0L;
        }
        return list.stream().mapToLong(MonitorApiResponseDto::getFailCount).sum();
    }

    @Override
    public MonitorSystemResponseDto monitorWmsList() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cWMS\u76d1\u63a7\u5217\u8868");
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName(SYS_WMS);
        dto.setSystemCode(SYS_WMS);
        dto.setMonitorApiList(this.monitorOpenapiLog(MonitorEnum.enumListBySys(SYS_WMS)));
        dto.setFailCount(this.monitorListToCount(dto.getMonitorApiList()));
        return dto;
    }

    public MonitorSystemResponseDto monitorWmsCount() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cWMS\u76d1\u63a7\u6570\u91cf");
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName(SYS_WMS);
        dto.setSystemCode(SYS_WMS);
        List<String> apiCodes = MonitorEnum.apiCodeListBySys(SYS_WMS);
        dto.setFailCount(Long.valueOf(this.monitorDas.queryOpenapiLogCountSumByCode(apiCodes).intValue()));
        return dto;
    }

    private List<MonitorApiResponseDto> monitorOpenapiLog(List<MonitorEnum> monitorEnumList) {
        logger.info("monitorOpenapiLog\uff1a{}", (Object)JSON.toJSONString(monitorEnumList));
        List apiCodes = monitorEnumList.stream().map(MonitorEnum::getApiCode).collect(Collectors.toList());
        List dataList = this.monitorDas.queryOpenapiLogCountByCode(apiCodes);
        Map<Object, Object> dataGroupMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)dataList)) {
            dataGroupMap = dataList.stream().collect(Collectors.groupingBy(PcpOpenapiLogRespDto::getApiCode));
        }
        HashMap finalDataGroupMap = dataGroupMap;
        return monitorEnumList.stream().map(e -> {
            MonitorApiResponseDto dto = new MonitorApiResponseDto();
            dto.setApiName(e.getName());
            dto.setApiCode(e.getApiCode());
            dto.setFailCount(Long.valueOf(0L));
            if (CollectionUtil.isNotEmpty((Collection)((Collection)finalDataGroupMap.get(e.getApiCode())))) {
                dto.setLogDataList((List)finalDataGroupMap.get(e.getApiCode()));
                dto.setFailCount(Long.valueOf(dto.getLogDataList().size()));
            }
            return dto;
        }).collect(Collectors.toList());
    }

    private List<MonitorApiResponseDto> queryOpenapiLogByCodeAndBizNo(List<MonitorEnum> monitorEnumList, List<String> bizNos) {
        logger.info("monitorOpenapiLog\uff1a{}", (Object)JSON.toJSONString(monitorEnumList));
        List apiCodes = monitorEnumList.stream().map(MonitorEnum::getApiCode).collect(Collectors.toList());
        List dataList = this.monitorDas.queryOpenapiLogByCodeAndBizNo(apiCodes, bizNos);
        Map<Object, Object> dataGroupMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)dataList)) {
            dataGroupMap = dataList.stream().collect(Collectors.groupingBy(PcpOpenapiLogRespDto::getApiCode));
        }
        HashMap finalDataGroupMap = dataGroupMap;
        return monitorEnumList.stream().map(e -> {
            MonitorApiResponseDto dto = new MonitorApiResponseDto();
            dto.setApiName(e.getName());
            dto.setApiCode(e.getApiCode());
            dto.setFailCount(Long.valueOf(0L));
            if (CollectionUtil.isNotEmpty((Collection)((Collection)finalDataGroupMap.get(e.getApiCode())))) {
                dto.setLogDataList((List)finalDataGroupMap.get(e.getApiCode()));
                dto.setFailCount(Long.valueOf(dto.getLogDataList().size()));
            }
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public MonitorSystemResponseDto monitorCspList() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0c\u8425\u9500\u4e91\u76d1\u63a7\u5217\u8868");
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName("\u8425\u9500\u4e91");
        dto.setSystemCode("CSP");
        dto.setMonitorApiList((List)Lists.newArrayList());
        dto.setFailCount(Long.valueOf(0L));
        return dto;
    }

    @Override
    public MonitorSystemResponseDto monitorFinanceList() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0c\u8d22\u52a1\u4e2d\u53f0\u76d1\u63a7\u5217\u8868");
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName("\u8d22\u52a1\u4e2d\u53f0");
        dto.setSystemCode(SYS_FINANCE);
        dto.setMonitorApiList((List)Lists.newArrayList((Object[])new MonitorApiResponseDto[]{this.monitorFinanceTC07()}));
        dto.setFailCount(this.monitorListToCount(dto.getMonitorApiList()));
        return dto;
    }

    @Override
    public MonitorSystemResponseDto monitorEasList() {
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName(SYS_EAS);
        dto.setSystemCode(SYS_EAS);
        ArrayList<MonitorApiResponseDto> list = new ArrayList<MonitorApiResponseDto>();
        list.add(this.queryEasAdjustment());
        list.add(this.queryEasTransfer());
        list.add(this.queryEasTransferOut());
        list.add(this.queryEasTransferIn());
        list.add(this.queryEasSaleOtherOut());
        list.addAll(this.monitorOpenapiLog(MonitorEnum.enumListBySys(SYS_EAS)));
        dto.setMonitorApiList(list);
        dto.setFailCount(this.monitorListToCount(dto.getMonitorApiList()));
        return dto;
    }

    @Override
    public MonitorSystemResponseDto monitorSapList() {
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName(SYS_SAP);
        dto.setSystemCode(SYS_SAP);
        ArrayList<MonitorApiResponseDto> list = new ArrayList<MonitorApiResponseDto>();
        this.querySapErrorOrderList(list);
        dto.setMonitorApiList(list);
        dto.setFailCount(this.monitorListToCount(dto.getMonitorApiList()));
        return dto;
    }

    @Override
    public MonitorSystemResponseDto monitorOcsList() {
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName(SYS_OCS);
        dto.setSystemCode(SYS_OCS);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.monitorIntransitInventoryOvercharge());
        list.add(this.monitorIntransitException());
        list.add(this.monitorIntransitOutAndInNumException());
        list.add(this.monitorResultNoNumException());
        dto.setMonitorApiList(list);
        dto.setFailCount(this.monitorListToCount(dto.getMonitorApiList()));
        logger.info("monitorOcsList: {}", (Object)JSON.toJSONString(list));
        return dto;
    }

    @Override
    public MonitorSystemResponseDto monitorTimeOutList() {
        MonitorSystemResponseDto dto = new MonitorSystemResponseDto();
        dto.setSystemName("\u8d85\u65f6");
        dto.setSystemCode(SYS_TIME_OUT);
        ArrayList<MonitorApiResponseDto<MonitorTransferOrderInTimeOutRespDto>> list = new ArrayList<MonitorApiResponseDto<MonitorTransferOrderInTimeOutRespDto>>();
        list.add(this.monitorTransferOrderInTimeOut());
        dto.setMonitorApiList(list);
        dto.setFailCount(this.monitorListToCount(dto.getMonitorApiList()));
        logger.info("monitorTimeOutList: {}", (Object)JSON.toJSONString(list));
        return dto;
    }

    @Override
    public MonitorApiResponseDto monitorFinanceTC07() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0c\u8d22\u52a1\u4e2d\u53f0\u76d1\u63a7\uff0c\u5185\u90e8\u9500\u552e\u8ba2\u5355\u5df2\u5b8c\u6210\u5df2\u7b7e\u6536\uff0c\u8d22\u52a1\u4e2d\u53f0\u5f85\u62c9\u5355\u6570");
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        responseDto.setApiName("\u5185\u90e8\u9500\u552e\u8ba2\u5355\u5df2\u5b8c\u6210/\u5df2\u7b7e\u6536\uff0c\u8d22\u52a1\u4e2d\u53f0\u5f85\u62c9\u5355\u6570");
        responseDto.setApiCode(MonitorEnum.DIY001.getApiCode());
        responseDto.setJumpType(Integer.valueOf(2));
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setDataList(this.monitorDas.queryTc07());
        if (CollectionUtil.isNotEmpty((Collection)responseDto.getDataList())) {
            responseDto.setFailCount(Long.valueOf(responseDto.getDataList().size()));
        }
        return responseDto;
    }

    @Override
    public MonitorApiResponseDto queryEasAdjustment() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cEAS\u76d1\u63a7\uff0c\u5728\u9014\u8c03\u6574\u5355\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        responseDto.setApiName("\u5728\u9014\u8c03\u6574\u5355\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        responseDto.setApiCode(MonitorEnum.EAS013_01.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setLogDataList(this.monitorDas.queryEasAdjustment());
        if (CollectionUtil.isNotEmpty((Collection)responseDto.getLogDataList())) {
            responseDto.setFailCount(Long.valueOf(responseDto.getLogDataList().size()));
        }
        return responseDto;
    }

    @Override
    public MonitorApiResponseDto queryEasTransfer() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cEAS\u76d1\u63a7\uff0c\u8c03\u62e8\u5355\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        responseDto.setApiName("\u8c03\u62e8\u5355\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        responseDto.setApiCode(MonitorEnum.EAS013_02.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setLogDataList(this.monitorDas.queryEasTransfer());
        if (CollectionUtil.isNotEmpty((Collection)responseDto.getLogDataList())) {
            responseDto.setFailCount(Long.valueOf(responseDto.getLogDataList().size()));
        }
        return responseDto;
    }

    @Override
    public MonitorApiResponseDto queryEasTransferOut() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cEAS\u76d1\u63a7\uff0c\u8c03\u62e8\u51fa\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        responseDto.setApiName("\u8c03\u62e8\u51fa\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        responseDto.setApiCode(MonitorEnum.EAS011.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setLogDataList(this.monitorDas.queryEasTransferOut());
        if (CollectionUtil.isNotEmpty((Collection)responseDto.getLogDataList())) {
            responseDto.setFailCount(Long.valueOf(responseDto.getLogDataList().size()));
        }
        return responseDto;
    }

    @Override
    public MonitorApiResponseDto queryEasTransferIn() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cEAS\u76d1\u63a7\uff0c\u8c03\u62e8\u5165\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        responseDto.setApiName("\u8c03\u62e8\u5165\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        responseDto.setApiCode(MonitorEnum.EAS012.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setLogDataList(this.monitorDas.queryEasTransferIn());
        if (CollectionUtil.isNotEmpty((Collection)responseDto.getLogDataList())) {
            responseDto.setFailCount(Long.valueOf(responseDto.getLogDataList().size()));
        }
        return responseDto;
    }

    @Override
    public MonitorApiResponseDto queryEasSaleOtherOut() {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cEAS\u76d1\u63a7\uff0c\u5185\u90e8\u9500\u552e\u8ba2\u5355\u4ee5\u5176\u4ed6\u51fa\u5e93\u5355\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        responseDto.setApiName("\u5185\u90e8\u9500\u552e\u8ba2\u5355\u4ee5\u5176\u4ed6\u51fa\u5e93\u5355\u63a8\u9001EAS\u5931\u8d25\u8bb0\u5f55");
        responseDto.setApiCode("EAS010_01");
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setLogDataList(this.monitorDas.queryEasSaleOtherOut());
        if (CollectionUtil.isNotEmpty((Collection)responseDto.getLogDataList())) {
            responseDto.setFailCount(Long.valueOf(responseDto.getLogDataList().size()));
        }
        return responseDto;
    }

    @Override
    public MonitorApiResponseDto queryApiMonitor(MonitorApiResponseDto dto) {
        logger.info("\u67e5\u8be2\u63a5\u53e3\u76d1\u63a7\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        MonitorEnum monitorEnum = MonitorEnum.getByApiCode(dto.getApiCode());
        if (monitorEnum.getSystemCode().equals("DIY")) {
            try {
                MonitorReportServiceImpl bean = (MonitorReportServiceImpl)SpringBeanUtil.getBean(MonitorReportServiceImpl.class);
                Class<?> aClass = bean.getClass();
                Method method = aClass.getMethod(monitorEnum.getName(), new Class[0]);
                Object invoke = method.invoke((Object)bean, new Object[0]);
                return (MonitorApiResponseDto)JSONObject.parseObject((String)JSON.toJSONString((Object)invoke), MonitorApiResponseDto.class);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BizException("-1", "\u67e5\u8be2\u63a5\u53e3\u76d1\u63a7\u5217\u8868\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        List<MonitorApiResponseDto> list = this.monitorOpenapiLog(Lists.newArrayList((Object[])new MonitorEnum[]{monitorEnum}));
        if (CollectionUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    private MonitorApiResponseDto<MonitorIntransitInventoryOverchargeRespDto> monitorIntransitInventoryOvercharge() {
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cOCS\u76d1\u63a7\uff0c\u5728\u9014\u5e93\u5b58\u8d85\u5356\u76d1\u63a7");
        responseDto.setApiName("\u5728\u9014\u5e93\u5b58\u8d85\u5356\u76d1\u63a7");
        responseDto.setApiCode(MonitorEnum.OCS001.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setJumpType(Integer.valueOf(2));
        List monitorIntransitInventoryOverchargeRespDtoList = this.monitorDas.queryIntransitInventoryOvercharge();
        if (CollectionUtil.isNotEmpty((Collection)monitorIntransitInventoryOverchargeRespDtoList)) {
            responseDto.setDtoList(monitorIntransitInventoryOverchargeRespDtoList);
            responseDto.setFailCount(Long.valueOf(monitorIntransitInventoryOverchargeRespDtoList.size()));
        }
        return responseDto;
    }

    private MonitorApiResponseDto<MonitorIntransitOrderRespDto> monitorIntransitException() {
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cOCS\u76d1\u63a7\uff0c\u8c03\u62e8\u5355\u5173\u8054\u5728\u9014\u8c03\u6574\u5355\u6570\u91cf\u76d1\u63a7");
        responseDto.setApiName("\u8c03\u62e8\u5355\u5173\u8054\u5728\u9014\u8c03\u6574\u5355\u6570\u91cf\u76d1\u63a7");
        responseDto.setApiCode(MonitorEnum.OCS002.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setJumpType(Integer.valueOf(1));
        List monitorIntransitOrderRespDtoList = this.monitorDas.queryIntransitException();
        if (CollectionUtil.isNotEmpty((Collection)monitorIntransitOrderRespDtoList)) {
            for (MonitorIntransitOrderRespDto monitorIntransitOrderRespDto : monitorIntransitOrderRespDtoList) {
                Lists.newArrayList((Object[])CsTransferOrderEnum.Status.values()).stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)monitorIntransitOrderRespDto.getOrderStatus())).findFirst().ifPresent(status -> monitorIntransitOrderRespDto.setOrderStatusName(status.getDesc()));
            }
            responseDto.setDtoList(monitorIntransitOrderRespDtoList);
            responseDto.setFailCount(Long.valueOf(monitorIntransitOrderRespDtoList.size()));
        }
        return responseDto;
    }

    private MonitorApiResponseDto<MonitorIntransitOutAndInNumRespDto> monitorIntransitOutAndInNumException() {
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cOCS\u76d1\u63a7\uff0c\u8c03\u62e8\u5355\u5173\u8054\u5728\u9014\u4ed3SKU\u6570\u91cf\u76d1\u63a7");
        responseDto.setApiName("\u8c03\u62e8\u5355\u5173\u8054\u5728\u9014\u4ed3SKU\u6570\u91cf\u76d1\u63a7");
        responseDto.setApiCode(MonitorEnum.OCS003.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setJumpType(Integer.valueOf(1));
        List monitorIntransitOutAndInNumRespDtoList = this.monitorDas.queryIntransitOutAndInNumException();
        if (CollectionUtil.isNotEmpty((Collection)monitorIntransitOutAndInNumRespDtoList)) {
            for (MonitorIntransitOutAndInNumRespDto monitorIntransitOutAndInNumRespDto : monitorIntransitOutAndInNumRespDtoList) {
                Lists.newArrayList((Object[])CsTransferOrderEnum.Status.values()).stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)monitorIntransitOutAndInNumRespDto.getOrderStatus())).findFirst().ifPresent(status -> monitorIntransitOutAndInNumRespDto.setOrderStatusName(status.getDesc()));
            }
            responseDto.setDtoList(monitorIntransitOutAndInNumRespDtoList);
            responseDto.setFailCount(Long.valueOf(monitorIntransitOutAndInNumRespDtoList.size()));
        }
        return responseDto;
    }

    private MonitorApiResponseDto<MonitorResultNoNumRespDto> monitorResultNoNumException() {
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cOCS\u76d1\u63a7\uff0c\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u6302\u8d77\u76d1\u63a7");
        responseDto.setApiName("\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u6302\u8d77\u76d1\u63a7");
        responseDto.setApiCode(MonitorEnum.OCS004.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setJumpType(Integer.valueOf(1));
        List monitorIntransitOutAndInNumRespDtoList = this.monitorDas.queryResultNoNumException();
        if (CollectionUtil.isNotEmpty((Collection)monitorIntransitOutAndInNumRespDtoList)) {
            for (MonitorResultNoNumRespDto monitorIntransitOutAndInNumRespDto : monitorIntransitOutAndInNumRespDtoList) {
                monitorIntransitOutAndInNumRespDto.setOrderStatusName(CsOrderStatusEnum.getDescByCode((String)monitorIntransitOutAndInNumRespDto.getOrderStatus()));
                monitorIntransitOutAndInNumRespDto.setBusinessTypeName(BusinessTypeCodeEnum.getMsgByCode((String)monitorIntransitOutAndInNumRespDto.getBusinessType()));
                monitorIntransitOutAndInNumRespDto.setOrderTypeName(BusinessTypeCodeEnum.getMsgByCode((String)monitorIntransitOutAndInNumRespDto.getOrderType()));
            }
            responseDto.setDtoList(monitorIntransitOutAndInNumRespDtoList);
            responseDto.setFailCount(Long.valueOf(monitorIntransitOutAndInNumRespDtoList.size()));
        }
        return responseDto;
    }

    private MonitorApiResponseDto<MonitorTransferOrderInTimeOutRespDto> monitorTransferOrderInTimeOut() {
        MonitorApiResponseDto responseDto = new MonitorApiResponseDto();
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0c\u8c03\u62e8\u5355\u5f85\u68c0\u8f6c\u5408\u683c/\u903b\u8f91\u8c03\u62e8\u7c7b\u578b\u8ba2\u5355\uff0cwms\u8fd4\u56de\u8d85\u65f6");
        responseDto.setApiName("\u5f85\u68c0\u8f6c\u5408\u683c\u548c\u903b\u8f91\u8c03\u62e8\u7c7b\u578b\u8c03\u62e8\u5355\u63a8\u5355\u7ed9wms\uff0c\u8d85\u8fc75\u5206\u949f\u672a\u8fd4\u56de\u7ed3\u679c");
        responseDto.setApiCode(MonitorEnum.TIMEOUT001.getApiCode());
        responseDto.setFailCount(Long.valueOf(0L));
        responseDto.setJumpType(Integer.valueOf(1));
        List monitorTransferOrderInTimeOutRespDtoList = this.monitorDas.queryTransferOrderInTimeOut();
        if (CollectionUtil.isNotEmpty((Collection)monitorTransferOrderInTimeOutRespDtoList)) {
            for (MonitorTransferOrderInTimeOutRespDto monitorTransferOrderInTimeOutRespDto : monitorTransferOrderInTimeOutRespDtoList) {
                Lists.newArrayList((Object[])CsTransferOrderEnum.Status.values()).stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)monitorTransferOrderInTimeOutRespDto.getOrderStatus())).findFirst().ifPresent(status -> monitorTransferOrderInTimeOutRespDto.setOrderStatusName(status.getDesc()));
            }
            responseDto.setDtoList(monitorTransferOrderInTimeOutRespDtoList);
            responseDto.setFailCount(Long.valueOf(monitorTransferOrderInTimeOutRespDtoList.size()));
        }
        return responseDto;
    }

    public void querySapErrorOrderList(List<MonitorApiResponseDto> respList) {
        logger.info("\u76d1\u63a7\u5e73\u53f0\uff0cSAP\u76d1\u63a7\uff0cSAP\u5f02\u5e38\u8ba2\u5355\u8bb0\u5f55");
        List monitorSapErrorOrderRespDtoList = this.monitorDas.querySapErrorOrder();
        List bizNos = monitorSapErrorOrderRespDtoList.stream().map(dto -> dto.getDocumentNo()).collect(Collectors.toList());
        bizNos.addAll(monitorSapErrorOrderRespDtoList.stream().filter(i -> i.getOrderType().equals("order_sales_refund")).map(dto -> dto.getPlatformOrderNo()).collect(Collectors.toList()));
        List apiCodes = MonitorEnum.enumListBySys(SYS_SAP).stream().map(m -> m.getApiCode()).collect(Collectors.toList());
        List apiLogs = this.monitorDas.queryOpenapiLogByCodeAndBizNo(apiCodes, bizNos);
        logger.info(JSONObject.toJSONString((Object)monitorSapErrorOrderRespDtoList));
        logger.info(JSONObject.toJSONString((Object)apiLogs));
        if (CollectionUtil.isNotEmpty((Collection)apiLogs)) {
            for (MonitorSapErrorOrderRespDto errorOrderRespDto : monitorSapErrorOrderRespDtoList) {
                for (PcpOpenapiLogRespDto apilog : apiLogs) {
                    if (!errorOrderRespDto.getDocumentNo().equals(apilog.getApiBizNo()) && !errorOrderRespDto.getPlatformOrderNo().equals(apilog.getApiBizNo())) continue;
                    errorOrderRespDto.setId(apilog.getId());
                    errorOrderRespDto.setApiCode(apilog.getApiCode());
                    errorOrderRespDto.setNodeApiResponse(apilog.getNodeApiResponse());
                    errorOrderRespDto.setApiBizNo(apilog.getApiBizNo());
                }
            }
        }
        ArrayList<MonitorSapErrorOrderRespDto> noSapOutNoList = new ArrayList<MonitorSapErrorOrderRespDto>();
        ArrayList<MonitorSapErrorOrderRespDto> createSapNoErrorList = new ArrayList<MonitorSapErrorOrderRespDto>();
        ArrayList<MonitorSapErrorOrderRespDto> checkSapNoErrorList = new ArrayList<MonitorSapErrorOrderRespDto>();
        ArrayList<MonitorSapErrorOrderRespDto> internalDealSapNoErrorList = new ArrayList<MonitorSapErrorOrderRespDto>();
        ArrayList<MonitorSapErrorOrderRespDto> allotOutSapNoErrorList = new ArrayList<MonitorSapErrorOrderRespDto>();
        ArrayList<MonitorSapErrorOrderRespDto> commonSapNoErrorList = new ArrayList<MonitorSapErrorOrderRespDto>();
        for (MonitorSapErrorOrderRespDto errorOrderRespDto : monitorSapErrorOrderRespDtoList) {
            String orderType = errorOrderRespDto.getOrderType();
            String sapNo = errorOrderRespDto.getSapOrderNo();
            String sapOutNo = errorOrderRespDto.getSapOutOrderNo();
            if ((orderType.equals("compensation_order") || orderType.equals("order_sales_refund")) && StringUtils.isEmpty((CharSequence)sapNo)) {
                createSapNoErrorList.add(errorOrderRespDto);
                continue;
            }
            if ((orderType.equals("compensation_order") || orderType.equals("other_out_stock") || orderType.equals("customer_refunding_order") || orderType.equals("secondary_distribution") || orderType.equals("agency_order") || orderType.equals("order_sales_refund")) && StringUtils.isEmpty((CharSequence)sapOutNo)) {
                noSapOutNoList.add(errorOrderRespDto);
                continue;
            }
            if ((orderType.equals("internal_deal") || orderType.equals("internal_deal_return")) && StringUtils.isEmpty((CharSequence)sapNo)) {
                internalDealSapNoErrorList.add(errorOrderRespDto);
                continue;
            }
            if (orderType.equals("inspection_qualified") && StringUtils.isEmpty((CharSequence)sapNo)) {
                checkSapNoErrorList.add(errorOrderRespDto);
                continue;
            }
            if ((orderType.equals("internal_allot") || orderType.equals("allot_logic_out") || orderType.equals("maiyou_bc_same_org_allot") || orderType.equals("borrow_allot") || orderType.equals("internal_export_deal")) && StringUtils.isEmpty((CharSequence)sapNo)) {
                allotOutSapNoErrorList.add(errorOrderRespDto);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)sapNo)) continue;
            commonSapNoErrorList.add(errorOrderRespDto);
        }
        MonitorApiResponseDto responseDto1 = new MonitorApiResponseDto();
        responseDto1.setApiName("\u9500\u552e\u8ba2\u5355\u53ef\u62c9\u5355\u672a\u751f\u6210SAP\u4ea4\u8d27\u5355");
        responseDto1.setApiCode(MonitorEnum.SAP001.getApiCode());
        responseDto1.setJumpType(Integer.valueOf(1));
        responseDto1.setDtoList(noSapOutNoList);
        responseDto1.setFailCount(Long.valueOf(noSapOutNoList.size()));
        respList.add(responseDto1);
        MonitorApiResponseDto responseDto2 = new MonitorApiResponseDto();
        responseDto2.setApiName("\u521b\u5efaSAP\u9500\u552e\u8ba2\u5355\u5931\u8d25");
        responseDto2.setApiCode(MonitorEnum.SAP001.getApiCode());
        responseDto2.setJumpType(Integer.valueOf(1));
        responseDto2.setDtoList(createSapNoErrorList);
        responseDto2.setFailCount(Long.valueOf(createSapNoErrorList.size()));
        respList.add(responseDto2);
        MonitorApiResponseDto responseDto3 = new MonitorApiResponseDto();
        responseDto3.setApiName("\u5f85\u68c0\u8f6c\u5408\u683c\u8c03\u7528SAP\u653e\u884c\u5931\u8d25");
        responseDto3.setApiCode(MonitorEnum.SAP001.getApiCode());
        responseDto3.setJumpType(Integer.valueOf(1));
        responseDto3.setDtoList(checkSapNoErrorList);
        responseDto3.setFailCount(Long.valueOf(checkSapNoErrorList.size()));
        respList.add(responseDto3);
        MonitorApiResponseDto responseDto4 = new MonitorApiResponseDto();
        responseDto4.setApiName("\u5185\u90e8\u4ea4\u6613\u6216\u5206\u8d27 \u51fa\u5e93\u540eSAP\u7269\u6599\u51ed\u8bc1\u5931\u8d25");
        responseDto4.setApiCode(MonitorEnum.SAP001.getApiCode());
        responseDto4.setJumpType(Integer.valueOf(1));
        responseDto4.setDtoList(internalDealSapNoErrorList);
        responseDto4.setFailCount(Long.valueOf(internalDealSapNoErrorList.size()));
        respList.add(responseDto4);
        MonitorApiResponseDto responseDto5 = new MonitorApiResponseDto();
        responseDto5.setApiName("\u8c03\u62e8\u4e1a\u52a1\u51fa\u5e93\u540eSAP\u7269\u6599\u51ed\u8bc1\u5931\u8d25");
        responseDto5.setApiCode(MonitorEnum.SAP001.getApiCode());
        responseDto5.setJumpType(Integer.valueOf(1));
        responseDto5.setDtoList(allotOutSapNoErrorList);
        responseDto5.setFailCount(Long.valueOf(allotOutSapNoErrorList.size()));
        respList.add(responseDto5);
        MonitorApiResponseDto responseDto6 = new MonitorApiResponseDto();
        responseDto6.setApiName("\u901a\u7528\u573a\u666f\u5165\u5e93\u6216\u51fa\u5e93\u540e\u521b\u5efa\u7269\u6599\u51ed\u8bc1\u5931\u8d25");
        responseDto6.setApiCode(MonitorEnum.SAP001.getApiCode());
        responseDto6.setJumpType(Integer.valueOf(1));
        responseDto6.setDtoList(commonSapNoErrorList);
        responseDto6.setFailCount(Long.valueOf(commonSapNoErrorList.size()));
        respList.add(responseDto6);
    }
}

