/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IReInsuranceCommonService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumChargingService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReInsuranceCommonServiceImpl
implements IReInsuranceCommonService {
    private static final Logger logger = LoggerFactory.getLogger(ReInsuranceCommonServiceImpl.class);
    @Resource
    private IReInsurancePremiumService reInsurancePremiumService;
    @Resource
    private IReInsurancePremiumChargingService reInsurancePremiumChargingService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u6839\u636e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u4fdd\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        logger.info("\u5220\u9664\u65e7\u6570\u636e\u5e76\u751f\u6210\u4fdd\u8d39\u539f\u59cb\u660e\u7ec6");
        ReInsurancePremiumReqDto reInsurancePremiumReqDto = new ReInsurancePremiumReqDto();
        reInsurancePremiumReqDto.setInOutTimeBegin(feeGenerateReqDto.getStartDate());
        reInsurancePremiumReqDto.setInOutTimeEnd(feeGenerateReqDto.getEndDate());
        this.reInsurancePremiumService.generateInsurancePremiumAfterDel(reInsurancePremiumReqDto);
        ReInsurancePremiumChargingReqDto chargingReqDto = new ReInsurancePremiumChargingReqDto();
        chargingReqDto.setInOutTimeBegin(feeGenerateReqDto.getStartDate());
        chargingReqDto.setInOutTimeEnd(feeGenerateReqDto.getEndDate());
        chargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
        chargingReqDto.setBillTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType()}));
        chargingReqDto.setIfDelFormer(true);
        this.reInsurancePremiumChargingService.generateInsurancePremiumCharging(chargingReqDto);
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        this.dailyDeliveryReportStockApportionService.autoApportion(apportionDto);
    }
}

