/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.constant.enums.GiftBalanceStatementTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.TaskQueryParamsDro;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseCommonService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseJobService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseService;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SortingExpenseCommonServiceImpl
implements ISortingExpenseCommonService {
    private static final Logger logger = LoggerFactory.getLogger(SortingExpenseCommonServiceImpl.class);
    @Resource
    private ISortingExpenseService sortingExpenseService;
    @Resource
    private ISortingExpenseJobService sortingExpenseJobService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u6839\u636e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u5206\u62e3\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            logger.info("\u5220\u9664\u65e7\u6570\u636e\u5e76\u751f\u6210\u5206\u62e3\u8d39\u539f\u59cb\u660e\u7ec6");
            TaskQueryParamsDro queryParamsDro = new TaskQueryParamsDro();
            queryParamsDro.setStartDateStr(DateUtil.formatDateTime((Date)feeGenerateReqDto.getStartDate()));
            queryParamsDro.setEndDateStr(DateUtil.formatDateTime((Date)feeGenerateReqDto.getEndDate()));
            queryParamsDro.setOutPhysicsWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            this.sortingExpenseService.executeJobNew(queryParamsDro);
            this.sortingExpenseJobService.generateBySortingFee(feeGenerateReqDto, false);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
        dealDetailDto.setDealTypeList(Arrays.stream(GiftBalanceStatementTradeTypeEnum.values()).map(GiftBalanceStatementTradeTypeEnum::getStatus).collect(Collectors.toList()));
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        this.dailyDeliveryReportStockApportionService.autoApportion(apportionDto);
    }
}

