/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingBillReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.SortingBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.SortingBillRespDto;
import com.dtyunxi.tcbj.biz.service.ISortingBillService;
import com.dtyunxi.tcbj.biz.service.impl.ReInsurancePremiumServiceImpl;
import com.dtyunxi.tcbj.dao.das.SortingExpenseDas;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.das.IBillDas;
import com.yunxi.dg.base.center.report.eo.BillEo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SortingBillServiceImpl
implements ISortingBillService {
    private static final Logger log = LoggerFactory.getLogger(SortingBillServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumServiceImpl.class);
    @Resource
    private SortingExpenseDas sortingExpenseDas;
    @Resource
    private IBillDas billDas;

    @Override
    public PageInfo<SortingBillRespDto> getSortingBillReportListPage(SortingBillReportListPageReqDto sortingBillReportListPageReqDto) {
        PageInfo page = this.sortingExpenseDas.getSortingBillReportListPage(sortingBillReportListPageReqDto);
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            page.getList().forEach(e -> {
                if (Objects.equals(1L, e.getAdjustType())) {
                    e.setSortingNum(Optional.ofNullable(e.getSortingNum()).orElse(BigDecimal.ZERO).add(Optional.of(e.getAdjustNum()).orElse(BigDecimal.ZERO)));
                } else if (Objects.equals(2L, e.getAdjustType())) {
                    e.setSortingNum(Optional.ofNullable(e.getSortingNum()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(e.getAdjustNum()).orElse(BigDecimal.ZERO)));
                }
            });
        }
        return page;
    }

    @Override
    public SortingBillCountDto getSortingBillReportListPageCount(SortingBillReportListPageReqDto sortingBillReportListPageReqDto) {
        this.logger.info("\u7edf\u8ba1\u5206\u62e3\u8d26\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)sortingBillReportListPageReqDto));
        return this.sortingExpenseDas.getSortingBillReportListPageCount(sortingBillReportListPageReqDto);
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u5206\u62e3\u8d26\u5355\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        BillEo updateEo = new BillEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List billEos = this.billDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = billEos.stream().filter(billEo -> billEo.getPlacedFlag() == null || billEo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.billDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }
}

