/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionOtherOperationEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionOtherVerifyEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CalculateWayEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsExceptionStorageBill;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsSatisfyContract;
import com.dtyunxi.tcbj.api.dto.request.ApportionOtherReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.StatisticsBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.UpdateStorageDetailDto;
import com.dtyunxi.tcbj.api.dto.response.ApportionOtherCostRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinStorageContractDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinStorageContractRespDto;
import com.dtyunxi.tcbj.api.dto.response.StatisticsBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageBillCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillPrintDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillRespDto;
import com.dtyunxi.tcbj.biz.service.IFinStorageContractService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeBillService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeDetailService;
import com.dtyunxi.tcbj.biz.service.impl.StorageChargeHelper;
import com.dtyunxi.tcbj.dao.das.StorageChargeBillDas;
import com.dtyunxi.tcbj.dao.das.StorageChargeDetailDas;
import com.dtyunxi.tcbj.dao.eo.StorageChargeBillEo;
import com.dtyunxi.tcbj.dao.eo.StorageChargeDetailEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageChargeBillServiceImpl
implements IStorageChargeBillService {
    private static final Logger log = LoggerFactory.getLogger(StorageChargeBillServiceImpl.class);
    private final Logger LOGGER = LoggerFactory.getLogger(StorageChargeBillServiceImpl.class);
    @Resource
    private StorageChargeBillDas storageChargeBillDas;
    @Resource
    private StorageChargeDetailDas storageChargeDetailDas;
    @Resource
    private IStorageChargeDetailService storageChargeDetailService;
    @Resource
    private IFinStorageContractService storageContractService;
    @Resource
    private IStorageChargeBillService storageChargeBillService;

    @Override
    public Long addStorageChargeBill(StorageChargeBillReqDto addReqDto) {
        StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storageChargeBillEo);
        this.storageChargeBillDas.insert((BaseEo)storageChargeBillEo);
        return storageChargeBillEo.getId();
    }

    @Override
    public void modifyStorageChargeBill(StorageChargeBillReqDto modifyReqDto) {
        StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storageChargeBillEo);
        this.storageChargeBillDas.updateSelective((BaseEo)storageChargeBillEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStorageChargeBill(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storageChargeBillDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StorageChargeBillRespDto queryById(Long id) {
        StorageChargeBillEo storageChargeBillEo = (StorageChargeBillEo)this.storageChargeBillDas.selectByPrimaryKey(id);
        StorageChargeBillRespDto storageChargeBillRespDto = new StorageChargeBillRespDto();
        DtoHelper.eo2Dto((BaseEo)storageChargeBillEo, (BaseVo)storageChargeBillRespDto);
        return storageChargeBillRespDto;
    }

    @Override
    public PageInfo<StorageChargeBillRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StorageChargeBillReqDto storageChargeBillReqDto = (StorageChargeBillReqDto)JSON.parseObject((String)filter, StorageChargeBillReqDto.class);
        storageChargeBillReqDto.setPageNum(pageNum);
        storageChargeBillReqDto.setPageSize(pageSize);
        PageInfo eoPageInfo = this.storageChargeBillDas.queryByPage(storageChargeBillReqDto);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StorageChargeBillRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public StorageBillCountRespDto queryByPageCount(StorageChargeBillReqDto storageChargeBillReqDto) {
        return this.storageChargeBillDas.queryByPageCount(storageChargeBillReqDto);
    }

    private StorageChargeBillEo extracted(StorageChargeBillReqDto storageChargeBillReqDto) {
        StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
        ArrayList sqlFilters = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)storageChargeBillReqDto.getBillTime())) {
            storageChargeBillEo.setBillTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)storageChargeBillReqDto.getBillTime(), (String)"yyyy-MM"));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeBillReqDto.getWarehouseCode())) {
            sqlFilters.add(SqlFilter.eq((String)"warehouse_code", (Object)storageChargeBillReqDto.getWarehouseCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeBillReqDto.getLogicWarehouseCode())) {
            sqlFilters.add(SqlFilter.like((String)"logic_warehouse_code", (Object)("%" + storageChargeBillReqDto.getLogicWarehouseCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeBillReqDto.getLogicWarehouseName())) {
            sqlFilters.add(SqlFilter.like((String)"logic_warehouse_name", (Object)("%" + storageChargeBillReqDto.getLogicWarehouseName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeBillReqDto.getChargeOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"charge_org_name", (Object)("%" + storageChargeBillReqDto.getChargeOrgName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeBillReqDto.getYear())) {
            sqlFilters.add(SqlFilter.like((String)"bill_time", (Object)("%" + storageChargeBillReqDto.getYear() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeBillReqDto.getIsSatisfy())) {
            storageChargeBillEo.setIsSatisfy(storageChargeBillReqDto.getIsSatisfy());
        }
        if (ObjectUtils.isNotEmpty((Object)storageChargeBillReqDto.getIsExcepion())) {
            IsExceptionStorageBill isExceptionStorageBill = IsExceptionStorageBill.keyOfEnum((Integer)storageChargeBillReqDto.getIsExcepion());
            Assert.notNull((Object)isExceptionStorageBill, (String)"0001", (String)"\u662f\u5426\u5f02\u5e38\u5b58\u5728\u53c2\u6570\u5f02\u5e38\uff01\uff01\uff01");
            if (IsExceptionStorageBill.IS_EXCEPTION.equals((Object)isExceptionStorageBill)) {
                storageChargeBillEo.setContractAverageSupport(new BigDecimal(isExceptionStorageBill.getVal()));
            } else {
                sqlFilters.add(SqlFilter.ne((String)"contract_average_support", (Object)IsExceptionStorageBill.IS_EXCEPTION.getVal()));
            }
        }
        storageChargeBillEo.setOrderByDesc("bill_time,warehouse_code");
        storageChargeBillEo.setSqlFilters((List)sqlFilters);
        return storageChargeBillEo;
    }

    @Override
    public List<StorageChargeBillPrintDto> printBill(String filter) {
        try {
            StorageChargeBillReqDto storageChargeBillReqDto = (StorageChargeBillReqDto)JSON.parseObject((String)filter, StorageChargeBillReqDto.class);
            StorageChargeBillEo storageChargeBillEo = this.extracted(storageChargeBillReqDto);
            List storageChargeBillList = this.storageChargeBillDas.select((BaseEo)storageChargeBillEo);
            Map<String, List<StorageChargeBillEo>> collect = storageChargeBillList.stream().collect(Collectors.groupingBy(c -> c.getBillTime() + c.getWarehouseCode() + c.getLogicWarehouseCode() + c.getChargeOrgId()));
            ArrayList storageChargeBillPrintDtoList = Lists.newArrayList();
            CountDownLatch countDownLatch = new CountDownLatch(collect.size());
            collect.forEach((k, v) -> {
                StorageChargeBillEo bill = (StorageChargeBillEo)v.stream().findFirst().get();
                StorageChargeHelper.storageExecutor.execute(() -> {
                    List<StorageChargeDetailEo> storageChargeDetailEos = this.queryStorageChargeDetail(bill);
                    Map<Date, List<StorageChargeDetailEo>> storageChargeDetailMap = storageChargeDetailEos.stream().collect(Collectors.groupingBy(StorageChargeDetailEo::getStorageTime));
                    storageChargeDetailMap.forEach((k1, v2) -> {
                        StorageChargeBillPrintDto storageChargeBillPrintDto = this.calculateAndCreate((Date)k1, (List<StorageChargeDetailEo>)v2);
                        if (ObjectUtils.isNotEmpty((Object)storageChargeBillPrintDto)) {
                            storageChargeBillPrintDtoList.add(storageChargeBillPrintDto);
                        }
                    });
                    countDownLatch.countDown();
                });
            });
            countDownLatch.await();
            return storageChargeBillPrintDtoList;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private StorageChargeBillPrintDto calculateAndCreate(Date c, List<StorageChargeDetailEo> chargeDetailEos) {
        StorageChargeDetailEo storageChargeDetailEo = (StorageChargeDetailEo)chargeDetailEos.stream().findFirst().get();
        List<FinStorageContractRespDto> storageContractRespDtos = this.storageContractService.queryByWarehouse(storageChargeDetailEo.getBillTime(), storageChargeDetailEo.getBillTime(), Arrays.asList(storageChargeDetailEo.getWarehouseCode()), null);
        if (CollectionUtils.isEmpty(storageContractRespDtos)) {
            this.LOGGER.info("\u3010{}\u3011\u4ed3\u50a8\u5408\u540c\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object)storageChargeDetailEo.getWarehouseCode());
            return null;
        }
        FinStorageContractRespDto storageContractRespDto = (FinStorageContractRespDto)storageContractRespDtos.stream().findFirst().get();
        List contractDetailRespDtoList = storageContractRespDto.getDetailRespDtoList().stream().filter(contract -> contract.getContractTime().equals(com.dtyunxi.cube.utils.DateUtil.getMonthBegin((Date)storageChargeDetailEo.getBillTime()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contractDetailRespDtoList)) {
            this.LOGGER.info("\u3010{}\u3011\u4ed3\u50a8\u5408\u540c\u4e0d\u5b58\u5728\u6307\u5b9a\u6708\u4efd\u660e\u7ec6\uff01\uff01\uff01", (Object)storageChargeDetailEo.getWarehouseCode());
            return null;
        }
        FinStorageContractDetailRespDto finStorageContractDetailRespDto = (FinStorageContractDetailRespDto)contractDetailRespDtoList.stream().findFirst().get();
        StorageChargeBillPrintDto storageChargeBillPrintDto = this.createStorageChargeBillPrintDto(new BigDecimal(storageContractRespDto.getContractAverageSupport()), finStorageContractDetailRespDto.getUnitPrice(), chargeDetailEos);
        return storageChargeBillPrintDto;
    }

    private StorageChargeBillPrintDto createStorageChargeBillPrintDto(BigDecimal contractAverageSupport, BigDecimal unitPrice, List<StorageChargeDetailEo> chargeDetailEos) {
        StorageChargeDetailEo storageChargeDetailEo = (StorageChargeDetailEo)chargeDetailEos.stream().findFirst().get();
        this.LOGGER.info("\u4ed3\u5e93:{} => \u6708\u4efd:{} => \u5408\u540c\u65e5\u5747\u6700\u4f4e\u677f\u6570:{}", new Object[]{storageChargeDetailEo.getWarehouseCode(), com.dtyunxi.cube.utils.DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)storageChargeDetailEo.getBillTime()), contractAverageSupport});
        StorageChargeBillPrintDto storageChargeBillPrintDto = new StorageChargeBillPrintDto();
        BigDecimal reduce = chargeDetailEos.stream().filter(detail -> detail.getOrganizationSupport().compareTo(BigDecimal.ZERO) > 0).map(detail -> detail.getOrganizationSupport()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal support = reduce.compareTo(contractAverageSupport) >= 0 ? contractAverageSupport : reduce;
        storageChargeBillPrintDto.setSupport(support);
        storageChargeBillPrintDto.setWarehouseCost(support.multiply(unitPrice));
        storageChargeBillPrintDto.setStorageTime(storageChargeDetailEo.getStorageTime());
        storageChargeBillPrintDto.setUnitPrice(unitPrice);
        storageChargeBillPrintDto.setChargeOrgName(storageChargeDetailEo.getChargeOrgName());
        return storageChargeBillPrintDto;
    }

    private List<StorageChargeDetailEo> queryStorageChargeDetail(StorageChargeBillEo storageChargeBillEo) {
        StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.ge((String)"bill_time", (Object)storageChargeBillEo.getBillTime()));
        sqlFilters.add(SqlFilter.lt((String)"bill_time", (Object)DateUtil.offsetMonth((Date)storageChargeBillEo.getBillTime(), (int)1)));
        storageChargeDetailEo.setSqlFilters((List)sqlFilters);
        storageChargeDetailEo.setWarehouseCode(storageChargeBillEo.getWarehouseCode());
        storageChargeDetailEo.setLogicWarehouseCode(storageChargeBillEo.getLogicWarehouseCode());
        storageChargeDetailEo.setChargeOrgId(storageChargeBillEo.getChargeOrgId());
        return this.storageChargeDetailDas.select((BaseEo)storageChargeDetailEo);
    }

    @Override
    public void syncStorageChargeBill(Date billDate, List<String> warehouseCodeList) {
        this.LOGGER.info("\u4ed3\u50a8\u8d26\u5355\u751f\u6210\uff1a{}\uff0c{}", (Object)billDate, warehouseCodeList);
        Date date = billDate;
        Date endDate = com.dtyunxi.cube.utils.DateUtil.getMonthEnd((Date)date);
        this.LOGGER.info("\u5904\u7406\u3010{}\u3011\u8d26\u5355\u6570\u636e", (Object)com.dtyunxi.cube.utils.DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)date));
        List<StorageChargeDetailEo> storageChargeDetailEos = this.storageChargeDetailService.getStorageChargeDetailEoByBillTime(date, endDate, warehouseCodeList);
        List<String> warehouseCodes = storageChargeDetailEos.stream().map(c -> c.getWarehouseCode()).distinct().collect(Collectors.toList());
        List<FinStorageContractRespDto> storageContractRespDtos = this.storageContractService.queryByWarehouseNotChargeMode(date, com.dtyunxi.cube.utils.DateUtil.getMonthEnd((Date)date), warehouseCodes, null);
        Map<String, List<FinStorageContractRespDto>> contractMap = this.calculateContractUnitPrice(date, storageContractRespDtos);
        this.LOGGER.info("\u4ed3\u50a8\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(contractMap));
        Map<String, List<StorageChargeDetailEo>> mapGroupByChargeOrgId = storageChargeDetailEos.stream().collect(Collectors.groupingBy(storageChargeDetailEo -> storageChargeDetailEo.getWarehouseCode() + storageChargeDetailEo.getChargeOrgId()));
        Map<String, BigDecimal> warehouseMonthSupportMap = this.calculateMonthWarehouseSupport(storageChargeDetailEos);
        List<StorageChargeBillEo> storageChargeBillEos = this.calculateAndSet(date, contractMap, mapGroupByChargeOrgId, warehouseMonthSupportMap, Maps.newHashMap());
        this.storageChargeBillService.logicDeleteStorageBill(date, warehouseCodeList);
        this.storageChargeBillService.insertStorageChargeBillBatch(storageChargeBillEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleteStorageBill(Date billDate, List<String> warehouseCodeList) {
        try {
            this.LOGGER.info("\u5220\u9664\u539f\u59cb\u4ed3\u50a8\u8d26\u5355\uff1a{},{}", (Object)billDate, warehouseCodeList);
            StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
            Date endDate = com.dtyunxi.cube.utils.DateUtil.getMonthEnd((Date)billDate);
            ArrayList sqlFilters = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(warehouseCodeList)) {
                sqlFilters.add(SqlFilter.in((String)"warehouse_code", warehouseCodeList));
            }
            sqlFilters.add(SqlFilter.ge((String)"bill_time", (Object)billDate));
            sqlFilters.add(SqlFilter.le((String)"bill_time", (Object)endDate));
            storageChargeBillEo.setSqlFilters((List)sqlFilters);
            this.storageChargeBillDas.logicDelete((BaseEo)storageChargeBillEo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<StorageChargeBillEo> queryStorageChargeBillByBillDate(Date billDate) {
        try {
            StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
            storageChargeBillEo.setBillTime(billDate);
            return this.storageChargeBillDas.select((BaseEo)storageChargeBillEo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<StorageChargeBillReqDto> salveList) {
        if (CollectionUtil.isEmpty(salveList)) {
            return;
        }
        ArrayList eos = Lists.newArrayList();
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        salveList.forEach(i -> {
            StorageChargeBillEo eo = new StorageChargeBillEo();
            DtoHelper.dto2Eo((BaseVo)i, (BaseEo)eo);
            eo.setBillTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)i.getBillTime(), (String)"yyyy-MM-dd"));
            if (StringUtils.isNotBlank((CharSequence)i.getChargeOrgId())) {
                eo.setChargeOrgId(Long.valueOf(i.getChargeOrgId()));
            }
            eos.add(eo);
        });
        eos.forEach(i -> {
            StorageChargeBillEo eo = this.storageChargeBillDas.queryByCondition(i);
            if (eo == null) {
                insertList.add(i);
            } else {
                i.setId(eo.getId());
                updateList.add(i);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)insertList)) {
            this.storageChargeBillDas.insertBatch((List)insertList);
        }
        if (CollectionUtil.isNotEmpty((Collection)updateList)) {
            updateList.forEach(i -> this.storageChargeBillDas.update((BaseEo)i));
        }
    }

    @Override
    public List<StatisticsBillRespDto> statisticsBillSum(StatisticsBillReqDto statisticsBillReqDto) {
        List statisticsBillRespDtos = this.storageChargeBillDas.statisticsBillSum(statisticsBillReqDto);
        return statisticsBillRespDtos;
    }

    @Override
    public StorageChargeBillRespDto queryBillDto(StorageChargeBillReqDto storageChargeBillReqDto) {
        StorageChargeBillEo eo = new StorageChargeBillEo();
        DtoHelper.dto2Eo((BaseVo)storageChargeBillReqDto, (BaseEo)eo);
        if (ObjectUtils.isNotEmpty((Object)storageChargeBillReqDto.getChargeOrgId())) {
            eo.setChargeOrgId(Long.valueOf(storageChargeBillReqDto.getChargeOrgId()));
        }
        eo.setBillTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)storageChargeBillReqDto.getBillTime(), (String)"yyyy-MM-dd"));
        StorageChargeBillRespDto respDto = new StorageChargeBillRespDto();
        StorageChargeBillEo dto = this.storageChargeBillDas.queryByCondition(eo);
        if (ObjectUtils.isNotEmpty((Object)dto)) {
            DtoHelper.eo2Dto((BaseEo)dto, (BaseVo)respDto);
            return respDto;
        }
        return null;
    }

    @Override
    public void correctionStorageChargeBill(Date date) {
        this.LOGGER.info("\u4fee\u6b63\u4ed3\u50a8\u8d26\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)date));
        Date billDate = com.dtyunxi.cube.utils.DateUtil.addMonths((Date)date, (int)-1);
        this.LOGGER.info("\u4fee\u6b63\u5408\u540c\u6bcf\u6708\u65e5\u5747\u677f\u6570\uff0c\u7528\u6700\u5927\u503c\u8ba1\u7b97\u5dee\u989d");
        this.storageChargeBillDas.correctionContractAverageSupport(billDate);
        this.LOGGER.info("\u4fee\u6b63\u4ed3\u50a8\u8d39\u7528");
        this.storageChargeBillDas.correctionWarehouseCost(billDate);
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4ed3\u50a8\u8d26\u5355\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        StorageChargeBillEo updateEo = new StorageChargeBillEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List eos = this.storageChargeBillDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = eos.stream().filter(eo -> eo.getPlacedFlag() == null || eo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.storageChargeBillDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertStorageChargeBillBatch(List<StorageChargeBillEo> storageChargeBillEos) {
        int result = this.storageChargeBillDas.insertBatch(storageChargeBillEos);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u6279\u91cf\u63d2\u5165\u4ed3\u50a8\u8d26\u5355\u5931\u8d25");
    }

    @Override
    public List<StorageChargeBillRespDto> apportionOtherList(ApportionOtherReqDto apportionOtherReqDto) {
        List<StorageChargeBillEo> storageChargeBillList = this.verifyApportionOtherList(apportionOtherReqDto);
        List<StorageChargeBillEo> storageChargeBillEoList = this.calculateApportionOther(apportionOtherReqDto, storageChargeBillList, ApportionOtherOperationEnum.APPORTION_DATA);
        ArrayList storageChargeBillRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(storageChargeBillEoList, (Collection)storageChargeBillRespDtoList, StorageChargeBillRespDto.class);
        return storageChargeBillRespDtoList;
    }

    @Override
    public ApportionOtherCostRespDto apportionOther(ApportionOtherReqDto apportionOtherReqDto) {
        List<StorageChargeBillEo> storageChargeBillList = this.verifyApportionOtherList(apportionOtherReqDto);
        if (ApportionOtherOperationEnum.VERIFY.equals((Object)ApportionOtherOperationEnum.keyOfEnum((Integer)apportionOtherReqDto.getOperation()))) {
            BigDecimal reduce = storageChargeBillList.stream().map(StorageChargeBillEo::getOtherCost).reduce(BigDecimal.ZERO, BigDecimal::add);
            ApportionOtherCostRespDto apportionOtherCostRespDto = new ApportionOtherCostRespDto();
            if (reduce.compareTo(BigDecimal.ZERO) != 0) {
                apportionOtherCostRespDto.setVerifyStatus(ApportionOtherVerifyEnum.ERROR.getKey());
                apportionOtherCostRespDto.setBillTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)apportionOtherReqDto.getBillDate(), (String)"yyyy-MM"));
                apportionOtherCostRespDto.setTotalOtherCost(reduce);
            }
            return apportionOtherCostRespDto;
        }
        List<StorageChargeBillEo> storageChargeBillEoList = this.calculateApportionOther(apportionOtherReqDto, storageChargeBillList, ApportionOtherOperationEnum.COMMIT);
        this.storageChargeBillService.updateBatch(storageChargeBillEoList);
        return null;
    }

    private List<StorageChargeBillEo> verifyApportionOtherList(ApportionOtherReqDto apportionOtherReqDto) {
        this.LOGGER.info("\u4ed3\u50a8\u8d26\u5355\u5206\u644a param :{}", (Object)JSON.toJSONString((Object)apportionOtherReqDto));
        CalculateWayEnum calculateWayEnum = CalculateWayEnum.keyOfEnum((Integer)apportionOtherReqDto.getCalculateWay());
        ApportionOtherOperationEnum apportionOtherOperationEnum = ApportionOtherOperationEnum.keyOfEnum((Integer)apportionOtherReqDto.getOperation());
        Assert.notNull((Object)apportionOtherReqDto.getBillDate(), (String)"0001", (String)"\u5206\u644a\u8d26\u5355\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!!!");
        Assert.notNull((Object)apportionOtherReqDto.getWarehouseCode(), (String)"0001", (String)"\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a!!!");
        Assert.notNull((Object)calculateWayEnum, (String)"0001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u63d0\u4ea4\u64cd\u4f5c\u65b9\u5f0f!!!");
        Assert.notNull((Object)apportionOtherReqDto.getOtherAmount(), (String)"0001", (String)"\u5176\u4ed6\u8d39\u7528\u603b\u989d\u4e0d\u80fd\u4e3a\u7a7a!!!");
        Assert.notNull((Object)apportionOtherOperationEnum, (String)"0001", (String)"\u5f53\u524d\u63d0\u4ea4\u64cd\u4f5c\u65b9\u5f0f\u4e0d\u5408\u6cd5!!!");
        StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
        storageChargeBillEo.setBillTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)apportionOtherReqDto.getBillDate(), (String)"yyyy-MM"));
        storageChargeBillEo.setWarehouseCode(apportionOtherReqDto.getWarehouseCode());
        storageChargeBillEo.setBillType(Integer.valueOf(1));
        List storageChargeBillList = this.storageChargeBillDas.select((BaseEo)storageChargeBillEo);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storageChargeBillList), (String)"0001", (String)"\u5f53\u524d\u7269\u7406\u4ed3\u4e0b\u7684\u5e93\u5b58\u7ec4\u7ec7\u8d26\u5355\u4e0d\u5b58\u5728");
        return storageChargeBillList;
    }

    private List<StorageChargeBillEo> calculateApportionOther(ApportionOtherReqDto apportionOtherReqDto, List<StorageChargeBillEo> storageChargeBillList, ApportionOtherOperationEnum apportionOtherOperationEnum) {
        CalculateWayEnum calculateWayEnum = CalculateWayEnum.keyOfEnum((Integer)apportionOtherReqDto.getCalculateWay());
        BigDecimal total = BigDecimal.ZERO;
        if (calculateWayEnum.equals((Object)CalculateWayEnum.VOLUME)) {
            BigDecimal isException = new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
            long count = storageChargeBillList.stream().filter(c -> c.getOutDeliveryVolume().compareTo(isException) == 0).count();
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)"0001", (String)"\u51fa\u5e93\u4f53\u79ef\u5f02\u5e38\u65e0\u6cd5\u8fdb\u884c\u5206\u644a\uff01\uff01\uff01");
            total = storageChargeBillList.stream().map(c -> c.getOutDeliveryVolume()).reduce(BigDecimal.ZERO, BigDecimal::add);
        } else {
            long count = storageChargeBillList.stream().filter(c -> c.getOutDeliverySupport().equals(IsExceptionStorageBill.IS_EXCEPTION.getVal())).count();
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)"0001", (String)"\u51fa\u5e93\u677f\u6570\u5f02\u5e38\u65e0\u6cd5\u8fdb\u884c\u5206\u644a\uff01\uff01\uff01");
            total = new BigDecimal(storageChargeBillList.stream().mapToInt(c -> c.getOutDeliverySupport()).sum());
        }
        Assert.isTrue((total.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"0001", (String)(StringUtils.defaultString((String)apportionOtherReqDto.getWarehouseName(), (String)"") + "\u51fa\u5e93\u4f53\u79ef/\u677f\u6750\u4e3a0"));
        Integer sumPercentage = 0;
        for (StorageChargeBillEo storageChargeBill : storageChargeBillList) {
            BigDecimal property;
            int percentage = 0;
            BigDecimal otherAmount = BigDecimal.ZERO;
            BigDecimal bigDecimal = property = calculateWayEnum.equals((Object)CalculateWayEnum.VOLUME) ? storageChargeBill.getOutDeliveryVolume() : new BigDecimal(storageChargeBill.getOutDeliverySupport());
            if (storageChargeBillList.indexOf(storageChargeBill) != storageChargeBillList.size() - 1) {
                BigDecimal percentageProperty = property.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : property.divide(total, 2, 4);
                percentage = percentageProperty.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue();
                sumPercentage = sumPercentage + percentage;
                otherAmount = apportionOtherReqDto.getOtherAmount().multiply(percentageProperty).setScale(2, 4);
            } else {
                percentage = 100 - sumPercentage;
                otherAmount = apportionOtherReqDto.getOtherAmount().multiply(new BigDecimal(percentage)).divide(BigDecimal.TEN.multiply(BigDecimal.TEN)).setScale(2, 4);
            }
            storageChargeBill.setOutDeliveryProperty(property);
            storageChargeBill.setOutPercentageProperty(BigDecimal.valueOf(percentage));
            storageChargeBill.setOtherCost(otherAmount);
            storageChargeBill.setTotalWarehouseCost(otherAmount.add(storageChargeBill.getTotalWarehouseCost()));
        }
        return storageChargeBillList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatch(List<StorageChargeBillEo> storageChargeBillList) {
        storageChargeBillList.forEach(c -> {
            int result = this.storageChargeBillDas.update((BaseEo)c);
            Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u6279\u91cf\u66f4\u65b0\u5931\u8d25");
        });
    }

    @Override
    public void updateStorageBill(UpdateStorageDetailDto updateStorageDetailDto) {
        this.LOGGER.info("\u3010\u89e6\u53d1\u8d26\u5355\u53d8\u66f4\u3011params : {}", (Object)JSON.toJSONString((Object)updateStorageDetailDto));
        Assert.notNull((Object)updateStorageDetailDto.getBillTime(), (String)"0001", (String)"\u66f4\u65b0\u8d26\u5355\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)updateStorageDetailDto.getWarehouseCodeList()), (String)"\u66f4\u65b0\u8d26\u5355\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        Date billTime = com.dtyunxi.cube.utils.DateUtil.parseDate((String)updateStorageDetailDto.getBillTime(), (String)"yyyy-MM");
        this.syncStorageChargeBill(billTime, updateStorageDetailDto.getWarehouseCodeList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStorageChargeBillByIds(List<Long> billIds) {
        billIds.forEach(c -> this.storageChargeBillDas.logicDeleteById(c));
    }

    private Date calculateUpdateBillEndTime(Date date, FinStorageContractRespDto c) {
        Date monthBegin = com.dtyunxi.cube.utils.DateUtil.getMonthBegin((Date)date);
        Date validEndTime = com.dtyunxi.cube.utils.DateUtil.getMonthBegin((Date)c.getValidEndTime());
        Date queryTime = null;
        Assert.isTrue((c.getValidStartTime().compareTo(monthBegin) < 0 ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5408\u540c\u6709\u6548\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        queryTime = validEndTime.compareTo(monthBegin) >= 0 ? monthBegin : com.dtyunxi.cube.utils.DateUtil.addMonths((Date)validEndTime, (int)1);
        return queryTime;
    }

    private List<StorageChargeBillEo> queryStorageChargeBillBywarehouseCode(List<String> warehouseCode, Date BillDate) {
        StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"warehouse_code", warehouseCode));
        storageChargeBillEo.setSqlFilters((List)sqlFilters);
        storageChargeBillEo.setBillTime(BillDate);
        return this.storageChargeBillDas.select((BaseEo)storageChargeBillEo);
    }

    private List<StorageChargeBillEo> calculateAndSet(Date billDate, Map<String, List<FinStorageContractRespDto>> contractMap, Map<String, List<StorageChargeDetailEo>> mapGroupByChargeOrgId, Map<String, BigDecimal> warehouseMonthSupportMap, Map<String, List<StorageChargeBillEo>> storageChargeBillMap) {
        this.LOGGER.info("\u5904\u7406\u6570\u636ecalculateAndSet");
        ArrayList resultList = Lists.newArrayList();
        mapGroupByChargeOrgId.forEach((k, v) -> {
            StorageChargeDetailEo storageChargeDetailEo = (StorageChargeDetailEo)v.stream().findFirst().get();
            List storageContractRespDtos = contractMap.getOrDefault(storageChargeDetailEo.getWarehouseCode(), null);
            long count = v.stream().filter(detail -> detail.getOrganizationSupport().compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0).count();
            BigDecimal monthSupport = count > 0L ? new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal()) : v.stream().map(detail -> detail.getOrganizationSupport()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal warehouseSupportAll = (BigDecimal)warehouseMonthSupportMap.get(storageChargeDetailEo.getWarehouseCode());
            if (CollectionUtils.isNotEmpty((Collection)storageContractRespDtos)) {
                this.LOGGER.info("\u83b7\u53d6\u5bf9\u5e94\u7684\u5408\u5e76\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)storageContractRespDtos));
                if (((FinStorageContractRespDto)storageContractRespDtos.get(0)).getChargeMode().equals(1)) {
                    FinStorageContractRespDto storageContractRespDto = (FinStorageContractRespDto)storageContractRespDtos.stream().skip(storageContractRespDtos.size() - 1).findFirst().get();
                    storageContractRespDtos.forEach(c -> {
                        List<StorageChargeDetailEo> calculateDetails = v.stream().filter(detail -> c.getValidStartTime().compareTo(detail.getBillTime()) <= 0 && c.getValidEndTime().compareTo(detail.getBillTime()) >= 0).collect(Collectors.toList());
                        StorageChargeBillEo storageChargeBillEo = this.basicStorageChargeBill(billDate, monthSupport, storageChargeDetailEo, calculateDetails, defaultInfo -> {
                            defaultInfo.setContractId(c.getId());
                            IsSatisfyContract isSatisfyContract = this.verifyIsSatisfy(warehouseSupportAll, storageContractRespDto, (StorageChargeBillEo)defaultInfo);
                            defaultInfo.setIsSatisfy(isSatisfyContract.getKey());
                            BigDecimal unitPrice = ObjectUtils.isNotEmpty((Object)c) && ObjectUtils.isNotEmpty((Object)c.getFinStorageContractDetailRespDto()) ? c.getFinStorageContractDetailRespDto().getUnitPrice() : new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
                            defaultInfo.setUnitPrice(unitPrice);
                            BigDecimal storageAmount = isSatisfyContract.equals((Object)IsSatisfyContract.IS_SATISFY) ? StorageChargeHelper.calculateIsSatisfyCost(defaultInfo.getAllMonthSupport(), unitPrice) : StorageChargeHelper.calculateStorageCost(c, warehouseSupportAll, unitPrice, defaultInfo.getAllMonthSupport(), defaultInfo.getDaysNum());
                            defaultInfo.setWarehouseCost(storageAmount);
                            String key = storageChargeDetailEo.getWarehouseCode() + storageChargeDetailEo.getChargeOrgId();
                            this.calculateOtherCost(storageChargeBillMap.getOrDefault(key, null), (StorageChargeBillEo)defaultInfo, storageContractRespDtos.indexOf(c), storageContractRespDtos.size());
                            defaultInfo.setTotalWarehouseCost(ObjectUtils.isNotEmpty((Object)defaultInfo.getOtherCost()) ? storageAmount.add(defaultInfo.getOtherCost()) : storageAmount);
                            this.LOGGER.info("\u5408\u540c\u6bcf\u6708\u65e5\u5747\u677f\u6570\u8ba1\u7b97\uff1a{}", (Object)JSON.toJSONString((Object)defaultInfo));
                            BigDecimal contractAverageSupport = StorageChargeHelper.calculateContractAverageSupport(defaultInfo.getAllMonthSupport(), warehouseSupportAll, storageChargeDetailEo.getWarehouseCode(), storageChargeDetailEo.getLogicWarehouseCode(), c);
                            if (Objects.equals(defaultInfo.getIsSatisfy(), IsSatisfyContract.NOT_SATISFY.getKey())) {
                                defaultInfo.setContractAverageSupport(contractAverageSupport);
                            }
                            HashSet<String> exceptionInfoSet = StorageChargeHelper.verifyStorageBillException(defaultInfo.getOutDeliverySupport(), defaultInfo.getAllMonthSupport(), unitPrice, defaultInfo.getOutDeliveryVolume(), warehouseSupportAll);
                            defaultInfo.setExceptionInfo(JSON.toJSONString(exceptionInfoSet));
                            if (CollectionUtils.isNotEmpty(exceptionInfoSet)) {
                                defaultInfo.setStatus(Integer.valueOf(1));
                            } else {
                                defaultInfo.setStatus(Integer.valueOf(0));
                            }
                            return defaultInfo;
                        });
                        storageChargeBillEo.setBillType(Integer.valueOf(1));
                        resultList.add(storageChargeBillEo);
                    });
                }
            } else {
                StorageChargeBillEo storageChargeBillEo = this.constructorDefault(billDate, (List<StorageChargeDetailEo>)v, storageChargeDetailEo, monthSupport, warehouseSupportAll);
                storageChargeBillEo.setBillType(Integer.valueOf(1));
                resultList.add(storageChargeBillEo);
            }
        });
        return resultList;
    }

    private StorageChargeBillEo constructorDefault(Date billDate, List<StorageChargeDetailEo> v, StorageChargeDetailEo storageChargeDetailEo, BigDecimal monthSupport, BigDecimal warehouseSupportAll) {
        StorageChargeBillEo storageChargeBillEo = this.basicStorageChargeBill(billDate, monthSupport, storageChargeDetailEo, v, defaultInfo -> {
            BigDecimal isException = new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
            defaultInfo.setIsSatisfy(IsSatisfyContract.NOT_SATISFY.getKey());
            defaultInfo.setUnitPrice(isException);
            defaultInfo.setContractAverageSupport(isException);
            defaultInfo.setWarehouseCost(isException);
            defaultInfo.setTotalWarehouseCost(isException);
            HashSet<String> exceptionInfoSet = StorageChargeHelper.verifyStorageBillException(defaultInfo.getOutDeliverySupport(), defaultInfo.getAllMonthSupport(), isException, defaultInfo.getOutDeliveryVolume(), warehouseSupportAll);
            defaultInfo.setExceptionInfo(JSON.toJSONString(exceptionInfoSet));
            return defaultInfo;
        });
        return storageChargeBillEo;
    }

    private IsSatisfyContract verifyIsSatisfy(BigDecimal warehouseSupportAll, FinStorageContractRespDto c, StorageChargeBillEo defaultInfo) {
        if (warehouseSupportAll.compareTo(BigDecimal.ZERO) == 0) {
            return IsSatisfyContract.NOT_SATISFY;
        }
        return warehouseSupportAll.divide(new BigDecimal(defaultInfo.getDaysNum()), 6, 1).compareTo(new BigDecimal(c.getContractAverageSupport())) >= 0 ? IsSatisfyContract.IS_SATISFY : IsSatisfyContract.NOT_SATISFY;
    }

    private void calculateOtherCost(List<StorageChargeBillEo> storageChargeBills, StorageChargeBillEo defaultInfo, Integer contractIndex, Integer count) {
        List collect;
        if (contractIndex.equals(count - 1) && CollectionUtils.isNotEmpty(storageChargeBills) && CollectionUtils.isNotEmpty(collect = storageChargeBills.stream().filter(c -> ObjectUtils.isNotEmpty((Object)c.getOtherCost())).collect(Collectors.toList()))) {
            StorageChargeBillEo storageChargeBill = (StorageChargeBillEo)collect.stream().findFirst().get();
            defaultInfo.setOtherCost(storageChargeBill.getOtherCost());
            defaultInfo.setOutDeliveryProperty(storageChargeBill.getOutDeliveryProperty());
            defaultInfo.setOutPercentageProperty(storageChargeBill.getOutPercentageProperty());
        }
    }

    private StorageChargeBillEo basicStorageChargeBill(Date billDate, BigDecimal monthSupport, StorageChargeDetailEo storageChargeDetailEo, List<StorageChargeDetailEo> calculateDetails, Function<StorageChargeBillEo, StorageChargeBillEo> func) {
        StorageChargeBillEo storageChargeBillEo = new StorageChargeBillEo();
        storageChargeBillEo.setBillTime(billDate);
        storageChargeBillEo.setWarehouseCode(storageChargeDetailEo.getWarehouseCode());
        storageChargeBillEo.setWarehouseName(storageChargeDetailEo.getWarehouseName());
        storageChargeBillEo.setChargeOrgId(storageChargeDetailEo.getChargeOrgId());
        storageChargeBillEo.setChargeOrgName(storageChargeDetailEo.getChargeOrgName());
        storageChargeBillEo.setAllMonthSupport(monthSupport);
        int day = com.dtyunxi.cube.utils.DateUtil.getDayDiff((Date)billDate, (Date)DateUtil.offsetMonth((Date)billDate, (int)1));
        storageChargeBillEo.setDaysNum(Integer.valueOf(day));
        long volumeCount = calculateDetails.stream().filter(detail -> detail.getAllOutVolume().compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0).count();
        BigDecimal outDeliveryVolumeTotal = volumeCount == 0L ? calculateDetails.stream().map(detail -> detail.getAllOutVolume()).reduce(BigDecimal.ZERO, BigDecimal::add) : new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal());
        storageChargeBillEo.setOutDeliveryVolume(outDeliveryVolumeTotal);
        long outDeliverySupportCount = calculateDetails.stream().map(detail -> StorageChargeHelper.getSupport(detail.getOutDeliveryNum(), detail.getPackingQuantity(), detail.getZhTrayNum())).filter(detail -> detail.equals(IsExceptionStorageBill.IS_EXCEPTION.getVal())).count();
        int outDeliverySupportTotal = outDeliverySupportCount == 0L ? calculateDetails.stream().mapToInt(detail -> StorageChargeHelper.getSupport(detail.getOutDeliveryNum(), detail.getPackingQuantity(), detail.getZhTrayNum())).sum() : IsExceptionStorageBill.IS_EXCEPTION.getVal().intValue();
        storageChargeBillEo.setOutDeliverySupport(Integer.valueOf(outDeliverySupportTotal));
        return func.apply(storageChargeBillEo);
    }

    private Map<String, List<FinStorageContractRespDto>> calculateContractUnitPrice(Date date, List<FinStorageContractRespDto> storageContractRespDtos) {
        Assert.notNull((Object)date, (String)"0001", (String)"\u8d26\u5355\u7edf\u8ba1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, List<FinStorageContractRespDto>> storageContractMapGroupByWarehouse = Optional.ofNullable(storageContractRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(FinStorageContractRespDto::getWarehouseCode));
        storageContractMapGroupByWarehouse.forEach((k, v) -> v.forEach(finStorageContractRespDto -> {
            List collect = finStorageContractRespDto.getDetailRespDtoList().stream().filter(c -> c.getContractTime().equals(date)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                FinStorageContractDetailRespDto finStorageContractDetailRespDto = (FinStorageContractDetailRespDto)collect.stream().findFirst().get();
                finStorageContractRespDto.setFinStorageContractDetailRespDto(finStorageContractDetailRespDto);
            }
        }));
        return storageContractMapGroupByWarehouse;
    }

    private Map<String, BigDecimal> calculateMonthWarehouseSupport(List<StorageChargeDetailEo> storageChargeDetailEos) {
        HashMap warehouseMonthSupportMap = Maps.newHashMap();
        Map<String, List<StorageChargeDetailEo>> mapGroupByWarehouseCode = storageChargeDetailEos.stream().collect(Collectors.groupingBy(StorageChargeDetailEo::getWarehouseCode));
        mapGroupByWarehouseCode.forEach((k, v) -> {
            BigDecimal warehouseMonthSupport = BigDecimal.ZERO;
            long count = v.stream().filter(c -> c.getOrganizationSupport().compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) == 0).count();
            warehouseMonthSupport = count > 0L ? new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal()) : v.stream().filter(c -> c.getOrganizationSupport().compareTo(new BigDecimal(IsExceptionStorageBill.IS_EXCEPTION.getVal())) != 0).map(c -> c.getOrganizationSupport()).reduce(BigDecimal.ZERO, BigDecimal::add);
            warehouseMonthSupportMap.put(k, warehouseMonthSupport);
        });
        return warehouseMonthSupportMap;
    }
}

