/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailChargingDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailChargingService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailService;
import com.dtyunxi.tcbj.dao.das.FinLogisticDetailChargingDas;
import com.dtyunxi.tcbj.dao.eo.FinLogisticDetailChargingEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinLogisticDetailChargingServiceImpl
implements IFinLogisticDetailChargingService {
    private final Logger logger = LoggerFactory.getLogger(FinLogisticDetailChargingServiceImpl.class);
    @Resource
    private FinLogisticDetailChargingDas das;
    @Resource
    private IFinLogisticDetailService finLogisticDetailService;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService dailyDeliveryReportCostBelongDetailService;

    @Override
    public void batchAdd(List<FinLogisticDetailChargingDto> dtoList) {
        this.logger.info("\u6279\u91cf\u65b0\u589e\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List finLogisticDetailChargingEoList = BeanUtil.copyToList(dtoList, FinLogisticDetailChargingEo.class);
        this.das.insertBatch(finLogisticDetailChargingEoList);
    }

    @Override
    public PageInfo<FinLogisticDetailChargingDto> queryPage(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return this.das.queryPage(dto);
    }

    @Override
    public FinLogisticDetailChargingDto queryFlagCount(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5f02\u5e38\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return this.das.queryFlagCount(dto);
    }

    @Override
    public FinLogisticDetailChargingDto queryDataCount(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u6570\u636e\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return this.das.queryDataCount(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillingOrg(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u4fee\u6539\u8ba1\u8d39\u7ec4\u7ec7: {}", (Object)JSON.toJSONString((Object)dto));
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)dto.getIds()), (String)"\u8bf7\u6c42\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a");
        List finLogisticDetailChargingEoList = this.das.selectByIds(dto.getIds());
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)finLogisticDetailChargingEoList), (String)"\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        finLogisticDetailChargingEoList.forEach(eo -> {
            FinLogisticDetailChargingEo updateEo = new FinLogisticDetailChargingEo();
            updateEo.setId(eo.getId());
            updateEo.setBillingOrgCode(eo.getBillingOrgCode());
            updateEo.setBillingOrgName(eo.getBillingOrgName());
            this.das.updateSelective((BaseEo)updateEo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateLogisticDetailCharging(FinLogisticDetailChargingDto reqDto) {
        this.logger.info("\u751f\u6210\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)reqDto.getBookkeepingDate()), (String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqDto.getBillTypeList())) {
            List types = Arrays.stream(DailyDeliveryReportCostBelongDetailCostTypeEnum.values()).map(DailyDeliveryReportCostBelongDetailCostTypeEnum::getType).collect(Collectors.toList());
            reqDto.setBillTypeList(types);
        }
        if (reqDto.isIfDelFormer()) {
            this.logicDel(reqDto);
        }
        reqDto.getBillTypeList().forEach(type -> {
            switch (Objects.requireNonNull(DailyDeliveryReportCostBelongDetailCostTypeEnum.getEnumByType((String)type))) {
                case GENERAL: {
                    this.generateLogisticDetailChargingForGeneral(reqDto);
                    break;
                }
                case INTERNAL_DEAL: {
                    reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType());
                    this.generateLogisticDetailChargingForCostBelongDetail(reqDto);
                    break;
                }
                case ARTIFICIAL: {
                    reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
                    this.generateLogisticDetailChargingForCostBelongDetail(reqDto);
                    break;
                }
                default: {
                    this.logger.info("\u672a\u77e5\u7c7b\u578b");
                }
            }
        });
    }

    public void generateLogisticDetailChargingForGeneral(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u751f\u6210\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff0c\u5e38\u89c4\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        FinLogisticsDetailReqDto detailReqDto = (FinLogisticsDetailReqDto)BeanUtil.copyProperties((Object)dto, FinLogisticsDetailReqDto.class, (String[])new String[0]);
        List<FinLogisticDetailRespDto> finLogisticDetailRespDtoList = this.finLogisticDetailService.queryList(detailReqDto);
        if (CollectionUtils.isEmpty(finLogisticDetailRespDtoList)) {
            this.logger.info("\u65e0\u7269\u6d41\u539f\u59cb\u660e\u7ec6\u6570\u636e");
            return;
        }
        List<FinLogisticDetailChargingDto> chargingReqDtoList = finLogisticDetailRespDtoList.stream().map(detailDto -> {
            FinLogisticDetailChargingDto chargingReqDto = (FinLogisticDetailChargingDto)BeanUtil.copyProperties((Object)detailDto, FinLogisticDetailChargingDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
            chargingReqDto.setFeeId(detailDto.getId());
            chargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            chargingReqDto.setBillingOrgCode(detailDto.getCostBelongOrgCode());
            chargingReqDto.setBillingOrgName(detailDto.getCostBelongOrgName());
            chargingReqDto.setApportionNum(detailDto.getQuantity());
            chargingReqDto.setApportionVolume(detailDto.getTotalVolume());
            chargingReqDto.setApportionWeight(detailDto.getTotalWeight());
            return chargingReqDto;
        }).collect(Collectors.toList());
        this.batchAdd(chargingReqDtoList);
    }

    public void generateLogisticDetailChargingForCostBelongDetail(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u751f\u6210\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff0c\u5185\u90e8\u4ea4\u6613/\u4eba\u5de5\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        DailyDeliveryReportCostBelongDetailDto queryDto = new DailyDeliveryReportCostBelongDetailDto();
        queryDto.setBookkeepingMonth(dto.getBookkeepingDate());
        queryDto.setType(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        queryDto.setCostType(dto.getBillType());
        queryDto.setPhysicalWarehouseCodeList(dto.getWarehouseCodeList());
        queryDto.setShipmentEnterpriseCodeList(dto.getLogisticCompanyCodeList());
        queryDto.setTransportStyleList(dto.getTransportTypeList());
        List costBelongDetailDtoList = this.dailyDeliveryReportCostBelongDetailService.queryList(queryDto);
        if (CollectionUtils.isEmpty((Collection)costBelongDetailDtoList)) {
            this.logger.info("\u65e0\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u4eba\u5de5\u5206\u644a/\u5185\u90e8\u4ea4\u6613\u6570\u636e");
            return;
        }
        List feeIds = costBelongDetailDtoList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).distinct().collect(Collectors.toList());
        FinLogisticsDetailReqDto detailReqDto = new FinLogisticsDetailReqDto();
        detailReqDto.setIds(feeIds);
        List<FinLogisticDetailRespDto> logisticDetailRespDtoList = this.finLogisticDetailService.queryList(detailReqDto);
        if (CollectionUtils.isEmpty(logisticDetailRespDtoList)) {
            this.logger.info("\u65e0\u4fdd\u8d39\u660e\u7ec6\u539f\u59cb\u8d39\u7528\u4fe1\u606f\u6570\u636e");
            return;
        }
        Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> belongDetailMap = costBelongDetailDtoList.stream().collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDel(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u903b\u8f91\u5220\u9664\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List finLogisticDetailChargingDtoList = this.das.queryList(dto);
        if (CollectionUtils.isNotEmpty((Collection)finLogisticDetailChargingDtoList)) {
            List ids = finLogisticDetailChargingDtoList.stream().map(FinLogisticDetailChargingDto::getId).collect(Collectors.toList());
            this.das.logicDeleteByIds(ids);
        }
    }
}

