/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailChargingDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailChargingService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticsReportService;
import com.dtyunxi.tcbj.biz.service.ILogisticCommonService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogisticCommonServiceImpl
implements ILogisticCommonService {
    private static final Logger logger = LoggerFactory.getLogger(LogisticCommonServiceImpl.class);
    @Resource
    private IFinLogisticsReportService finLogisticsReportService;
    @Resource
    private IFinLogisticDetailChargingService finLogisticDetailChargingService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u6839\u636e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u7269\u6d41\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            logger.info("\u5220\u9664\u65e7\u6570\u636e\u5e76\u751f\u6210\u7269\u6d41\u539f\u59cb\u660e\u7ec6");
            LogisticStatisticReqDto logisticStatisticReqDto = new LogisticStatisticReqDto();
            logisticStatisticReqDto.setStartTime(DateUtil.getDateFormat((Date)feeGenerateReqDto.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            logisticStatisticReqDto.setEndTime(DateUtil.getDateFormat((Date)feeGenerateReqDto.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            logisticStatisticReqDto.setWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            logisticStatisticReqDto.setTransportTypeList(feeGenerateReqDto.getTransportTypeList());
            logisticStatisticReqDto.setLogisticCodeList(feeGenerateReqDto.getLogisticCompanyCodeList());
            this.finLogisticsReportService.generateLogisticStatisticDataForDailyDeliveryReport(logisticStatisticReqDto);
            FinLogisticDetailChargingDto generalChargingReqDto = new FinLogisticDetailChargingDto();
            generalChargingReqDto.setBookkeepingDate(feeGenerateReqDto.getBookkeepingMonth());
            generalChargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            generalChargingReqDto.setBillTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType()}));
            generalChargingReqDto.setIfDelFormer(true);
            this.finLogisticDetailChargingService.generateLogisticDetailCharging(generalChargingReqDto);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        this.dailyDeliveryReportStockApportionService.autoApportion(apportionDto);
    }
}

