/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrderBizTypeRespDto;
import com.dtyunxi.finance.api.query.IApportionmentConfigQueryApi;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.biz.enums.ExpressBusinessTypeEnum;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IExpressCostChargingService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseJobService;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.convert.entity.DailyDeliveryReportStockApportionConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportStockApportionDomain;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportStockApportionStatusEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailRecordDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionOrgDetailDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportStockApportionEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailRecordService;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DailyDeliveryReportStockApportionServiceImpl
extends BaseServiceImpl<DailyDeliveryReportStockApportionDto, DailyDeliveryReportStockApportionEo, IDailyDeliveryReportStockApportionDomain>
implements IDailyDeliveryReportStockApportionService {
    private static final Logger logger = LoggerFactory.getLogger(DailyDeliveryReportStockApportionServiceImpl.class);
    @Resource
    private IDailyDeliveryReportCostBelongDetailService dailyDeliveryReportCostBelongDetailService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;
    @Resource
    private IDailyDeliveryReportDealDetailRecordService dailyDeliveryReportDealDetailRecordService;
    @Resource
    private ISortingExpenseJobService sortingExpenseJobService;
    @Resource
    private IApportionmentConfigQueryApi apportionmentConfigQueryApi;
    @Resource
    private IExpressCostChargingService expressCostChargingService;
    @Resource
    private IReInsurancePremiumService reInsurancePremiumService;
    @Resource
    private IFinLogisticDetailService finLogisticDetailService;
    @Resource
    private ItemExtendDas itemExtendDas;

    public DailyDeliveryReportStockApportionServiceImpl(IDailyDeliveryReportStockApportionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DailyDeliveryReportStockApportionDto, DailyDeliveryReportStockApportionEo> converter() {
        return DailyDeliveryReportStockApportionConverter.INSTANCE;
    }

    @Override
    public PageInfo<DailyDeliveryReportStockApportionDto> queryPage(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = ((IDailyDeliveryReportStockApportionDomain)this.domain).queryPage(dto);
        if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(info -> {
                info.setApportionStatusStr(DailyDeliveryReportStockApportionStatusEnum.getDesc((String)info.getApportionStatus()));
                info.setTypeStr(DailyDeliveryFeeModuleEnum.getDescByCode((String)info.getType()));
                info.setBusinessTypeStr(ExpressBusinessTypeEnum.getNameByType(info.getBusinessType()));
            });
        }
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAdd(List<DailyDeliveryReportStockApportionDto> dtoList) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6279\u91cf\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List eoList = BeanUtil.copyToList(dtoList, DailyDeliveryReportStockApportionEo.class);
        ((IDailyDeliveryReportStockApportionDomain)this.domain).insertBatch(eoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u5220\u9664\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void artificialApportion(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u4eba\u5de5\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getId()), (String)"\u5206\u644a\u5931\u8d25\uff0c\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getBookkeepingMonth()), (String)"\u5206\u644a\u5931\u8d25\uff0c\u8bb0\u8d26\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)CollectionUtil.isEmpty((Collection)dto.getOrgDetailDtoList()), (String)"\u5206\u644a\u5931\u8d25\uff0c\u5206\u644a\u8ba1\u8d39\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        DailyDeliveryReportStockApportionEo stockApportionEo = (DailyDeliveryReportStockApportionEo)((IDailyDeliveryReportStockApportionDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)stockApportionEo), (String)"\u627e\u4e0d\u5230\u5206\u644a\u5355\u636e");
        BigDecimal apportionNumTotal = dto.getOrgDetailDtoList().stream().map(DailyDeliveryReportStockApportionOrgDetailDto::getApportionNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal apportionAlready = ObjectUtil.isEmpty((Object)stockApportionEo.getApportionAlready()) ? BigDecimal.ZERO : stockApportionEo.getApportionAlready();
        BigDecimal apportionRemain = stockApportionEo.getApportionTotal().subtract(apportionAlready);
        AssertUtils.isFalse((apportionNumTotal.compareTo(apportionRemain) != 0 ? 1 : 0) != 0, (String)"\u5206\u644a\u5931\u8d25\uff0c\u9700\u8981\u5c06\u6240\u6709\u5269\u4f59\u6570\u91cf\u5206\u644a\u5b8c");
        ArrayList costBelongDetailDtoList = new ArrayList();
        dto.getOrgDetailDtoList().forEach(orgDetailDto -> {
            DailyDeliveryReportCostBelongDetailDto costBelongDetailDto = new DailyDeliveryReportCostBelongDetailDto();
            costBelongDetailDto.setBookkeepingMonth(dto.getBookkeepingMonth());
            costBelongDetailDto.setStockApportionId(stockApportionEo.getId());
            costBelongDetailDto.setFeeId(stockApportionEo.getFeeId());
            costBelongDetailDto.setReportId(stockApportionEo.getReportId());
            costBelongDetailDto.setDealDetailId(stockApportionEo.getDetailId());
            costBelongDetailDto.setType(stockApportionEo.getType());
            costBelongDetailDto.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
            costBelongDetailDto.setApportionNum(orgDetailDto.getApportionNum());
            costBelongDetailDto.setCostOrgCode(orgDetailDto.getCostOrgCode());
            costBelongDetailDto.setCostOrgName(orgDetailDto.getCostOrgName());
            costBelongDetailDtoList.add(costBelongDetailDto);
        });
        this.dailyDeliveryReportCostBelongDetailService.batchAdd(costBelongDetailDtoList);
        stockApportionEo.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.ALREADY_APPORTION.getType());
        stockApportionEo.setApportionAlready(stockApportionEo.getApportionTotal());
        ((IDailyDeliveryReportStockApportionDomain)this.domain).updateSelective((BaseEo)stockApportionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void autoApportion(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u81ea\u52a8\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getType()), (String)"\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBookkeepingMonth()), (String)"\u8bb0\u8d26\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        ApportionmentConfigExtRespDto apportionmentConfigExtRespDto = (ApportionmentConfigExtRespDto)RestResponseHelper.extractData((RestResponse)this.apportionmentConfigQueryApi.queryByCostModuleCode(dto.getType()));
        if (ObjectUtil.isEmpty((Object)apportionmentConfigExtRespDto)) {
            logger.info("\u81ea\u52a8\u5206\u644a\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8d39\u7528\u6a21\u5757\u5206\u644a\u914d\u7f6e");
            return;
        }
        logger.info("\u8d39\u7528\u6a21\u5757\u5206\u644a\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)apportionmentConfigExtRespDto));
        List stockApportionDtoList = ((IDailyDeliveryReportStockApportionDomain)this.domain).queryList(dto);
        if (CollectionUtil.isEmpty((Collection)stockApportionDtoList)) {
            logger.info("\u81ea\u52a8\u5206\u644a\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5206\u644a\u5355\u636e\u6570\u636e");
            return;
        }
        if (CollectionUtil.isEmpty(stockApportionDtoList = stockApportionDtoList.stream().filter(f -> f.getRemainAlready().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()))) {
            logger.info("\u81ea\u52a8\u5206\u644a\u5931\u8d25\uff0c\u65e0\u5269\u4f59\u5206\u644a\u6570\u91cf");
            return;
        }
        Integer tradeApportionmentDeadline = apportionmentConfigExtRespDto.getTradeApportionmentDeadline();
        DailyDeliveryReportDealDetailDto queryDealDetailDto = this.setDealTimeScope(dto.getBookkeepingMonth(), tradeApportionmentDeadline);
        queryDealDetailDto.setFeeModule(dto.getType());
        if (CollectionUtil.isNotEmpty((Collection)apportionmentConfigExtRespDto.getOrderBizTypeList())) {
            List orderTypeList = apportionmentConfigExtRespDto.getOrderBizTypeList().stream().map(ApportionmentOrderBizTypeRespDto::getOrderType).collect(Collectors.toList());
            queryDealDetailDto.setDealTypeList(orderTypeList);
        }
        queryDealDetailDto.setApportionRemain(BigDecimal.ONE);
        logger.info("\u67e5\u8be2\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)queryDealDetailDto));
        List dealDetailDtoList = this.dailyDeliveryReportDealDetailService.queryList(queryDealDetailDto);
        if (CollectionUtil.isEmpty((Collection)dealDetailDtoList)) {
            logger.info("\u65e0\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\u6570\u636e");
            return;
        }
        Map<String, List<DailyDeliveryReportDealDetailDto>> dealDetailMap = dealDetailDtoList.stream().collect(Collectors.groupingBy(g -> g.getSkuCode() + "_" + g.getBatch()));
        ArrayList<DailyDeliveryReportCostBelongDetailDto> costBelongDetailDtoList = new ArrayList<DailyDeliveryReportCostBelongDetailDto>();
        ArrayList<DailyDeliveryReportStockApportionDto> updateStockApportionDtoList = new ArrayList<DailyDeliveryReportStockApportionDto>();
        for (DailyDeliveryReportStockApportionDto apportionDto : stockApportionDtoList) {
            logger.info("\u904d\u5386\u80a1\u4efd\u5355\u636e\u8fdb\u884c\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)apportionDto));
            List<DailyDeliveryReportDealDetailDto> dealDetailList = dealDetailMap.get(apportionDto.getSkuCode() + apportionDto.getBatch());
            if (CollectionUtil.isEmpty(dealDetailList)) {
                logger.info("\u6ca1\u6709\u5339\u914d\u5230\u53ef\u5206\u644a\u7684\u5185\u90e8\u4ea4\u6613");
                continue;
            }
            apportionDto.setApportionAlready(ObjectUtil.isEmpty((Object)apportionDto.getApportionAlready()) ? BigDecimal.ZERO : apportionDto.getApportionAlready());
            BigDecimal remainAlready = apportionDto.getRemainAlready();
            for (DailyDeliveryReportDealDetailDto dealDetail : dealDetailList) {
                if (dealDetail.getApportionRemain().compareTo(BigDecimal.ZERO) <= 0) continue;
                DailyDeliveryReportCostBelongDetailDto belongDetailDto = (DailyDeliveryReportCostBelongDetailDto)BeanUtil.copyProperties((Object)apportionDto, DailyDeliveryReportCostBelongDetailDto.class, (String[])new String[]{"id", "extension", "createPerson", "createTime", "updatePerson", "updateTime", "dr"});
                belongDetailDto.setStockApportionId(apportionDto.getId());
                belongDetailDto.setReportId(apportionDto.getReportId());
                belongDetailDto.setDetailId(apportionDto.getDetailId());
                belongDetailDto.setFeeId(apportionDto.getFeeId());
                belongDetailDto.setDealDetailId(dealDetail.getId());
                belongDetailDto.setType(apportionDto.getType());
                belongDetailDto.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType());
                belongDetailDto.setCostOrgCode(dealDetail.getOutInventoryOrgId());
                belongDetailDto.setCostOrgName(dealDetail.getOutInventoryOrg());
                if (remainAlready.compareTo(dealDetail.getApportionRemain()) > 0) {
                    remainAlready = remainAlready.subtract(dealDetail.getApportionRemain());
                    belongDetailDto.setApportionNum(dealDetail.getApportionRemain());
                    apportionDto.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.PORTION_APPORTION.getType());
                } else {
                    dealDetail.setApportionRemain(dealDetail.getApportionRemain().subtract(remainAlready));
                    belongDetailDto.setApportionNum(remainAlready);
                    apportionDto.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.ALREADY_APPORTION.getType());
                }
                apportionDto.setApportionAlready(apportionDto.getApportionAlready().add(belongDetailDto.getApportionNum()));
                costBelongDetailDtoList.add(belongDetailDto);
                if (remainAlready.compareTo(BigDecimal.ZERO) > 0) continue;
                break;
            }
            if (apportionDto.getApportionStatus().equals(DailyDeliveryReportStockApportionStatusEnum.NOT_APPORTION.getType())) {
                updateStockApportionDtoList.add(apportionDto);
            }
            Date nowDate = new Date();
            if (CollectionUtil.isNotEmpty(costBelongDetailDtoList)) {
                List dealDetailRecordDtoList = costBelongDetailDtoList.stream().map(m -> {
                    DailyDeliveryReportDealDetailRecordDto dealDetailRecordDto = new DailyDeliveryReportDealDetailRecordDto();
                    dealDetailRecordDto.setDealDetailId(m.getDealDetailId());
                    dealDetailRecordDto.setStockApportionId(m.getStockApportionId());
                    dealDetailRecordDto.setBookkeepingMonth(m.getBookkeepingMonth());
                    dealDetailRecordDto.setFeeModule(m.getType());
                    dealDetailRecordDto.setApportionQuantity(m.getApportionNum());
                    dealDetailRecordDto.setApportionTime(nowDate);
                    return dealDetailRecordDto;
                }).collect(Collectors.toList());
                logger.info("\u4fdd\u5b58\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u751f\u6210\u5206\u644a\u6d41\u6c34\uff1a{}", dealDetailRecordDtoList);
                this.dailyDeliveryReportDealDetailRecordService.insertBatch(dealDetailRecordDtoList);
            }
            if (CollectionUtil.isNotEmpty(costBelongDetailDtoList)) {
                this.replenishVolumeWeight(costBelongDetailDtoList);
                this.dailyDeliveryReportCostBelongDetailService.batchAdd(costBelongDetailDtoList);
            }
            if (!CollectionUtil.isNotEmpty(updateStockApportionDtoList)) continue;
            logger.info("\u66f4\u65b0\u5206\u644a\u5355\u636e\u5206\u644a\u72b6\u6001\uff1a{}", updateStockApportionDtoList);
            updateStockApportionDtoList.forEach(stockApportion -> {
                DailyDeliveryReportStockApportionEo updateEo = new DailyDeliveryReportStockApportionEo();
                updateEo.setId(stockApportion.getId());
                updateEo.setApportionAlready(stockApportion.getApportionAlready());
                updateEo.setApportionStatus(stockApportion.getApportionStatus());
                ((IDailyDeliveryReportStockApportionDomain)this.domain).updateSelective((BaseEo)updateEo);
            });
        }
    }

    private void replenishVolumeWeight(List<DailyDeliveryReportCostBelongDetailDto> dtoList) {
        List itemCodeList = dtoList.stream().map(DailyDeliveryReportCostBelongDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        List itemExtendEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", itemCodeList)).groupBy((Object)"item_code")).list();
        Map itemExtendEoMap = Optional.ofNullable(itemExtendEoList).map(p -> p.stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity(), (o, o1) -> o))).orElse(new HashMap());
        dtoList.forEach(dto -> {
            dto.setApportionVolume(BigDecimal.ZERO);
            dto.setApportionWeight(BigDecimal.ZERO);
            ItemExtendEo itemExtendEo = (ItemExtendEo)itemExtendEoMap.get(dto.getSkuCode());
            if (ObjectUtil.isNotEmpty((Object)itemExtendEo)) {
                dto.setApportionVolume(ObjectUtil.isNotEmpty((Object)itemExtendEo.getVolume()) ? itemExtendEo.getVolume().multiply(dto.getApportionNum()) : BigDecimal.ZERO);
                dto.setApportionWeight(ObjectUtil.isNotEmpty((Object)itemExtendEo.getQuantity()) ? itemExtendEo.getQuantity().multiply(dto.getApportionNum()) : BigDecimal.ZERO);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generate(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getType()), (String)"\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBookkeepingMonth()), (String)"\u751f\u6210\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        switch (DailyDeliveryFeeModuleEnum.getByCode((String)dto.getType())) {
            case LOGISTICS_FEE: {
                this.generateByLogisticsFee(dto);
                break;
            }
            case PREMIUM_FEE: {
                this.generateByPremiumFee(dto);
                break;
            }
            case SORTING_FEE: {
                this.generateBySortingFee(dto);
                break;
            }
            case EXPRESS_DELIVERY: {
                this.generateByExpressDelivery(dto);
                break;
            }
            default: {
                logger.info("\u672a\u5904\u7406\u7c7b\u578b\uff01");
            }
        }
        logger.info("\u8d39\u7528\u6a21\u5757");
    }

    private void generateByLogisticsFee(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u7269\u6d41\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        FinLogisticsDetailReqDto detailReqDto = new FinLogisticsDetailReqDto();
        detailReqDto.setBookkeepingDate(dto.getBookkeepingMonth());
        detailReqDto.setWarehouseCodeList(dto.getPhysicalWarehouseCodeList());
        detailReqDto.setTransportTypeList(dto.getTransportStyleList());
        detailReqDto.setLogisticCompanyCodeList(dto.getShipmentEnterpriseNameList());
        detailReqDto.setIfApportion(YesOrNoEnum.YES.getCode());
        List<FinLogisticDetailRespDto> finLogisticDetailRespDtoList = this.finLogisticDetailService.queryList(detailReqDto);
        if (CollectionUtil.isEmpty(finLogisticDetailRespDtoList)) {
            logger.info("\u65e0\u7269\u6d41\u539f\u59cb\u660e\u7ec6\u6570\u636e");
            return;
        }
        List<DailyDeliveryReportStockApportionDto> stockApportionDtoList = finLogisticDetailRespDtoList.stream().map(logisticDetail -> {
            DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
            apportionDto.setBookkeepingMonth(dto.getBookkeepingMonth());
            apportionDto.setReportId(logisticDetail.getLinkDailyReportId());
            apportionDto.setFeeId(logisticDetail.getId());
            apportionDto.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.NOT_APPORTION.getType());
            apportionDto.setApportionTotal(logisticDetail.getQuantity());
            apportionDto.setApportionAlready(BigDecimal.ZERO);
            return apportionDto;
        }).collect(Collectors.toList());
        this.batchAdd(stockApportionDtoList);
    }

    private void generateByPremiumFee(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u4fdd\u8d39\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        ReInsurancePremiumReqDto reqDto = new ReInsurancePremiumReqDto();
        reqDto.setInOutTimeBegin(dto.getOrderShippingTimeStart());
        reqDto.setInOutTimeEnd(dto.getOrderShippingTimeEnd());
        reqDto.setOutPhysicsWarehouseCodeList(dto.getPhysicalWarehouseCodeList());
        reqDto.setShippingCompanyList(dto.getShipmentEnterpriseNameList());
        reqDto.setShippingTypeList(dto.getTransportStyleList());
        List<ReInsurancePremiumRespDto> reInsurancePremiumRespDtoList = this.reInsurancePremiumService.queryList(reqDto);
        if (CollectionUtil.isEmpty(reInsurancePremiumRespDtoList)) {
            logger.info("\u65e0\u4fdd\u8d39\u539f\u59cb\u660e\u7ec6\u6570\u636e");
            return;
        }
        List<DailyDeliveryReportStockApportionDto> stockApportionDtoList = reInsurancePremiumRespDtoList.stream().map(premiumRespDto -> {
            DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
            apportionDto.setBookkeepingMonth(dto.getBookkeepingMonth());
            apportionDto.setReportId(premiumRespDto.getLinkDailyReportId());
            apportionDto.setDetailId(premiumRespDto.getLinkDailyDetailId());
            apportionDto.setFeeId(premiumRespDto.getId());
            apportionDto.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.NOT_APPORTION.getType());
            apportionDto.setApportionTotal(premiumRespDto.getQuantity());
            apportionDto.setApportionAlready(BigDecimal.ZERO);
            return apportionDto;
        }).collect(Collectors.toList());
        this.batchAdd(stockApportionDtoList);
    }

    private void generateBySortingFee(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u5206\u62e3\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        this.sortingExpenseJobService.generateBySortingFee(dto);
    }

    private void generateByExpressDelivery(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u6839\u636e\u5feb\u9012\u8d39\u7528\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        this.expressCostChargingService.generateStockApportion(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void afreshGenerate(DailyDeliveryReportStockApportionDto dto) {
        logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getType()), (String)"\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getBookkeepingMonth()), (String)"\u751f\u6210\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        List stockApportionDtoList = ((IDailyDeliveryReportStockApportionDomain)this.domain).queryList(dto);
        if (CollectionUtil.isNotEmpty((Collection)stockApportionDtoList)) {
            logger.info("\u65e0\u80a1\u4efd\u5206\u644a\u5355\u636e\u53ef\u91cd\u65b0\u751f\u6210");
            List stockApportionIds = stockApportionDtoList.stream().map(DailyDeliveryReportStockApportionDto::getId).collect(Collectors.toList());
            this.dailyDeliveryReportDealDetailRecordService.logicDeleteByStockApportionIds(stockApportionIds);
            this.dailyDeliveryReportCostBelongDetailService.logicDeleteByStockApportionIds(stockApportionIds);
            ((IDailyDeliveryReportStockApportionDomain)this.domain).logicDeleteByIds(stockApportionIds);
        }
        this.generate(dto);
    }

    private DailyDeliveryReportDealDetailDto setDealTimeScope(String bookkeepingMonth, Integer tradeApportionmentDeadline) {
        String[] parts = bookkeepingMonth.split("-");
        int year = Integer.parseInt(parts[0]);
        int month = Integer.parseInt(parts[1]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.set(year, month - 1, 1, 23, 59, 59);
        calendar.set(14, 999);
        calendar.add(2, 1);
        calendar.add(5, tradeApportionmentDeadline - 1);
        Date endDate = calendar.getTime();
        DailyDeliveryReportDealDetailDto queryDealDetailDto = new DailyDeliveryReportDealDetailDto();
        queryDealDetailDto.setDealTimeStart(startDate);
        queryDealDetailDto.setDealTimeEnd(endDate);
        return queryDealDetailDto;
    }
}

