/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.api.dto.request.WarehouseIssueStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseIssueStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseIssueTotalStatisticsRespDto;
import com.dtyunxi.tcbj.biz.service.IHomePageStatisticsAssistService;
import com.dtyunxi.tcbj.biz.service.IWarehouseIssueStatisticsService;
import com.dtyunxi.tcbj.biz.utils.LbsUtil;
import com.dtyunxi.tcbj.dao.das.WarehouseIssueStatisticsDas;
import com.dtyunxi.tcbj.dao.eo.WarehouseIssueStatisticsEo;
import com.dtyunxi.tcbj.dao.vo.OutWarehouseStatisticsVo;
import com.dtyunxi.tcbj.dao.vo.QueryStatisticVo;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WarehouseIssueStatisticsServiceImpl
implements IWarehouseIssueStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(WarehouseIssueStatisticsServiceImpl.class);
    @Resource
    private WarehouseIssueStatisticsDas warehouseIssueStatisticsDas;
    @Resource
    private IHomePageStatisticsAssistService homePageStatisticsAssistService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private LbsUtil lbsUtil;
    @Resource
    private ExecutorService statisticsExecutor;

    @Override
    public Long addWarehouseIssueStatistics(WarehouseIssueStatisticsReqDto addReqDto) {
        WarehouseIssueStatisticsEo warehouseIssueStatisticsEo = new WarehouseIssueStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)warehouseIssueStatisticsEo);
        this.warehouseIssueStatisticsDas.insert((BaseEo)warehouseIssueStatisticsEo);
        return warehouseIssueStatisticsEo.getId();
    }

    @Override
    public void modifyWarehouseIssueStatistics(WarehouseIssueStatisticsReqDto modifyReqDto) {
        WarehouseIssueStatisticsEo warehouseIssueStatisticsEo = new WarehouseIssueStatisticsEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseIssueStatisticsEo);
        this.warehouseIssueStatisticsDas.updateSelective((BaseEo)warehouseIssueStatisticsEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseIssueStatistics(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseIssueStatisticsDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseIssueStatisticsRespDto queryById(Long id) {
        this.syncWarehouseIssueStatics();
        this.syncWarehouseIssueStaticsExt();
        WarehouseIssueStatisticsEo warehouseIssueStatisticsEo = (WarehouseIssueStatisticsEo)this.warehouseIssueStatisticsDas.selectByPrimaryKey(id);
        WarehouseIssueStatisticsRespDto warehouseIssueStatisticsRespDto = new WarehouseIssueStatisticsRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseIssueStatisticsEo, (BaseVo)warehouseIssueStatisticsRespDto);
        return warehouseIssueStatisticsRespDto;
    }

    @Override
    public PageInfo<WarehouseIssueStatisticsRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        log.info("queryByPage->filter:{}", (Object)filter);
        WarehouseIssueStatisticsReqDto warehouseIssueStatisticsReqDto = (WarehouseIssueStatisticsReqDto)JSON.parseObject((String)filter, WarehouseIssueStatisticsReqDto.class);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseIssueStatisticsDas.filter().eq((Object)"type", (Object)warehouseIssueStatisticsReqDto.getType())).orderByDesc((Object)"sale_create_date")).page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseIssueStatisticsRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncWarehouseIssueStatics() {
        List<WarehouseIssueStatisticsEo> eoList;
        ArrayList issuedStatusList;
        ArrayList notIssuedStatusList;
        List<OutWarehouseStatisticsVo> saleOrderList = this.asyncSaleOrder("1");
        List<OutWarehouseStatisticsVo> transferOrderList = this.asyncTransferOrder();
        log.info("homePageStatisticsAssistService.voList:{}", (Object)JSON.toJSONString(saleOrderList));
        HashSet timeSet = Sets.newHashSet();
        Map<Object, Object> saleOrderMap = Maps.newHashMap();
        Map<Object, Object> transferOrderMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(saleOrderList)) {
            notIssuedStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.WAIT_DELIVERY.getCode()});
            issuedStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()});
            eoList = this.handleData(saleOrderList, notIssuedStatusList, issuedStatusList);
            timeSet.addAll(eoList.stream().map(WarehouseIssueStatisticsEo::getUniqueKey).collect(Collectors.toSet()));
            saleOrderMap = eoList.stream().collect(Collectors.toMap(WarehouseIssueStatisticsEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtil.isNotEmpty(transferOrderList)) {
            notIssuedStatusList = Lists.newArrayList((Object[])new String[]{"wait_delivery"});
            issuedStatusList = Lists.newArrayList((Object[])new String[]{"wait_receive", "finish", "hang_up"});
            eoList = this.handleTransferData(transferOrderList, notIssuedStatusList, issuedStatusList);
            timeSet.addAll(eoList.stream().map(WarehouseIssueStatisticsEo::getUniqueKey).collect(Collectors.toSet()));
            transferOrderMap = eoList.stream().collect(Collectors.toMap(WarehouseIssueStatisticsEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtil.isEmpty((Collection)timeSet)) {
            return;
        }
        ArrayList saveList = Lists.newArrayList();
        for (String s : timeSet) {
            String[] arr = s.split(":");
            String saleCreateDate = arr[0];
            String warehouseCode = arr[1];
            WarehouseIssueStatisticsEo eo = new WarehouseIssueStatisticsEo();
            eo.setSaleCreateDate(saleCreateDate);
            eo.setWarehouseCode(warehouseCode);
            if (saleOrderMap.containsKey(s)) {
                WarehouseIssueStatisticsEo saleOrder = (WarehouseIssueStatisticsEo)saleOrderMap.get(s);
                eo.setWarehouseName(saleOrder.getWarehouseName());
                eo.setNotIssuedVolume(saleOrder.getNotIssuedVolume());
                eo.setNotIssuedNum(saleOrder.getNotIssuedNum());
                eo.setIssuedNumber(saleOrder.getIssuedNumber());
                eo.setIssuedVolume(saleOrder.getIssuedVolume());
            }
            if (transferOrderMap.containsKey(s)) {
                WarehouseIssueStatisticsEo transferOrder = (WarehouseIssueStatisticsEo)transferOrderMap.get(s);
                eo.setWarehouseName(transferOrder.getWarehouseName());
                eo.setTrNotIssuedVolume(transferOrder.getTrNotIssuedVolume());
                eo.setTrNotIssuedNum(transferOrder.getTrNotIssuedNum());
                eo.setTrIssuedNumber(transferOrder.getTrIssuedNumber());
                eo.setTrIssuedVolume(transferOrder.getTrIssuedVolume());
            }
            if (eo.getNotIssuedNum() <= 0L && eo.getTrNotIssuedNum() <= 0L) continue;
            eo.setType(Integer.valueOf(1));
            saveList.add(eo);
        }
        log.info("homePageStatisticsAssistService.eoList:{}", (Object)JSON.toJSONString((Object)saveList));
        this.save(saveList, "1");
    }

    @Override
    public void syncWarehouseIssueStaticsExt() {
        List<WarehouseIssueStatisticsEo> eoList;
        ArrayList issuedStatusList;
        ArrayList notIssuedStatusList;
        List<OutWarehouseStatisticsVo> saleOrderList = this.asyncSaleOrder("2");
        if (CollectionUtil.isEmpty(saleOrderList)) {
            return;
        }
        ArrayList nutritionList = Lists.newArrayList();
        ArrayList otherList = Lists.newArrayList();
        for (OutWarehouseStatisticsVo vo : saleOrderList) {
            String orderType = vo.getOrderType();
            if (SaleOrderTypeEnum.ACTIVITY_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType().equals(orderType)) {
                nutritionList.add(vo);
                continue;
            }
            otherList.add(vo);
        }
        HashSet timeSet = Sets.newHashSet();
        Map<Object, Object> nutritionMap = Maps.newHashMap();
        Map<Object, Object> otherMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)nutritionList)) {
            notIssuedStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.WAIT_DELIVERY.getCode()});
            issuedStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()});
            eoList = this.handleData(nutritionList, notIssuedStatusList, issuedStatusList);
            timeSet.addAll(eoList.stream().map(WarehouseIssueStatisticsEo::getUniqueKey).collect(Collectors.toSet()));
            nutritionMap = eoList.stream().collect(Collectors.toMap(WarehouseIssueStatisticsEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtil.isNotEmpty((Collection)otherList)) {
            notIssuedStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.WAIT_DELIVERY.getCode()});
            issuedStatusList = Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.COMPLETE.getCode(), SaleOrderStatusEnum.RECEIVED.getCode()});
            eoList = this.handleData(otherList, notIssuedStatusList, issuedStatusList);
            timeSet.addAll(eoList.stream().map(WarehouseIssueStatisticsEo::getUniqueKey).collect(Collectors.toSet()));
            otherMap = eoList.stream().collect(Collectors.toMap(WarehouseIssueStatisticsEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList saveList = Lists.newArrayList();
        for (String s : timeSet) {
            String[] arr = s.split(":");
            String saleCreateDate = arr[0];
            String warehouseCode = arr[1];
            WarehouseIssueStatisticsEo eo = new WarehouseIssueStatisticsEo();
            eo.setSaleCreateDate(saleCreateDate);
            eo.setWarehouseCode(warehouseCode);
            if (nutritionMap.containsKey(s)) {
                WarehouseIssueStatisticsEo saleOrder = (WarehouseIssueStatisticsEo)nutritionMap.get(s);
                eo.setWarehouseName(saleOrder.getWarehouseName());
                eo.setNotIssuedVolume(saleOrder.getNotIssuedVolume());
                eo.setNotIssuedNum(saleOrder.getNotIssuedNum());
                eo.setIssuedNumber(saleOrder.getIssuedNumber());
                eo.setIssuedVolume(saleOrder.getIssuedVolume());
            }
            if (otherMap.containsKey(s)) {
                WarehouseIssueStatisticsEo otherOrder = (WarehouseIssueStatisticsEo)otherMap.get(s);
                eo.setWarehouseName(otherOrder.getWarehouseName());
                eo.setTrNotIssuedVolume(otherOrder.getNotIssuedVolume());
                eo.setTrNotIssuedNum(otherOrder.getNotIssuedNum());
                eo.setTrIssuedNumber(otherOrder.getIssuedNumber());
                eo.setTrIssuedVolume(otherOrder.getIssuedVolume());
            }
            if (eo.getNotIssuedNum() <= 0L && eo.getTrNotIssuedNum() <= 0L) continue;
            eo.setType(Integer.valueOf(2));
            saveList.add(eo);
        }
        this.save(saveList, "2");
    }

    @Override
    public String queryUpdateTimeExt() {
        String updateTime = (String)this.cacheService.getCache("warehouse_issue_statistics_update_time_ext", String.class);
        if (StringUtils.isBlank((CharSequence)updateTime)) {
            WarehouseIssueStatisticsEo eo = (WarehouseIssueStatisticsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseIssueStatisticsDas.filter().eq((Object)"type", (Object)2)).orderByDesc((Object)"update_time")).last("limit 1")).one();
            if (eo == null) {
                return "";
            }
            return DateUtil.format((Date)eo.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern());
        }
        return updateTime;
    }

    @Override
    public String queryUpdateTime() {
        String updateTime = (String)this.cacheService.getCache("warehouse_issue_statistics_update_time", String.class);
        if (StringUtils.isBlank((CharSequence)updateTime)) {
            WarehouseIssueStatisticsEo eo = (WarehouseIssueStatisticsEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.warehouseIssueStatisticsDas.filter().eq((Object)"type", (Object)1)).orderByDesc((Object)"update_time")).last("limit 1")).one();
            if (eo == null) {
                return "";
            }
            return DateUtil.format((Date)eo.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern());
        }
        return updateTime;
    }

    @Override
    public WarehouseIssueTotalStatisticsRespDto queryTotalStatistics() {
        return this.homePageStatisticsAssistService.queryTotalStatistics();
    }

    @Override
    public WarehouseIssueTotalStatisticsRespDto queryTotalStatisticsExt(String type) {
        WarehouseIssueStatisticsEo eo = this.warehouseIssueStatisticsDas.queryTotalData(type);
        WarehouseIssueTotalStatisticsRespDto respDto = new WarehouseIssueTotalStatisticsRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)eo, (String[])new String[0]);
        return respDto;
    }

    private List<OutWarehouseStatisticsVo> asyncSaleOrder(String queryFlag) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.querySaleOrder(queryFlag), this.statisticsExecutor);
        try {
            List orderInfoVos = future.get();
            if (CollectionUtil.isEmpty((Collection)orderInfoVos)) {
                return null;
            }
            return orderInfoVos;
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4f53\u79ef\u3001\u7968\u6570\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<OutWarehouseStatisticsVo> asyncTransferOrder() {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> this.queryTransferOrder(), this.statisticsExecutor);
        try {
            List orderInfoVos = future.get();
            if (CollectionUtil.isEmpty((Collection)orderInfoVos)) {
                return null;
            }
            return orderInfoVos;
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4f53\u79ef\u3001\u7968\u6570\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private List<OutWarehouseStatisticsVo> querySaleOrder(String queryFlag) {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList allVoList = Lists.newArrayList();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            queryVo.setQueryFlag(queryFlag);
            List<OutWarehouseStatisticsVo> voList = this.homePageStatisticsAssistService.queryOutWarehouseStatistics(queryVo);
            if (CollectionUtil.isEmpty(voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return allVoList;
    }

    private List<OutWarehouseStatisticsVo> queryTransferOrder() {
        Integer pageNum = 1;
        Integer pageSize = 10000;
        ArrayList allVoList = Lists.newArrayList();
        while (true) {
            QueryStatisticVo queryVo = new QueryStatisticVo();
            queryVo.setPageSize(pageSize);
            queryVo.setPageNum(pageNum);
            List<OutWarehouseStatisticsVo> voList = this.homePageStatisticsAssistService.queryTransferOutWarehouseStatistics(queryVo);
            if (CollectionUtil.isEmpty(voList)) break;
            allVoList.addAll(voList);
            if (voList.size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        return allVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(List<WarehouseIssueStatisticsEo> eoList, String type) {
        this.warehouseIssueStatisticsDas.deleteAll(type);
        if (CollectionUtil.isNotEmpty(eoList)) {
            this.warehouseIssueStatisticsDas.insertBatch(eoList);
        }
    }

    private void dataClassification(List<WarehouseIssueStatisticsEo> eoList, List<WarehouseIssueStatisticsEo> eos, List<WarehouseIssueStatisticsEo> insertEos, List<WarehouseIssueStatisticsEo> updateEos, List<WarehouseIssueStatisticsEo> deleteEos) {
        Map eoMap = eos.stream().collect(Collectors.toMap(WarehouseIssueStatisticsEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        eoList.stream().forEach(i -> {
            String uniqueKey = i.getUniqueKey();
            Long notIssuedNum = i.getNotIssuedNum();
            if (eoMap.containsKey(uniqueKey)) {
                WarehouseIssueStatisticsEo eo = (WarehouseIssueStatisticsEo)eoMap.get(uniqueKey);
                if (notIssuedNum > 0L) {
                    i.setId(eo.getId());
                    updateEos.add((WarehouseIssueStatisticsEo)i);
                } else {
                    deleteEos.add(eo);
                }
            } else if (notIssuedNum > 0L) {
                insertEos.add((WarehouseIssueStatisticsEo)i);
            }
        });
    }

    private List<WarehouseIssueStatisticsEo> handleData(List<OutWarehouseStatisticsVo> voList, List<String> notIssuedStatusList, List<String> issuedStatusList) {
        Map<String, List<OutWarehouseStatisticsVo>> voMap = voList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getWarehouseCode())).collect(Collectors.groupingBy(OutWarehouseStatisticsVo::getKey));
        ArrayList eoList = Lists.newArrayList();
        log.info("handleData.voMap:{}", (Object)JSON.toJSONString(voMap));
        voMap.forEach((key, value) -> {
            WarehouseIssueStatisticsEo eo = new WarehouseIssueStatisticsEo();
            OutWarehouseStatisticsVo vo = (OutWarehouseStatisticsVo)value.get(0);
            eo.setSaleCreateDate(vo.getSaleCreateTime());
            eo.setWarehouseName(vo.getWarehouseName());
            eo.setWarehouseCode(vo.getWarehouseCode());
            Long notIssuedNum = 0L;
            BigDecimal notIssuedVolume = BigDecimal.ZERO;
            Long issuedNumber = 0L;
            BigDecimal issuedVolume = BigDecimal.ZERO;
            for (OutWarehouseStatisticsVo outVo : value) {
                String status = outVo.getStatus();
                if (notIssuedStatusList.contains(status)) {
                    notIssuedNum = notIssuedNum + 1L;
                    notIssuedVolume = notIssuedVolume.add(outVo.getVolume());
                }
                if (!issuedStatusList.contains(status)) continue;
                issuedNumber = issuedNumber + 1L;
                issuedVolume = issuedVolume.add(outVo.getVolume());
            }
            eo.setIssuedVolume(issuedVolume.setScale(0, 4));
            eo.setIssuedNumber(issuedNumber);
            eo.setNotIssuedNum(notIssuedNum);
            eo.setNotIssuedVolume(notIssuedVolume.setScale(0, RoundingMode.HALF_UP));
            eoList.add(eo);
        });
        return eoList;
    }

    private List<WarehouseIssueStatisticsEo> handleTransferData(List<OutWarehouseStatisticsVo> voList) {
        Map<String, List<OutWarehouseStatisticsVo>> voMap = voList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getWarehouseCode())).collect(Collectors.groupingBy(OutWarehouseStatisticsVo::getKey));
        ArrayList eoList = Lists.newArrayList();
        log.info("handleTransferData.voMap:{}", (Object)JSON.toJSONString(voMap));
        voMap.forEach((key, value) -> {
            WarehouseIssueStatisticsEo eo = new WarehouseIssueStatisticsEo();
            OutWarehouseStatisticsVo vo = (OutWarehouseStatisticsVo)value.get(0);
            eo.setSaleCreateDate(vo.getSaleCreateTime());
            eo.setWarehouseName(vo.getWarehouseName());
            eo.setWarehouseCode(vo.getWarehouseCode());
            Long notIssuedNum = 0L;
            BigDecimal notIssuedVolume = BigDecimal.ZERO;
            Long issuedNumber = 0L;
            BigDecimal issuedVolume = BigDecimal.ZERO;
            for (OutWarehouseStatisticsVo outVo : value) {
                String status = outVo.getStatus();
                if (Objects.equals(status, "wait_delivery")) {
                    notIssuedNum = notIssuedNum + 1L;
                    notIssuedVolume = notIssuedVolume.add(outVo.getVolume());
                }
                if (!Objects.equals(status, "finish")) continue;
                issuedNumber = issuedNumber + 1L;
                issuedVolume = issuedVolume.add(outVo.getVolume());
            }
            eo.setTrIssuedVolume(issuedVolume.setScale(0, 4));
            eo.setTrIssuedNumber(issuedNumber);
            eo.setTrNotIssuedNum(notIssuedNum);
            eo.setTrNotIssuedVolume(notIssuedVolume.setScale(0, RoundingMode.HALF_UP));
            eoList.add(eo);
        });
        return eoList;
    }

    private List<WarehouseIssueStatisticsEo> handleTransferData(List<OutWarehouseStatisticsVo> voList, List<String> notIssuedStatusList, List<String> issuedStatusList) {
        Map<String, List<OutWarehouseStatisticsVo>> voMap = voList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getWarehouseCode())).collect(Collectors.groupingBy(OutWarehouseStatisticsVo::getKey));
        ArrayList eoList = Lists.newArrayList();
        log.info("handleTransferData.voMap:{}", (Object)JSON.toJSONString(voMap));
        voMap.forEach((key, value) -> {
            WarehouseIssueStatisticsEo eo = new WarehouseIssueStatisticsEo();
            OutWarehouseStatisticsVo vo = (OutWarehouseStatisticsVo)value.get(0);
            eo.setSaleCreateDate(vo.getSaleCreateTime());
            eo.setWarehouseName(vo.getWarehouseName());
            eo.setWarehouseCode(vo.getWarehouseCode());
            Long notIssuedNum = 0L;
            BigDecimal notIssuedVolume = BigDecimal.ZERO;
            Long issuedNumber = 0L;
            BigDecimal issuedVolume = BigDecimal.ZERO;
            for (OutWarehouseStatisticsVo outVo : value) {
                String status = outVo.getStatus();
                if (notIssuedStatusList.contains(status)) {
                    notIssuedNum = notIssuedNum + 1L;
                    notIssuedVolume = notIssuedVolume.add(outVo.getVolume());
                }
                if (!issuedStatusList.contains(status)) continue;
                issuedNumber = issuedNumber + 1L;
                issuedVolume = issuedVolume.add(outVo.getVolume());
            }
            eo.setTrIssuedVolume(issuedVolume.setScale(0, 4));
            eo.setTrIssuedNumber(issuedNumber);
            eo.setTrNotIssuedNum(notIssuedNum);
            eo.setTrNotIssuedVolume(notIssuedVolume.setScale(0, RoundingMode.HALF_UP));
            eoList.add(eo);
        });
        return eoList;
    }
}

