/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceFlagEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumChargingRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.biz.enums.ExpressBusinessTypeEnum;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumChargingService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumChargingDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumChargingEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReInsurancePremiumChargingServiceImpl
implements IReInsurancePremiumChargingService {
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumChargingServiceImpl.class);
    @Resource
    private ReInsurancePremiumChargingDas das;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private IReInsurancePremiumService reInsurancePremiumService;
    @Resource
    private IReInsuranceBillService reInsuranceBillService;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService dailyDeliveryReportCostBelongDetailService;

    @Override
    public Long addReInsurancePremiumCharging(ReInsurancePremiumChargingReqDto addReqDto) {
        ReInsurancePremiumChargingEo reInsurancePremiumEo = new ReInsurancePremiumChargingEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reInsurancePremiumEo);
        this.das.insert((BaseEo)reInsurancePremiumEo);
        return reInsurancePremiumEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddReInsurancePremiumCharging(List<ReInsurancePremiumChargingReqDto> reqDtoList) {
        this.logger.info("\u6279\u91cf\u65b0\u589e\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u8868\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List reInsurancePremiumChargingEoList = BeanUtil.copyToList(reqDtoList, ReInsurancePremiumChargingEo.class);
        this.das.insertBatch(reInsurancePremiumChargingEoList);
    }

    @Override
    public void modifyReInsurancePremium(ReInsurancePremiumChargingReqDto modifyReqDto) {
        ReInsurancePremiumChargingEo reInsurancePremiumEo = new ReInsurancePremiumChargingEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reInsurancePremiumEo);
        this.das.updateSelective((BaseEo)reInsurancePremiumEo);
    }

    @Override
    public ReInsurancePremiumChargingRespDto queryById(Long id) {
        ReInsurancePremiumChargingEo reInsurancePremiumEo = (ReInsurancePremiumChargingEo)this.das.selectByPrimaryKey(id);
        ReInsurancePremiumChargingRespDto reInsurancePremiumRespDto = new ReInsurancePremiumChargingRespDto();
        DtoHelper.eo2Dto((BaseEo)reInsurancePremiumEo, (BaseVo)reInsurancePremiumRespDto);
        return reInsurancePremiumRespDto;
    }

    @Override
    public PageInfo<ReInsurancePremiumChargingRespDto> queryByPage(ReInsurancePremiumChargingReqDto reqDto) {
        List eos;
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.setDate(reqDto);
        PageInfo dtoPageInfo = this.das.queryByPage(reqDto);
        List relevanceNos = dtoPageInfo.getList().stream().map(ReInsurancePremiumChargingRespDto::getRelevanceNo).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(relevanceNos) && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", relevanceNos)).isNotNull((Object)"pre_order_no")).list()))) {
            Map<String, String> stringMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getPreOrderNo, (k1, k2) -> k1));
            map.putAll(stringMap);
        }
        List dtoList = dtoPageInfo.getList().stream().map(eo -> {
            eo.setBillTypeStr(DailyDeliveryReportCostBelongDetailCostTypeEnum.getDesc((String)eo.getBillType()));
            eo.setFlagName(InsuranceFlagEnum.getValueByCode((Integer)eo.getFlag()));
            eo.setShippingTypeName(eo.getShippingType());
            if (StringUtils.isNotBlank((CharSequence)eo.getBusinessType())) {
                eo.setBusinessTypeName(eo.getBusinessType());
                if (StringUtils.isNotBlank((CharSequence)ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()))) {
                    eo.setBusinessTypeName(ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getRelevanceNo()) && StringUtils.isBlank((CharSequence)eo.getExternalOrderNo()) && map.containsKey(eo.getRelevanceNo())) {
                eo.setExternalOrderNo((String)map.get(eo.getRelevanceNo()));
                Object[] externalOrderArray = eo.getExternalOrderNo().split(",");
                eo.setExternalOrderNo((String)Lists.newArrayList((Object[])externalOrderArray).stream().sorted().findFirst().get());
            }
            return eo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ReInsurancePremiumChargingRespDto> queryList(ReInsurancePremiumChargingReqDto reqDto) {
        List premiumChargingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().ge(ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeBegin()), (Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le(ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeEnd()), (Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBillType()), (Object)"bill_type", (Object)reqDto.getBillType())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getBillTypeList()), (Object)"bill_type", (Collection)reqDto.getBillTypeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingCompanyList()), (Object)"shipping_company", (Collection)reqDto.getShippingCompanyList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingTypeList()), (Object)"shipping_type", (Collection)reqDto.getShippingTypeList())).list();
        return BeanUtil.copyToList((Collection)premiumChargingEoList, ReInsurancePremiumChargingRespDto.class);
    }

    @Override
    public void updateCostBelongOrg(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u4fee\u6539\u8ba1\u8d39\u5f52\u5c5e\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)reqDto.getIds()), (String)"\u8bf7\u6c42ids\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getCostBelongOrgCode()), (String)"\u8ba1\u8d39\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getCostBelongOrgName()), (String)"\u8ba1\u8d39\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List chargingEoList = this.das.selectByIds(reqDto.getIds());
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)chargingEoList), (String)"\u627e\u4e0d\u5230\u4fee\u6539\u6570\u636e");
        chargingEoList.forEach(chargingEo -> {
            ReInsurancePremiumChargingEo updateEo = new ReInsurancePremiumChargingEo();
            updateEo.setId(chargingEo.getId());
            updateEo.setCostBelongOrgId(reqDto.getCostBelongOrgId());
            updateEo.setCostBelongOrgCode(reqDto.getCostBelongOrgCode());
            updateEo.setCostBelongOrgName(reqDto.getCostBelongOrgName());
            this.das.updateSelective((BaseEo)updateEo);
        });
    }

    @Override
    public ReInsurancePremiumChargingRespDto queryFlagCount(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5f02\u5e38\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.das.queryFlagCount(reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateInsurancePremiumCharging(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)reqDto.getInOutTimeBegin()) && ObjectUtils.isEmpty((Object)reqDto.getInOutTimeEnd()) && ObjectUtils.isEmpty((Object)reqDto.getBookkeepingMonth()) ? 1 : 0) != 0, (String)"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqDto.getBillTypeList())) {
            List types = Arrays.stream(DailyDeliveryReportCostBelongDetailCostTypeEnum.values()).map(DailyDeliveryReportCostBelongDetailCostTypeEnum::getType).collect(Collectors.toList());
            reqDto.setBillTypeList(types);
        }
        if (reqDto.isIfDelFormer()) {
            this.logicDel(reqDto);
        }
        reqDto.getBillTypeList().forEach(type -> {
            switch (Objects.requireNonNull(DailyDeliveryReportCostBelongDetailCostTypeEnum.getEnumByType((String)type))) {
                case GENERAL: {
                    this.generateInsurancePremiumChargingForGeneral(reqDto);
                    break;
                }
                case INTERNAL_DEAL: {
                    reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType());
                    this.generateInsurancePremiumChargingForCostBelongDetail(reqDto);
                    break;
                }
                case ARTIFICIAL: {
                    reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
                    this.generateInsurancePremiumChargingForCostBelongDetail(reqDto);
                    break;
                }
                default: {
                    this.logger.info("\u672a\u77e5\u7c7b\u578b");
                }
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateInsuranceBill(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8d26\u5355\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List<ReInsurancePremiumChargingRespDto> reInsurancePremiumChargingRespDtoList = this.queryList(reqDto);
        if (CollectionUtils.isEmpty(reInsurancePremiumChargingRespDtoList)) {
            this.logger.info("\u65e0\u8ba1\u8d39\u660e\u7ec6");
            return;
        }
        this.logger.info("\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(reInsurancePremiumChargingRespDtoList));
        ArrayList<ReInsuranceBillReqDto> billReqDtoList = new ArrayList<ReInsuranceBillReqDto>();
        Map<String, List<ReInsurancePremiumChargingRespDto>> premiumChargingRespDtoMap = reInsurancePremiumChargingRespDtoList.stream().collect(Collectors.groupingBy(ReInsurancePremiumChargingRespDto::getConsignmentNo));
        premiumChargingRespDtoMap.forEach((k, v) -> {
            ReInsuranceBillReqDto billReqDto = (ReInsuranceBillReqDto)BeanUtil.copyProperties(v.get(0), ReInsuranceBillReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
            billReqDto.setInsureTotalPrice(v.stream().map(ReInsurancePremiumChargingRespDto::getInsureTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            billReqDtoList.add(billReqDto);
        });
        this.reInsuranceBillService.batchAddReInsuranceBill(billReqDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDel(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u903b\u8f91\u5220\u9664\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List<ReInsurancePremiumChargingRespDto> reInsurancePremiumChargingRespDtoList = this.queryList(reqDto);
        if (CollectionUtils.isNotEmpty(reInsurancePremiumChargingRespDtoList)) {
            List ids = reInsurancePremiumChargingRespDtoList.stream().map(ReInsurancePremiumChargingRespDto::getId).collect(Collectors.toList());
            this.das.logicDeleteByIds(ids);
        }
    }

    private void generateInsurancePremiumChargingForGeneral(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u5e38\u89c4\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ReInsurancePremiumReqDto queryDto = new ReInsurancePremiumReqDto();
        queryDto.setIfApportion(YesOrNoEnum.NO.getCode());
        queryDto.setInOutTimeBegin(reqDto.getInOutTimeBegin());
        queryDto.setInOutTimeEnd(reqDto.getInOutTimeEnd());
        queryDto.setOutPhysicsWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
        queryDto.setShippingCompanyList(reqDto.getShippingCompanyList());
        queryDto.setShippingTypeList(reqDto.getShippingTypeList());
        List<ReInsurancePremiumRespDto> reInsurancePremiumRespDtoList = this.reInsurancePremiumService.queryList(queryDto);
        if (CollectionUtils.isEmpty(reInsurancePremiumRespDtoList)) {
            this.logger.info("\u65e0\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6-\u5e38\u89c4\u8ba1\u8d39\u4fe1\u606f\u6570\u636e");
            return;
        }
        List<ReInsurancePremiumChargingReqDto> chargingReqDtoList = reInsurancePremiumRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getCostBelongOrgName())).map(dto -> {
            ReInsurancePremiumChargingReqDto chargingReqDto = (ReInsurancePremiumChargingReqDto)BeanUtil.copyProperties((Object)dto, ReInsurancePremiumChargingReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
            chargingReqDto.setFeeId(dto.getId());
            chargingReqDto.setCostBelongOrgName(dto.getCostBelongOrgName());
            chargingReqDto.setCostBelongOrgCode(dto.getCostBelongOrgCode());
            chargingReqDto.setCostBelongOrgId(dto.getCostBelongOrgId());
            chargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            chargingReqDto.setAllocationQuantity(dto.getQuantity());
            return chargingReqDto;
        }).collect(Collectors.toList());
        this.batchAddReInsurancePremiumCharging(chargingReqDtoList);
    }

    private void generateInsurancePremiumChargingForCostBelongDetail(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u4eba\u5de5\u5206\u644a/\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DailyDeliveryReportCostBelongDetailDto queryDto = new DailyDeliveryReportCostBelongDetailDto();
        queryDto.setBookkeepingMonth(reqDto.getBookkeepingMonth());
        queryDto.setType(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        queryDto.setCostType(reqDto.getBillType());
        queryDto.setPhysicalWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
        queryDto.setShipmentEnterpriseNameList(reqDto.getShippingCompanyList());
        queryDto.setTransportStyleList(reqDto.getShippingTypeList());
        List costBelongDetailDtoList = this.dailyDeliveryReportCostBelongDetailService.queryList(queryDto);
        if (CollectionUtils.isEmpty((Collection)costBelongDetailDtoList)) {
            this.logger.info("\u65e0\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u4eba\u5de5\u5206\u644a/\u5185\u90e8\u4ea4\u6613\u6570\u636e");
            return;
        }
        Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> costBelongDetailDtoMap = costBelongDetailDtoList.stream().collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
        List<Long> feeIds = costBelongDetailDtoList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).collect(Collectors.toList());
        List<ReInsurancePremiumRespDto> reInsurancePremiumRespDtoList = this.reInsurancePremiumService.queryByIds(feeIds);
        if (CollectionUtils.isEmpty(reInsurancePremiumRespDtoList)) {
            this.logger.info("\u65e0\u4fdd\u8d39\u660e\u7ec6\u539f\u59cb\u8d39\u7528\u4fe1\u606f\u6570\u636e");
            return;
        }
        ArrayList chargingReqDtoList = new ArrayList();
        reInsurancePremiumRespDtoList.forEach(premiumRespDto -> {
            List detailDtoList = (List)costBelongDetailDtoMap.get(premiumRespDto.getId());
            BigDecimal insureTotalPrice = BigDecimal.ZERO;
            detailDtoList.stream().forEach(detail -> {
                ReInsurancePremiumChargingReqDto chargingReqDto = (ReInsurancePremiumChargingReqDto)BeanUtil.copyProperties((Object)premiumRespDto, ReInsurancePremiumChargingReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime", ""});
                chargingReqDto.setFeeId(premiumRespDto.getId());
                chargingReqDto.setBillType(reqDto.getBillType());
                chargingReqDto.setAllocationQuantity(detail.getApportionNum());
                if (ObjectUtils.isNotEmpty((Object)premiumRespDto.getInsureTotalPrice()) && ObjectUtils.isNotEmpty((Object)premiumRespDto.getInsureUnitPrice()) && ObjectUtils.isNotEmpty((Object)detail.getApportionNum())) {
                    boolean isLast;
                    boolean bl = isLast = detailDtoList.indexOf(detail) == detailDtoList.size() - 1;
                    if (isLast) {
                        chargingReqDto.setInsureTotalPrice(premiumRespDto.getInsureTotalPrice().subtract(insureTotalPrice));
                    } else {
                        chargingReqDto.setInsureTotalPrice(chargingReqDto.getInsureUnitPrice().multiply(chargingReqDto.getAllocationQuantity()).setScale(6, RoundingMode.DOWN));
                        insureTotalPrice.add(chargingReqDto.getInsureTotalPrice());
                    }
                }
                chargingReqDtoList.add(chargingReqDto);
            });
            if (CollectionUtils.isNotEmpty((Collection)chargingReqDtoList)) {
                this.batchAddReInsurancePremiumCharging(chargingReqDtoList);
            }
        });
    }

    private void setDate(ReInsurancePremiumChargingReqDto reInsurancePremiumReqDto) {
        try {
            if (ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeEnd())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String begin = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeBegin()) + " 00:00:00";
                String end = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeEnd()) + " 23:59:59";
                reInsurancePremiumReqDto.setInOutTimeBegin(simpleDateFormat.parse(begin));
                reInsurancePremiumReqDto.setInOutTimeEnd(simpleDateFormat.parse(end));
            }
        }
        catch (Exception e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

