/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.query.IApportionmentConfigQueryApi;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.UpdateBillOrgDto;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostChargingReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostChargingRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.exception.ExampleExceptionCode;
import com.dtyunxi.tcbj.biz.service.IExpressCostChargingService;
import com.dtyunxi.tcbj.biz.service.PmsRegenerateTasksService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.biz.utils.PmsTasksUtils;
import com.dtyunxi.tcbj.dao.das.ExpressCostChargingDas;
import com.dtyunxi.tcbj.dao.das.ExpressCostDetailDas;
import com.dtyunxi.tcbj.dao.eo.ExpressCostChargingEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportStockApportionDomain;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.dto.entity.MasterOrderDifferenceDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportStockApportionEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ExpressCostChargingServiceImpl
implements IExpressCostChargingService {
    private static final Logger log = LoggerFactory.getLogger(ExpressCostChargingServiceImpl.class);
    @Resource
    private ExpressCostChargingDas expressCostChargingDas;
    @Resource
    private ExpressCostDetailDas expressCostDetailDas;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private PmsRegenerateTasksService tasksService;
    @Resource
    private IApportionmentConfigQueryApi apportionmentConfigQueryApi;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService costBelongDetailService;
    @Resource
    private IDailyDeliveryReportStockApportionDomain stockApportionDomain;

    @Override
    public Long addExpressCostCharging(ExpressCostChargingReqDto addReqDto) {
        ExpressCostChargingEo expressCostDetailEo = new ExpressCostChargingEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)expressCostDetailEo);
        this.expressCostChargingDas.insert((BaseEo)expressCostDetailEo);
        return expressCostDetailEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeExpressCostCharging(Long id) {
        this.expressCostChargingDas.logicDeleteById(id);
    }

    @Override
    public ExpressCostChargingRespDto queryById(Long id) {
        ExpressCostChargingEo expressCostDetailEo = (ExpressCostChargingEo)this.expressCostChargingDas.selectByPrimaryKey(id);
        ExpressCostChargingRespDto expressCostDetailRespDto = new ExpressCostChargingRespDto();
        DtoHelper.eo2Dto((BaseEo)expressCostDetailEo, (BaseVo)expressCostDetailRespDto);
        return expressCostDetailRespDto;
    }

    @Override
    public PageInfo<ExpressCostChargingRespDto> queryByPage(ExpressCostReportQueryDto queryDto) {
        log.info("\u67e5\u8be2\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u8be6\u60c5\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo(this.expressCostChargingDas.queryPage(queryDto));
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            return dtoPageInfo;
        }
        dtoPageInfo.getList().forEach(info -> {
            if (ObjectUtils.isEmpty((Object)info.getAdjustmentType())) {
                info.setRemark(null);
            }
            if (StringUtils.isBlank((CharSequence)info.getInWarehouseCode())) {
                info.setInOrgCode(null);
            }
            info.setCostTypeName(DailyDeliveryReportCostBelongDetailCostTypeEnum.getDesc((String)info.getCostType()));
        });
        return dtoPageInfo;
    }

    @Override
    public Boolean hasPlacedFlag(ExpressCostReportQueryDto reqDto) {
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{reqDto.getStartTime(), reqDto.getEndTime()})) {
            throw new RuntimeException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        reqDto.setPlacedFlag(Integer.valueOf(1));
        PageInfo<ExpressCostChargingRespDto> page = this.queryByPage(reqDto);
        List pageList = page.getList();
        return CollUtil.isNotEmpty((Collection)pageList);
    }

    @Override
    public ReInsuranceBillCountDto queryExpressCount(ExpressCostReportQueryDto queryDto) {
        ReInsuranceBillCountDto reInsuranceBillCountDto = this.expressCostChargingDas.queryExpressCount(queryDto);
        ExpressCostReportQueryDto queryDifferenceDto = (ExpressCostReportQueryDto)BeanUtil.copyProperties((Object)queryDto, ExpressCostReportQueryDto.class, (String[])new String[0]);
        queryDifferenceDto.setPageNum(Integer.valueOf(1));
        queryDifferenceDto.setPageSize(Integer.valueOf(1));
        PageInfo<MasterOrderDifferenceDto> masterOrderDifferenceDtoPageInfo = this.queryPageMasterOrderDifference(queryDifferenceDto);
        reInsuranceBillCountDto.setMasterOrderDifferenceTotal(new BigDecimal(masterOrderDifferenceDtoPageInfo.getTotal()));
        return reInsuranceBillCountDto;
    }

    @Override
    public void syncExpressCostData(LogisticStatisticReqDto reqDto) {
        log.info("\u751f\u6210\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u6570\u636e\uff0c\u79fb\u9664\u65e7\u6570\u636e\u540e\u5728\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List costTypeList = reqDto.getCostTypeList();
        List chargingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostChargingDas.filter().between((Object)"outbound_time", (Object)reqDto.getStartTime(), (Object)reqDto.getEndTime())).in(CollUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)reqDto.getWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getLogisticCodeList()), (Object)"logistic_code", (Collection)reqDto.getLogisticCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getTransportTypeList()), (Object)"transport_type", (Collection)reqDto.getTransportTypeList())).in(CollUtil.isNotEmpty((Collection)costTypeList), (Object)"cost_type", (Collection)costTypeList)).list();
        if (CollUtil.isNotEmpty((Collection)chargingEoList)) {
            boolean exists = chargingEoList.stream().anyMatch(chargingEo -> Objects.equals(chargingEo.getPlacedFlag(), 1));
            if (exists) {
                throw new BizException(ExampleExceptionCode.PLACED_FLAG_EXC.getCode(), "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
            }
            List ids = chargingEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            ListUtils.partition(ids, (int)1000).forEach(slice -> this.expressCostChargingDas.logicDeleteByIds(slice));
        }
        if (CollUtil.isEmpty((Collection)costTypeList) || costTypeList.contains(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            List costDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().between((Object)"outbound_time", (Object)reqDto.getStartTime(), (Object)reqDto.getEndTime())).in(CollUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)reqDto.getWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getLogisticCodeList()), (Object)"logistic_code", (Collection)reqDto.getLogisticCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getTransportTypeList()), (Object)"transport_type", (Collection)reqDto.getTransportTypeList())).eq((Object)"if_apportion", (Object)0)).list();
            this.insertNotApportionBatch(costDetailEos);
        }
        if (!Objects.equals(reqDto.getIfApportion(), 0)) {
            int pageNum = 1;
            DailyDeliveryReportCostBelongDetailDto belongDetailDto = new DailyDeliveryReportCostBelongDetailDto();
            belongDetailDto.setPageSize(Integer.valueOf(2000));
            belongDetailDto.setType(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
            belongDetailDto.setOrderShippingTimeStart(reqDto.getStartTime());
            belongDetailDto.setOrderShippingTimeEnd(reqDto.getEndTime());
            belongDetailDto.setPhysicalWarehouseCodeList(reqDto.getWarehouseCodeList());
            belongDetailDto.setShipmentEnterpriseCodeList(reqDto.getLogisticCodeList());
            belongDetailDto.setTransportStyleList(reqDto.getTransportTypeList());
            belongDetailDto.setCostTypeList(costTypeList);
            while (true) {
                belongDetailDto.setPageNum(Integer.valueOf(pageNum));
                log.info("\u5206\u9875\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e\u6570\u636e pageNum\uff1a {}", (Object)pageNum);
                PageInfo pageInfo = this.costBelongDetailService.queryPage(belongDetailDto);
                List costBelongDetailList = pageInfo.getList();
                if (CollUtil.isEmpty((Collection)costBelongDetailList)) {
                    log.info("\u8d39\u7528\u5f52\u5c5e\u6570\u636e\u4e3a\u7a7a pageNum\uff1a {}", (Object)pageNum);
                    break;
                }
                ++pageNum;
                List feeIds = costBelongDetailList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollUtil.isEmpty(feeIds)) {
                    log.info("\u8d39\u7528\u5f52\u5c5e\u6570\u636e\u65e0\u8d39\u7528\u539f\u59cbid pageNum\uff1a {}", (Object)pageNum);
                    continue;
                }
                List sortingExpenseEos = ((ExtQueryChainWrapper)this.expressCostDetailDas.filter().in((Object)"id", feeIds)).list();
                Map costDetailEoMap = sortingExpenseEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
                Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> feeIdMap = costBelongDetailList.stream().filter(belongDetail -> Objects.nonNull(belongDetail.getFeeId())).collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
                ArrayList costChargingEos = Lists.newArrayList();
                for (List<DailyDeliveryReportCostBelongDetailDto> costBelongDetails : feeIdMap.values()) {
                    Iterator<DailyDeliveryReportCostBelongDetailDto> belongDetailIterator = costBelongDetails.iterator();
                    Long feeId = costBelongDetails.get(0).getFeeId();
                    ExpressCostDetailEo costDetailEo = (ExpressCostDetailEo)costDetailEoMap.get(feeId);
                    if (Objects.isNull(costDetailEo)) {
                        log.info("\u5feb\u9012\u539f\u59cb\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728 feeId\uff1a{}", (Object)feeId);
                        continue;
                    }
                    BigDecimal totalFreight = costDetailEo.getTotalFreight();
                    BigDecimal allFreight = BigDecimal.ZERO;
                    while (belongDetailIterator.hasNext()) {
                        DailyDeliveryReportCostBelongDetailDto belongDetail2 = belongDetailIterator.next();
                        ExpressCostChargingEo costChargingEo = (ExpressCostChargingEo)BeanUtil.copyProperties((Object)costDetailEo, ExpressCostChargingEo.class, (String[])new String[]{"id"});
                        costChargingEo.setCostType(belongDetail2.getCostType());
                        costChargingEo.setAllocationQuantity(belongDetail2.getApportionNum());
                        costChargingEo.setApportionWeight(belongDetail2.getApportionWeight());
                        costChargingEo.setBillingOrgName(belongDetail2.getCostOrgCode());
                        costChargingEo.setBillingOrgName(belongDetail2.getCostOrgName());
                        costChargingEo.setOrgTotalFreight(this.apportionSortingExpense(costChargingEo, belongDetail2));
                        if (!belongDetailIterator.hasNext()) {
                            costChargingEo.setOrgTotalFreight(NumberUtil.sub((Number)totalFreight, (Number)allFreight));
                        }
                        allFreight = allFreight.add(costChargingEo.getOrgTotalFreight());
                        costChargingEos.add(costChargingEo);
                    }
                }
                if (!CollUtil.isNotEmpty((Collection)costChargingEos)) continue;
                this.expressCostChargingDas.insertBatch((List)costChargingEos);
            }
        }
    }

    @Override
    public void insertNotApportionBatch(List<ExpressCostDetailEo> costDetailEos) {
        if (CollUtil.isEmpty(costDetailEos)) {
            log.info("\u5feb\u9012\u539f\u59cb\u660e\u7ec6\u4e3a\u7a7a");
            return;
        }
        List costChargingEos = costDetailEos.stream().filter(costDetail -> Objects.equals(costDetail.getIfApportion(), 0)).map(costDetail -> {
            ExpressCostChargingEo costChargingEo = (ExpressCostChargingEo)BeanUtil.copyProperties((Object)costDetail, ExpressCostChargingEo.class, (String[])new String[]{"id"});
            costChargingEo.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            costChargingEo.setAllocationQuantity(new BigDecimal(costDetail.getPieceNum()));
            costChargingEo.setApportionWeight(costDetail.getChargedWeight());
            costChargingEo.setOrgTotalFreight(costDetail.getTotalFreight());
            return costChargingEo;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(costChargingEos)) {
            this.expressCostChargingDas.insertBatch(costChargingEos);
        }
    }

    private BigDecimal apportionSortingExpense(ExpressCostChargingEo sortingExpenseEo, DailyDeliveryReportCostBelongDetailDto costBelongDetailDto) {
        if (Objects.isNull(sortingExpenseEo) || Objects.isNull(costBelongDetailDto)) {
            return BigDecimal.ZERO;
        }
        Long pieceNum = sortingExpenseEo.getPieceNum();
        BigDecimal totalFreight = sortingExpenseEo.getTotalFreight();
        if (Objects.isNull(pieceNum) || BigDecimalUtils.leZero((BigDecimal)totalFreight).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal num = new BigDecimal(pieceNum);
        BigDecimal allocationQuantity = sortingExpenseEo.getAllocationQuantity();
        BigDecimal weight = (BigDecimal)ObjectUtil.defaultIfNull((Object)sortingExpenseEo.getChargedWeight(), (Object)sortingExpenseEo.getWeight());
        if (BigDecimalUtils.leZero((BigDecimal)allocationQuantity).booleanValue() || BigDecimalUtils.leZero((BigDecimal)weight).booleanValue()) {
            return BigDecimal.ZERO;
        }
        if (NumberUtil.equals((BigDecimal)allocationQuantity, (BigDecimal)num)) {
            return totalFreight;
        }
        BigDecimal totalWeight = NumberUtil.mul((Number)num, (Number)weight);
        BigDecimal allocationTotalWeight = NumberUtil.mul((BigDecimal[])new BigDecimal[]{allocationQuantity, weight, totalFreight});
        return NumberUtil.div((Number)allocationTotalWeight, (Number)totalWeight, (int)2);
    }

    @Override
    public void againCalculate(AgainCalculateReqDto reqDto) {
    }

    @Override
    public String delete(LogisticStatisticReqDto reqDto) {
        log.info("\u5220\u9664\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.expressCostChargingDas.deleteExpressCostDetailAndReport(reqDto);
        return "\u6267\u884c\u5b8c\u6210";
    }

    @Override
    public List<ExpressCostChargingRespDto> queryList(ExpressCostChargingReqDto reqDto) {
        log.info("\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List detailEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostChargingDas.filter().eq(StringUtils.isNotBlank((CharSequence)reqDto.getOutboundCode()), (Object)"outbound_code", (Object)reqDto.getOutboundCode())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getExpressNo()), (Object)"express_no", (Object)reqDto.getExpressNo())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getEasNo()), (Object)"eas_no", (Object)reqDto.getEasNo())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getOutboundCodeList()), (Object)"outbound_code", (Collection)reqDto.getOutboundCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getEasNoList()), (Object)"eas_no", (Collection)reqDto.getEasNoList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getExpressNoList()), (Object)"express_no", (Collection)reqDto.getExpressNoList())).list();
        return BeanUtil.copyToList((Collection)detailEoList, ExpressCostChargingRespDto.class);
    }

    @Override
    public PageInfo<MasterOrderDifferenceDto> queryPageMasterOrderDifference(ExpressCostReportQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u603b\u5355\u5dee\u5f02\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        queryDto.setLogisticCodeList(this.getCarrierCodeList());
        return this.expressCostChargingDas.queryPageMasterOrderDifference(queryDto);
    }

    @Override
    public void generateExpressCostData(LogisticStatisticReqDto reqDto) {
        log.info("\u751f\u6210\u5feb\u9012\u62a5\u8868\u6570\u636e\uff08\u4f1a\u5220\u9664\u65e7\u6570\u636e\uff09\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        String tasksId = StrUtil.blankToDefault((CharSequence)reqDto.getTaskId(), (String)PmsTasksUtils.getTasksId());
        log.info("generateExpressCostData \u672c\u6b21\u4efb\u52a1id\uff1a{}", (Object)tasksId);
        Boolean flag = this.cacheService.setIfAbsent("generateExpressCostChargingData", (Object)true, 3600);
        if (flag.booleanValue()) {
            try {
                this.syncExpressCostData(reqDto);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.cacheService.delCache("generateExpressCostChargingData");
            }
        } else {
            throw new BizException("-1", "\u64cd\u4f5c\u751f\u6210\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void generateStockApportion(DailyDeliveryReportStockApportionDto reqDto) {
        log.info("\u5feb\u9012\u8d39\u7528\u751f\u6210\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u80a1\u4efd\u5206\u644a\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List costDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostDetailDas.filter().eq((Object)"bookkeeping_month", (Object)reqDto.getBookkeepingMonth())).eq((Object)"if_apportion", (Object)1)).list();
        if (CollUtil.isEmpty((Collection)costDetailEos)) {
            log.info("\u5feb\u9012\u8d39\u7528\u65e0\u5339\u914d\u6570\u636e");
            return;
        }
        List apportionDtos = costDetailEos.stream().map(detailEo -> {
            DailyDeliveryReportStockApportionEo apportionDto = new DailyDeliveryReportStockApportionEo();
            apportionDto.setBookkeepingMonth(DateTimeUtils.formatDate(detailEo.getOutboundTime(), "yyyy-MM"));
            apportionDto.setReportId(detailEo.getLinkDailyReportId());
            apportionDto.setFeeId(detailEo.getId());
            apportionDto.setType(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
            apportionDto.setApportionStatus("NOT_APPORTION");
            apportionDto.setApportionTotal(new BigDecimal(detailEo.getPieceNum()));
            apportionDto.setApportionAlready(BigDecimal.ZERO);
            return apportionDto;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(apportionDtos)) {
            this.stockApportionDomain.insertBatch(apportionDtos);
        }
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u5feb\u9012\u8ba1\u8d39\u660e\u7ec6\u8d39\u7528\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ExpressCostChargingEo updateEo = new ExpressCostChargingEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List eos = this.expressCostChargingDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = eos.stream().filter(eo -> eo.getPlacedFlag() == null || eo.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.expressCostChargingDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        log.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillOrg(UpdateBillOrgDto reqDto) {
        int updateNum = this.expressCostChargingDas.updateBillOrg(reqDto);
        int size = reqDto.getIdList().size();
        AssertUtil.isTrue((boolean)Objects.equals(updateNum, size), (String)"\u5df2\u5f52\u6863\u6570\u636e\u4e0d\u80fd\u4fee\u6539");
    }

    @Override
    public List<ExpressCostChargingRespDto> queryListByExpressOrders(List<String> orderNos) {
        if (CollectionUtil.isEmpty(orderNos)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)this.expressCostChargingDas.filter().in((Object)"express_no", orderNos)).list(Integer.valueOf(orderNos.size()));
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)respDtos, ExpressCostChargingRespDto.class);
        return respDtos;
    }

    private List<String> getCarrierCodeList() {
        CsShipmenetEnterpriseQueryDto csShipmenetEnterpriseQueryDto = new CsShipmenetEnterpriseQueryDto();
        csShipmenetEnterpriseQueryDto.setPageNum(Integer.valueOf(1));
        csShipmenetEnterpriseQueryDto.setPageSize(Integer.valueOf(100));
        csShipmenetEnterpriseQueryDto.setShipmentEnterpriseStatus(Long.valueOf(1L));
        csShipmenetEnterpriseQueryDto.setShipmentEnterpriseType(Long.valueOf(2L));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csShipmenetEnterpriseQueryApi.queryByPage(csShipmenetEnterpriseQueryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            return respDtoPageInfo.getList().stream().map(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseCode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

