/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.constant.enums.GiftBalanceStatementTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IExpressCostChargingService;
import com.dtyunxi.tcbj.biz.service.IExpressCostCommonService;
import com.dtyunxi.tcbj.biz.service.IExpressCostDetailService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExpressCostCommonServiceImpl
implements IExpressCostCommonService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostCommonServiceImpl.class);
    @Resource
    private IExpressCostDetailService expressCostDetailService;
    @Resource
    private IExpressCostChargingService expressCostChargingService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u6839\u636e\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u751f\u6210\u5feb\u9012\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        List costTypeList = feeGenerateReqDto.getCostTypeList();
        String startTime = DateUtil.formatDateTime((Date)feeGenerateReqDto.getStartDate());
        String endTime = DateUtil.formatDateTime((Date)feeGenerateReqDto.getEndDate());
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            logger.info("\u5220\u9664\u65e7\u6570\u636e\u5e76\u751f\u6210\u5feb\u9012\u8d39\u539f\u59cb\u660e\u7ec6");
            if (feeGenerateReqDto.getRefreshOriginalDetail().booleanValue()) {
                LogisticStatisticReqDto statisticReqDto = new LogisticStatisticReqDto();
                statisticReqDto.setStartTime(startTime);
                statisticReqDto.setEndTime(endTime);
                statisticReqDto.setCostTypeList(costTypeList);
                statisticReqDto.setWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
                statisticReqDto.setLogisticCodeList(feeGenerateReqDto.getLogisticCompanyCodeList());
                statisticReqDto.setTransportTypeList(feeGenerateReqDto.getTransportTypeList());
                this.expressCostDetailService.syncExpressCostData(statisticReqDto);
            }
            LogisticStatisticReqDto statisticReqDto1 = new LogisticStatisticReqDto();
            statisticReqDto1.setStartTime(startTime);
            statisticReqDto1.setEndTime(endTime);
            statisticReqDto1.setCostTypeList(costTypeList);
            statisticReqDto1.setWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            statisticReqDto1.setLogisticCodeList(feeGenerateReqDto.getLogisticCompanyCodeList());
            statisticReqDto1.setTransportTypeList(feeGenerateReqDto.getTransportTypeList());
            statisticReqDto1.setIfApportion(Integer.valueOf(0));
            this.expressCostChargingService.generateExpressCostData(statisticReqDto1);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
        dealDetailDto.setDealTypeList(Arrays.stream(GiftBalanceStatementTradeTypeEnum.values()).map(GiftBalanceStatementTradeTypeEnum::getStatus).collect(Collectors.toList()));
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        this.dailyDeliveryReportStockApportionService.autoApportion(apportionDto);
        if (CollUtil.isEmpty((Collection)costTypeList) || costTypeList.contains(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType())) {
            LogisticStatisticReqDto statisticReqDto2 = new LogisticStatisticReqDto();
            statisticReqDto2.setStartTime(startTime);
            statisticReqDto2.setEndTime(endTime);
            statisticReqDto2.setCostTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType()}));
            statisticReqDto2.setWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            statisticReqDto2.setLogisticCodeList(feeGenerateReqDto.getLogisticCompanyCodeList());
            statisticReqDto2.setTransportTypeList(feeGenerateReqDto.getTransportTypeList());
            statisticReqDto2.setIfApportion(Integer.valueOf(1));
            this.expressCostChargingService.generateExpressCostData(statisticReqDto2);
        }
    }

    @Override
    public void generateForCostBelongDetail(DailyDeliveryReportCostBelongDetailDto dto) {
        Pair<String, String> datePair = DateTimeUtils.getByMonthStr(dto.getBookkeepingMonth());
        AssertUtil.assertNotNull(datePair, (String)"\u8bb0\u8d26\u6708\u4efd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406");
        LogisticStatisticReqDto statisticReqDto = new LogisticStatisticReqDto();
        statisticReqDto.setStartTime((String)datePair.getKey());
        statisticReqDto.setEndTime((String)datePair.getValue());
        statisticReqDto.setCostTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType()}));
        statisticReqDto.setIfApportion(Integer.valueOf(1));
        this.expressCostChargingService.generateExpressCostData(statisticReqDto);
    }
}

