/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.biz.service.IExpressCostCommonService;
import com.dtyunxi.tcbj.biz.service.IFeeCommonService;
import com.dtyunxi.tcbj.biz.service.ILogisticCommonService;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsuranceCommonService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumChargingService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseCommonService;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FeeCommonServiceImpl
implements IFeeCommonService {
    private static final Logger logger = LoggerFactory.getLogger(FeeCommonServiceImpl.class);
    @Resource
    private ISortingExpenseCommonService sortingExpenseCommonService;
    @Resource
    private IReInsuranceCommonService reInsuranceCommonService;
    @Resource
    private IExpressCostCommonService expressCostCommonService;
    @Resource
    private ILogisticCommonService logisticCommonService;
    @Resource
    private IReInsurancePremiumChargingService reInsurancePremiumChargingService;
    @Resource
    private IReInsuranceBillService reInsuranceBillService;

    @Override
    public void generateInsurance(FeeGenerateReqDto reqDto) {
        logger.info("\u8d39\u7528\u751f\u6210\u670d\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqDto);
        String feeType = reqDto.getFeeType();
        AssertUtil.assertNotBlank((String)feeType, (String)"\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        DailyDeliveryFeeModuleEnum feeModuleEnum = DailyDeliveryFeeModuleEnum.getByCode((String)feeType);
        AssertUtil.assertNotNull((Object)feeModuleEnum, (String)("\u8d39\u7528\u7c7b\u578b\u4e0d\u5b58\u5728:" + feeType));
        logger.info("\u8d39\u7528\u751f\u6210\u670d\u52a1\u6267\u884c\uff0c\u8d39\u7528\u6a21\u5757\uff1a{}", (Object)feeModuleEnum.getDesc());
        switch (feeModuleEnum) {
            case SORTING_FEE: {
                this.sortingExpenseCommonService.generateInsurance(reqDto);
                break;
            }
            case PREMIUM_FEE: {
                this.reInsuranceCommonService.generateInsurance(reqDto);
                break;
            }
            case EXPRESS_DELIVERY: {
                this.expressCostCommonService.generateInsurance(reqDto);
                break;
            }
            case LOGISTICS_FEE: {
                this.logisticCommonService.generateInsurance(reqDto);
                break;
            }
            case PREMIUM_FEE_BILL: {
                ReInsurancePremiumChargingReqDto generateBillReq = new ReInsurancePremiumChargingReqDto();
                generateBillReq.setBookkeepingMonth(reqDto.getBookkeepingMonth());
                this.reInsurancePremiumChargingService.generateInsuranceBill(generateBillReq);
                break;
            }
            default: {
                logger.error("\u8d39\u7528\u7c7b\u578b\u4e0d\u5b58\u5728:" + feeType);
                AssertUtil.isTrue((boolean)false, (String)("\u8d39\u7528\u7c7b\u578b\u4e0d\u5b58\u5728\u5904\u7406\u670d\u52a1:" + feeType));
            }
        }
        logger.info("\u8d39\u7528\u751f\u6210\u670d\u52a1\u6267\u884c\u7ed3\u675f\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqDto);
    }

    @Override
    public void generateForCostBelongDetail(DailyDeliveryReportCostBelongDetailDto dto) {
        logger.info("\u6839\u636e\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u751f\u6210\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtil.assertNotBlank((String)dto.getType(), (String)"\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        switch (DailyDeliveryFeeModuleEnum.getByCode((String)dto.getType())) {
            case SORTING_FEE: {
                this.sortingExpenseCommonService.generateForCostBelongDetail(dto);
                break;
            }
            case PREMIUM_FEE: {
                ReInsurancePremiumChargingReqDto reqDto = new ReInsurancePremiumChargingReqDto();
                reqDto.setBookkeepingMonth(dto.getBookkeepingMonth());
                reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
                reqDto.setBillTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType()}));
                reqDto.setIfDelFormer(true);
                this.reInsurancePremiumChargingService.generateInsurancePremiumCharging(reqDto);
                break;
            }
            case EXPRESS_DELIVERY: {
                this.expressCostCommonService.generateForCostBelongDetail(dto);
                break;
            }
            case LOGISTICS_FEE: {
                break;
            }
            default: {
                logger.error("\u8d39\u7528\u7c7b\u578b\u4e0d\u5b58\u5728:" + dto.getType());
                AssertUtil.isTrue((boolean)false, (String)("\u8d39\u7528\u7c7b\u578b\u4e0d\u5b58\u5728\u5904\u7406\u670d\u52a1:" + dto.getType()));
            }
        }
    }
}

