/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.PCPCustomerDetailEnum;
import com.dtyunxi.tcbj.api.dto.response.AddressRespDto;
import com.dtyunxi.tcbj.api.dto.response.CompanyRespDto;
import com.dtyunxi.tcbj.api.dto.response.ContactRespDto;
import com.dtyunxi.tcbj.api.dto.response.CsCustomerRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrganizationInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomAreaRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerLevelRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerSalesmanRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerStatusRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerTypeRespDto;
import com.dtyunxi.tcbj.api.dto.response.SalesmanRespDto;
import com.dtyunxi.tcbj.biz.dto.PCPCustomerDetailDto;
import com.dtyunxi.tcbj.biz.service.ICustomerAreaService;
import com.dtyunxi.tcbj.biz.service.IPCPCustomerService;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.das.CustomerLevelDas;
import com.dtyunxi.tcbj.dao.das.CustomerTypeDas;
import com.dtyunxi.tcbj.dao.das.RCustomerRegionDas;
import com.dtyunxi.tcbj.dao.das.RCustomerSalesmanDas;
import com.dtyunxi.tcbj.dao.eo.AddressEo;
import com.dtyunxi.tcbj.dao.eo.ContactsInfoEo;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.eo.CustomerLevelEo;
import com.dtyunxi.tcbj.dao.eo.CustomerStatusEo;
import com.dtyunxi.tcbj.dao.eo.CustomerTypeEo;
import com.dtyunxi.tcbj.dao.eo.RCustomerRegionEo;
import com.dtyunxi.tcbj.dao.eo.RCustomerSalesmanEo;
import com.dtyunxi.tcbj.dao.mapper.AddressMapper;
import com.dtyunxi.tcbj.dao.mapper.ContactsInfoMapper;
import com.dtyunxi.tcbj.dao.mapper.CustomerLevelMapper;
import com.dtyunxi.tcbj.dao.mapper.CustomerSalesmanMapper;
import com.dtyunxi.tcbj.dao.mapper.CustomerStatusMapper;
import com.dtyunxi.tcbj.dao.mapper.CustomerTypeMapper;
import com.dtyunxi.tcbj.dao.mapper.OrganizationInfoMapper;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceImpl
implements IPCPCustomerService {
    private static Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private CustomerTypeMapper customerTypeMapper;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private CustomerLevelMapper customerLevelMapper;
    @Resource
    private CustomerStatusMapper customerStatusMapper;
    @Resource
    private CustomerSalesmanMapper customerSalesmanMapper;
    @Resource
    private AddressMapper addressMapper;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Resource
    private ContactsInfoMapper contactsInfoMapper;
    @Resource
    private CsCustomerDas csCustomerDas;
    @Resource
    private OrganizationInfoMapper organizationInfoMapper;

    @Override
    public PageInfo<CsCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List<Object> customerIdList;
        List customerRegionEos;
        ArrayList<SqlFilter> sqlFilters;
        RCustomerRegionEo selectEo;
        List<String> regionCodeList;
        CustomerAreaListReqDto customerAreaListReqDto;
        PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (PCPCustomerSearchReqDto)JSONObject.parseObject((String)filter, PCPCustomerSearchReqDto.class);
        }
        List<Object> idList = new ArrayList();
        if (searchReqDto.getIsFilterDownstreamCustomersByCurrentUser().booleanValue()) {
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            if (!CollectionUtils.isEmpty((Collection)searchReqDto.getIdList())) {
                idList.retainAll(searchReqDto.getIdList());
            }
        } else if (CollUtil.isNotEmpty((Collection)searchReqDto.getIdList())) {
            idList = searchReqDto.getIdList();
        }
        if (!CollectionUtils.isEmpty((Collection)searchReqDto.getRegionIds())) {
            customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setIds(searchReqDto.getRegionIds());
            regionCodeList = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            selectEo = new RCustomerRegionEo();
            sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            if (CollectionUtils.isEmpty((Collection)customerRegionEos)) {
                return new PageInfo();
            }
            customerIdList = Lists.newArrayList();
            customerIdList = customerRegionEos.stream().map(RCustomerRegionEo::getCustomerId).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (CollectionUtils.isEmpty((Collection)idList)) {
                return new PageInfo();
            }
        }
        if (!CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            regionCodeList = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            selectEo = new RCustomerRegionEo();
            sqlFilters = new ArrayList();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            customerIdList = customerRegionEos.stream().map(RCustomerRegionEo::getCustomerId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)customerIdList)) {
                return new PageInfo();
            }
            if (CollUtil.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            List customerIdList2 = eos.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(idList)) {
                idList = customerIdList2;
            } else {
                idList.retainAll(customerIdList2);
            }
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        List idNotInList = searchReqDto.getIdNotInList();
        if (CollUtil.isNotEmpty(idList) && CollUtil.isNotEmpty((Collection)idNotInList)) {
            idList.removeAll(idNotInList);
            if (CollUtil.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdNotInList(null);
        }
        searchReqDto.setIdList(idList);
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        searchReqDto.setType(Integer.valueOf(2));
        PageInfo pageInfo = this.csCustomerDas.queryPageBySearchCon(pageNum, pageSize, searchReqDto);
        logger.info("pageInfo,\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        if (Objects.nonNull(pageInfo) && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List regionCodes = pageInfo.getList().stream().filter(bean -> StringUtils.isNotEmpty((CharSequence)bean.getRegionCodes())).flatMap(bean -> Arrays.stream(bean.getRegionCodes().split(","))).distinct().collect(Collectors.toList());
            CustomerAreaListReqDto customerAreaListReqDto2 = new CustomerAreaListReqDto();
            customerAreaListReqDto2.setCodes(regionCodes);
            Map<String, String> regionNameMap = this.customerAreaService.queryForList(customerAreaListReqDto2).stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (a1, a2) -> a2));
            for (CsCustomerRespDto customerRespDto : pageInfo.getList()) {
                if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
                    customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
                } else {
                    customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
                }
                if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) continue;
                ArrayList<String> regionNameList = new ArrayList<String>();
                for (String code : customerRespDto.getRegionCodes().split(",")) {
                    regionNameList.add(regionNameMap.get(code));
                }
                customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
            }
        }
        return pageInfo;
    }

    private CustomerRespDto queryById(Long id) {
        CsCustomerEo parentCustomer;
        List<CustomerAreaRespDto> customerAreaRespDtos;
        CsCustomerEo customerEo = (CsCustomerEo)this.csCustomerDas.selectByPrimaryKey(id);
        Assert.notNull((Object)customerEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        if (customerEo.getParentCustomerId() != null) {
            CsCustomerEo customerEo1 = (CsCustomerEo)this.csCustomerDas.selectByPrimaryKey(customerEo.getParentCustomerId());
            customerEo1 = customerEo1 == null ? new CsCustomerEo() : customerEo1;
            customerRespDto.setParentCustomerName(customerEo1.getName());
        }
        if (CollectionUtils.isNotEmpty(customerAreaRespDtos = this.customerAreaService.queryAreaByCustomerId(customerEo.getId()))) {
            customerRespDto.setRegionNames(customerAreaRespDtos.stream().map(CustomerAreaRespDto::getName).collect(Collectors.joining(",")));
        }
        if (Objects.nonNull(customerEo.getParentCustomerId()) && Objects.nonNull(parentCustomer = (CsCustomerEo)this.csCustomerDas.selectByPrimaryKey(customerEo.getParentCustomerId()))) {
            customerRespDto.setParentCustomerId(parentCustomer.getId());
            customerRespDto.setParentCustomerName(parentCustomer.getName());
        }
        return customerRespDto;
    }

    @Override
    public PCPCustomerRespDto queryPCPCustomerDetailById(Long id) {
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5ba2\u6237\u67e5\u8be2\u63a5\u53e3\u53c2\u6570:{}", (Object)id);
        CustomerRespDto customerRespDto = this.queryById(id);
        CsCustomerRespDto dto = new CsCustomerRespDto();
        BeanUtils.copyProperties((Object)customerRespDto, (Object)dto);
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5ba2\u6237\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)dto));
        if (Objects.isNull(dto.getId())) {
            return null;
        }
        PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
        searchReqDto.setOption(PCPCustomerDetailEnum.allEnum.stream().map(PCPCustomerDetailEnum::getCode).collect(Collectors.toList()));
        Long orgInfoId = dto.getOrgInfoId();
        PCPCustomerDetailDto pcpCustomerDetailDto = this.queryPageParams(searchReqDto, Arrays.asList(orgInfoId), Arrays.asList(id));
        pcpCustomerDetailDto.setCsCustomerRespDto(dto);
        PCPCustomerRespDto pcpCustomerRespDto = this.PCPCustomerDetail(pcpCustomerDetailDto);
        return pcpCustomerRespDto;
    }

    @Override
    public PCPCustomerRespDto queryPCPCustomerDetailByCode(String code) {
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5ba2\u6237\u67e5\u8be2\u63a5\u53e3\u53c2\u6570:{}", (Object)code);
        CsCustomerEo record = new CsCustomerEo();
        record.setCode(code);
        CsCustomerEo customerEo = (CsCustomerEo)this.csCustomerDas.selectOne((BaseEo)record);
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5ba2\u6237\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)customerEo));
        if (Objects.isNull(customerEo)) {
            return null;
        }
        CsCustomerRespDto dto = new CsCustomerRespDto();
        BeanUtils.copyProperties((Object)customerEo, (Object)dto);
        PCPCustomerDetailDto pcpCustomerDetailDto = new PCPCustomerDetailDto();
        pcpCustomerDetailDto.setCsCustomerRespDto(dto);
        PCPCustomerRespDto pcpCustomerRespDto = this.PCPCustomerDetail(pcpCustomerDetailDto);
        return pcpCustomerRespDto;
    }

    @Override
    public List<PCPCustomerRespDto> queryPCPCustomerDetail(PCPCustomerSearchReqDto searchReqDto) {
        searchReqDto.setPageNum(Integer.valueOf(1));
        searchReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<PCPCustomerRespDto> pageInfo = this.queryPCPCustomerDetailByPage(searchReqDto);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            return pageInfo.getList();
        }
        return Lists.newArrayList();
    }

    @Override
    public PageInfo<PCPCustomerRespDto> queryPCPCustomerDetailByPage(PCPCustomerSearchReqDto searchReqDto) {
        PageInfo<CsCustomerRespDto> customerRespDtoPageInfo = this.queryByPage(JSON.toJSONString((Object)searchReqDto), searchReqDto.getPageNum(), searchReqDto.getPageSize());
        logger.info("customerRespDtoPageInfo,\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString(customerRespDtoPageInfo));
        if (CollectionUtils.isEmpty((Collection)customerRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        List customerRespDtos = customerRespDtoPageInfo.getList();
        List<Long> orgInfoIds = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        List<Long> ids = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        PCPCustomerDetailDto pcpCustomerDetailDto = this.queryPageParams(searchReqDto, orgInfoIds, ids);
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            return new PageInfo();
        }
        List pcpCustomerRespDtos = customerRespDtos.stream().map(customerRespDto -> {
            pcpCustomerDetailDto.setCsCustomerRespDto((CsCustomerRespDto)customerRespDto);
            return this.PCPCustomerDetail(pcpCustomerDetailDto);
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, customerRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList(pcpCustomerRespDtos);
        logger.info("pageInfo,\u67e5\u8be2\u7ed3\u679c\u51fa\u6765\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        return pageInfo;
    }

    @Override
    public List<PCPCustomerRespDto> queryPCPCustomerDetailByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.csCustomerDas.filter().in((Object)"code", codes)).eq((Object)"dr", (Object)0)).list(Integer.valueOf(codes.size()));
        ArrayList respDtos = Lists.newArrayList();
        for (CsCustomerEo eo : eos) {
            PCPCustomerRespDto pcpCustomerRespDto = new PCPCustomerRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)pcpCustomerRespDto);
            pcpCustomerRespDto.setId(eo.getId());
            pcpCustomerRespDto.setCustomerCode(eo.getCode());
            pcpCustomerRespDto.setCustomerName(eo.getName());
            respDtos.add(pcpCustomerRespDto);
        }
        return respDtos;
    }

    private PCPCustomerDetailDto queryPageParams(PCPCustomerSearchReqDto searchReqDto, List<Long> orgInfoIds, List<Long> ids) {
        List pcpCustomerDetailEnums = PCPCustomerDetailEnum.getValueByCode((List)searchReqDto.getOption());
        PCPCustomerDetailDto pcpCustomerDetailDto = new PCPCustomerDetailDto();
        if (CollectionUtils.isEmpty((Collection)pcpCustomerDetailEnums)) {
            return pcpCustomerDetailDto;
        }
        for (PCPCustomerDetailEnum detailEnum : pcpCustomerDetailEnums) {
            List statusList = this.customerStatusMapper.selectList((Wrapper)new QueryWrapper());
            Map<Long, CustomerStatusEo> statusEoMap = statusList.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
            pcpCustomerDetailDto.setStatusEoMap(statusEoMap);
        }
        return pcpCustomerDetailDto;
    }

    private PCPCustomerRespDto PCPCustomerDetail(PCPCustomerDetailDto pcpCustomerDetailDto) {
        OrganizationInfoRespDto orgInfo;
        CsCustomerRespDto customerRespDto = pcpCustomerDetailDto.getCsCustomerRespDto();
        Map<Long, CustomerStatusEo> statusEoMap = pcpCustomerDetailDto.getStatusEoMap();
        Map<Long, CustomerTypeEo> typeEoMap = pcpCustomerDetailDto.getTypeEoMap();
        Map<Long, CustomerLevelEo> levelEoMap = pcpCustomerDetailDto.getLevelEoMap();
        Map<Long, List<AddressEo>> addressMap = pcpCustomerDetailDto.getAddressMap();
        Map<Long, List<PCPCustomerSalesmanRespDto>> salesmanMap = pcpCustomerDetailDto.getSalesmanMap();
        Map<Long, List<ContactsInfoEo>> contactsMap = pcpCustomerDetailDto.getContactsMap();
        Map<Long, List<OrganizationInfoRespDto>> orgInfoMap = pcpCustomerDetailDto.getOrgInfoMap();
        Long orgInfoId = customerRespDto.getOrgInfoId();
        logger.info("\u5ba2\u6237\u8be6\u60c5\u5904\u7406\u53c2\u6570:{},{},{}", new Object[]{JSON.toJSONString((Object)customerRespDto), JSON.toJSONString(statusEoMap), JSON.toJSONString(typeEoMap), JSON.toJSONString(levelEoMap)});
        PCPCustomerRespDto pcpCustomerRespDto = new PCPCustomerRespDto();
        pcpCustomerRespDto.setId(customerRespDto.getId());
        pcpCustomerRespDto.setCustomerName(customerRespDto.getName());
        pcpCustomerRespDto.setCustomerCode(customerRespDto.getCode());
        pcpCustomerRespDto.setCustomerShortName(customerRespDto.getName());
        pcpCustomerRespDto.setParentCustomerId(ParamConverter.convertToString((Object)customerRespDto.getParentCustomerId()));
        pcpCustomerRespDto.setParentCustomerName(customerRespDto.getParentCustomerName());
        pcpCustomerRespDto.setFinancialPrint(customerRespDto.getFinancialPrint());
        pcpCustomerRespDto.setReportsPrint(customerRespDto.getReportsPrint());
        pcpCustomerRespDto.setExtraMaterial(customerRespDto.getExtraMaterial());
        pcpCustomerRespDto.setShipmentEnterprise(customerRespDto.getShipmentEnterprise());
        pcpCustomerRespDto.setInformationRemarks(customerRespDto.getInformationRemarks());
        pcpCustomerRespDto.setOrgName(customerRespDto.getOrgName());
        pcpCustomerRespDto.setThirdParentPartyId(customerRespDto.getThirdParentPartyId());
        pcpCustomerRespDto.setUpdateTime(customerRespDto.getUpdateTime());
        pcpCustomerRespDto.setUpdatePerson(customerRespDto.getUpdatePerson());
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionNames())) {
            PCPCustomAreaRespDto customerCustomArea = new PCPCustomAreaRespDto();
            customerCustomArea.setName(customerRespDto.getRegionNames());
            pcpCustomerRespDto.setCustomerCustomArea(customerCustomArea);
        }
        pcpCustomerRespDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u5730\u5740\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}", (Object)customerRespDto);
        if (Objects.nonNull(customerRespDto)) {
            AddressRespDto customerArea = new AddressRespDto();
            customerArea.setProvince(customerRespDto.getProvince());
            customerArea.setProvinceCode(customerRespDto.getProvinceCode());
            customerArea.setCity(customerRespDto.getCity());
            customerArea.setCityCode(customerRespDto.getCityCode());
            customerArea.setDistrict(customerRespDto.getCounty());
            customerArea.setDistrictCode(customerRespDto.getCountyCode());
            customerArea.setDetailAddress(customerRespDto.getAddress());
            pcpCustomerRespDto.setCustomerArea(customerArea);
        }
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u4e1a\u52a1\u5458\u67e5\u8be2\u63a5\u53e3\u53c2\u6570:{}", (Object)customerRespDto.getId());
        List<PCPCustomerSalesmanRespDto> customerSalesmanEos = salesmanMap.get(customerRespDto.getId());
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u4e1a\u52a1\u5458\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSON.toJSONString(customerSalesmanEos));
        if (CollectionUtils.isNotEmpty(customerSalesmanEos)) {
            List salesmans = customerSalesmanEos.stream().map(customerSalesmanEo -> {
                SalesmanRespDto salesmanVO = new SalesmanRespDto();
                CubeBeanUtils.copyProperties((Object)salesmanVO, (Object)customerSalesmanEo, (String[])new String[0]);
                return salesmanVO;
            }).collect(Collectors.toList());
            pcpCustomerRespDto.setSalesmans(salesmans);
        }
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u516c\u53f8\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u53c2\u6570:{}");
        List<OrganizationInfoRespDto> orgInfos = orgInfoMap.get(customerRespDto.getOrgInfoId());
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u516c\u53f8\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}");
        if (CollectionUtils.isNotEmpty(orgInfos) && Objects.nonNull(orgInfo = (OrganizationInfoRespDto)orgInfos.stream().findFirst().orElse(null))) {
            CompanyRespDto customerCompanyInfo = new CompanyRespDto();
            customerCompanyInfo.setCreditCode(orgInfo.getCreditCode());
            customerCompanyInfo.setOrgName(orgInfo.getOrgName());
            customerCompanyInfo.setBusinessLicenseType(ParamConverter.convertToString((Object)orgInfo.getBusinessLicenseType()));
            if (Objects.nonNull(orgInfo.getTermBeginTime())) {
                customerCompanyInfo.setTermBeginTime(DateUtil.getDateFormat((Date)orgInfo.getTermBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (Objects.nonNull(orgInfo.getTermEndTime())) {
                customerCompanyInfo.setTermEndTime(DateUtil.getDateFormat((Date)orgInfo.getTermEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            customerCompanyInfo.setLegalName(orgInfo.getLegalName());
            customerCompanyInfo.setLegalCardType(ParamConverter.convertToString((Object)orgInfo.getLegalCardType()));
            customerCompanyInfo.setLegalCardNum(orgInfo.getLegalCardNum());
            if (Objects.nonNull(orgInfo.getCardEffectBeginTime())) {
                customerCompanyInfo.setCardEffectBeginTime(DateUtil.getDateFormat((Date)orgInfo.getCardEffectBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (Objects.nonNull(orgInfo.getCardEffectEndTime())) {
                customerCompanyInfo.setCardEffectEndTime(DateUtil.getDateFormat((Date)orgInfo.getCardEffectEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            customerCompanyInfo.setIdCardFront(orgInfo.getIdCardFront());
            customerCompanyInfo.setIdCardBack(orgInfo.getIdCardBack());
            customerCompanyInfo.setBussinessLicenseUrl(orgInfo.getBussinessLicenseUrl());
            customerCompanyInfo.setCompanyId(ParamConverter.convertToString((Object)orgInfo.getId()));
            logger.info("\u5ba2\u6237\u8be6\u60c5-\u516c\u53f8\u4fe1\u606f-\u6240\u5c5e\u5730\u533a\u8be6\u7ec6\u5730\u5740\u63a5\u53e3\u53c2\u6570:{}", (Object)customerRespDto);
            List<AddressEo> addressEos = addressMap.get(orgInfoId);
            logger.info("\u5ba2\u6237\u8be6\u60c5-\u516c\u53f8\u4fe1\u606f-\u6240\u5c5e\u5730\u533a\u8be6\u7ec6\u5730\u5740\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSON.toJSONString(addressEos));
            if (CollectionUtils.isNotEmpty(addressEos)) {
                AddressEo addressRespDto = addressEos.stream().findFirst().orElse(null);
                AddressRespDto customerArea = new AddressRespDto();
                customerArea.setId(addressRespDto.getId());
                customerArea.setProvince(addressRespDto.getProvince());
                customerArea.setProvinceCode(addressRespDto.getProvinceCode());
                customerArea.setCity(addressRespDto.getCity());
                customerArea.setCityCode(addressRespDto.getCityCode());
                customerArea.setDistrict(addressRespDto.getDistrict());
                customerArea.setDistrictCode(addressRespDto.getDistrictCode());
                customerArea.setStreetCode(addressRespDto.getStreetCode());
                customerArea.setDetailAddress(addressRespDto.getDetailAddr());
                customerCompanyInfo.setArea(customerArea);
            }
            pcpCustomerRespDto.setCustomerCompanyInfo(customerCompanyInfo);
        }
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u8054\u7cfb\u4eba\u67e5\u8be2\u63a5\u53e3\u53c2\u6570:{}", (Object)orgInfoId);
        List<ContactsInfoEo> contactsInfoEos = contactsMap.get(orgInfoId);
        logger.info("\u5ba2\u6237\u8be6\u60c5-\u8054\u7cfb\u4eba\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c:{}", (Object)JSON.toJSONString(contactsInfoEos));
        if (CollectionUtils.isNotEmpty(contactsInfoEos)) {
            List contactsInfoList = contactsInfoEos.stream().map(contactsInfo -> {
                ContactRespDto contactVO = new ContactRespDto();
                contactVO.setContactName(contactsInfo.getLinkName());
                contactVO.setContactPosition(contactsInfo.getPosition());
                contactVO.setContactPhone(contactsInfo.getPhoneNum());
                contactVO.setContactTel(contactsInfo.getTel());
                contactVO.setContactEmail(contactsInfo.getEmail());
                contactVO.setContactId(ParamConverter.convertToString((Object)contactsInfo.getId()));
                contactVO.setContactReserveMobile(contactsInfo.getReserveMobile());
                contactVO.setIsDefault(ParamConverter.convertToString((Object)contactsInfo.getStatus()));
                return contactVO;
            }).collect(Collectors.toList());
            pcpCustomerRespDto.setContactsInfoList(contactsInfoList);
        }
        if (Objects.nonNull(customerRespDto.getStatusId()) && Objects.nonNull(statusEoMap.get(customerRespDto.getStatusId()))) {
            CustomerStatusEo status = statusEoMap.get(customerRespDto.getStatusId());
            PCPCustomerStatusRespDto customerStatus = new PCPCustomerStatusRespDto();
            CubeBeanUtils.copyProperties((Object)customerStatus, (Object)status, (String[])new String[0]);
            pcpCustomerRespDto.setCustomerStatus(customerStatus);
        }
        if (Objects.nonNull(customerRespDto.getCustomerTypeId()) && Objects.nonNull(typeEoMap.get(customerRespDto.getCustomerTypeId()))) {
            CustomerTypeEo customerType = typeEoMap.get(customerRespDto.getCustomerTypeId());
            PCPCustomerTypeRespDto customerTypeVo = new PCPCustomerTypeRespDto();
            CubeBeanUtils.copyProperties((Object)customerTypeVo, (Object)customerType, (String[])new String[0]);
            pcpCustomerRespDto.setCustomerType(customerTypeVo);
        }
        if (Objects.nonNull(customerRespDto.getLevelId()) && Objects.nonNull(levelEoMap.get(customerRespDto.getLevelId()))) {
            CustomerLevelEo customerLevelRespDto = levelEoMap.get(customerRespDto.getLevelId());
            PCPCustomerLevelRespDto customerLevel = new PCPCustomerLevelRespDto();
            CubeBeanUtils.copyProperties((Object)customerLevel, (Object)customerLevelRespDto, (String[])new String[0]);
            pcpCustomerRespDto.setCustomerLevel(customerLevel);
        }
        return pcpCustomerRespDto;
    }
}

