/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.finance.api.dto.response.ApportionmentConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrganizationRespDto;
import com.dtyunxi.finance.api.query.IApportionmentConfigQueryApi;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.constant.ReInsuranceBillTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceFlagEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticsStatusEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumExceptionDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReportUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetSaleOrderListPageEsParams;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.SaleOrderRespEsVo;
import com.dtyunxi.tcbj.api.query.es.TradeEsReportQueryApi;
import com.dtyunxi.tcbj.biz.enums.ExpressBusinessTypeEnum;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryFeeFilterExtConfigService;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.dtyunxi.tcbj.dao.Constants.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderAddressDas;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderDas;
import com.dtyunxi.tcbj.dao.das.FeeAttributionConfigDas;
import com.dtyunxi.tcbj.dao.das.FinInsuranceSettingsDas;
import com.dtyunxi.tcbj.dao.das.FinLogisticsSettingsDas;
import com.dtyunxi.tcbj.dao.das.ReInsuranceBillDas;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.FinInsuranceSettingsEo;
import com.dtyunxi.tcbj.dao.eo.FinLogisticsSettingsEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsuranceBillEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.mapper.DeliveryResultOrderMapper;
import com.dtyunxi.tcbj.dao.mapper.ReInsurancePremiumMapper;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderMapper;
import com.dtyunxi.tcbj.dao.vo.CostBelongVo;
import com.dtyunxi.tcbj.dao.vo.InsuranceCustomerInfoVo;
import com.dtyunxi.tcbj.dao.vo.InsuranceFeeVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dao.das.IDailyDeliveryReportDas;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailCombineDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryFeeFilterConfigService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReInsurancePremiumServiceImpl
implements IReInsurancePremiumService {
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumServiceImpl.class);
    private static final String INSURANCE_REPORT_LOCK_KEY = "INSURANCE_REPORT_LOCK_KEY";
    private static final String INSURANCE_UPDATE_LOCK_KEY = "INSURANCE_UPDATE_LOCK_KEY";
    private static final String BILL_UPDATE_LOCK_KEY = "BILL_UPDATE_LOCK_KEY";
    @Resource
    private ReInsurancePremiumDas reInsurancePremiumDas;
    @Resource
    private ReInsuranceBillDas reInsuranceBillDas;
    @Resource
    private IReInsuranceBillService billService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ReInsurancePremiumMapper insurancePremiumMapper;
    @Resource
    private FinInsuranceSettingsDas finInsuranceSettingsDas;
    @Resource
    private FinLogisticsSettingsDas finLogisticsSettingsDas;
    @Resource
    private IDailyDeliveryReportDas iDailyDeliveryReportDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private IDailyDeliveryFeeFilterConfigService feeFilterService;
    @Resource
    private IDailyDeliveryFeeFilterExtConfigService dailyDeliveryFeeFilterExtConfigService;
    @Resource
    private ConsignmentOrderDas consignmentOrderDas;
    @Resource
    private ConsignmentOrderAddressDas consignmentOrderAddressDas;
    @Resource(name="tradeEsReportQueryApiImpl")
    private TradeEsReportQueryApi tradeEsReportQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi icsShipmenetEnterpriseQueryApi;
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Autowired
    private SaleOrderMapper saleOrderMapper;
    @Resource
    private FeeAttributionConfigDas feeAttributionConfigDas;
    @Autowired
    private DeliveryResultOrderMapper deliveryResultOrderMapper;
    @Resource
    private IApportionmentConfigQueryApi apportionmentConfigQueryApi;

    @Override
    public Long addReInsurancePremiumCharging(ReInsurancePremiumReqDto addReqDto) {
        ReInsurancePremiumEo reInsurancePremiumEo = new ReInsurancePremiumEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reInsurancePremiumEo);
        this.reInsurancePremiumDas.insert((BaseEo)reInsurancePremiumEo);
        return reInsurancePremiumEo.getId();
    }

    @Override
    public void modifyReInsurancePremium(ReInsurancePremiumReqDto modifyReqDto) {
        ReInsurancePremiumEo reInsurancePremiumEo = new ReInsurancePremiumEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reInsurancePremiumEo);
        this.reInsurancePremiumDas.updateSelective((BaseEo)reInsurancePremiumEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReInsurancePremium(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.reInsurancePremiumDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ReInsurancePremiumRespDto queryById(Long id) {
        ReInsurancePremiumEo reInsurancePremiumEo = (ReInsurancePremiumEo)this.reInsurancePremiumDas.selectByPrimaryKey(id);
        ReInsurancePremiumRespDto reInsurancePremiumRespDto = new ReInsurancePremiumRespDto();
        DtoHelper.eo2Dto((BaseEo)reInsurancePremiumEo, (BaseVo)reInsurancePremiumRespDto);
        return reInsurancePremiumRespDto;
    }

    @Override
    public PageInfo<ReInsurancePremiumRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List eos;
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)filter);
        ReInsurancePremiumReqDto reInsurancePremiumReqDto = (ReInsurancePremiumReqDto)JSON.parseObject((String)filter, ReInsurancePremiumReqDto.class);
        this.setDate(reInsurancePremiumReqDto);
        reInsurancePremiumReqDto.setPageNum(pageNum);
        reInsurancePremiumReqDto.setPageSize(pageSize);
        PageInfo dtoPageInfo = this.reInsurancePremiumDas.queryByPage(reInsurancePremiumReqDto);
        List relevanceNos = dtoPageInfo.getList().stream().map(ReInsurancePremiumRespDto::getRelevanceNo).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(relevanceNos) && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", relevanceNos)).isNotNull((Object)"pre_order_no")).list()))) {
            Map<String, String> stringMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getPreOrderNo, (k1, k2) -> k1));
            map.putAll(stringMap);
        }
        List dtoList = dtoPageInfo.getList().stream().map(eo -> {
            eo.setBillType(ReInsuranceBillTypeEnum.getNameByCode((String)eo.getBillType()));
            eo.setFlagName(InsuranceFlagEnum.getValueByCode((Integer)eo.getFlag()));
            eo.setShippingTypeName(eo.getShippingType());
            if (StringUtils.isNotBlank((CharSequence)eo.getBusinessType())) {
                eo.setBusinessTypeName(eo.getBusinessType());
                if (StringUtils.isNotBlank((CharSequence)ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()))) {
                    eo.setBusinessTypeName(ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getRelevanceNo()) && StringUtils.isBlank((CharSequence)eo.getExternalOrderNo()) && map.containsKey(eo.getRelevanceNo())) {
                eo.setExternalOrderNo((String)map.get(eo.getRelevanceNo()));
                Object[] externalOrderArray = eo.getExternalOrderNo().split(",");
                eo.setExternalOrderNo((String)Lists.newArrayList((Object[])externalOrderArray).stream().sorted().findFirst().get());
            }
            return eo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ReInsuranceBillCountDto queryFlagCount(ReInsurancePremiumReqDto reqDto) {
        return this.reInsurancePremiumDas.queryFlagCount(reqDto);
    }

    @Override
    public ReInsurancePremiumRespDto queryInsureTotalPriceCount(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u6295\u4fdd\u91d1\u989d\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.reInsurancePremiumDas.queryInsureTotalPriceCount(reqDto);
    }

    private void setDate(ReInsurancePremiumReqDto reInsurancePremiumReqDto) {
        try {
            if (ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeEnd())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String begin = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeBegin()) + " 00:00:00";
                String end = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeEnd()) + " 23:59:59";
                reInsurancePremiumReqDto.setInOutTimeBegin(simpleDateFormat.parse(begin));
                reInsurancePremiumReqDto.setInOutTimeEnd(simpleDateFormat.parse(end));
            }
        }
        catch (Exception e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateInsuranceReportNew(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210generateInsuranceReportNew\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        boolean lockFlag = this.cacheService.setIfAbsent(INSURANCE_REPORT_LOCK_KEY, (Object)1, 600);
        if (!lockFlag) {
            throw new BizException("-1", "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u6570\u636e\u751f\u6210\u670d\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7b49\u5f85\u751f\u6210\u5b8c\u540e\u518d\u6267\u884c");
        }
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        ApportionmentConfigExtRespDto apportionmentConfigExtRespDto = (ApportionmentConfigExtRespDto)RestResponseHelper.extractData((RestResponse)this.apportionmentConfigQueryApi.queryByCostModuleCode(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode()));
        HashMap insureMaps = new HashMap();
        HashMap<String, InsuranceCustomerInfoVo> physicsWareMap = new HashMap<String, InsuranceCustomerInfoVo>();
        HashMap<String, String> startPlaceMap = new HashMap<String, String>(8);
        List<DailyDeliveryFeeFilterExtConfigRespDto> filter = this.dailyDeliveryFeeFilterExtConfigService.queryModuleCode(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        this.logger.info("\u4fdd\u8d39\u5254\u9664\u8d39\u7528\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString(filter));
        CsShipmenetEnterpriseQueryDto enterpriseQueryDto = new CsShipmenetEnterpriseQueryDto();
        enterpriseQueryDto.setPageNum(Integer.valueOf(1));
        enterpriseQueryDto.setPageSize(Integer.valueOf(1000));
        PageInfo enterpriseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.icsShipmenetEnterpriseQueryApi.queryByPage(enterpriseQueryDto));
        Map shipmenetEnterpriseRespDtoMap = Optional.ofNullable(enterpriseRespDtoPageInfo.getList()).map(m -> enterpriseRespDtoPageInfo.getList().stream().collect(Collectors.toMap(o -> o.getShipmentEnterpriseCode() + "-" + o.getCustomerCode(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        int pageSize = 5000;
        DailyDeliveryReportDto reportQueryDto = new DailyDeliveryReportDto();
        reportQueryDto.setPageNum(Integer.valueOf(1));
        reportQueryDto.setPageSize(Integer.valueOf(pageSize));
        reportQueryDto.setOrderShippingTimeStart(reqDto.getInOutTimeBegin());
        reportQueryDto.setOrderShippingTimeEnd(reqDto.getInOutTimeEnd());
        this.logger.info("\u67e5\u8be2\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\u751f\u6210\u4fdd\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reportQueryDto));
        PageInfo reportDtoPageInfo = this.reInsurancePremiumDas.getDailyDeliveryReportEoListByDate(reportQueryDto);
        while (ObjectUtils.isNotEmpty((Object)reportDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)reportDtoPageInfo.getList())) {
            this.logger.info("\u904d\u5386\u6570\u636e\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)reportDtoPageInfo.getList()));
            ArrayList<ReInsuranceBillEo> billEoList = new ArrayList<ReInsuranceBillEo>();
            List ids = reportDtoPageInfo.getList().stream().map(DailyDeliveryReportDto::getId).collect(Collectors.toList());
            List dailyDeliveryReportDetailList = this.reInsurancePremiumDas.getDailyDeliveryReportDetail(ids);
            Map dailyDeliveryReportDetailMap = Optional.ofNullable(dailyDeliveryReportDetailList).map(m -> m.stream().collect(Collectors.groupingBy(DailyDeliveryReportDetailCombineDto::getDailyDeliveryReportId))).orElse(new HashMap());
            Map yyjSaleOrderMap = new HashMap();
            ArrayList yyjBus = Lists.newArrayList((Object[])new String[]{"nutrition_integral", "activity_order"});
            List yyjOrders = reportDtoPageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getRelevanceNo()) && StringUtils.isNotBlank((CharSequence)f.getBusinessType()) && yyjBus.contains(f.getBusinessType())).map(DailyDeliveryReportDto::getRelevanceNo).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(yyjOrders)) {
                GetSaleOrderListPageEsParams param = new GetSaleOrderListPageEsParams();
                param.setPageNum(Integer.valueOf(1));
                param.setPageSize(Integer.valueOf(5000));
                param.setOrderNoList(yyjOrders);
                param.setOrderTypeList((List)yyjBus);
                PageInfo yyjSaleOrderPageInfo = (PageInfo)this.tradeEsReportQueryApi.querySaleOrderListPage(param).getData();
                yyjSaleOrderMap = Optional.ofNullable(yyjSaleOrderPageInfo.getList()).map(m -> yyjSaleOrderPageInfo.getList().stream().collect(Collectors.toMap(SaleOrderRespEsVo::getSaleOrderNo, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            }
            Map saleOrderMap = new HashMap();
            ArrayList otherBus = Lists.newArrayList((Object[])new String[]{"nutrition_integral", "activity_order", "maiyou_allot"});
            List saleOrders = reportDtoPageInfo.getList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getRelevanceNo()) && StringUtils.isNotBlank((CharSequence)f.getBusinessType()) && !otherBus.contains(f.getBusinessType())).map(DailyDeliveryReportDto::getRelevanceNo).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(yyjOrders)) {
                GetSaleOrderListPageEsParams param = new GetSaleOrderListPageEsParams();
                param.setPageNum(Integer.valueOf(1));
                param.setPageSize(Integer.valueOf(5000));
                param.setOrderNoList(saleOrders);
                param.setExcludeOrderTypeList((List)otherBus);
                PageInfo saleOrderPageInfo = (PageInfo)this.tradeEsReportQueryApi.querySaleOrderListPage(param).getData();
                saleOrderMap = Optional.ofNullable(saleOrderPageInfo.getList()).map(m -> saleOrderPageInfo.getList().stream().collect(Collectors.toMap(SaleOrderRespEsVo::getSaleOrderNo, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            }
            Map insuranceItemVoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportDetailList)) {
                List longCodes = dailyDeliveryReportDetailList.stream().map(DailyDeliveryReportDetailCombineDto::getLongCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                List insuranceItemVoList = this.reInsurancePremiumDas.getPcpItemByLongCode(longCodes);
                insuranceItemVoMap = Optional.ofNullable(insuranceItemVoList).map(m -> m.stream().collect(Collectors.toMap(InsuranceItemVo::getLongCode, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            }
            for (DailyDeliveryReportDto dailyDto : reportDtoPageInfo.getList()) {
                this.logger.info("generateInsuranceReport\u5904\u7406\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dailyDto));
                ReInsuranceBillEo insuranceBillEo = new ReInsuranceBillEo();
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)dailyDto, (String[])new String[0]);
                insuranceBillEo.setLinkDailyReportId(dailyDto.getId());
                insuranceBillEo.setExternalOrderNo(dailyDto.getEasOrderNo());
                insuranceBillEo.setWmsConsignmentNo(dailyDto.getConsignmentNo());
                insuranceBillEo.setWmsMergeDocumentNo(dailyDto.getJoinMergeDocumentNo());
                insuranceBillEo.setCustomerName(dailyDto.getReceivingCustomer());
                insuranceBillEo.setCustomerAddress(dailyDto.getReceivingAddress());
                insuranceBillEo.setInOutTime(dailyDto.getOrderShippingTime());
                insuranceBillEo.setDocumentNo(dailyDto.getOutResultNo());
                insuranceBillEo.setShippingCompany(dailyDto.getShippingCompanyName());
                insuranceBillEo.setShippingCompanyCode(dailyDto.getShippingCompany());
                insuranceBillEo.setShippingType(dailyDto.getTransportStyle());
                insuranceBillEo.setStartPlace(dailyDto.getStartCity());
                insuranceBillEo.setEndPlace(dailyDto.getReceivingAddressCity());
                insuranceBillEo.setEndPlaceCode(dailyDto.getReceivingAddressCityCode());
                insuranceBillEo.setEndProvince(dailyDto.getReceivingAddressProvince());
                insuranceBillEo.setEndProvinceCode(dailyDto.getReceivingAddressProvinceCode());
                insuranceBillEo.setOutLogicWarehouseCode(dailyDto.getLogicWarehouseCode());
                insuranceBillEo.setOutLogicWarehouseName(dailyDto.getLogicWarehouse());
                insuranceBillEo.setInLogicWarehouseCode(dailyDto.getInLogicWarehouseCode());
                insuranceBillEo.setInLogicWarehouseName(dailyDto.getInLogicWarehouse());
                insuranceBillEo.setBillOrgName(StringUtils.isNotBlank((CharSequence)dailyDto.getBillOrgName()) ? dailyDto.getBillOrgName() : dailyDto.getInventoryOrganizationName());
                insuranceBillEo.setBillOrgCode(StringUtils.isNotBlank((CharSequence)dailyDto.getBillOrgCode()) ? dailyDto.getBillOrgCode() : dailyDto.getInventoryOrganizationCode());
                insuranceBillEo.setLinkDailyReportId(dailyDto.getId());
                insuranceBillEo.setMuchFlagDailyReportId(Objects.equals(1, dailyDto.getMuchDeliveryFlag()) ? dailyDto.getId() : null);
                insuranceBillEo.setOrderRemark(dailyDto.getRemark());
                insuranceBillEo.setPlacedFlag(Integer.valueOf(0));
                insuranceBillEo.setTransportNo(dailyDto.getTransportNo());
                insuranceBillEo.setReceivingPerson(dailyDto.getReceivingPerson());
                insuranceBillEo.setCostBelongOrgId(insuranceBillEo.getOutOrganizationId());
                insuranceBillEo.setCostBelongOrgName(insuranceBillEo.getOutOrganizationName());
                this.logger.info("\u751f\u6210\u4fdd\u8d39\u660e\u7ec61\uff1a{}", (Object)JSON.toJSONString((Object)insuranceBillEo));
                insuranceBillEo.setId(null);
                ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
                List dailydetailEo = (List)dailyDeliveryReportDetailMap.get(dailyDto.getId());
                if (CollectionUtil.isEmpty((Collection)dailydetailEo)) {
                    this.logger.info("\u65e0\u660e\u7ec6\u4fe1\u606f\uff0c\u4e0d\u751f\u6210\u8ba1\u8d39");
                    continue;
                }
                StringBuilder billReason = new StringBuilder();
                BigDecimal quantity = BigDecimal.ZERO;
                BigDecimal insureTotalPrice = BigDecimal.ZERO;
                try {
                    int billQuotaVerify;
                    Object str;
                    String orderShippingTime;
                    List insureFeeList;
                    SaleOrderRespEsVo saleOrder;
                    if (null == insuranceBillEo.getRemark() && null == insuranceBillEo.getCustomerName() && null == insuranceBillEo.getCustomerAddress() && null == insuranceBillEo.getStartPlace() && null == insuranceBillEo.getEndPlace() && null == insuranceBillEo.getExternalOrderNo()) {
                        this.getCommonOtherData(insuranceBillEo, physicsWareMap, startPlaceMap);
                    }
                    if (null != dailyDto.getLogicWarehouse()) {
                        insuranceBillEo.setOutLogicWarehouseName(dailyDto.getLogicWarehouse());
                    }
                    if (null != dailyDto.getInLogicWarehouse()) {
                        insuranceBillEo.setInLogicWarehouseName(dailyDto.getInLogicWarehouse());
                    }
                    if (null != dailyDto.getInventoryOrganizationName()) {
                        insuranceBillEo.setOutOrganizationName(dailyDto.getInventoryOrganizationName());
                    }
                    if (null != dailyDto.getConsignmentNo()) {
                        insuranceBillEo.setWmsConsignmentNo(dailyDto.getConsignmentNo());
                    }
                    if (null != dailyDto.getOutNoticeNo()) {
                        insuranceBillEo.setOutDocumentNo(dailyDto.getOutNoticeNo());
                    }
                    if (null != dailyDto.getPhysicalWarehouseCode()) {
                        insuranceBillEo.setOutPhysicsWarehouseCode(dailyDto.getPhysicalWarehouseCode());
                    }
                    if (null != dailyDto.getPhysicalWarehouse()) {
                        insuranceBillEo.setOutPhysicsWarehouseName(dailyDto.getPhysicalWarehouse());
                    }
                    this.logger.info("\u4ece\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u83b7\u53d6\u8c03\u5165/\u8c03\u51fa\u5e93\u5b58\u7ec4\u7ec7");
                    if (null != dailyDto.getOutInventoryOrgId()) {
                        insuranceBillEo.setOutOrganizationId(Long.valueOf(dailyDto.getOutInventoryOrgId()));
                    }
                    if (null != dailyDto.getOutInventoryOrg()) {
                        insuranceBillEo.setOutOrganizationName(dailyDto.getOutInventoryOrg());
                    }
                    if (null != dailyDto.getInInventoryOrgId()) {
                        insuranceBillEo.setInOrganizationId(Long.valueOf(dailyDto.getInInventoryOrgId()));
                    }
                    if (null != dailyDto.getInInventoryOrg()) {
                        insuranceBillEo.setInOrganizationName(dailyDto.getInInventoryOrg());
                    }
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getRelevanceNo()) && ObjectUtils.isNotEmpty(yyjSaleOrderMap.get(insuranceBillEo.getRelevanceNo()))) {
                        saleOrder = (SaleOrderRespEsVo)yyjSaleOrderMap.get(insuranceBillEo.getRelevanceNo());
                        insuranceBillEo.setCostBelongOrgId(saleOrder.getOrganizationId());
                        insuranceBillEo.setCostBelongOrgName(saleOrder.getOrganizationName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getRelevanceNo()) && ObjectUtils.isNotEmpty(saleOrderMap.get(insuranceBillEo.getRelevanceNo()))) {
                        saleOrder = (SaleOrderRespEsVo)saleOrderMap.get(insuranceBillEo.getRelevanceNo());
                        insuranceBillEo.setCostBelongOrgId(saleOrder.getOrganizationId());
                        insuranceBillEo.setCostBelongOrgName(saleOrder.getOrganizationName());
                    }
                    this.logger.info("\u4f7f\u7528\u6298\u6263-bill\u8d26\u5355\u6240\u9700\u5224\u65ad");
                    InsuranceFeeVo insuranceFeeVo = null;
                    this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u548c\u8d26\u5355\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)insuranceBillEo));
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getShippingCompany()) && insuranceBillEo.getShippingCompany().equals("\u4e2d\u901a")) {
                        insuranceBillEo.setShippingCompany("\u4e2d\u901a\u5feb\u9012");
                    }
                    if (CollectionUtils.isEmpty((Collection)(insureFeeList = this.reInsurancePremiumDas.getInsureFee(orderShippingTime = DateUtil.getDateFormat((Date)dailyDto.getOrderShippingTime(), (String)"yyyy-MM-dd"), insuranceBillEo.getShippingCompanyCode(), insuranceBillEo.getShippingType(), insureMaps, insuranceBillEo.getShippingCompany())))) {
                        str = "[\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]";
                        billReason.append((String)str);
                    } else if (insureFeeList.size() > 1) {
                        String str2 = "[\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]";
                        billReason.append(str2);
                    } else {
                        insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
                        insuranceBillEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
                        this.logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insuranceFeeVo));
                    }
                    this.logger.info("\u5f00\u59cb\u5904\u7406\u4fdd\u8d39\u8d26\u5355\u5bf9\u5e94\u7684\u4fdd\u8d39\u660e\u7ec6\u5217\u8868");
                    insuranceBillEo.setBillingFeeFlag(Integer.valueOf(1));
                    if (null == dailydetailEo || dailydetailEo.isEmpty()) {
                        str = "\u65e0\u4fdd\u8d39\u660e\u7ec6\u6570\u636e";
                        this.logger.warn((String)str);
                        insuranceBillEo.setBillingFeeFlag(Integer.valueOf(0));
                        insuranceBillEo.setNoBillingReason((String)str);
                        quantity = null;
                        insureTotalPrice = null;
                    } else {
                        for (DailyDeliveryReportDetailCombineDto productDto : dailydetailEo) {
                            CsShipmenetEnterpriseRespDto shipmenetEnterpriseRespDto;
                            StringBuilder builder = new StringBuilder();
                            if (StringUtils.isNotBlank((CharSequence)billReason.toString())) {
                                builder.append((CharSequence)billReason);
                            }
                            ReInsurancePremiumEo premiumEo = new ReInsurancePremiumEo();
                            this.logger.info("\u5c06\u8d26\u5355\u516c\u7528\u7684\u8d4b\u503c\u7ed9\u5355\u4e2a\u660e\u7ec6");
                            CubeBeanUtils.copyProperties((Object)premiumEo, (Object)insuranceBillEo, (String[])new String[]{"id", "reason", "create_time", "create_person", "update_person", "update_time"});
                            premiumEo.setPlacedFlag(Integer.valueOf(0));
                            premiumEo.setBillingFeeFlag(Integer.valueOf(1));
                            premiumEo.setLinkDailyReportId(productDto.getId());
                            premiumEo.setExternalOrderNo(dailyDto.getEasOrderNo());
                            premiumEo.setLongCode(productDto.getLongCode());
                            premiumEo.setCargoName(productDto.getProductName());
                            premiumEo.setQuantity(productDto.getQuantity());
                            premiumEo.setCreateTime(null);
                            premiumEo.setUpdateTime(null);
                            premiumEo.setBatch(productDto.getBatch());
                            this.logger.info("\u5904\u7406\u4fdd\u8d39\u660e\u7ec6\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString((Object)premiumEo));
                            if (null != dailyDto.getConsignmentNo()) {
                                premiumEo.setWmsConsignmentNo(dailyDto.getConsignmentNo());
                            }
                            if (null != dailyDto.getOutNoticeNo()) {
                                premiumEo.setOutDocumentNo(dailyDto.getOutNoticeNo());
                            }
                            if (null != dailyDto.getPhysicalWarehouseCode()) {
                                premiumEo.setOutPhysicsWarehouseCode(dailyDto.getPhysicalWarehouseCode());
                            }
                            if (null != dailyDto.getPhysicalWarehouse()) {
                                premiumEo.setOutPhysicsWarehouseName(dailyDto.getPhysicalWarehouse());
                            }
                            if (null != productDto.getReceivingCustomer() && null != productDto.getShipmentEnterpriseCode() && ObjectUtils.isNotEmpty((Object)(shipmenetEnterpriseRespDto = (CsShipmenetEnterpriseRespDto)shipmenetEnterpriseRespDtoMap.get(productDto.getShipmentEnterpriseCode() + "-" + productDto.getReceivingCustomer())))) {
                                premiumEo.setBillingFeeFlag(Integer.valueOf(0));
                                premiumEo.setNoBillingReason("\u5ba2\u6237\u548c\u627f\u8fd0\u5546\u6709\u5339\u914d\u5173\u7cfb");
                                insuranceBillEo.setBillingFeeFlag(Integer.valueOf(0));
                                insuranceBillEo.setNoBillingReason("\u5ba2\u6237\u548c\u627f\u8fd0\u5546\u6709\u5339\u914d\u5173\u7cfb");
                            }
                            DailyDeliveryFeeFilterExtConfigReqDto configReqDto = new DailyDeliveryFeeFilterExtConfigReqDto();
                            configReqDto.setFilterPhysicalWarehouse(premiumEo.getOutPhysicsWarehouseCode());
                            configReqDto.setFilterLogicWarehouse(premiumEo.getOutLogicWarehouseCode());
                            configReqDto.setFilterBusinessType(premiumEo.getBusinessType());
                            configReqDto.setLogisticsCompany(premiumEo.getShippingCompany());
                            configReqDto.setFilterInventoryOrg(premiumEo.getOutOrganizationName());
                            configReqDto.setTransportStyle(premiumEo.getShippingType());
                            boolean filterApplicable = this.dailyDeliveryFeeFilterExtConfigService.isFilterApplicable(filter, configReqDto);
                            if (filterApplicable) {
                                this.logger.info("\u547d\u4e2d\u5254\u9664\u8ba1\u8d39\u914d\u7f6e");
                                premiumEo.setBillingFeeFlag(Integer.valueOf(0));
                                premiumEo.setNoBillingReason("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                                insuranceBillEo.setBillingFeeFlag(Integer.valueOf(0));
                                insuranceBillEo.setNoBillingReason("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                            }
                            if (premiumEo.getBillingFeeFlag() == 0) {
                                this.logger.info("\u5199\u5165\u5931\u8d25\u539f\u56e0\uff08\u975e\u7a7a\u65f6\uff09");
                                if (builder.length() > 0) {
                                    premiumEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                                    premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                                } else {
                                    premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                                }
                                premiumEoList.add(premiumEo);
                                continue;
                            }
                            this.logger.info("\u6c47\u603b\u67d0\u4e2a\u8d26\u5355\u7684\u6240\u6709\u660e\u7ec6\u7684\u6570\u91cf");
                            if (null == premiumEo.getQuantity()) {
                                premiumEo.setQuantity(BigDecimal.ZERO);
                            }
                            quantity = quantity.add(premiumEo.getQuantity());
                            this.logger.info("\u6839\u636e\u957f\u7f16\u7801,,\u4ece\u5546\u54c1\u6269\u5c55\u53c2\u6570\u8868\u53d6\u51fa\u5efa\u8bae\u96f6\u552e\u4ef7\u548c\u7d22\u8d54\u5355\u4ef7(\u6295\u4fdd\u5355\u4ef7),,,,\u4ece\u5546\u54c1\u5b9a\u4e49\u8868\u53d6\u957f\u7f16\u7801,\u5546\u54c1\u7c7b\u578b");
                            InsuranceItemVo itemEo = (InsuranceItemVo)insuranceItemVoMap.get(premiumEo.getLongCode());
                            this.logger.info("\u8bbe\u7f6e\u5546\u54c1\u7c7b\u578b\u548c\u5185\u90e8\u4ea4\u6613\u4ef7(\u6295\u4fdd\u5355\u4ef7)");
                            if (ObjectUtils.isEmpty((Object)itemEo)) {
                                builder.append("[\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1]");
                            } else {
                                if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                                    builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\uff0c\u4e3a\u7a7a]");
                                } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                                    builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u3010" + itemEo.getItemType() + "\u3011\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728]");
                                } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                                    premiumEo.setItemType(SubTypeEnum.PRODUCT.getType());
                                } else {
                                    premiumEo.setItemType(itemEo.getItemType());
                                }
                                if (null != productDto.getRecommendPrice()) {
                                    premiumEo.setRecommendPrice(productDto.getRecommendPrice());
                                }
                                if (null != productDto.getInternalTransaction()) {
                                    premiumEo.setClaimPrice(productDto.getInternalTransaction());
                                    if (premiumEo.getClaimPrice().compareTo(BigDecimal.ZERO) == 0) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801= " + premiumEo.getLongCode() + " \u7684\u5185\u90e8\u91c7\u8d2d\u4ef7\u4e3a0]");
                                    }
                                } else {
                                    builder.append("[\u5546\u54c1\u957f\u7f16\u7801= " + premiumEo.getLongCode() + " \u7684\u5185\u90e8\u91c7\u8d2d\u4ef7\u4e3a\u7a7a]");
                                }
                            }
                            this.logger.info("\u5bf9\u4e8e\u4f7f\u7528\u6298\u6263\u548c\u4fdd\u8d39\u8d39\u7387\u7684\u5904\u7406");
                            if (!CollectionUtils.isEmpty((Collection)insureFeeList) && insureFeeList.size() == 1) {
                                InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                                premiumEo.setLogisticsSetttingsId(feeVo.getId());
                                if (ObjectUtils.isEmpty((Object)premiumEo.getItemType())) {
                                    builder.append("[\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263]");
                                } else {
                                    if (premiumEo.getLongCode().startsWith("A.A")) {
                                        premiumEo.setUseDiscount(feeVo.getProductDiscount());
                                    } else {
                                        premiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                                    }
                                    premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                                }
                            }
                            this.logger.info("\u8ba1\u7b97\u6295\u4fdd\u5355\u4ef7");
                            if (ObjectUtils.isNotEmpty((Object)premiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumEo.getUseDiscount())) {
                                premiumEo.setInsureUnitPrice(premiumEo.getClaimPrice().multiply(premiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                                premiumEo.setInsureTotalPrice(premiumEo.getInsureUnitPrice().multiply(premiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
                            }
                            if (null == premiumEo.getUseDiscount() || null == premiumEo.getInsureUnitPrice()) {
                                builder.append("[\u6295\u4fdd\u4ef7\u6216\u6298\u6263\u4e3a\u7a7a]");
                            }
                            this.logger.info("\u5f00\u59cb\u53e0\u52a0\u6bcf\u4e2a\u660e\u7ec6\u7684\u6295\u4fdd\u603b\u4ef7");
                            insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(premiumEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                            this.logger.info("\u5199\u5165\u5931\u8d25\u539f\u56e0\uff08\u975e\u7a7a\u65f6\uff09");
                            if (builder.length() > 0) {
                                premiumEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                                premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            } else {
                                premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                            }
                            premiumEoList.add(premiumEo);
                        }
                    }
                    this.logger.info("\u81f3\u6b64\u5355\u4e2a\u4fdd\u8d39\u8d26\u5355\u7684\u5168\u90e8\u660e\u7ec6\u5904\u7406\u5b8c\u6bd5");
                    insuranceBillEo.setQuantity(quantity);
                    insuranceBillEo.setInsureTotalPrice(insureTotalPrice);
                    this.logger.info("\u8ba1\u7b97\u4fdd\u8d39\u8d26\u5355\u7684\u4fdd\u8d39");
                    int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
                    if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                        insuranceBillEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                        if (ObjectUtils.isNotEmpty((Object)insureTotalPrice) && ObjectUtils.isNotEmpty((Object)insuranceBillEo.getUseInsuranceRate())) {
                            if (insureTotalPrice.compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                                insuranceBillEo.setInsureFee(insuranceBillEo.getInsureTotalPrice().multiply(insuranceBillEo.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                                continue;
                            }
                            insuranceBillEo.setInsureFee(new BigDecimal("0"));
                            continue;
                        }
                        billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
                        continue;
                    }
                    billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
                }
                catch (Exception e) {
                    billReason.append(e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    if (billReason.length() > 0) {
                        insuranceBillEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
                        insuranceBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    } else {
                        insuranceBillEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                    }
                    insuranceBillEo.setCreateTime(null);
                    insuranceBillEo.setUpdateTime(null);
                    this.logger.info("\u65e0\u8bba\u662f\u5426\u5f02\u5e38\uff0c\u90fd\u8981\u8c03\u7528\u4e8b\u52a1\u5199\u5165\u4fdd\u8d39\u8d26\u5355\u548c\u660e\u7ec6\u540c\u65f6");
                    this.logger.info("\u8d26\u5355\u5bf9\u8c61,\u660e\u7ec6\u5bf9\u8c61:{},{}", (Object)insuranceBillEo, premiumEoList);
                    insuranceBillEo.setPremiumEoList(premiumEoList);
                    billEoList.add(insuranceBillEo);
                }
            }
            this.billService.addInsurePremiumAndBill(billEoList);
            reportQueryDto.setPageNum(Integer.valueOf(reportQueryDto.getPageNum() + 1));
            this.logger.info("\u67e5\u8be2\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u6570\u636e\u751f\u6210\u4fdd\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reportQueryDto));
            reportDtoPageInfo = this.reInsurancePremiumDas.getDailyDeliveryReportEoListByDate(reportQueryDto);
        }
        this.cacheService.delCache(INSURANCE_REPORT_LOCK_KEY);
        return "00000";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer generateInsurancePremium(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("generateInsurancePremium\u4fdd\u8d39\u660e\u7ec6\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        boolean lockFlag = this.cacheService.setIfAbsent(INSURANCE_REPORT_LOCK_KEY, (Object)1, 600);
        if (!lockFlag) {
            throw new BizException("-1", "\u4fdd\u8d39\u660e\u7ec6\u751f\u6210\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u8bf7\u7b49\u5f85\u751f\u6210\u5b8c\u540e\u518d\u6267\u884c");
        }
        try {
            Object object;
            DailyDeliveryReportDto reportDto = new DailyDeliveryReportDto();
            reportDto.setOrderShippingTimeStart(reqDto.getInOutTimeBegin());
            reportDto.setOrderShippingTimeEnd(reqDto.getInOutTimeEnd());
            reportDto.setPhysicalWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
            reportDto.setShippingCompanyNameList(reqDto.getShippingCompanyList());
            reportDto.setTransportStyleList(reqDto.getShippingTypeList());
            this.logger.info("\u67e5\u8be2\u9700\u8ba1\u8d39\u7684\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reportDto));
            List dailyDeliveryReportDetailCombineDtoList = this.reInsurancePremiumDas.queryGenerateInsurancePremium(reportDto);
            if (CollectionUtils.isEmpty((Collection)dailyDeliveryReportDetailCombineDtoList)) {
                this.logger.info("\u65e0\u6570\u636e\u9700\u8981\u751f\u6210");
                Integer n = 0;
                return n;
            }
            Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
            ApportionmentConfigExtRespDto apportionmentConfigExtRespDto = (ApportionmentConfigExtRespDto)RestResponseHelper.extractData((RestResponse)this.apportionmentConfigQueryApi.queryByCostModuleCode(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode()));
            this.logger.info("\u8bfb\u53d6\u8d39\u7528\u5206\u644a\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)apportionmentConfigExtRespDto));
            List<DailyDeliveryFeeFilterExtConfigRespDto> filter = this.dailyDeliveryFeeFilterExtConfigService.queryModuleCode(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
            this.logger.info("\u4fdd\u8d39\u5254\u9664\u8d39\u7528\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString(filter));
            CsShipmenetEnterpriseQueryDto enterpriseQueryDto = new CsShipmenetEnterpriseQueryDto();
            enterpriseQueryDto.setPageNum(Integer.valueOf(1));
            enterpriseQueryDto.setPageSize(Integer.valueOf(1000));
            PageInfo enterpriseRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.icsShipmenetEnterpriseQueryApi.queryByPage(enterpriseQueryDto));
            Map shipmenetEnterpriseRespDtoMap = Optional.ofNullable(enterpriseRespDtoPageInfo.getList()).map(m -> enterpriseRespDtoPageInfo.getList().stream().collect(Collectors.toMap(o -> o.getShipmentEnterpriseCode() + "-" + o.getCustomerCode(), Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            List longCodeList = dailyDeliveryReportDetailCombineDtoList.stream().map(DailyDeliveryReportDetailCombineDto::getLongCode).distinct().collect(Collectors.toList());
            Map insuranceItemVoMap = new HashMap();
            if (CollectionUtils.isNotEmpty(longCodeList)) {
                List insuranceItemVoList = this.reInsurancePremiumDas.getPcpItemByLongCode(longCodeList);
                insuranceItemVoMap = Optional.ofNullable(insuranceItemVoList).map(m -> m.stream().collect(Collectors.toMap(InsuranceItemVo::getLongCode, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
            }
            List insureFeeList = this.reInsurancePremiumDas.getInsureFee();
            this.logger.info("\u83b7\u53d6\u4fdd\u9669\u516c\u53f8\u6295\u4fdd\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insureFeeList));
            ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
            Map<Long, List<DailyDeliveryReportDetailCombineDto>> dtoCollect = dailyDeliveryReportDetailCombineDtoList.stream().collect(Collectors.groupingBy(DailyDeliveryReportDetailCombineDto::getDailyDeliveryReportId));
            for (Map.Entry<Long, List<DailyDeliveryReportDetailCombineDto>> map : dtoCollect.entrySet()) {
                this.logger.info("\u4fbf\u5229\u5904\u7406\u5355\u636e\uff1a{}", (Object)JSON.toJSONString(map.getValue()));
                for (DailyDeliveryReportDetailCombineDto combineDto : map.getValue()) {
                    List apportionmentOrgCodeList;
                    CsShipmenetEnterpriseRespDto shipmenetEnterpriseRespDto;
                    this.logger.info("\u4fbf\u5229\u5904\u7406\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(map.getValue()));
                    ReInsurancePremiumEo insurancePremiumEo = new ReInsurancePremiumEo();
                    insurancePremiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                    insurancePremiumEo.setPlacedFlag(Integer.valueOf(0));
                    insurancePremiumEo.setBillingFeeFlag(Integer.valueOf(1));
                    insurancePremiumEo.setLinkDailyReportId(combineDto.getId());
                    insurancePremiumEo.setLinkDailyDetailId(combineDto.getDetailId());
                    insurancePremiumEo.setExternalOrderNo(combineDto.getEasOrderNo());
                    insurancePremiumEo.setWmsConsignmentNo(combineDto.getConsignmentNo());
                    insurancePremiumEo.setCustomerName(combineDto.getReceivingCustomer());
                    insurancePremiumEo.setCustomerAddress(combineDto.getReceivingAddress());
                    insurancePremiumEo.setInOutTime(combineDto.getOrderShippingTime());
                    insurancePremiumEo.setDocumentNo(combineDto.getOutResultNo());
                    insurancePremiumEo.setShippingCompany(combineDto.getShippingCompanyName());
                    insurancePremiumEo.setShippingCompanyCode(combineDto.getShippingCompany());
                    insurancePremiumEo.setShippingType(combineDto.getTransportStyle());
                    insurancePremiumEo.setStartPlace(combineDto.getStartCity());
                    insurancePremiumEo.setEndPlace(combineDto.getReceivingAddressCity());
                    insurancePremiumEo.setEndPlaceCode(combineDto.getReceivingAddressCityCode());
                    insurancePremiumEo.setEndProvince(combineDto.getReceivingAddressProvince());
                    insurancePremiumEo.setEndProvinceCode(combineDto.getReceivingAddressProvinceCode());
                    insurancePremiumEo.setOutLogicWarehouseCode(combineDto.getLogicWarehouseCode());
                    insurancePremiumEo.setOutLogicWarehouseName(combineDto.getLogicWarehouse());
                    insurancePremiumEo.setInLogicWarehouseCode(combineDto.getInLogicWarehouseCode());
                    insurancePremiumEo.setInLogicWarehouseName(combineDto.getInLogicWarehouse());
                    insurancePremiumEo.setCostBelongOrgCode(combineDto.getBelongOrgCode());
                    insurancePremiumEo.setCostBelongOrgName(combineDto.getBelongOrgName());
                    insurancePremiumEo.setOutOrganizationCode(combineDto.getOutInventoryOrgId());
                    insurancePremiumEo.setOutOrganizationName(combineDto.getOutInventoryOrg());
                    insurancePremiumEo.setInOrganizationCode(combineDto.getInInventoryOrgId());
                    insurancePremiumEo.setInOrganizationName(combineDto.getInInventoryOrg());
                    insurancePremiumEo.setOrderRemark(combineDto.getRemark());
                    insurancePremiumEo.setTransportNo(combineDto.getTransportNo());
                    insurancePremiumEo.setReceivingPerson(combineDto.getReceivingPerson());
                    insurancePremiumEo.setLongCode(combineDto.getLongCode());
                    insurancePremiumEo.setCargoName(combineDto.getProductName());
                    insurancePremiumEo.setQuantity(combineDto.getQuantity());
                    insurancePremiumEo.setBatch(combineDto.getBatch());
                    insurancePremiumEo.setOutDocumentNo(combineDto.getOutNoticeNo());
                    insurancePremiumEo.setOutPhysicsWarehouseName(combineDto.getPhysicalWarehouse());
                    insurancePremiumEo.setOutPhysicsWarehouseCode(combineDto.getPhysicalWarehouseCode());
                    insurancePremiumEo.setRelevanceNo(combineDto.getRelevanceNo());
                    if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                        insurancePremiumEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                    }
                    if (StringUtils.isNotBlank((CharSequence)insurancePremiumEo.getShippingCompany()) && insurancePremiumEo.getShippingCompany().equals("\u4e2d\u901a")) {
                        insurancePremiumEo.setShippingCompany("\u4e2d\u901a\u5feb\u9012");
                    }
                    this.logger.info("\u8bbe\u7f6e\u5546\u54c1\u7c7b\u578b");
                    InsuranceItemVo itemEo = (InsuranceItemVo)insuranceItemVoMap.get(insurancePremiumEo.getLongCode());
                    if (ObjectUtils.isEmpty((Object)itemEo)) {
                        this.premiumFlag(Boolean.TRUE, insurancePremiumEo, "\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a" + insurancePremiumEo.getLongCode() + "\u7684\u5546\u54c1");
                    } else {
                        this.logger.info("\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)itemEo));
                        if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                            this.premiumFlag(Boolean.TRUE, insurancePremiumEo, "\u5546\u54c1\u957f\u7f16\u7801\u4e3a" + insurancePremiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\uff0c\u4e3a\u7a7a");
                        } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                            this.premiumFlag(Boolean.TRUE, insurancePremiumEo, "\u7684\u5546\u54c1\u7c7b\u578b " + itemEo.getItemType() + "\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728");
                        } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                            insurancePremiumEo.setItemType(SubTypeEnum.PRODUCT.getType());
                        } else {
                            insurancePremiumEo.setItemType(itemEo.getItemType());
                        }
                    }
                    InsuranceFeeVo feeVo = this.matchUseInsuranceRate(insurancePremiumEo, insureFeeList);
                    if (null != combineDto.getReceivingCustomer() && null != combineDto.getShipmentEnterpriseCode() && ObjectUtils.isNotEmpty((Object)(shipmenetEnterpriseRespDto = (CsShipmenetEnterpriseRespDto)shipmenetEnterpriseRespDtoMap.get(combineDto.getShipmentEnterpriseCode() + "-" + combineDto.getReceivingCustomer())))) {
                        insurancePremiumEo.setBillingFeeFlag(Integer.valueOf(0));
                        insurancePremiumEo.setNoBillingReason("\u5ba2\u6237\u548c\u627f\u8fd0\u5546\u6709\u5339\u914d\u5173\u7cfb");
                    }
                    DailyDeliveryFeeFilterExtConfigReqDto configReqDto = new DailyDeliveryFeeFilterExtConfigReqDto();
                    configReqDto.setFilterPhysicalWarehouse(insurancePremiumEo.getOutPhysicsWarehouseCode());
                    configReqDto.setFilterLogicWarehouse(insurancePremiumEo.getOutLogicWarehouseCode());
                    configReqDto.setFilterBusinessType(insurancePremiumEo.getBusinessType());
                    configReqDto.setLogisticsCompany(insurancePremiumEo.getShippingCompany());
                    configReqDto.setFilterInventoryOrg(insurancePremiumEo.getOutOrganizationName());
                    configReqDto.setTransportStyle(insurancePremiumEo.getShippingType());
                    this.logger.info("\u5339\u914d\u5254\u9664\u8d39\u7528\uff1a{}", (Object)JSON.toJSONString((Object)configReqDto));
                    boolean filterApplicable = this.dailyDeliveryFeeFilterExtConfigService.isFilterApplicable(filter, configReqDto);
                    if (filterApplicable) {
                        insurancePremiumEo.setBillingFeeFlag(Integer.valueOf(0));
                        insurancePremiumEo.setNoBillingReason("\u5254\u9664\u8ba1\u8d39\u914d\u7f6e\u547d\u4e2d");
                    }
                    insurancePremiumEo.setRecommendPrice(combineDto.getRecommendPrice());
                    this.premiumFlag(ObjectUtils.isEmpty((Object)insurancePremiumEo.getRecommendPrice()), insurancePremiumEo, "\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a");
                    insurancePremiumEo.setClaimPrice(combineDto.getInternalTransaction());
                    this.premiumFlag(ObjectUtils.isEmpty((Object)insurancePremiumEo.getClaimPrice()), insurancePremiumEo, "\u5185\u90e8\u4ea4\u6613\u4ef7\u4e3a\u7a7a");
                    this.premiumFlag(ObjectUtils.isNotEmpty((Object)insurancePremiumEo.getClaimPrice()) && insurancePremiumEo.getClaimPrice().compareTo(BigDecimal.ZERO) == 0, insurancePremiumEo, "\u7684\u5185\u90e8\u91c7\u8d2d\u4ef7\u4e3a0");
                    this.logger.info("\u4f7f\u7528\u6298\u6263\u5339\u914d");
                    if (ObjectUtils.isNotEmpty((Object)feeVo)) {
                        if (ObjectUtils.isEmpty((Object)insurancePremiumEo.getItemType())) {
                            this.premiumFlag(Boolean.TRUE, insurancePremiumEo, "\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263");
                        } else {
                            if (insurancePremiumEo.getItemType().equals(SubTypeEnum.PRODUCT.getType())) {
                                insurancePremiumEo.setUseDiscount(feeVo.getProductDiscount());
                            } else {
                                insurancePremiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                            }
                            this.premiumFlag(ObjectUtils.isEmpty((Object)insurancePremiumEo.getUseDiscount()), insurancePremiumEo, "\u4f7f\u7528\u6298\u6263\u4e3a\u7a7a");
                        }
                    }
                    this.logger.info("\u8ba1\u7b97\u6295\u4fdd\u5355\u4ef7");
                    if (ObjectUtils.isNotEmpty((Object)insurancePremiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)insurancePremiumEo.getUseDiscount())) {
                        insurancePremiumEo.setInsureUnitPrice(insurancePremiumEo.getClaimPrice().multiply(insurancePremiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                        insurancePremiumEo.setInsureTotalPrice(insurancePremiumEo.getInsureUnitPrice().multiply(insurancePremiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
                    }
                    if (StringUtils.isNotBlank((CharSequence)insurancePremiumEo.getReason())) {
                        insurancePremiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    }
                    insurancePremiumEo.setIfApportion(YesOrNoEnum.NO.getCode());
                    if (apportionmentConfigExtRespDto.getIsShareholdingApportionment() == 1 && CollectionUtil.isNotEmpty((Collection)apportionmentConfigExtRespDto.getOrganizationList()) && (apportionmentOrgCodeList = apportionmentConfigExtRespDto.getOrganizationList().stream().map(ApportionmentOrganizationRespDto::getOrganizationCode).collect(Collectors.toList())).contains(insurancePremiumEo.getCostBelongOrgCode())) {
                        insurancePremiumEo.setIfApportion(YesOrNoEnum.YES.getCode());
                    }
                    premiumEoList.add(insurancePremiumEo);
                }
            }
            if (CollectionUtils.isNotEmpty(premiumEoList)) {
                this.reInsurancePremiumDas.insertBatch(premiumEoList);
                object = premiumEoList.size();
                return object;
            }
            object = 0;
            return object;
        }
        catch (Exception e) {
            this.logger.error("generateInsurancePremium\u4fdd\u8d39\u660e\u7ec6\u751f\u6210\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", e.getMessage());
        }
        finally {
            this.cacheService.delCache(INSURANCE_REPORT_LOCK_KEY);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDeleInsurancePremium(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u5220\u9664\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List premiumEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsurancePremiumDas.filter().ge(ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeBegin()), (Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le(ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeEnd()), (Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingCompanyList()), (Object)"shipping_company", (Collection)reqDto.getShippingCompanyList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingTypeList()), (Object)"shipping_type", (Collection)reqDto.getShippingTypeList())).list();
        if (CollectionUtils.isNotEmpty((Collection)premiumEoList)) {
            this.logger.info("\u9700\u5220\u9664\u4fdd\u8d39\u660e\u7ec6\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)premiumEoList));
            List ids = premiumEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsurancePremiumDas.logicDeleteByIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateInsurancePremiumAfterDel(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u751f\u6210\uff0c\u5220\u9664\u65e7\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.logicDeleInsurancePremium(reqDto);
        this.generateInsurancePremium(reqDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateInsuranceReport(Date generateDate) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u751f\u6210\uff1a{}", (Object)generateDate);
        Boolean lockFlag = this.cacheService.setCache(INSURANCE_REPORT_LOCK_KEY, (Object)1, 120);
        if (!lockFlag.booleanValue()) {
            return "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u6570\u636e\u751f\u6210\u670d\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7b49\u5f85\u751f\u6210\u5b8c\u540e\u518d\u6267\u884c";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String calDate = dateFormat.format(generateDate);
        this.logger.info("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u65e5\u671f:{}:\u7684\u4fdd\u8d39\u6570\u636e", (Object)calDate);
        String calDateBegin = calDate + " 00:00:00";
        String calDateEnd = calDate + " 23:59:59";
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u66f4\u65b0\u5f02\u5e38\u4fe1\u606f\uff0c\u66f4\u65b0\u65f6\u95f4\uff1a{}\uff0c{}", (Object)calDateBegin, (Object)calDateEnd);
        Long outResultNoCount = this.reInsurancePremiumDas.getOutResultNoCountByDate(calDateBegin, calDateEnd);
        if (outResultNoCount == 0L) {
            String info = "\u4fdd\u8d39\u62a5\u8868\u51fa\u5e93\u65e5\u671f:" + calDate + ",\u83b7\u53d6\u5230\u51fa\u5e93\u7ed3\u679c\u5355\u53f7\u6761\u6570\u4e3a0,\u751f\u6210\u4fdd\u8d39\u62a5\u8868\u7ed3\u679c\u6570\u4e3a0\uff0c\u7ed3\u675f\u751f\u6210";
            this.logger.info(info);
            return info;
        }
        HashMap itemMaps = new HashMap();
        HashMap warehouseMaps = new HashMap();
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        HashMap costBelongMaps = new HashMap();
        HashMap insureMaps = new HashMap();
        HashMap<String, InsuranceCustomerInfoVo> physicsWareMap = new HashMap<String, InsuranceCustomerInfoVo>();
        HashMap<String, String> startPlaceMap = new HashMap<String, String>(8);
        Integer pageNum = 0;
        Integer pageSize = 1000;
        List outResultOrderEoList = this.reInsurancePremiumDas.getOutResultNoListByDate(calDateBegin, calDateEnd, pageNum, pageSize);
        while (CollectionUtils.isNotEmpty((Collection)outResultOrderEoList)) {
            for (OutResultOrderEo orderEo : outResultOrderEoList) {
                this.logger.info("generateInsuranceReport\u5904\u7406\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)orderEo));
                ReInsuranceBillEo insuranceBillEo = new ReInsuranceBillEo();
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)orderEo, (String[])new String[0]);
                ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
                List detailEoList = this.reInsurancePremiumDas.getOutResultOrderDetail(orderEo.getDocumentNo());
                StringBuilder billReason = new StringBuilder();
                BigDecimal quantity = BigDecimal.ZERO;
                BigDecimal insureTotalPrice = BigDecimal.ZERO;
                try {
                    int billQuotaVerify;
                    Object str;
                    CostBelongVo belongVo;
                    LogicWarehouseEo logicWarehouseEo;
                    SaleOrderEo saleOrderEo;
                    this.getCommonOtherData(insuranceBillEo, physicsWareMap, startPlaceMap);
                    if (StringUtils.contains((CharSequence)insuranceBillEo.getRelevanceNo(), (CharSequence)"DD") && null != (saleOrderEo = (SaleOrderEo)this.saleOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SaleOrderEo.class).eq(SaleOrderEo::getSaleOrderNo, (Object)insuranceBillEo.getRelevanceNo())))) {
                        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getEasOrderNo())) {
                            insuranceBillEo.setExternalOrderNo(saleOrderEo.getEasOrderNo());
                        } else {
                            insuranceBillEo.setExternalOrderNo(saleOrderEo.getEasOutOrderNo());
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)insuranceBillEo.getExternalOrderNo())) {
                        insuranceBillEo.setExternalOrderNo(insuranceBillEo.getRelevanceNo());
                    }
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getOutLogicWarehouseCode())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(insuranceBillEo.getOutLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            insuranceBillEo.setOutOrganizationId(logicWarehouseEo.getOrganizationId());
                            insuranceBillEo.setOutOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u51fa\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + insuranceBillEo.getOutLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getInLogicWarehouseCode())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(insuranceBillEo.getInLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            insuranceBillEo.setInOrganizationId(logicWarehouseEo.getOrganizationId());
                            insuranceBillEo.setInOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u5165\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + insuranceBillEo.getInLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (ObjectUtils.isEmpty((Object)(belongVo = this.reInsurancePremiumDas.getCostBelong(insuranceBillEo.getOutLogicWarehouseCode(), insuranceBillEo.getInLogicWarehouseCode(), costBelongMaps)))) {
                        if (!ObjectUtils.isEmpty((Object)insuranceBillEo.getOutOrganizationId())) {
                            insuranceBillEo.setCostBelongOrgId(insuranceBillEo.getOutOrganizationId());
                            insuranceBillEo.setCostBelongOrgName(insuranceBillEo.getOutOrganizationName());
                        }
                    } else {
                        insuranceBillEo.setCostBelongOrgId(belongVo.getCostBelongOrgId());
                        insuranceBillEo.setCostBelongOrgName(belongVo.getCostBelongOrgName());
                    }
                    InsuranceFeeVo insuranceFeeVo = null;
                    List insureFeeList = this.reInsurancePremiumDas.getInsureFee(calDateBegin, insuranceBillEo.getShippingCompanyCode(), insuranceBillEo.getShippingType(), insureMaps, insuranceBillEo.getShippingCompany());
                    if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                        str = "[\u51fa\u5e93\u65e5\u671f:" + calDate + ",\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]";
                        billReason.append((String)str);
                    } else if (insureFeeList.size() > 1) {
                        String str2 = "[\u51fa\u5e93\u65e5\u671f:" + calDate + ",\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]";
                        billReason.append(str2);
                    } else {
                        insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
                        insuranceBillEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
                        this.logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insuranceFeeVo));
                    }
                    if (CollectionUtils.isEmpty((Collection)detailEoList)) {
                        str = "[\u751f\u6210\u4fdd\u8d39\u9519\u8bef,\u51fa\u5e93\u7ed3\u679c\u5355\u53f7:{" + orderEo.getDocumentNo() + "}:\u65e0\u660e\u7ec6\u6570\u636e]";
                        this.logger.warn((String)str);
                        billReason.append((String)str);
                        quantity = null;
                        insureTotalPrice = null;
                    }
                    for (OutResultOrderDetailEo orderDetailEo : detailEoList) {
                        StringBuilder builder = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)billReason.toString())) {
                            builder.append((CharSequence)billReason);
                        }
                        ReInsurancePremiumEo premiumEo = new ReInsurancePremiumEo();
                        CubeBeanUtils.copyProperties((Object)premiumEo, (Object)insuranceBillEo, (String[])new String[]{"reason"});
                        premiumEo.setLongCode(orderDetailEo.getSkuCode());
                        premiumEo.setCargoName(orderDetailEo.getSkuName());
                        premiumEo.setQuantity(orderDetailEo.getQuantity());
                        quantity = quantity.add(premiumEo.getQuantity());
                        InsuranceItemVo itemEo = this.reInsurancePremiumDas.getPcpItemByLongCode(premiumEo.getLongCode(), itemMaps);
                        if (ObjectUtils.isEmpty((Object)itemEo)) {
                            builder.append("[\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1]");
                        } else {
                            if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                                builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\uff0c\u4e3a\u7a7a]");
                            } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                                builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + premiumEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u3010" + itemEo.getItemType() + "\u3011\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728]");
                            } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                                premiumEo.setItemType(SubTypeEnum.PRODUCT.getType());
                            } else {
                                premiumEo.setItemType(itemEo.getItemType());
                            }
                            if (!ObjectUtils.isEmpty((Object)itemEo.getClaimPrice())) {
                                premiumEo.setClaimPrice(itemEo.getClaimPrice());
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)insureFeeList) && insureFeeList.size() == 1) {
                            InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                            premiumEo.setLogisticsSetttingsId(feeVo.getId());
                            if (ObjectUtils.isEmpty((Object)premiumEo.getItemType())) {
                                builder.append("[\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263]");
                            } else {
                                if (premiumEo.getLongCode().startsWith("A.A")) {
                                    premiumEo.setUseDiscount(feeVo.getProductDiscount());
                                } else {
                                    premiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                                }
                                premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                            }
                        }
                        if (ObjectUtils.isNotEmpty((Object)premiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumEo.getUseDiscount())) {
                            premiumEo.setInsureUnitPrice(premiumEo.getClaimPrice().multiply(premiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                            premiumEo.setInsureTotalPrice(premiumEo.getInsureUnitPrice().multiply(premiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
                        }
                        insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(premiumEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                        premiumEo.setCreateTime(new Date());
                        premiumEo.setUpdateTime(new Date());
                        if (builder.length() > 0) {
                            premiumEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                            premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                        } else {
                            premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                        }
                        premiumEoList.add(premiumEo);
                    }
                    insuranceBillEo.setQuantity(quantity);
                    insuranceBillEo.setInsureTotalPrice(insureTotalPrice);
                    int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
                    if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                        insuranceBillEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                        if (ObjectUtils.isNotEmpty((Object)insureTotalPrice) && ObjectUtils.isNotEmpty((Object)insuranceBillEo.getUseInsuranceRate())) {
                            if (insureTotalPrice.compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                                insuranceBillEo.setInsureFee(insuranceBillEo.getInsureTotalPrice().multiply(insuranceBillEo.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                                continue;
                            }
                            insuranceBillEo.setInsureFee(new BigDecimal("0"));
                            continue;
                        }
                        billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
                        continue;
                    }
                    billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
                }
                catch (Exception e) {
                    billReason.append(e.getMessage());
                    e.printStackTrace();
                }
                finally {
                    if (billReason.length() > 0) {
                        insuranceBillEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
                        insuranceBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    } else {
                        insuranceBillEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                    }
                    this.billService.addInsurePremiumAndBill(insuranceBillEo, premiumEoList);
                }
            }
            if (outResultOrderEoList.size() < pageSize) {
                outResultOrderEoList = null;
                continue;
            }
            outResultOrderEoList.clear();
            outResultOrderEoList = this.reInsurancePremiumDas.getOutResultNoListByDate(calDateBegin, calDateEnd, pageNum, pageSize);
        }
        this.cacheService.delCache(INSURANCE_REPORT_LOCK_KEY);
        this.logger.info("\u7ed3\u675f\u751f\u6210\u51fa\u5e93\u65e5\u671f:{}:\u7684\u4fdd\u8d39\u6570\u636e", (Object)calDate);
        return "00000";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateInsuranceExceptionReport(ReInsurancePremiumExceptionDto exceptionDto) {
        Integer errCount;
        this.logger.info("\u66f4\u65b0\u4fdd\u8d39\u660e\u7ec6\u5f02\u5e38\u6570\u636e\uff1a{},{},{},{},{}", new Object[]{exceptionDto.getBeginDate(), exceptionDto.getEndDate(), exceptionDto.getShippingCompanyCode(), exceptionDto.getShippingType(), exceptionDto.getInsuranceCompany()});
        Boolean lockFlag = this.cacheService.setCache(INSURANCE_UPDATE_LOCK_KEY, (Object)1, 300);
        if (!lockFlag.booleanValue()) {
            throw new BizException("INSU0001", "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u5f02\u5e38\u6570\u636e\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String calDateBegin = null;
        String calDateEnd = null;
        if (exceptionDto.getBeginDate() != null) {
            String beginDate = dateFormat.format(exceptionDto.getBeginDate());
            calDateBegin = beginDate.substring(0, 10) + " 00:00:00";
        }
        if (exceptionDto.getEndDate() != null) {
            String endDate = dateFormat.format(exceptionDto.getEndDate());
            calDateEnd = endDate.substring(0, 10) + " 23:59:59";
        }
        if ((errCount = this.reInsurancePremiumDas.getInsuranceCountByDate(calDateBegin, calDateEnd, exceptionDto)) == 0) {
            this.logger.info("\u4fdd\u8d39\u62a5\u8868\u66f4\u65b0\u65e5\u671f\u8d77:{},\u66f4\u65b0\u65e5\u671f\u6b62:{},\u5f02\u5e38\u6570\u636e\u6570\u4e3a0", (Object)calDateBegin, calDateEnd);
            return "\u4fdd\u8d39\u62a5\u8868\u4e8e\u8be5\u67e5\u8be2\u6761\u4ef6\u5185\u65e0\u5f02\u5e38\u6570\u636e\uff0c\u66f4\u65b0\u7ed3\u675f\u3002";
        }
        Integer errPremiumCount = 0;
        Integer billUpNum = 0;
        Integer billUpSuccNum = 0;
        Integer billUpErrNum = 0;
        Integer premiumUpSuccNum = 0;
        Integer premiumUpErrNum = 0;
        HashMap itemMaps = new HashMap();
        HashMap warehouseMaps = new HashMap();
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        HashMap costBelongMaps = new HashMap();
        HashMap insureMaps = new HashMap();
        Integer pageNum = 0;
        Integer pageSize = 1000;
        List billEoList = this.reInsurancePremiumDas.getInsuranceBillListByDate(exceptionDto, calDateBegin, calDateEnd, pageNum, pageSize);
        while (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            billUpNum = billUpNum + billEoList.size();
            for (ReInsuranceBillEo billEo : billEoList) {
                ReInsuranceBillEo billUpEo = new ReInsuranceBillEo();
                billUpEo.setId(billEo.getId());
                billUpEo.setUseInsuranceRate(billEo.getUseInsuranceRate());
                billUpEo.setCostBelongOrgId(billEo.getCostBelongOrgId());
                billUpEo.setCostBelongOrgName(billEo.getCostBelongOrgName());
                billUpEo.setOutOrganizationId(billEo.getOutOrganizationId());
                billUpEo.setOutOrganizationName(billEo.getOutOrganizationName());
                billUpEo.setInOrganizationId(billEo.getInOrganizationId());
                billUpEo.setInOrganizationName(billEo.getInOrganizationName());
                billUpEo.setUseAmountConfig(billEo.getUseAmountConfig());
                List outResultDetailList = this.reInsurancePremiumDas.getOutResultOrderDetailNotInPremium(billEo.getDocumentNo());
                ArrayList<ReInsurancePremiumEo> notInPremiumEos = new ArrayList<ReInsurancePremiumEo>();
                BigDecimal notAddQuantity = billEo.getQuantity() == null ? new BigDecimal(0) : billEo.getQuantity();
                for (OutResultOrderDetailEo notGenerateDetailEo : outResultDetailList) {
                    ReInsurancePremiumEo premiumEo = new ReInsurancePremiumEo();
                    CubeBeanUtils.copyProperties((Object)premiumEo, (Object)billEo, (boolean)false, (String[])new String[]{"id", "insureUnitPrice", "insureTotalPrice", "useInsuranceRate"});
                    premiumEo.setLongCode(notGenerateDetailEo.getSkuCode());
                    premiumEo.setCargoName(notGenerateDetailEo.getSkuName());
                    premiumEo.setQuantity(notGenerateDetailEo.getQuantity());
                    premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    notInPremiumEos.add(premiumEo);
                    notAddQuantity = notAddQuantity.add(notGenerateDetailEo.getQuantity());
                }
                if (CollectionUtils.isNotEmpty(notInPremiumEos)) {
                    this.reInsurancePremiumDas.insertBatch(notInPremiumEos);
                    billUpEo.setQuantity(notAddQuantity);
                }
                ArrayList<ReInsurancePremiumEo> premiumUpEoList = new ArrayList<ReInsurancePremiumEo>();
                List detailEoList = this.reInsurancePremiumDas.getReInsurancePremiumEo(billEo.getDocumentNo());
                StringBuilder billReason = new StringBuilder();
                BigDecimal insureTotalPrice = new BigDecimal("0");
                if (CollectionUtils.isEmpty((Collection)detailEoList)) {
                    String str = "\u66f4\u65b0\u4fdd\u8d39\u9519\u8bef,\u51fa\u5e93\u7ed3\u679c\u5355\u53f7:{" + billEo.getDocumentNo() + "}:\u65e0\u660e\u7ec6\u6570\u636e";
                    this.logger.warn(str);
                    billReason.append(str);
                    insureTotalPrice = null;
                }
                try {
                    LogicWarehouseEo logicWarehouseEo;
                    if (StringUtils.isNotBlank((CharSequence)billEo.getOutLogicWarehouseCode()) && ObjectUtils.isEmpty((Object)billEo.getOutOrganizationId())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(billEo.getOutLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            billUpEo.setOutOrganizationId(logicWarehouseEo.getOrganizationId());
                            billUpEo.setOutOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u51fa\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + billEo.getOutLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)billEo.getInLogicWarehouseCode()) && ObjectUtils.isEmpty((Object)billEo.getInOrganizationId())) {
                        logicWarehouseEo = this.reInsurancePremiumDas.getWarehouseOrgId(billEo.getInLogicWarehouseCode(), warehouseMaps);
                        if (ObjectUtils.isNotEmpty((Object)logicWarehouseEo)) {
                            billUpEo.setInOrganizationId(logicWarehouseEo.getOrganizationId());
                            billUpEo.setInOrganizationName(logicWarehouseEo.getOrganizationName());
                        } else {
                            billReason.append("[\u5165\u5e93\u903b\u8f91\u4ed3\u5e93\u7f16\u7801: " + billEo.getInLogicWarehouseCode() + " \u627e\u4e0d\u5230\u5176\u5f52\u5c5e\u7ec4\u7ec7]");
                        }
                    }
                    if (ObjectUtils.isEmpty((Object)billEo.getCostBelongOrgId())) {
                        CostBelongVo belongVo = this.reInsurancePremiumDas.getCostBelong(billEo.getOutLogicWarehouseCode(), billEo.getInLogicWarehouseCode(), costBelongMaps);
                        if (ObjectUtils.isEmpty((Object)belongVo)) {
                            if (!ObjectUtils.isEmpty((Object)billUpEo.getOutOrganizationId())) {
                                billUpEo.setCostBelongOrgId(billUpEo.getOutOrganizationId());
                                billUpEo.setCostBelongOrgName(billUpEo.getOutOrganizationName());
                            }
                        } else {
                            billUpEo.setCostBelongOrgId(belongVo.getCostBelongOrgId());
                            billUpEo.setCostBelongOrgName(belongVo.getCostBelongOrgName());
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
                        if (StringUtils.isBlank((CharSequence)billEo.getShippingCompany())) {
                            billEo.setShippingCompany(((ReInsurancePremiumEo)detailEoList.get(0)).getShippingCompany());
                        }
                        if (StringUtils.isBlank((CharSequence)billEo.getShippingCompanyCode())) {
                            billEo.setShippingCompanyCode(((ReInsurancePremiumEo)detailEoList.get(0)).getShippingCompanyCode());
                        }
                    }
                    List insureFeeList = this.reInsurancePremiumDas.getInsureFee(dateFormat.format(billEo.getInOutTime()), billEo.getShippingCompanyCode(), billEo.getShippingType(), insureMaps, billEo.getShippingCompany());
                    if (ObjectUtils.isEmpty((Object)billEo.getUseInsuranceRate())) {
                        String str = "[\u51fa\u5e93\u65e5\u671f:" + dateFormat.format(billEo.getInOutTime()) + ",\u7269\u6d41\u516c\u53f8:" + billEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + billEo.getShippingType();
                        if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                            billReason.append(str + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]");
                        } else if (insureFeeList.size() > 1) {
                            billReason.append(str + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]");
                        } else {
                            billUpEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
                        }
                    }
                    for (ReInsurancePremiumEo orderDetailEo : detailEoList) {
                        Integer n;
                        if (InsuranceFlagEnum.CORRECT.getCode().equals(orderDetailEo.getFlag())) {
                            if (!ObjectUtils.isNotEmpty((Object)insureTotalPrice)) continue;
                            insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(orderDetailEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                            continue;
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append(billReason.toString());
                        Integer n2 = errPremiumCount;
                        Integer n3 = errPremiumCount = Integer.valueOf(errPremiumCount + 1);
                        ReInsurancePremiumEo premiumUpEo = new ReInsurancePremiumEo();
                        premiumUpEo.setId(orderDetailEo.getId());
                        premiumUpEo.setItemType(orderDetailEo.getItemType());
                        premiumUpEo.setClaimPrice(orderDetailEo.getClaimPrice());
                        premiumUpEo.setUseDiscount(orderDetailEo.getUseDiscount());
                        premiumUpEo.setQuantity(orderDetailEo.getQuantity());
                        premiumUpEo.setInsureUnitPrice(orderDetailEo.getInsureUnitPrice());
                        premiumUpEo.setInsureTotalPrice(orderDetailEo.getInsureTotalPrice());
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getOutOrganizationId())) {
                            premiumUpEo.setOutOrganizationId(billUpEo.getOutOrganizationId());
                            premiumUpEo.setOutOrganizationName(billUpEo.getOutOrganizationName());
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getInOrganizationId())) {
                            premiumUpEo.setInOrganizationId(billUpEo.getInOrganizationId());
                            premiumUpEo.setInOrganizationName(billUpEo.getInOrganizationName());
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getCostBelongOrgId())) {
                            premiumUpEo.setCostBelongOrgId(billUpEo.getCostBelongOrgId());
                            premiumUpEo.setCostBelongOrgName(billUpEo.getCostBelongOrgName());
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getClaimPrice()) || orderDetailEo.getClaimPrice().compareTo(BigDecimal.ZERO) == 0 || ObjectUtils.isEmpty((Object)orderDetailEo.getItemType())) {
                            InsuranceItemVo itemEo = this.reInsurancePremiumDas.getPcpItemByLongCode(orderDetailEo.getLongCode(), itemMaps);
                            if (ObjectUtils.isEmpty((Object)itemEo)) {
                                builder.append("[\u5546\u54c1\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u957f\u7f16\u7801\u4e3a " + orderDetailEo.getLongCode() + " \u7684\u5546\u54c1]");
                            } else {
                                if (ObjectUtils.isEmpty((Object)orderDetailEo.getItemType())) {
                                    if (ObjectUtils.isEmpty((Object)itemEo.getItemType())) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + orderDetailEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a]");
                                    } else if (StringUtils.isBlank((CharSequence)SubTypeEnum.getSubTypeDesc((Integer)itemEo.getItemType()))) {
                                        builder.append("[\u5546\u54c1\u957f\u7f16\u7801\u4e3a " + orderDetailEo.getLongCode() + " \u7684\u5546\u54c1\u7c7b\u578b\u3010" + itemEo.getItemType() + "\u3011\u9519\u8bef\uff0c\u6b64\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728]");
                                    } else if (SubTypeEnum.GIFT.getType().intValue() == itemEo.getItemType().intValue()) {
                                        premiumUpEo.setItemType(Integer.valueOf(SubTypeEnum.PRODUCT.getType()));
                                    } else {
                                        premiumUpEo.setItemType(Integer.valueOf(itemEo.getItemType()));
                                    }
                                }
                                if (!ObjectUtils.isEmpty((Object)itemEo.getClaimPrice())) {
                                    premiumUpEo.setClaimPrice(itemEo.getClaimPrice());
                                }
                            }
                        }
                        if (ObjectUtils.isEmpty((Object)orderDetailEo.getUseDiscount())) {
                            if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                                builder.append("[\u627e\u4e0d\u5230\u5bf9\u5e94\u6709\u6548\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\uff0c\u6298\u6263\u4e0e\u8d39\u7387\u5747\u4e0d\u77e5]");
                            } else {
                                InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                                premiumUpEo.setLogisticsSetttingsId(feeVo.getId());
                                if (ObjectUtils.isNotEmpty((Object)premiumUpEo.getItemType())) {
                                    if (premiumUpEo.getLongCode().startsWith("A.A")) {
                                        premiumUpEo.setUseDiscount(feeVo.getProductDiscount());
                                    } else {
                                        premiumUpEo.setUseDiscount(feeVo.getMaterialDiscount());
                                    }
                                    premiumUpEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                                    billUpEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                                }
                            }
                        }
                        if (ObjectUtils.isNotEmpty((Object)premiumUpEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumUpEo.getUseDiscount())) {
                            premiumUpEo.setInsureUnitPrice(premiumUpEo.getClaimPrice().multiply(premiumUpEo.getUseDiscount()));
                            premiumUpEo.setInsureTotalPrice(Optional.ofNullable(premiumUpEo.getInsureUnitPrice()).orElse(BigDecimal.ZERO).multiply(premiumUpEo.getQuantity()));
                        }
                        insureTotalPrice = Optional.ofNullable(insureTotalPrice).orElse(BigDecimal.ZERO).add(Optional.ofNullable(premiumUpEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
                        premiumUpEo.setUpdateTime(new Date());
                        if (builder.length() > 0) {
                            premiumUpEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                            premiumUpEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            n3 = premiumUpErrNum;
                            n = premiumUpErrNum = Integer.valueOf(premiumUpErrNum + 1);
                        } else {
                            premiumUpEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                            premiumUpEo.setReason("");
                            n3 = premiumUpSuccNum;
                            n = premiumUpSuccNum = Integer.valueOf(premiumUpSuccNum + 1);
                        }
                        premiumUpEoList.add(premiumUpEo);
                    }
                    billUpEo.setInsureTotalPrice(insureTotalPrice);
                    if (ObjectUtils.isEmpty((Object)billEo.getUseAmountConfig())) {
                        if (ObjectUtils.isEmpty((Object)useAmountConfig)) {
                            billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
                        } else {
                            billUpEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                        }
                    }
                    if (ObjectUtils.isNotEmpty((Object)billUpEo.getInsureTotalPrice()) && ObjectUtils.isNotEmpty((Object)billUpEo.getUseInsuranceRate())) {
                        billUpEo.setInsureFee(billUpEo.getInsureTotalPrice().multiply(billUpEo.getUseInsuranceRate()));
                        if (ObjectUtils.isNotEmpty((Object)billUpEo.getUseAmountConfig()) && billUpEo.getInsureTotalPrice().compareTo(billUpEo.getUseAmountConfig()) < 0) {
                            billUpEo.setInsureFee(new BigDecimal("0"));
                        }
                    } else {
                        billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
                    }
                    billUpEo.setUpdateTime(new Date());
                }
                catch (Exception e) {
                    billReason.append(e.getMessage());
                    for (ReInsurancePremiumEo eo : premiumUpEoList) {
                        eo.setReason(eo.getReason() + "[" + e.getMessage() + "]");
                        eo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                    }
                    e.printStackTrace();
                }
                finally {
                    Object object;
                    Integer n;
                    if (billReason.length() > 0) {
                        billUpEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
                        billUpEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                        n = billUpErrNum;
                        billUpErrNum = billUpErrNum + 1;
                        object = billUpErrNum;
                    } else {
                        billUpEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                        billUpEo.setReason("");
                        n = billUpSuccNum;
                        billUpSuccNum = billUpSuccNum + 1;
                        object = billUpSuccNum;
                    }
                    this.billService.updateInsurePremiumAndBill(billUpEo, premiumUpEoList);
                }
            }
            pageNum = pageNum + pageSize;
            if (billEoList.size() < pageSize) {
                billEoList = null;
                continue;
            }
            billEoList.clear();
            billEoList = this.reInsurancePremiumDas.getInsuranceBillListByDate(exceptionDto, calDateBegin, calDateEnd, pageNum, pageSize);
        }
        this.cacheService.delCache(INSURANCE_UPDATE_LOCK_KEY);
        String msg = "\u6267\u884c\u66f4\u65b0\u5f02\u5e38\u6570\u636e\u5b8c\u6210:\u5f53\u524d\u5df2\u66f4\u65b0\u4fdd\u8d39\u660e\u7ec6\u5f02\u5e38\u6570\u636e" + errPremiumCount + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + premiumUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + premiumUpErrNum + "\u6761\uff1b\u5bf9\u5e94\u4fdd\u8d39\u8d26\u5355\u66f4\u65b0" + billUpNum + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + billUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + billUpErrNum + "\u6761\u3002";
        this.logger.info(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> updateInsuranceByLogistics(ReInsurancePremiumReportUpdateReqDto dto) {
        String msg;
        String updateEnd;
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u53ca\u8d26\u5355\u66f4\u65b0\uff1a{}", (Object)dto);
        Boolean lockFlag = this.cacheService.setCache(BILL_UPDATE_LOCK_KEY, (Object)1, 120);
        if (!lockFlag.booleanValue()) {
            throw new BizException("INSU0003", "\u5f53\u524d\u5df2\u6709\u4fdd\u8d39\u8d26\u5355\u6570\u636e\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u66f4\u65b0");
        }
        SimpleDateFormat updateFormat = new SimpleDateFormat("yyyy-MM");
        String updateBegin = dto.getUpdateTime() + "-01 00:00:00";
        Long i = this.reInsurancePremiumDas.clearByDate(updateBegin, updateEnd = dto.getUpdateTime() + "-30 23:59:59");
        if (i > 0L) {
            this.logger.info("\u65e5\u671f:{}\u5b58\u5728\u5df2\u5f52\u6863\u6570\u636e", (Object)dto.getUpdateTime());
            return new RestResponse("100000", "\u76f8\u5173\u6570\u636e\u5df2\u5f52\u6863,\u65e0\u6cd5\u751f\u6210");
        }
        Integer billCount = 0;
        Integer premiumCount = 0;
        Integer billUpSuccNum = 0;
        Integer billUpErrNum = 0;
        Integer premiumUpSuccNum = 0;
        Integer premiumUpErrNum = 0;
        DailyDeliveryReportListQueryDto listQueryDto = new DailyDeliveryReportListQueryDto();
        try {
            listQueryDto.setOrderShippingTimeStart(updateFormat.parse(updateBegin));
            listQueryDto.setOrderShippingTimeEnd(updateFormat.parse(updateEnd));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List eoList = this.iDailyDeliveryReportDas.pageQuery(listQueryDto);
        for (DailyDeliveryReportEo reportEo : eoList) {
            FinInsuranceSettingsEo insuranceEo;
            Date time;
            String transportCode;
            String shipCode = reportEo.getShipmentEnterpriseCode();
            FinLogisticsSettingsEo logisticsEo = this.finLogisticsSettingsDas.getBySomeType(shipCode, transportCode = reportEo.getTransportStyleCode(), time = reportEo.getOrderShippingTime());
            if (ObjectUtils.isEmpty((Object)logisticsEo) || LogisticsStatusEnum.INVALID.getStatus().equals(logisticsEo.getStatus()) || ObjectUtils.isEmpty((Object)(insuranceEo = (FinInsuranceSettingsEo)this.finInsuranceSettingsDas.selectByPrimaryKey(logisticsEo.getInsuranceId())))) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateBegin = dateFormat.format(logisticsEo.getEfffectiveTimeBegin()) + " 00:00:00";
            String dateEnd = dateFormat.format(logisticsEo.getEfffectiveTimeEnd()) + " 23:59:59";
            ReInsuranceBillEo searchBillEo = new ReInsuranceBillEo();
            CsShipmenetEnterpriseRespDto enterpriseRespDto = (CsShipmenetEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.icsShipmenetEnterpriseQueryApi.queryByPrimaryKey(Long.valueOf(logisticsEo.getShipmentEnterpriseCode())));
            if (enterpriseRespDto == null || StringUtils.isBlank((CharSequence)enterpriseRespDto.getShipmentEnterpriseCode())) continue;
            searchBillEo.setShippingCompanyCode(enterpriseRespDto.getShipmentEnterpriseCode());
            String shippingTypeName = CsShipmentLogisticsTypeEnum.formType((Integer)Integer.valueOf(logisticsEo.getLogisticsType()));
            searchBillEo.setShippingType(shippingTypeName);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.ge((String)"in_out_time", (Object)dateBegin));
            sqlFilters.add(SqlFilter.le((String)"in_out_time", (Object)dateEnd));
            searchBillEo.setOrderBy("in_out_time");
            searchBillEo.setSqlFilters(sqlFilters);
            Integer billNum = this.reInsuranceBillDas.count((BaseEo)searchBillEo);
            if (billNum == 0) {
                throw new BizException("RIP006", "\u4fdd\u8d39\u8d26\u5355\u66f4\u65b0\u5b8c\u6210\uff0c\u66f4\u65b0\u6570\u636e0\u6761");
            }
            searchBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
            Integer errBillNum = this.reInsuranceBillDas.count((BaseEo)searchBillEo);
            if (errBillNum > 0) {
                throw new BizException("RIP003", "\u4fdd\u8d39\u8d26\u5355\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u5728\u3010\u4fdd\u8d39\u660e\u7ec6\u3011\u9875\u9762-\u5904\u7406\u66f4\u65b0\u751f\u6548\u65e5\u671f\u8303\u56f4\u5185\u7684\u5f02\u5e38\u6570\u636e\u540e\u91cd\u8bd5");
            }
            Integer pageNum = 0;
            Integer pageSize = 1000;
            searchBillEo.setFlag(null);
            Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
            List billEoList = this.reInsuranceBillDas.selectList((BaseEo)searchBillEo, pageNum, pageSize);
            while (CollectionUtils.isNotEmpty((Collection)billEoList)) {
                for (ReInsuranceBillEo billEo : billEoList) {
                    Integer n = billCount;
                    Integer n2 = billCount = Integer.valueOf(billCount + 1);
                    if (billEo.getPlacedFlag() == 1) continue;
                    ReInsuranceBillEo billUpEo = new ReInsuranceBillEo();
                    billUpEo.setId(billEo.getId());
                    billUpEo.setUseInsuranceRate(insuranceEo.getInsuranceRate());
                    if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
                        billUpEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
                    } else {
                        billUpEo.setUseAmountConfig(billEo.getUseAmountConfig());
                    }
                    BigDecimal insureTotalPrice = new BigDecimal("0");
                    ArrayList<ReInsurancePremiumEo> premiumUpEoList = new ArrayList<ReInsurancePremiumEo>();
                    List detailEoList = this.reInsurancePremiumDas.getReInsurancePremiumEo(billEo.getDocumentNo());
                    try {
                        for (ReInsurancePremiumEo orderDetailEo : detailEoList) {
                            Integer n3 = premiumCount;
                            Integer n4 = premiumCount = Integer.valueOf(premiumCount + 1);
                            ReInsurancePremiumEo premiumUpEo = new ReInsurancePremiumEo();
                            premiumUpEo.setId(orderDetailEo.getId());
                            if (SubTypeEnum.PRODUCT.getType().equals(orderDetailEo.getItemType())) {
                                premiumUpEo.setUseDiscount(logisticsEo.getProductDiscount());
                            } else if (SubTypeEnum.MATERIEL.getType().equals(orderDetailEo.getItemType())) {
                                premiumUpEo.setUseDiscount(logisticsEo.getMaterialDiscount());
                            }
                            premiumUpEo.setUseInsuranceRate(insuranceEo.getInsuranceRate());
                            billUpEo.setUseInsuranceRate(insuranceEo.getInsuranceRate());
                            premiumUpEo.setInsureUnitPrice(Optional.ofNullable(orderDetailEo.getClaimPrice()).orElse(BigDecimal.ZERO).multiply(Optional.ofNullable(premiumUpEo.getUseDiscount()).orElse(BigDecimal.ZERO)));
                            premiumUpEo.setInsureTotalPrice(Optional.ofNullable(premiumUpEo.getInsureUnitPrice()).orElse(BigDecimal.ZERO).multiply(orderDetailEo.getQuantity()));
                            insureTotalPrice = insureTotalPrice.add(premiumUpEo.getInsureTotalPrice());
                            premiumUpEo.setUpdateTime(new Date());
                            premiumUpEoList.add(premiumUpEo);
                        }
                        billUpEo.setInsureTotalPrice(insureTotalPrice);
                        if (insureTotalPrice.compareTo(billUpEo.getUseAmountConfig()) >= 0) {
                            billUpEo.setInsureFee(billUpEo.getInsureTotalPrice().multiply(billUpEo.getUseInsuranceRate()));
                        } else {
                            billUpEo.setInsureFee(new BigDecimal("0"));
                        }
                        billUpEo.setUpdateTime(new Date());
                    }
                    catch (Exception e) {
                        billUpEo.setReason(e.getMessage());
                        e.printStackTrace();
                        msg = e.getMessage();
                    }
                    finally {
                        Integer n5;
                        Object object;
                        if (StringUtils.isNotBlank((CharSequence)billUpEo.getReason())) {
                            billUpEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            for (Object eo : premiumUpEoList) {
                                eo.setReason(billUpEo.getReason());
                                eo.setFlag(InsuranceFlagEnum.ERROR.getCode());
                            }
                            premiumUpErrNum = premiumUpErrNum + premiumUpEoList.size();
                            object = billUpErrNum;
                            n5 = billUpErrNum = Integer.valueOf(billUpErrNum + 1);
                        } else {
                            premiumUpSuccNum = premiumUpSuccNum + premiumUpEoList.size();
                            object = billUpSuccNum;
                            n5 = billUpSuccNum = Integer.valueOf(billUpSuccNum + 1);
                        }
                        this.billService.updateInsurePremiumAndBill(billUpEo, premiumUpEoList);
                    }
                }
                pageNum = pageNum + pageSize;
                if (billEoList.size() < pageSize) {
                    billEoList = null;
                    continue;
                }
                billEoList.clear();
                billEoList = this.reInsuranceBillDas.selectList((BaseEo)searchBillEo, pageNum, pageSize);
            }
        }
        this.cacheService.delCache(BILL_UPDATE_LOCK_KEY);
        msg = "\u6267\u884c\u66f4\u65b0\u8d26\u5355\u6570\u636e\u5b8c\u6210:\u5f53\u524d\u5df2\u66f4\u65b0\u4fdd\u8d39\u660e\u7ec6\u6570\u636e" + premiumCount + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + premiumUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + premiumUpErrNum + "\u6761\uff1b\u5bf9\u5e94\u4fdd\u8d39\u8d26\u5355\u66f4\u65b0" + billCount + "\u6761\uff0c\u66f4\u65b0\u6210\u529f" + billUpSuccNum + "\u6761\uff0c\u66f4\u65b0\u5931\u8d25" + billUpErrNum + "\u6761\u3002";
        if (billUpErrNum > 0) {
            msg = msg + "\u8bf7\u67e5\u770b\u5177\u4f53\u539f\u56e0\u91cd\u65b0\u4fee\u6b63\u540e\uff0c\u751f\u6210\u660e\u7ec6\u518d\u66f4\u65b0\u8d26\u5355";
        }
        this.logger.info(msg);
        return new RestResponse((Object)msg);
    }

    private void getCommonOtherData(ReInsuranceBillEo insuranceBillEo, Map<String, InsuranceCustomerInfoVo> physicsWareMap, Map<String, String> startPlaceMap) {
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)insuranceBillEo.getBusinessType());
        switch (typeEnum) {
            case ORDER_SALES_OUT: 
            case BAIJIAN_DIRECT_SALES: 
            case AGENCY_ORDER: {
                InsuranceCustomerInfoVo cusInfoVo = this.reInsurancePremiumDas.getOrderSalesOutData(insuranceBillEo.getRelevanceNo());
                if (cusInfoVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)cusInfoVo, (String[])new String[0]);
                break;
            }
            case OTHER_OUT: {
                InsuranceCustomerInfoVo otherOutVo = this.reInsurancePremiumDas.getOtherOutData(insuranceBillEo.getRelevanceNo());
                if (otherOutVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)otherOutVo, (String[])new String[0]);
                break;
            }
            case OUTSOURCE_REFUND: 
            case PURCHASE_REFUND: {
                InsuranceCustomerInfoVo refundVo = this.reInsurancePremiumDas.getOutResourceAndPurchaseRefundData(insuranceBillEo.getRelevanceNo());
                if (refundVo == null) break;
                insuranceBillEo.setOrderRemark(refundVo.getOrderRemark());
                insuranceBillEo.setExternalOrderNo(refundVo.getExternalOrderNo());
                break;
            }
            case ALLOT_OUT: 
            case ALLOT_OUT_ONLY: {
                InsuranceCustomerInfoVo allotOutVo = this.reInsurancePremiumDas.getAllotOutData(insuranceBillEo.getRelevanceNo(), physicsWareMap);
                if (allotOutVo == null) break;
                CubeBeanUtils.copyProperties((Object)insuranceBillEo, (Object)allotOutVo, (String[])new String[0]);
                break;
            }
            default: {
                insuranceBillEo.setRemark("\u83b7\u53d6\u5ba2\u6237\u5730\u5740\u3001\u5ba2\u6237\u540d\u79f0\u3001\u5916\u90e8\u5355\u53f7\u7b49\u6269\u5c55\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\u662f\u7c7b\u578b\u9519\u8bef\uff0c\u8be5\u7c7b\u578b\u3010" + insuranceBillEo.getBusinessType() + "\u3011\u4e0d\u5b58\u5728");
            }
        }
        insuranceBillEo.setStartPlace(this.reInsurancePremiumDas.getStartPlace(insuranceBillEo.getOutLogicWarehouseCode(), startPlaceMap));
        if (StringUtils.isNotBlank((CharSequence)insuranceBillEo.getDocumentNo())) {
            ConsignmentOrderAddressEo addressEo = this.reInsurancePremiumDas.queryAddress(insuranceBillEo.getDocumentNo());
            if (ObjectUtils.isNotEmpty((Object)addressEo)) {
                insuranceBillEo.setCustomerAddress(addressEo.getDetailAddress());
            } else {
                insuranceBillEo.setCustomerAddress(null);
            }
        }
    }

    @Override
    public String clearInsuranceByDate(ReInsurancePremiumReqDto reqDto) {
        List billEoList;
        List premiumEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsurancePremiumDas.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).list();
        if (CollectionUtils.isNotEmpty((Collection)premiumEoList)) {
            List ids = premiumEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsurancePremiumDas.logicDeleteByIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(billEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsuranceBillDas.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).list()))) {
            List ids = billEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsuranceBillDas.logicDeleteByIds(ids);
        }
        return null;
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4fdd\u8d39\u660e\u7ec6\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumEo updateEo = new ReInsurancePremiumEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List reInsurancePremiumEos = this.reInsurancePremiumDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = reInsurancePremiumEos.stream().filter(e -> e.getPlacedFlag() == null || e.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.reInsurancePremiumDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        this.logger.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillOrg(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fee\u6539\u4fdd\u8d39\u660e\u7ec6\u8ba1\u8d39\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)reqDto.getId()), (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumEo premiumEo = (ReInsurancePremiumEo)this.reInsurancePremiumDas.selectByPrimaryKey(reqDto.getId());
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)premiumEo), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        premiumEo.setCostBelongOrgCode(reqDto.getBillOrgCode());
        premiumEo.setCostBelongOrgName(reqDto.getBillOrgName());
        premiumEo.setOrderRemark(reqDto.getOrderRemark());
        premiumEo.setRemark(reqDto.getOrderRemark());
        this.reInsurancePremiumDas.updateSelective((BaseEo)premiumEo);
    }

    @Override
    public void generateInsuranceReportImport(ReInsuranceBillReqDto billReqDto) {
        int billQuotaVerify;
        String str;
        this.logger.info("\u5bfc\u5165\u751f\u6210\u4fdd\u8d39\u660e\u7ec6\u548c\u8d26\u5355\u62a5\u8868\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)billReqDto));
        ReInsuranceBillEo insuranceBillEo = (ReInsuranceBillEo)BeanUtil.copyProperties((Object)billReqDto, ReInsuranceBillEo.class, (String[])new String[0]);
        StringBuilder billReason = new StringBuilder();
        InsuranceFeeVo insuranceFeeVo = null;
        String orderShippingTime = DateUtil.getDateFormat((Date)insuranceBillEo.getInOutTime(), (String)"yyyy-MM-dd");
        HashMap insureMaps = new HashMap();
        List insureFeeList = this.reInsurancePremiumDas.getInsureFee(orderShippingTime, insuranceBillEo.getShippingCompanyCode(), insuranceBillEo.getShippingType(), insureMaps, insuranceBillEo.getShippingCompany());
        if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
            str = "[\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]";
            billReason.append(str);
        } else if (insureFeeList.size() > 1) {
            str = "[\u7269\u6d41\u516c\u53f8:" + insuranceBillEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + insuranceBillEo.getShippingType() + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]";
            billReason.append(str);
        } else {
            insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
            insuranceBillEo.setUseInsuranceRate(((InsuranceFeeVo)insureFeeList.get(0)).getInsuranceRate());
            this.logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insuranceFeeVo));
        }
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal insureTotalPrice = BigDecimal.ZERO;
        ArrayList<ReInsurancePremiumEo> premiumEoList = new ArrayList<ReInsurancePremiumEo>();
        for (ReInsurancePremiumReqDto reqDto : billReqDto.getPremiumReqDtoList()) {
            ReInsurancePremiumEo premiumEo = (ReInsurancePremiumEo)BeanUtil.copyProperties((Object)reqDto, ReInsurancePremiumEo.class, (String[])new String[0]);
            premiumEo.setId(null);
            premiumEo.setIfApportion(YesOrNoEnum.NO.getCode());
            StringBuilder builder = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)insureFeeList) && insureFeeList.size() == 1) {
                InsuranceFeeVo feeVo = (InsuranceFeeVo)insureFeeList.get(0);
                premiumEo.setLogisticsSetttingsId(feeVo.getId());
                if (ObjectUtils.isEmpty((Object)premiumEo.getItemType())) {
                    builder.append("[\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u5b9a\u4f7f\u7528\u4ea7\u54c1\u6298\u6263\u6216\u7269\u6599\u6298\u6263]");
                } else {
                    if (premiumEo.getLongCode().startsWith("A.A")) {
                        premiumEo.setUseDiscount(feeVo.getProductDiscount());
                    } else {
                        premiumEo.setUseDiscount(feeVo.getMaterialDiscount());
                    }
                    premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
                }
            }
            this.logger.info("\u8ba1\u7b97\u6295\u4fdd\u5355\u4ef7");
            if (ObjectUtils.isNotEmpty((Object)premiumEo.getClaimPrice()) && ObjectUtils.isNotEmpty((Object)premiumEo.getUseDiscount())) {
                premiumEo.setInsureUnitPrice(premiumEo.getClaimPrice().multiply(premiumEo.getUseDiscount()).setScale(6, RoundingMode.DOWN));
                premiumEo.setInsureTotalPrice(premiumEo.getInsureUnitPrice().multiply(premiumEo.getQuantity()).setScale(6, RoundingMode.DOWN));
            }
            if (null == premiumEo.getUseDiscount() || null == premiumEo.getInsureUnitPrice()) {
                builder.append("[\u6295\u4fdd\u4ef7\u6216\u6298\u6263\u4e3a\u7a7a]");
            }
            insureTotalPrice = insureTotalPrice.add(Optional.ofNullable(premiumEo.getInsureTotalPrice()).orElse(BigDecimal.ZERO));
            quantity = quantity.add(premiumEo.getQuantity());
            if (builder.length() > 0) {
                premiumEo.setReason(builder.toString().replaceAll("null", "\u4e3a\u7a7a"));
                premiumEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
            } else {
                premiumEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
            }
            premiumEoList.add(premiumEo);
        }
        insuranceBillEo.setQuantity(quantity);
        insuranceBillEo.setInsureTotalPrice(insureTotalPrice);
        insuranceBillEo.setBillingFeeFlag(Integer.valueOf(1));
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        this.logger.info("\u8ba1\u7b97\u4fdd\u8d39\u8d26\u5355\u7684\u4fdd\u8d39");
        int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
        if (ObjectUtils.isNotEmpty((Object)useAmountConfig)) {
            insuranceBillEo.setUseAmountConfig(new BigDecimal(useAmountConfig));
            if (ObjectUtils.isNotEmpty((Object)insureTotalPrice) && ObjectUtils.isNotEmpty((Object)insuranceBillEo.getUseInsuranceRate())) {
                if (insureTotalPrice.compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                    insuranceBillEo.setInsureFee(insuranceBillEo.getInsureTotalPrice().multiply(insuranceBillEo.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                } else {
                    insuranceBillEo.setInsureFee(new BigDecimal("0"));
                }
            } else {
                billReason.append("[\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\uff0c\u6216\u8d39\u7387\u4e3a\u7a7a]");
            }
        } else {
            billReason.append("[\u7cfb\u7edf\u914d\u7f6e\u7684\u6700\u5927\u4fdd\u8d39\u91d1\u989d\u4e0d\u5b58\u5728]");
        }
        if (billReason.length() > 0) {
            insuranceBillEo.setReason(billReason.toString().replaceAll("null", "\u4e3a\u7a7a"));
            insuranceBillEo.setFlag(InsuranceFlagEnum.ERROR.getCode());
        } else {
            insuranceBillEo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
        }
        insuranceBillEo.setPremiumEoList(premiumEoList);
        this.reInsurancePremiumDas.insertBatch(premiumEoList);
    }

    @Override
    public List<InsuranceItemVo> getPcpItemByLongCode(List<String> longCodes) {
        return this.reInsurancePremiumDas.getPcpItemByLongCode(longCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByIds(List<Long> ids) {
        this.logger.info("\u5220\u9664\u4fdd\u8d39\u8d39\u7528\uff1a{}", ids);
        List premiumEoList = this.reInsurancePremiumDas.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)premiumEoList)) {
            return;
        }
        List placedFlagList = premiumEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(placedFlagList), (String)"\u5b58\u5728\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u5220\u9664");
        premiumEoList.forEach(premiumEo -> {
            if (ObjectUtils.isNotEmpty((Object)premiumEo.getBillId())) {
                List premiumEos;
                ReInsuranceBillEo billEo = (ReInsuranceBillEo)this.reInsuranceBillDas.selectByPrimaryKey(premiumEo.getBillId());
                if (ObjectUtils.isNotEmpty((Object)billEo)) {
                    this.reInsuranceBillDas.logicDeleteById(billEo.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)(premiumEos = ((ExtQueryChainWrapper)this.reInsurancePremiumDas.filter().eq((Object)"bill_id", (Object)premiumEo.getBillId())).list()))) {
                    List pIds = premiumEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.reInsurancePremiumDas.logicDeleteByIds(pIds);
                }
            } else {
                this.reInsurancePremiumDas.logicDeleteById(premiumEo.getId());
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ignoreExcByIds(List<Long> ids) {
        this.logger.info("\u5ffd\u7565\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(ids));
        List premiumEoList = this.reInsurancePremiumDas.selectByIds(ids);
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)premiumEoList), (String)"\u627e\u4e0d\u5230\u660e\u7ec6\u4fe1\u606f");
        List placedFlagList = premiumEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(placedFlagList), (String)"\u5b58\u5728\u660e\u7ec6\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        List billIds = premiumEoList.stream().map(ReInsurancePremiumEo::getBillId).filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
        List billEoList = this.reInsuranceBillDas.selectByIds(billIds);
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            List billPlacedFlagList = billEoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getPlacedFlag()) && f.getPlacedFlag() == 1).collect(Collectors.toList());
            AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty(billPlacedFlagList), (String)"\u5b58\u5728\u5355\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        premiumEoList.forEach(eo -> {
            eo.setReason("");
            eo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
            this.reInsurancePremiumDas.updateSelective((BaseEo)eo);
        });
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            billEoList.forEach(eo -> {
                eo.setReason("");
                eo.setFlag(InsuranceFlagEnum.CORRECT.getCode());
                this.reInsuranceBillDas.updateSelective((BaseEo)eo);
            });
        }
    }

    @Override
    public List<ReInsurancePremiumRespDto> queryByIds(List<Long> ids) {
        List premiumEoList = this.reInsurancePremiumDas.selectByIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)premiumEoList)) {
            return BeanUtil.copyToList((Collection)premiumEoList, ReInsurancePremiumRespDto.class);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ReInsurancePremiumRespDto> queryList(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u67e5\u8be2\u4fdd\u8d39\u660e\u7ec6\u5217\u8868\u4fe1\u606fqueryList\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)reqDto.getInOutTimeBegin()) || ObjectUtils.isEmpty((Object)reqDto.getInOutTimeEnd()) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4fdd\u8d39\u660e\u7ec6\u5217\u8868\u4fe1\u606f\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        List premiumEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsurancePremiumDas.filter().ge((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le((Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).eq(ObjectUtils.isNotEmpty((Object)reqDto.getIfApportion()), (Object)"if_apportion", (Object)reqDto.getIfApportion())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingCompanyList()), (Object)"shipping_company", (Collection)reqDto.getShippingCompanyList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingTypeList()), (Object)"shipping_type", (Collection)reqDto.getShippingTypeList())).list();
        return BeanUtil.copyToList((Collection)premiumEoList, ReInsurancePremiumRespDto.class);
    }

    private InsuranceFeeVo matchUseInsuranceRate(ReInsurancePremiumEo premiumEo, List<InsuranceFeeVo> feeVoList) {
        this.logger.info("\u5339\u914d\u8d39\u7387\uff1a{}", (Object)JSON.toJSONString((Object)premiumEo));
        if (CollectionUtils.isEmpty(feeVoList)) {
            this.premiumFlag(Boolean.TRUE, premiumEo, "\u6ca1\u6709\u8d39\u7387\u4fe1\u606f");
            return null;
        }
        Integer shippingTypeCode = CsShipmentLogisticsTypeEnum.formDesc((String)premiumEo.getShippingType());
        InsuranceFeeVo feeVo = new InsuranceFeeVo();
        int i = 0;
        for (InsuranceFeeVo vo : feeVoList) {
            this.logger.info("\u5408\u540c\u751f\u6548\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u5408\u540c\u751f\u6548\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u660e\u7ec6\u51fa\u5e93\u65f6\u95f4\uff1a{}\uff0c\u5408\u540c\u7269\u6d41\u516c\u53f8\u7f16\u7801\u5bf9\u5e94\u660e\u7ec6\uff1a{}-{}\uff0c\u5408\u540c\u627f\u8fd0\u65b9\u5f0f\u5bf9\u5e94\u660e\u7ec6\uff1a{}-{}", new Object[]{vo.getEfffectiveTimeBegin(), vo.getEfffectiveTimeEnd(), premiumEo.getInOutTime(), vo.getShipmentEnterpriseCode(), premiumEo.getShippingCompanyCode(), vo.getLogisticsType(), shippingTypeCode});
            if (premiumEo.getInOutTime().compareTo(vo.getEfffectiveTimeBegin()) < 0 || premiumEo.getInOutTime().compareTo(vo.getEfffectiveTimeEnd()) > 0 || !premiumEo.getShippingCompanyCode().equals(vo.getShipmentEnterpriseCode()) || !shippingTypeCode.toString().equals(vo.getLogisticsType())) continue;
            feeVo = vo;
            ++i;
        }
        String str = "\u7269\u6d41\u516c\u53f8:" + premiumEo.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + premiumEo.getShippingType();
        if (i == 0) {
            this.premiumFlag(Boolean.TRUE, premiumEo, str + "\u6ca1\u6709\u5339\u914d\u5230\u8d39\u7387\u4fe1\u606f");
            return null;
        }
        if (i > 1) {
            this.premiumFlag(Boolean.TRUE, premiumEo, str + "\u5339\u914d\u5230\u591a\u4e2a\u8d39\u7387\u4fe1\u606f");
            return null;
        }
        premiumEo.setUseInsuranceRate(feeVo.getInsuranceRate());
        premiumEo.setLogisticsSetttingsId(feeVo.getId());
        return feeVo;
    }

    private boolean premiumFlag(boolean flag, ReInsurancePremiumEo premiumEo, String mes) {
        if (flag) {
            if (StringUtils.isBlank((CharSequence)premiumEo.getReason())) {
                premiumEo.setReason(mes);
            } else {
                premiumEo.setReason(premiumEo.getReason() + "\uff1b" + mes);
            }
        }
        return flag;
    }
}

