/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.datalimit.service.IDataLimitRuleQueryService;
import com.dtyunxi.tcbj.api.dto.request.ClaimOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.GetPurchaseReturnOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.ClaimOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.GiftPackageExtDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReportTabCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderReportExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.OutPlannedOrderVO;
import com.dtyunxi.tcbj.biz.service.query.ITransferOrderReportQueryService;
import com.dtyunxi.tcbj.dao.das.OrganizationDas;
import com.dtyunxi.tcbj.dao.das.QualityInspectionDataDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferOrderReportQueryServiceImpl
implements ITransferOrderReportQueryService {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderReportQueryServiceImpl.class);
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Autowired
    IDataLimitRuleQueryService dataLimitRuleQueryService;
    @Autowired
    IContext context;
    @Resource
    private QualityInspectionDataDas qualityInspectionDataDas;
    @Resource
    private OrganizationDas organizationDas;

    @Override
    public PageInfo<TransferOrderReportRespDto> internalDealReportPage(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        return this.reTransferOrderDas.internalDealList(reqDto);
    }

    @Override
    public PageInfo<TransferOrderReportRespDto> internalDealOutReportPage(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u5df2\u51fa\u5e93\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        return this.reTransferOrderDas.internalDealOutList(reqDto);
    }

    @Override
    public ReportTabCountRespDto internalDealReportCount(TransferOrderReportReqDto reqDto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u62a5\u8868tab\u6570\u91cf\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ReportTabCountRespDto respDto = new ReportTabCountRespDto();
        respDto.setTotalCount(Long.valueOf(0L));
        respDto.setOutCount(Long.valueOf(0L));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        PageInfo<TransferOrderReportRespDto> transferOrderReportRespDtoPageInfo = this.internalDealReportPage(reqDto);
        respDto.setTotalCount(Long.valueOf(transferOrderReportRespDtoPageInfo.getTotal()));
        PageInfo<TransferOrderReportRespDto> transferOrderDetailOutReportPage = this.internalDealOutReportPage(reqDto);
        respDto.setOutCount(Long.valueOf(transferOrderDetailOutReportPage.getTotal()));
        return respDto;
    }

    @Override
    public PageInfo<TransferOrderReportRespDto> transferOrderDetailReportPage(TransferOrderReportReqDto reqDto) {
        List transferOrders;
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setExcludeTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        PageInfo transferOrderReportRespDtoPageInfo = this.reTransferOrderDas.transferOrderDetailReportPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReportRespDtoPageInfo.getList()) && CollectionUtils.isNotEmpty(transferOrders = transferOrderReportRespDtoPageInfo.getList().stream().filter(f -> f.getTransferOrderNo().substring(0, 2).equals("TP")).map(TransferOrderReportRespDto::getTransferOrderNo).collect(Collectors.toList()))) {
            List easOrderNoList = this.reTransferOrderDas.queryTpEasOrderNo(transferOrders);
            Map map = Optional.ofNullable(easOrderNoList).map(m -> m.stream().collect(Collectors.toMap(TransferOrderReportRespDto::getTransferOrderNo, TransferOrderReportRespDto::getEasNo, (o, o1) -> o))).orElse(new HashMap());
            transferOrderReportRespDtoPageInfo.getList().forEach(info -> info.setEasNo((String)map.get(info.getTransferOrderNo())));
        }
        return transferOrderReportRespDtoPageInfo;
    }

    @Override
    public PageInfo<TransferOrderReportRespDto> transferOrderDetailOutReportPage(TransferOrderReportReqDto reqDto) {
        List transferOrders;
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u5df2\u51fa\u5e93\u62a5\u8868\u5206\u9875\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setExcludeTypes((List)Lists.newArrayList((Object[])new String[]{"internal_deal", "internal_deal_return", "sale_return_internal_deal"}));
        PageInfo transferOrderReportRespDtoPageInfo = this.reTransferOrderDas.transferOrderDetailOutReportPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReportRespDtoPageInfo.getList()) && CollectionUtils.isNotEmpty(transferOrders = transferOrderReportRespDtoPageInfo.getList().stream().filter(f -> f.getTransferOrderNo().substring(0, 2).equals("TP")).map(TransferOrderReportRespDto::getTransferOrderNo).collect(Collectors.toList()))) {
            List easOrderNoList = this.reTransferOrderDas.queryTpEasOrderNo(transferOrders);
            Map map = Optional.ofNullable(easOrderNoList).map(m -> m.stream().collect(Collectors.toMap(TransferOrderReportRespDto::getTransferOrderNo, TransferOrderReportRespDto::getEasNo, (o, o1) -> o))).orElse(new HashMap());
            transferOrderReportRespDtoPageInfo.getList().forEach(info -> info.setEasNo((String)map.get(info.getTransferOrderNo())));
        }
        return transferOrderReportRespDtoPageInfo;
    }

    @Override
    public ReportTabCountRespDto transferOrderDetailReportCount(TransferOrderReportReqDto reqDto) {
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u62a5\u8868tab\u6570\u91cf\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ReportTabCountRespDto respDto = new ReportTabCountRespDto();
        respDto.setTotalCount(Long.valueOf(0L));
        respDto.setOutCount(Long.valueOf(0L));
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1));
        PageInfo<TransferOrderReportRespDto> transferOrderReportRespDtoPageInfo = this.transferOrderDetailReportPage(reqDto);
        respDto.setTotalCount(Long.valueOf(transferOrderReportRespDtoPageInfo.getTotal()));
        PageInfo<TransferOrderReportRespDto> transferOrderDetailOutReportPage = this.transferOrderDetailOutReportPage(reqDto);
        respDto.setOutCount(Long.valueOf(transferOrderDetailOutReportPage.getTotal()));
        return respDto;
    }

    @Override
    public PageInfo<OutPlannedOrderVO> purchaseReturnDetailReportPage(GetPurchaseReturnOrderListPageParams req) {
        logger.info("\u91c7\u8d2d\u9000\u8d27\u8ba2\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        req.setOrderType(CsPlannedOrderTypeEnum.PURCHASE_RETREAT.getCode());
        return this.reTransferOrderDas.purchaseReturnDetailReportPage(req);
    }

    @Override
    public PageInfo<TransferOrderReportExtRespDto> transferOrderDetailReportExtPage(TransferOrderReportExtReqDto reqDto) {
        logger.info("\u8c03\u62e8\u5355\u660e\u7ec6\u5206\u9875\u67e5\u8be2EXT\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo transferOrderReportExtRespDtoPageInfo = this.reTransferOrderDas.transferOrderDetailReportExtPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)transferOrderReportExtRespDtoPageInfo.getList())) {
            List inOrganizationIds;
            List codeList = transferOrderReportExtRespDtoPageInfo.getList().stream().map(TransferOrderReportExtRespDto::getLongCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            List batchList = transferOrderReportExtRespDtoPageInfo.getList().stream().map(TransferOrderReportExtRespDto::getBatch).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(codeList) || CollectionUtils.isEmpty(batchList)) {
                return transferOrderReportExtRespDtoPageInfo;
            }
            GiftPackageExtDto extDto = new GiftPackageExtDto();
            extDto.setProNoList(codeList);
            extDto.setLotList(batchList);
            List giftPackageInfoExtDtoList = this.reTransferOrderDas.queryGiftPackageInfo(extDto);
            Map giftPackageMap = Optional.ofNullable(giftPackageInfoExtDtoList).map(m -> giftPackageInfoExtDtoList.stream().collect(Collectors.groupingBy(g -> g.getProNo() + "-" + g.getLot()))).orElse(new HashMap());
            Map qualityInspectionDataMap = new HashMap();
            List qualityInspectionDataEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.qualityInspectionDataDas.filter().in((Object)"long_code", codeList)).in((Object)"batch", batchList)).list();
            if (!CollectionUtils.isEmpty((Collection)qualityInspectionDataEoList)) {
                List qualityInspectionDataRespDtoList = BeanUtil.copyToList((Collection)qualityInspectionDataEoList, QualityInspectionDataRespDto.class);
                qualityInspectionDataMap = Optional.ofNullable(qualityInspectionDataRespDtoList).map(m -> qualityInspectionDataRespDtoList.stream().collect(Collectors.groupingBy(g -> g.getLongCode() + "-" + g.getBatch()))).orElse(new HashMap());
            }
            Map orgMap = new HashMap();
            List organizationIds = new ArrayList();
            List outOrganizationIds = transferOrderReportExtRespDtoPageInfo.getList().stream().map(TransferOrderReportExtRespDto::getOutOrganizationId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(organizationIds)) {
                organizationIds.addAll(outOrganizationIds);
            }
            if (CollectionUtils.isNotEmpty(inOrganizationIds = transferOrderReportExtRespDtoPageInfo.getList().stream().map(TransferOrderReportExtRespDto::getInOrganizationId).collect(Collectors.toList()))) {
                organizationIds.addAll(inOrganizationIds);
            }
            organizationIds = organizationIds.stream().distinct().collect(Collectors.toList());
            List organizationEos = this.organizationDas.selectByIds(organizationIds);
            orgMap = Optional.ofNullable(organizationEos).map(eos -> eos.stream().collect(Collectors.toMap(BaseEo::getId, OrganizationEo::getCode, (o, o1) -> o))).orElse(new HashMap());
            Map finalQualityInspectionDataMap = qualityInspectionDataMap;
            Map finalOrgMap = orgMap;
            transferOrderReportExtRespDtoPageInfo.getList().forEach(info -> {
                if (StringUtils.isNotBlank((CharSequence)info.getBatch()) && StringUtils.isNotBlank((CharSequence)info.getLongCode())) {
                    info.setGiftPackageInfoExtDtoList((List)giftPackageMap.get(info.getLongCode() + "-" + info.getBatch()));
                    info.setQualityInspectionDataRespDtoList((List)finalQualityInspectionDataMap.get(info.getLongCode() + "-" + info.getBatch()));
                    if (ObjectUtil.isNotEmpty((Object)info.getOutOrganizationId())) {
                        info.setOutOrganizationCode((String)finalOrgMap.get(info.getOutOrganizationId()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)info.getInOrganizationId())) {
                        info.setInOrganizationCode((String)finalOrgMap.get(info.getInOrganizationId()));
                    }
                }
            });
        }
        return transferOrderReportExtRespDtoPageInfo;
    }

    @Override
    public PageInfo<ClaimOrderDetailRespDto> claimOrderDetailReportPage(ClaimOrderDetailReqDto req) {
        logger.info("\u7d22\u8d54\u8ba2\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        return this.reTransferOrderDas.claimOrderDetailReportPage(req);
    }
}

