/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.utils;

import com.dtyunxi.exceptions.BizException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class DateUtil {
    private static final String formatStr = "yyyy-mm-dd";

    public static String formatYM(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        return dateFormat.format(date);
    }

    public static String addOneDay(String dateStr) {
        try {
            Date parse = new SimpleDateFormat(formatStr).parse(dateStr);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(parse);
            ((Calendar)calendar).add(5, 1);
            parse = calendar.getTime();
            return new SimpleDateFormat(formatStr).format(parse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("-1", e.getMessage());
        }
    }

    public static String reduceOneDay(String dateStr) throws ParseException {
        Date parse = new SimpleDateFormat(formatStr).parse(dateStr);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parse);
        ((Calendar)calendar).add(5, -1);
        parse = calendar.getTime();
        return new SimpleDateFormat(formatStr).format(parse);
    }

    public static Map<String, Date> getDealTimeScope(String bookkeepingMonth) {
        YearMonth yearMonthObject = YearMonth.parse(bookkeepingMonth);
        LocalDateTime startOfMonth = yearMonthObject.atDay(1).atStartOfDay();
        LocalDateTime endOfMonth = yearMonthObject.atEndOfMonth().atTime(23, 59, 59);
        Date startDate = Date.from(startOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(endOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        HashMap<String, Date> resultMap = new HashMap<String, Date>();
        resultMap.put("startDate", startDate);
        resultMap.put("endDate", endDate);
        return resultMap;
    }
}

