/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.tcbj.api.dto.response.BrotherCustomerShopRespDto;
import com.dtyunxi.tcbj.biz.service.IShopReportService;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.mapper.CsCustomerMapper;
import com.dtyunxi.tcbj.dao.mapper.ShopMapper;
import com.dtyunxi.tcbj.dao.vo.ReportShopVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopReportServiceImpl
implements IShopReportService {
    @Autowired
    private IContext context;
    @Autowired
    private CsCustomerMapper csCustomerMapper;
    @Autowired
    private ShopMapper shopMapper;

    @Override
    public List<BrotherCustomerShopRespDto> queryBrotherCustomerShop() {
        ArrayList result = Lists.newArrayList();
        ServiceContext serviceContext = ServiceContext.getContext();
        String customerId = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return result;
        }
        List csCustomerEos = this.csCustomerMapper.queryBrotherCustomerByIdAndSalesmanId(Long.valueOf(customerId), this.context.userId());
        if (CollectionUtils.isEmpty((Collection)csCustomerEos)) {
            return result;
        }
        Map<Long, CsCustomerEo> customerMap = csCustomerEos.stream().collect(Collectors.toMap(CsCustomerEo::getMerchantId, e -> e, (e1, e2) -> e1));
        List shopVos = this.shopMapper.queryShopByOrgId(customerMap.keySet());
        for (ReportShopVo vo : shopVos) {
            BrotherCustomerShopRespDto respDto = new BrotherCustomerShopRespDto();
            respDto.setId(vo.getId());
            respDto.setStatus(vo.getStatus());
            respDto.setName(vo.getShopName());
            respDto.setSellerId(vo.getSellerId());
            respDto.setSellerName(vo.getSellerName());
            respDto.setOrganizationId(vo.getOrgId());
            respDto.setOrganizationName(vo.getSellerName());
            CsCustomerEo csCustomerEo = customerMap.get(vo.getOrgId());
            if (csCustomerEo != null) {
                respDto.setCustomerId(csCustomerEo.getId());
                respDto.setCustomerName(csCustomerEo.getName());
            }
            result.add(respDto);
        }
        return result;
    }
}

