/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceFlagEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumChargingRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.biz.enums.ExpressBusinessTypeEnum;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumChargingService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumChargingDas;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumChargingEo;
import com.dtyunxi.tcbj.dao.vo.InsuranceFeeVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportStockApportionStatusEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReInsurancePremiumChargingServiceImpl
implements IReInsurancePremiumChargingService {
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumChargingServiceImpl.class);
    @Resource
    private ReInsurancePremiumChargingDas das;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private IReInsurancePremiumService reInsurancePremiumService;
    @Resource
    private IReInsuranceBillService reInsuranceBillService;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService dailyDeliveryReportCostBelongDetailService;
    @Resource
    private ReInsurancePremiumDas reInsurancePremiumDas;

    @Override
    public Long addReInsurancePremiumCharging(ReInsurancePremiumChargingReqDto addReqDto) {
        ReInsurancePremiumChargingEo reInsurancePremiumEo = new ReInsurancePremiumChargingEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reInsurancePremiumEo);
        this.das.insert((BaseEo)reInsurancePremiumEo);
        return reInsurancePremiumEo.getId();
    }

    @Override
    public void batchAddReInsurancePremiumCharging(List<ReInsurancePremiumChargingReqDto> reqDtoList) {
        this.logger.info("\u6279\u91cf\u65b0\u589e\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u8868\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List reInsurancePremiumChargingEoList = BeanUtil.copyToList(reqDtoList, ReInsurancePremiumChargingEo.class);
        this.das.insertBatch(reInsurancePremiumChargingEoList);
    }

    @Override
    public void modifyReInsurancePremium(ReInsurancePremiumChargingReqDto modifyReqDto) {
        ReInsurancePremiumChargingEo reInsurancePremiumEo = new ReInsurancePremiumChargingEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reInsurancePremiumEo);
        this.das.updateSelective((BaseEo)reInsurancePremiumEo);
    }

    @Override
    public ReInsurancePremiumChargingRespDto queryById(Long id) {
        ReInsurancePremiumChargingEo reInsurancePremiumEo = (ReInsurancePremiumChargingEo)this.das.selectByPrimaryKey(id);
        ReInsurancePremiumChargingRespDto reInsurancePremiumRespDto = new ReInsurancePremiumChargingRespDto();
        DtoHelper.eo2Dto((BaseEo)reInsurancePremiumEo, (BaseVo)reInsurancePremiumRespDto);
        return reInsurancePremiumRespDto;
    }

    @Override
    public PageInfo<ReInsurancePremiumChargingRespDto> queryByPage(ReInsurancePremiumChargingReqDto reqDto) {
        List eos;
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.setDate(reqDto);
        PageInfo dtoPageInfo = this.das.queryByPage(reqDto);
        List relevanceNos = dtoPageInfo.getList().stream().map(ReInsurancePremiumChargingRespDto::getRelevanceNo).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(relevanceNos) && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", relevanceNos)).isNotNull((Object)"pre_order_no")).list()))) {
            Map<String, String> stringMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getPreOrderNo, (k1, k2) -> k1));
            map.putAll(stringMap);
        }
        List dtoList = dtoPageInfo.getList().stream().map(eo -> {
            eo.setBillTypeStr(DailyDeliveryReportCostBelongDetailCostTypeEnum.getDesc((String)eo.getBillType()));
            eo.setFlagName(InsuranceFlagEnum.getValueByCode((Integer)eo.getFlag()));
            eo.setShippingTypeName(eo.getShippingType());
            if (StringUtils.isNotBlank((CharSequence)eo.getBusinessType())) {
                eo.setBusinessTypeName(eo.getBusinessType());
                if (StringUtils.isNotBlank((CharSequence)ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()))) {
                    eo.setBusinessTypeName(ExpressBusinessTypeEnum.getNameByType(eo.getBusinessType()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getRelevanceNo()) && StringUtils.isBlank((CharSequence)eo.getExternalOrderNo()) && map.containsKey(eo.getRelevanceNo())) {
                eo.setExternalOrderNo((String)map.get(eo.getRelevanceNo()));
                Object[] externalOrderArray = eo.getExternalOrderNo().split(",");
                eo.setExternalOrderNo((String)Lists.newArrayList((Object[])externalOrderArray).stream().sorted().findFirst().get());
            }
            return eo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ReInsurancePremiumChargingRespDto> queryList(ReInsurancePremiumChargingReqDto reqDto) {
        List premiumChargingEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().ge(ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeBegin()), (Object)"in_out_time", (Object)reqDto.getInOutTimeBegin())).le(ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeEnd()), (Object)"in_out_time", (Object)reqDto.getInOutTimeEnd())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBillType()), (Object)"bill_type", (Object)reqDto.getBillType())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getBillTypeList()), (Object)"bill_type", (Collection)reqDto.getBillTypeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingCompanyList()), (Object)"shipping_company", (Collection)reqDto.getShippingCompanyList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getShippingTypeList()), (Object)"shipping_type", (Collection)reqDto.getShippingTypeList())).list();
        return BeanUtil.copyToList((Collection)premiumChargingEoList, ReInsurancePremiumChargingRespDto.class);
    }

    @Override
    public void updateCostBelongOrg(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u4fee\u6539\u8ba1\u8d39\u5f52\u5c5e\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)reqDto.getIds()), (String)"\u8bf7\u6c42ids\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getCostBelongOrgCode()), (String)"\u8ba1\u8d39\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getCostBelongOrgName()), (String)"\u8ba1\u8d39\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List chargingEoList = this.das.selectByIds(reqDto.getIds());
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)chargingEoList), (String)"\u627e\u4e0d\u5230\u4fee\u6539\u6570\u636e");
        chargingEoList.forEach(chargingEo -> {
            ReInsurancePremiumChargingEo updateEo = new ReInsurancePremiumChargingEo();
            updateEo.setId(chargingEo.getId());
            updateEo.setCostBelongOrgId(reqDto.getCostBelongOrgId());
            updateEo.setCostBelongOrgCode(reqDto.getCostBelongOrgCode());
            updateEo.setCostBelongOrgName(reqDto.getCostBelongOrgName());
            this.das.updateSelective((BaseEo)updateEo);
        });
    }

    @Override
    public ReInsurancePremiumChargingRespDto queryFlagCount(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5f02\u5e38\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.das.queryFlagCount(reqDto);
    }

    @Override
    public void generateInsurancePremiumCharging(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)reqDto.getInOutTimeBegin()) && ObjectUtils.isEmpty((Object)reqDto.getInOutTimeEnd()) && ObjectUtils.isEmpty((Object)reqDto.getBookkeepingMonth()) ? 1 : 0) != 0, (String)"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqDto.getBillTypeList())) {
            List types = Arrays.stream(DailyDeliveryReportCostBelongDetailCostTypeEnum.values()).map(DailyDeliveryReportCostBelongDetailCostTypeEnum::getType).collect(Collectors.toList());
            reqDto.setBillTypeList(types);
        }
        if (reqDto.isIfDelFormer()) {
            this.logicDel(reqDto);
        }
        reqDto.getBillTypeList().forEach(type -> {
            switch (Objects.requireNonNull(DailyDeliveryReportCostBelongDetailCostTypeEnum.getEnumByType((String)type))) {
                case GENERAL: {
                    this.generateInsurancePremiumChargingForGeneral(reqDto);
                    break;
                }
                case INTERNAL_DEAL: {
                    reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType());
                    this.generateInsurancePremiumChargingForCostBelongDetail(reqDto);
                    break;
                }
                case ARTIFICIAL: {
                    reqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
                    this.generateInsurancePremiumChargingForCostBelongDetail(reqDto);
                    break;
                }
                default: {
                    this.logger.info("\u672a\u77e5\u7c7b\u578b");
                }
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateInsuranceBill(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8d26\u5355\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getBookkeepingMonth()), (String)"\u8bb0\u8d26\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, Date> dealTimeScope = com.dtyunxi.tcbj.biz.utils.DateUtil.getDealTimeScope(reqDto.getBookkeepingMonth());
        reqDto.setInOutTimeBegin(dealTimeScope.get("startDate"));
        reqDto.setInOutTimeEnd(dealTimeScope.get("endDate"));
        List<ReInsurancePremiumChargingRespDto> reInsurancePremiumChargingRespDtoList = this.queryList(reqDto);
        if (CollectionUtils.isEmpty(reInsurancePremiumChargingRespDtoList)) {
            this.logger.info("\u65e0\u8ba1\u8d39\u660e\u7ec6");
            return;
        }
        this.logger.info("\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(reInsurancePremiumChargingRespDtoList));
        Long useAmountConfig = this.reInsurancePremiumDas.getUseAmountConfig();
        HashMap insureMaps = new HashMap();
        ArrayList<ReInsuranceBillReqDto> billReqDtoList = new ArrayList<ReInsuranceBillReqDto>();
        Map<Long, List<ReInsurancePremiumChargingRespDto>> premiumChargingRespDtoMap = reInsurancePremiumChargingRespDtoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getFeeId())).collect(Collectors.groupingBy(ReInsurancePremiumChargingRespDto::getFeeId));
        premiumChargingRespDtoMap.forEach((k, v) -> {
            int billQuotaVerify;
            ReInsuranceBillReqDto billReqDto = (ReInsuranceBillReqDto)BeanUtil.copyProperties(v.get(0), ReInsuranceBillReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
            billReqDto.setQuantity(v.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getQuantity())).map(ReInsurancePremiumChargingRespDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
            billReqDto.setInsureTotalPrice(v.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getInsureTotalPrice())).map(ReInsurancePremiumChargingRespDto::getInsureTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            InsuranceFeeVo insuranceFeeVo = new InsuranceFeeVo();
            if (StringUtils.isBlank((CharSequence)billReqDto.getShippingCompany()) || StringUtils.isBlank((CharSequence)billReqDto.getShippingType()) || StringUtils.isBlank((CharSequence)billReqDto.getShippingCompany())) {
                this.setBillReason(billReqDto, "\u7269\u6d41\u516c\u53f8\u3001\u627f\u8fd0\u65b9\u5f0f\u4e3a\u7a7a");
            } else {
                String orderShippingTime = DateUtil.getDateFormat((Date)billReqDto.getInOutTime(), (String)"yyyy-MM-dd");
                List insureFeeList = this.reInsurancePremiumDas.getInsureFee(orderShippingTime, billReqDto.getShippingCompanyCode(), billReqDto.getShippingType(), insureMaps, billReqDto.getShippingCompany());
                if (CollectionUtils.isEmpty((Collection)insureFeeList)) {
                    String str = "[\u7269\u6d41\u516c\u53f8:" + billReqDto.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + billReqDto.getShippingType() + "\u65e0\u5bf9\u5e94\u7684\u6298\u6263\u548c\u8d39\u7387]";
                    this.setBillReason(billReqDto, str);
                } else if (insureFeeList.size() > 1) {
                    String str = "[\u7269\u6d41\u516c\u53f8:" + billReqDto.getShippingCompany() + ",\u627f\u8fd0\u65b9\u5f0f:" + billReqDto.getShippingType() + "\u5b58\u5728\u91cd\u590d\u7684\u6298\u6263\u548c\u8d39\u7387]";
                    this.setBillReason(billReqDto, str);
                } else {
                    insuranceFeeVo = (InsuranceFeeVo)insureFeeList.get(0);
                    this.logger.info("\u7269\u6d41\u516c\u53f8\u5173\u8054\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)insuranceFeeVo));
                }
            }
            int n = billQuotaVerify = null != insuranceFeeVo && null != insuranceFeeVo.getBillQuotaVerify() ? insuranceFeeVo.getBillQuotaVerify() : 0;
            if (ObjectUtils.isNotEmpty((Object)billReqDto.getInsureTotalPrice()) && ObjectUtils.isNotEmpty((Object)billReqDto.getUseInsuranceRate())) {
                if (billReqDto.getInsureTotalPrice().compareTo(BigDecimal.valueOf(useAmountConfig)) >= 0 && billQuotaVerify == 1 || billQuotaVerify == 0) {
                    billReqDto.setInsureFee(billReqDto.getInsureTotalPrice().multiply(billReqDto.getUseInsuranceRate()).setScale(6, RoundingMode.DOWN));
                } else {
                    billReqDto.setInsureFee(new BigDecimal("0"));
                }
            } else {
                this.setBillReason(billReqDto, "\u6c47\u603b\u5355\u7968\u603b\u4ef7\u503c\u4e3a\u7a7a\u6216\u8d39\u7387\u4e3a\u7a7a");
            }
            billReqDto.setFlag(InsuranceFlagEnum.CORRECT.getCode());
            if (StringUtils.isNotBlank((CharSequence)billReqDto.getReason())) {
                billReqDto.setFlag(InsuranceFlagEnum.ERROR.getCode());
            }
            billReqDtoList.add(billReqDto);
        });
        if (CollectionUtils.isNotEmpty(billReqDtoList)) {
            this.reInsuranceBillService.batchAddReInsuranceBill(billReqDtoList);
        }
    }

    private void setBillReason(ReInsuranceBillReqDto billReqDto, String msg) {
        if (StringUtils.isBlank((CharSequence)billReqDto.getReason())) {
            billReqDto.setReason(msg);
        } else {
            billReqDto.setReason("\uff1b" + msg);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDel(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u903b\u8f91\u5220\u9664\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List<ReInsurancePremiumChargingRespDto> reInsurancePremiumChargingRespDtoList = this.queryList(reqDto);
        if (CollectionUtils.isNotEmpty(reInsurancePremiumChargingRespDtoList)) {
            List ids = reInsurancePremiumChargingRespDtoList.stream().map(ReInsurancePremiumChargingRespDto::getId).collect(Collectors.toList());
            this.das.logicDeleteByIdsBatch(ids);
        }
    }

    @Override
    public ReInsurancePremiumChargingRespDto queryInsureTotalPriceCount(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u6295\u4fdd\u91d1\u989d\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        BigDecimal bigDecimal = this.das.queryInsureTotalPriceCount(reqDto);
        ReInsurancePremiumChargingRespDto respDto = new ReInsurancePremiumChargingRespDto();
        respDto.setInsureTotalPriceCount(bigDecimal);
        return respDto;
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        this.logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u66f4\u65b0\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)updateReqDto));
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsurancePremiumChargingEo updateEo = new ReInsurancePremiumChargingEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List insurancePremiumChargingEoList = this.das.selectByIds(updateReqDto.getModuleRecordIdList());
        List list = insurancePremiumChargingEoList.stream().filter(e -> e.getPlacedFlag() == null || e.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.das.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        this.logger.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    private void generateInsurancePremiumChargingForGeneral(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u5e38\u89c4\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ReInsurancePremiumReqDto queryDto = new ReInsurancePremiumReqDto();
        queryDto.setBillingFeeFlag(YesOrNoEnum.YES.getCode());
        queryDto.setIfApportion(YesOrNoEnum.NO.getCode());
        queryDto.setInOutTimeBegin(reqDto.getInOutTimeBegin());
        queryDto.setInOutTimeEnd(reqDto.getInOutTimeEnd());
        queryDto.setOutPhysicsWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
        queryDto.setShippingCompanyList(reqDto.getShippingCompanyList());
        queryDto.setShippingTypeList(reqDto.getShippingTypeList());
        List<ReInsurancePremiumRespDto> reInsurancePremiumRespDtoList = this.reInsurancePremiumService.queryList(queryDto);
        if (CollectionUtils.isEmpty(reInsurancePremiumRespDtoList)) {
            this.logger.info("\u65e0\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6-\u5e38\u89c4\u8ba1\u8d39\u4fe1\u606f\u6570\u636e");
            return;
        }
        List<ReInsurancePremiumChargingReqDto> chargingReqDtoList = reInsurancePremiumRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getCostBelongOrgName())).map(dto -> {
            ReInsurancePremiumChargingReqDto chargingReqDto = (ReInsurancePremiumChargingReqDto)BeanUtil.copyProperties((Object)dto, ReInsurancePremiumChargingReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
            chargingReqDto.setFeeId(dto.getId());
            chargingReqDto.setCostBelongOrgName(dto.getCostBelongOrgName());
            chargingReqDto.setCostBelongOrgCode(dto.getCostBelongOrgCode());
            chargingReqDto.setCostBelongOrgId(dto.getCostBelongOrgId());
            chargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            chargingReqDto.setAllocationQuantity(dto.getQuantity());
            return chargingReqDto;
        }).collect(Collectors.toList());
        this.batchAddReInsurancePremiumCharging(chargingReqDtoList);
    }

    private void generateInsurancePremiumChargingForCostBelongDetail(ReInsurancePremiumChargingReqDto reqDto) {
        this.logger.info("\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u4eba\u5de5\u5206\u644a/\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DailyDeliveryReportCostBelongDetailDto queryDto = new DailyDeliveryReportCostBelongDetailDto();
        queryDto.setBookkeepingMonth(reqDto.getBookkeepingMonth());
        queryDto.setType(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        queryDto.setCostType(reqDto.getBillType());
        queryDto.setPhysicalWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
        queryDto.setShipmentEnterpriseNameList(reqDto.getShippingCompanyList());
        queryDto.setTransportStyleList(reqDto.getShippingTypeList());
        queryDto.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.ALREADY_APPORTION.getType());
        queryDto.setStockApportionId(reqDto.getStockApportionId());
        List costBelongDetailDtoList = this.dailyDeliveryReportCostBelongDetailService.queryList(queryDto);
        if (CollectionUtils.isEmpty((Collection)costBelongDetailDtoList)) {
            this.logger.info("\u65e0\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u4eba\u5de5\u5206\u644a/\u5185\u90e8\u4ea4\u6613\u6570\u636e");
            return;
        }
        Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> costBelongDetailDtoMap = costBelongDetailDtoList.stream().collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
        List<Long> feeIds = costBelongDetailDtoList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).collect(Collectors.toList());
        List<ReInsurancePremiumRespDto> reInsurancePremiumRespDtoList = this.reInsurancePremiumService.queryByIds(feeIds);
        if (CollectionUtils.isEmpty(reInsurancePremiumRespDtoList)) {
            this.logger.info("\u65e0\u4fdd\u8d39\u660e\u7ec6\u539f\u59cb\u8d39\u7528\u4fe1\u606f\u6570\u636e");
            return;
        }
        ArrayList chargingReqDtoList = new ArrayList();
        reInsurancePremiumRespDtoList.forEach(premiumRespDto -> {
            List detailDtoList = (List)costBelongDetailDtoMap.get(premiumRespDto.getId());
            BigDecimal insureTotalPrice = BigDecimal.ZERO;
            detailDtoList.stream().forEach(detail -> {
                ReInsurancePremiumChargingReqDto chargingReqDto = (ReInsurancePremiumChargingReqDto)BeanUtil.copyProperties((Object)premiumRespDto, ReInsurancePremiumChargingReqDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime", ""});
                chargingReqDto.setFeeId(premiumRespDto.getId());
                chargingReqDto.setBillType(reqDto.getBillType());
                chargingReqDto.setAllocationQuantity(detail.getApportionNum());
                if (ObjectUtils.isNotEmpty((Object)premiumRespDto.getInsureTotalPrice()) && ObjectUtils.isNotEmpty((Object)premiumRespDto.getInsureUnitPrice()) && ObjectUtils.isNotEmpty((Object)detail.getApportionNum())) {
                    boolean isLast;
                    boolean bl = isLast = detailDtoList.indexOf(detail) == detailDtoList.size() - 1;
                    if (isLast) {
                        chargingReqDto.setInsureTotalPrice(premiumRespDto.getInsureTotalPrice().subtract(insureTotalPrice));
                    } else {
                        chargingReqDto.setInsureTotalPrice(chargingReqDto.getInsureUnitPrice().multiply(chargingReqDto.getAllocationQuantity()).setScale(6, RoundingMode.DOWN));
                        insureTotalPrice.add(chargingReqDto.getInsureTotalPrice());
                    }
                }
                chargingReqDtoList.add(chargingReqDto);
            });
            if (CollectionUtils.isNotEmpty((Collection)chargingReqDtoList)) {
                this.batchAddReInsurancePremiumCharging(chargingReqDtoList);
            }
        });
    }

    private void setDate(ReInsurancePremiumChargingReqDto reInsurancePremiumReqDto) {
        try {
            if (ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeEnd())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String begin = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeBegin()) + " 00:00:00";
                String end = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeEnd()) + " 23:59:59";
                reInsurancePremiumReqDto.setInOutTimeBegin(simpleDateFormat.parse(begin));
                reInsurancePremiumReqDto.setInOutTimeEnd(simpleDateFormat.parse(end));
                reInsurancePremiumReqDto.setOrderNo(reInsurancePremiumReqDto.getDocumentNo());
                reInsurancePremiumReqDto.setDocumentNo(null);
            }
        }
        catch (Exception e) {
            this.logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

