/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigDataDto;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigLogDataDto;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryFeeFilterExtConfigService;
import com.dtyunxi.tcbj.dao.das.DailyDeliveryFeeFilterExtConfigDas;
import com.dtyunxi.tcbj.dao.eo.DailyDeliveryFeeFilterExtConfigEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DailyDeliveryFeeFilterExtConfigServiceImpl
implements IDailyDeliveryFeeFilterExtConfigService {
    private static Logger logger = LoggerFactory.getLogger(DailyDeliveryFeeFilterExtConfigServiceImpl.class);
    @Resource
    private DailyDeliveryFeeFilterExtConfigDas dailyDeliveryFeeFilterExtConfigDas;

    @Override
    public Long addDailyDeliveryFeeFilterExtConfig(DailyDeliveryFeeFilterExtConfigReqDto addReqDto) {
        logger.info("\u65b0\u589e\u5254\u9664\u8ba1\u8d39\u6269\u5f20\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)addReqDto.getModuleCode()), (String)"\u8d39\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.convertData(addReqDto);
        DailyDeliveryFeeFilterExtConfigEo dailyDeliveryFeeFilterExtConfigEo = new DailyDeliveryFeeFilterExtConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dailyDeliveryFeeFilterExtConfigEo);
        this.dailyDeliveryFeeFilterExtConfigDas.insert((BaseEo)dailyDeliveryFeeFilterExtConfigEo);
        return dailyDeliveryFeeFilterExtConfigEo.getId();
    }

    @Override
    public void modifyDailyDeliveryFeeFilterExtConfig(DailyDeliveryFeeFilterExtConfigReqDto modifyReqDto) {
        logger.info("\u7f16\u8f91\u5254\u9664\u8ba1\u8d39\u6269\u5f20\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)modifyReqDto.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)modifyReqDto.getModuleCode()), (String)"\u8d39\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.convertData(modifyReqDto);
        DailyDeliveryFeeFilterExtConfigEo dailyDeliveryFeeFilterExtConfigEo = new DailyDeliveryFeeFilterExtConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dailyDeliveryFeeFilterExtConfigEo);
        this.dailyDeliveryFeeFilterExtConfigDas.update((BaseEo)dailyDeliveryFeeFilterExtConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDailyDeliveryFeeFilterExtConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dailyDeliveryFeeFilterExtConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DailyDeliveryFeeFilterExtConfigRespDto queryById(Long id) {
        DailyDeliveryFeeFilterExtConfigEo dailyDeliveryFeeFilterExtConfigEo = (DailyDeliveryFeeFilterExtConfigEo)this.dailyDeliveryFeeFilterExtConfigDas.selectByPrimaryKey(id);
        DailyDeliveryFeeFilterExtConfigRespDto dailyDeliveryFeeFilterExtConfigRespDto = new DailyDeliveryFeeFilterExtConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)dailyDeliveryFeeFilterExtConfigEo, (BaseVo)dailyDeliveryFeeFilterExtConfigRespDto);
        this.convertData(dailyDeliveryFeeFilterExtConfigRespDto);
        return dailyDeliveryFeeFilterExtConfigRespDto;
    }

    @Override
    public PageInfo<DailyDeliveryFeeFilterExtConfigRespDto> queryByPage(DailyDeliveryFeeFilterExtConfigReqDto reqDto) {
        logger.info("\u5254\u9664\u8ba1\u8d39\u6269\u5f20\u914d\u7f6e\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dailyDeliveryFeeFilterExtConfigDas.filter().eq(StringUtils.isNotBlank((CharSequence)reqDto.getModuleCode()), (Object)"module_code", (Object)reqDto.getModuleCode())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getModuleCodeList()), (Object)"module_code", (Collection)reqDto.getModuleCodeList())).like(StringUtils.isNotBlank((CharSequence)reqDto.getFilterPhysicalWarehouse()), (Object)"filter_physical_warehouse", (Object)reqDto.getFilterPhysicalWarehouse())).like(StringUtils.isNotBlank((CharSequence)reqDto.getFilterLogicWarehouse()), (Object)"filter_logic_warehouse", (Object)reqDto.getFilterLogicWarehouse())).like(StringUtils.isNotBlank((CharSequence)reqDto.getFilterBusinessType()), (Object)"filter_business_type", (Object)reqDto.getFilterBusinessType())).like(StringUtils.isNotBlank((CharSequence)reqDto.getFilterInventoryOrg()), (Object)"filter_inventory_org", (Object)reqDto.getFilterInventoryOrg())).orderByDesc((Object)"update_time")).page(Integer.valueOf(reqDto.getPageNum()), Integer.valueOf(reqDto.getPageSize()));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DailyDeliveryFeeFilterExtConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (CollectionUtil.isNotEmpty((Collection)dtoPageInfo.getList())) {
            dtoPageInfo.getList().forEach(this::convertData);
        }
        return dtoPageInfo;
    }

    @Override
    public List<DailyDeliveryFeeFilterExtConfigRespDto> queryModuleCode(String moduleCode) {
        logger.info("\u6839\u636e\u8d39\u7528\u7c7b\u578b\u67e5\u8be2\u5254\u9664\u914d\u7f6e\u96c6\u5408\uff1a{}", (Object)moduleCode);
        List configEoList = ((ExtQueryChainWrapper)this.dailyDeliveryFeeFilterExtConfigDas.filter().eq((Object)"module_code", (Object)moduleCode)).list();
        ArrayList<DailyDeliveryFeeFilterExtConfigRespDto> configRespDtoList = new ArrayList<DailyDeliveryFeeFilterExtConfigRespDto>();
        if (CollectionUtil.isNotEmpty((Collection)configEoList)) {
            CubeBeanUtils.copyCollection(configRespDtoList, (Collection)configEoList, DailyDeliveryFeeFilterExtConfigRespDto.class);
            configRespDtoList.forEach(this::convertData);
        }
        return configRespDtoList;
    }

    @Override
    public boolean isFilterApplicable(List<DailyDeliveryFeeFilterExtConfigRespDto> configRespDtoList, DailyDeliveryFeeFilterExtConfigReqDto reqDto) {
        logger.info("\u6821\u9a8c\u662f\u5426\u7b26\u5408\u5254\u9664\u89c4\u5219\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)reqDto), (Object)JSON.toJSONString(configRespDtoList));
        if (CollectionUtil.isEmpty(configRespDtoList)) {
            return false;
        }
        boolean result = true;
        for (DailyDeliveryFeeFilterExtConfigRespDto config : configRespDtoList) {
            List collect;
            result = true;
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterPhysicalWarehouseDataList())) {
                if (StringUtils.isBlank((CharSequence)reqDto.getFilterPhysicalWarehouse())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterPhysicalWarehouseDataList().stream().filter(f -> f.getCode().equals(reqDto.getFilterPhysicalWarehouse())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterLogicWarehouseDataList())) {
                if (StringUtils.isBlank((CharSequence)reqDto.getFilterLogicWarehouse())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterLogicWarehouseDataList().stream().filter(f -> f.getCode().equals(reqDto.getFilterLogicWarehouse())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterBusinessTypeDataList())) {
                if (StringUtils.isBlank((CharSequence)reqDto.getFilterBusinessType())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterBusinessTypeDataList().stream().filter(f -> f.getCode().equals(reqDto.getFilterBusinessType())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterInventoryOrgDataList())) {
                if (StringUtils.isBlank((CharSequence)reqDto.getFilterInventoryOrg())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterInventoryOrgDataList().stream().filter(f -> f.getName().equals(reqDto.getFilterInventoryOrg())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)config.getFilterLogisticsDataList())) {
                if (StringUtils.isBlank((CharSequence)reqDto.getLogisticsCompany()) || StringUtils.isBlank((CharSequence)reqDto.getTransportStyle())) {
                    result = false;
                    continue;
                }
                collect = config.getFilterLogisticsDataList().stream().filter(f -> f.getLogName().equals(reqDto.getLogisticsCompany())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect)) {
                    result = false;
                    continue;
                }
                List collect1 = collect.stream().map(DailyDeliveryFeeFilterExtConfigLogDataDto::getCarrierList).flatMap(Collection::stream).filter(f -> f.getName().equals(reqDto.getTransportStyle())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(collect1)) {
                    result = false;
                    continue;
                }
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    private void convertData(DailyDeliveryFeeFilterExtConfigRespDto respDto) {
        String collect;
        if (StringUtils.isNotBlank((CharSequence)respDto.getFilterPhysicalWarehouse())) {
            respDto.setFilterPhysicalWarehouseDataList(JSON.parseArray((String)respDto.getFilterPhysicalWarehouse(), DailyDeliveryFeeFilterExtConfigDataDto.class));
            collect = respDto.getFilterPhysicalWarehouseDataList().stream().map(DailyDeliveryFeeFilterExtConfigDataDto::getName).collect(Collectors.joining(","));
            respDto.setFilterPhysicalWarehouse(collect);
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getFilterLogicWarehouse())) {
            respDto.setFilterLogicWarehouseDataList(JSON.parseArray((String)respDto.getFilterLogicWarehouse(), DailyDeliveryFeeFilterExtConfigDataDto.class));
            collect = respDto.getFilterLogicWarehouseDataList().stream().map(DailyDeliveryFeeFilterExtConfigDataDto::getName).collect(Collectors.joining(","));
            respDto.setFilterLogicWarehouse(collect);
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getFilterBusinessType())) {
            respDto.setFilterBusinessTypeDataList(JSON.parseArray((String)respDto.getFilterBusinessType(), DailyDeliveryFeeFilterExtConfigDataDto.class));
            collect = respDto.getFilterBusinessTypeDataList().stream().map(DailyDeliveryFeeFilterExtConfigDataDto::getName).collect(Collectors.joining(","));
            respDto.setFilterBusinessType(collect);
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getFilterInventoryOrg())) {
            respDto.setFilterInventoryOrgDataList(JSON.parseArray((String)respDto.getFilterInventoryOrg(), DailyDeliveryFeeFilterExtConfigDataDto.class));
            collect = respDto.getFilterInventoryOrgDataList().stream().map(DailyDeliveryFeeFilterExtConfigDataDto::getName).collect(Collectors.joining(","));
            respDto.setFilterInventoryOrg(collect);
        }
        if (StringUtils.isNotBlank((CharSequence)respDto.getFilterLogistics())) {
            respDto.setFilterLogisticsDataList(JSON.parseArray((String)respDto.getFilterLogistics(), DailyDeliveryFeeFilterExtConfigLogDataDto.class));
        }
    }

    private void convertData(DailyDeliveryFeeFilterExtConfigReqDto reqDto) {
        reqDto.setFilterPhysicalWarehouse(CollectionUtil.isNotEmpty((Collection)reqDto.getFilterPhysicalWarehouseDataList()) ? JSON.toJSONString((Object)reqDto.getFilterPhysicalWarehouseDataList()) : null);
        reqDto.setFilterLogicWarehouse(CollectionUtil.isNotEmpty((Collection)reqDto.getFilterLogicWarehouseDataList()) ? JSON.toJSONString((Object)reqDto.getFilterLogicWarehouseDataList()) : null);
        reqDto.setFilterBusinessType(CollectionUtil.isNotEmpty((Collection)reqDto.getFilterBusinessTypeDataList()) ? JSON.toJSONString((Object)reqDto.getFilterBusinessTypeDataList()) : null);
        reqDto.setFilterInventoryOrg(CollectionUtil.isNotEmpty((Collection)reqDto.getFilterInventoryOrgDataList()) ? JSON.toJSONString((Object)reqDto.getFilterInventoryOrgDataList()) : null);
        reqDto.setFilterLogistics(CollectionUtil.isNotEmpty((Collection)reqDto.getFilterLogisticsDataList()) ? JSON.toJSONString((Object)reqDto.getFilterLogisticsDataList()) : null);
    }
}

