/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticsReportService;
import com.dtyunxi.tcbj.biz.utils.BigDecimalUtil;
import com.dtyunxi.tcbj.dao.das.FinLogisticDetailDas;
import com.dtyunxi.tcbj.dao.eo.FinLogisticDetailEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinLogisticDetailServiceImpl
implements IFinLogisticDetailService {
    private static Logger logger = LoggerFactory.getLogger(FinLogisticDetailServiceImpl.class);
    @Resource
    private FinLogisticDetailDas finLogisticDetailDas;
    @Resource
    private IFinLogisticsReportService finLogisticsReportService;

    @Override
    public void batchSave(Long id, List<FinLogisticsReportDto> finLogisticsReportDtoList) {
        ArrayList<FinLogisticDetailEo> finLogisticDetailEoList = new ArrayList<FinLogisticDetailEo>();
        if (CollectionUtils.isNotEmpty(finLogisticsReportDtoList)) {
            for (FinLogisticsReportDto reportDto : finLogisticsReportDtoList) {
                FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
                BeanUtils.copyProperties((Object)reportDto, (Object)detailEo);
                detailEo.setReportId(id.toString());
                finLogisticDetailEoList.add(detailEo);
            }
        }
        if (CollectionUtils.isNotEmpty(finLogisticDetailEoList)) {
            this.finLogisticDetailDas.insertBatch(finLogisticDetailEoList);
        }
    }

    @Override
    public void detailSave(Long id, FinLogisticsReportDto reportDto) {
        FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
        BeanUtils.copyProperties((Object)reportDto, (Object)detailEo);
        detailEo.setReportId(id.toString());
        this.finLogisticDetailDas.insert((BaseEo)detailEo);
    }

    @Override
    public List<FinLogisticsReportDto> selectById(List<String> ids) {
        ArrayList<FinLogisticsReportDto> finLogisticDetailRespDtoList = new ArrayList<FinLogisticsReportDto>();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                FinLogisticDetailEo detailEo = (FinLogisticDetailEo)this.finLogisticDetailDas.selectByPrimaryKey(Long.valueOf(id));
                if (null == detailEo || null == detailEo.getId()) continue;
                FinLogisticsReportDto respDto = new FinLogisticsReportDto();
                BeanUtils.copyProperties((Object)detailEo, (Object)respDto);
                respDto.setWarehouseCode(detailEo.getWarehouseId());
                respDto.setReportId(Long.valueOf(detailEo.getReportId()));
                finLogisticDetailRespDtoList.add(respDto);
            }
        }
        return finLogisticDetailRespDtoList;
    }

    @Override
    public FinLogisticDetailRespDto calculateData(List<FinLogisticDetailRespDto> detailRespDtoList) {
        logger.info("\u8ba1\u7b97\u5f00\u59cbcalculateData:{}", (Object)JSON.toJSONString(detailRespDtoList));
        FinLogisticDetailRespDto detailRespDto = new FinLogisticDetailRespDto();
        if (CollectionUtils.isNotEmpty(detailRespDtoList)) {
            FinLogisticDetailRespDto reportDto = detailRespDtoList.get(0);
            BigDecimal totalBox = detailRespDtoList.stream().map(FinLogisticDetailRespDto::getBox).reduce(BigDecimal.ZERO, BigDecimal::add);
            detailRespDto.setTotalBox(totalBox);
            BigDecimal totalVolume = detailRespDtoList.stream().map(FinLogisticDetailRespDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
            detailRespDto.setTotalVolume(totalVolume);
            BigDecimal totalWeight = detailRespDtoList.stream().map(FinLogisticDetailRespDto::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
            detailRespDto.setTotalWeight(totalWeight);
            BigDecimal totalOilPrice = detailRespDtoList.stream().filter(i -> i.getOilTotalPrice() != null).map(FinLogisticDetailRespDto::getOilTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalDeliveryPrice = detailRespDtoList.stream().filter(i -> i.getDeliveryAmount() != null).map(FinLogisticDetailRespDto::getDeliveryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalUnloadPrice = detailRespDtoList.stream().filter(i -> i.getUnloadAmount() != null).map(FinLogisticDetailRespDto::getUnloadAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalSpecialPrice = detailRespDtoList.stream().filter(i -> i.getSpecialAmount() != null).map(FinLogisticDetailRespDto::getSpecialAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalLowPrice = detailRespDtoList.stream().filter(i -> i.getMinCharge() != null).map(FinLogisticDetailRespDto::getMinCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
            detailRespDto.setTotalTransportAmount(totalOilPrice.add(totalDeliveryPrice).add(totalUnloadPrice).add(totalSpecialPrice).add(totalLowPrice));
            if (ChargeModeEnum.VOLUME.getType().equals(reportDto.getChargeMode())) {
                for (FinLogisticDetailRespDto logisticsReportDto : detailRespDtoList) {
                    if (logisticsReportDto.getVolume() == null || logisticsReportDto.getTransportPrice() == null || logisticsReportDto.getTransportAmount() == null) continue;
                    detailRespDto.setShareAmount(BigDecimalUtil.div(totalVolume, logisticsReportDto.getVolume()).multiply(logisticsReportDto.getTransportPrice()).multiply(logisticsReportDto.getTransportAmount()));
                }
            } else if (ChargeModeEnum.WEIGHT.getType().equals(reportDto.getChargeMode())) {
                for (FinLogisticDetailRespDto logisticsReportDto : detailRespDtoList) {
                    if (logisticsReportDto.getWeight() == null || logisticsReportDto.getTransportPrice() == null || logisticsReportDto.getTransportAmount() == null) continue;
                    detailRespDto.setShareAmount(BigDecimalUtil.div(totalWeight, logisticsReportDto.getWeight()).multiply(logisticsReportDto.getTransportPrice()).multiply(logisticsReportDto.getTransportAmount()));
                }
            }
            List reportIds = detailRespDtoList.stream().map(FinLogisticDetailRespDto::getReportId).collect(Collectors.toList());
            detailRespDto.setReportIds(reportIds);
        }
        return detailRespDto;
    }

    @Override
    public void updateDetailRespDto(List<FinLogisticDetailRespDto> respDtoList, Long reportId) {
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            for (FinLogisticDetailRespDto respDto : respDtoList) {
                FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
                BeanUtils.copyProperties((Object)respDto, (Object)detailEo);
                detailEo.setReportId(reportId.toString());
                logger.info("updateDetailRespDto detailEo={}", (Object)JSONObject.toJSONString((Object)detailEo));
                this.finLogisticDetailDas.update((BaseEo)detailEo);
            }
        }
    }

    @Override
    public void updateDetail(FinLogisticsReportDto respDtoList, Long reportId) {
        FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
        BeanUtils.copyProperties((Object)respDtoList, (Object)detailEo);
        detailEo.setReportId(reportId.toString());
        this.finLogisticDetailDas.update((BaseEo)detailEo);
    }

    @Override
    public void updateDetailList(List<FinLogisticsReportDto> reportDtoList, Long reportId) {
        if (CollectionUtils.isNotEmpty(reportDtoList)) {
            for (FinLogisticsReportDto respDto : reportDtoList) {
                FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
                BeanUtils.copyProperties((Object)respDto, (Object)detailEo);
                detailEo.setReportId(reportId.toString());
                this.finLogisticDetailDas.update((BaseEo)detailEo);
            }
        }
    }

    @Override
    public List<FinLogisticsReportDto> selectFinLogisticsReportDto(List<String> ids) {
        ArrayList<FinLogisticsReportDto> finLogisticsReportDtoList = new ArrayList<FinLogisticsReportDto>();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
                FinLogisticDetailEo detailEo = new FinLogisticDetailEo();
                detailEo.setReportId(id);
                List finLogisticDetailEoList = this.finLogisticDetailDas.select((BaseEo)detailEo);
                List<FinLogisticsReportDto> dtoList = this.setData(finLogisticDetailEoList);
                finLogisticsReportDtoList.addAll(dtoList);
            }
        }
        return finLogisticsReportDtoList;
    }

    @Override
    public List<FinLogisticsReportDto> selectFinLogisticsReportList(String warehouseCode, Date startTime, Date endTime, String transportType, Boolean abnormal, String logisticCompany) {
        ArrayList dtoList = Lists.newArrayList();
        Integer pageNum = 1;
        while (true) {
            PageInfo page;
            ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().ge((Object)"outbound_time", (Object)startTime)).le((Object)"outbound_time", (Object)endTime)).eq((Object)"warehouse_id", (Object)warehouseCode)).eq((Object)"transport_type", (Object)transportType)).eq((Object)"logistic_Id", (Object)logisticCompany);
            if (abnormal.booleanValue()) {
                filter.eq((Object)"status", (Object)1);
            }
            if ((page = filter.page(pageNum, Integer.valueOf(10000))) != null && CollectionUtil.isNotEmpty((Collection)page.getList())) {
                ArrayList list = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)page.getList(), (Collection)list, FinLogisticsReportDto.class);
                dtoList.addAll(list);
            }
            if (page == null || CollectionUtil.isEmpty((Collection)page.getList()) || page.getList().size() < 10000) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtil.isEmpty((Collection)dtoList)) {
            return null;
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importModifyData(List<FinLogisticsReportDto> reportDtoList) {
        if (CollectionUtil.isEmpty(reportDtoList)) {
            return;
        }
        List outNoticeCodes = reportDtoList.stream().map(FinLogisticsReportDto::getOutNoticeCode).collect(Collectors.toList());
        List eos = ((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().in((Object)"out_notice_code", outNoticeCodes)).list(Integer.valueOf(2000));
        Map<Object, Object> eoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            eoMap = eos.stream().collect(Collectors.toMap(FinLogisticDetailEo::getOutNoticeCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList eoList = Lists.newArrayList();
        for (FinLogisticsReportDto dto : reportDtoList) {
            String outNoticeCode = dto.getOutNoticeCode();
            if (!CollectionUtil.isNotEmpty((Map)eoMap) || !eoMap.containsKey(outNoticeCode)) continue;
            FinLogisticDetailEo finLogisticDetailEo = (FinLogisticDetailEo)eoMap.get(outNoticeCode);
            FinLogisticDetailEo eo = new FinLogisticDetailEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            eo.setId(finLogisticDetailEo.getId());
            eoList.add(eo);
        }
        eoList.forEach(i -> this.finLogisticDetailDas.updateSelective((BaseEo)i));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertBatch(List<FinLogisticsReportDto> reportDtoList) {
        if (CollectionUtil.isEmpty(reportDtoList)) {
            return;
        }
        for (FinLogisticsReportDto reportDto : reportDtoList) {
            Long id = this.finLogisticsReportService.addFinLogistics(reportDto);
            this.detailSave(id, reportDto);
        }
    }

    @Override
    public void delByIds(Set<Long> detailIds) {
        this.finLogisticDetailDas.logicDeleteByIds(new ArrayList<Long>(detailIds));
    }

    @Override
    public List<FinLogisticsReportDto> selectByReport(Long reportId) {
        ArrayList<FinLogisticsReportDto> finLogisticDetailRespDtoList = new ArrayList<FinLogisticsReportDto>();
        List eos = ((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq((Object)"report_id", (Object)reportId)).list(Integer.valueOf(1000));
        if (CollectionUtils.isNotEmpty((Collection)eos)) {
            for (FinLogisticDetailEo eo : eos) {
                FinLogisticsReportDto respDto = new FinLogisticsReportDto();
                BeanUtils.copyProperties((Object)eo, (Object)respDto);
                respDto.setWarehouseCode(eo.getWarehouseId());
                respDto.setReportId(Long.valueOf(eo.getReportId()));
                finLogisticDetailRespDtoList.add(respDto);
            }
        }
        return finLogisticDetailRespDtoList;
    }

    @Override
    public List<FinLogisticDetailRespDto> selectByDetail(LogisticStatisticReqDto reqDto) {
        logger.info("\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u62a5\u8868\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().eq((Object)"dr", (Object)0)).ge(ObjectUtils.isNotEmpty((Object)reqDto.getStartTime()), (Object)"outbound_time", (Object)reqDto.getStartTime())).le(ObjectUtils.isNotEmpty((Object)reqDto.getEndTime()), (Object)"outbound_time", (Object)reqDto.getEndTime())).eq(StringUtils.isNotEmpty((CharSequence)reqDto.getWarehouseCode()), (Object)"warehouse_id", (Object)reqDto.getWarehouseCode())).eq(StringUtils.isNotEmpty((CharSequence)reqDto.getShippingCompanyCode()), (Object)"logistic_Id", (Object)reqDto.getShippingCompanyCode())).eq(StringUtils.isNotEmpty((CharSequence)reqDto.getShippingType()), (Object)"transport_type", (Object)reqDto.getShippingType())).eq(StringUtils.isNotEmpty((CharSequence)reqDto.getRelevanceNo()), (Object)"business_code", (Object)reqDto.getRelevanceNo())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getDocumentNos()), (Object)"outbound_code", (Collection)reqDto.getDocumentNos())).list();
        ArrayList<FinLogisticDetailRespDto> respDtoList = new ArrayList<FinLogisticDetailRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            DtoHelper.eoList2DtoList((Collection)eoList, respDtoList, FinLogisticDetailRespDto.class);
        }
        return respDtoList;
    }

    @Override
    public List<FinLogisticDetailRespDto> queryList(FinLogisticsDetailReqDto reqDto) {
        logger.info("\u67e5\u8be2\u7269\u6d41\u8d39\u7528\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finLogisticDetailDas.filter().in(CollectionUtil.isNotEmpty((Collection)reqDto.getIds()), (Object)"id", (Collection)reqDto.getIds())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBookkeepingDate()), (Object)"bookkeeping_date", (Object)reqDto.getBookkeepingDate())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getWarehouseCodeList()), (Object)"warehouse_code", (Collection)reqDto.getWarehouseCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getTransportTypeList()), (Object)"transport_type", (Collection)reqDto.getTransportTypeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getLogisticCompanyCodeList()), (Object)"logistic_company_code", (Collection)reqDto.getLogisticCompanyCodeList())).eq(ObjectUtils.isNotEmpty((Object)reqDto.getIfApportion()), (Object)"if_apportion", (Object)reqDto.getIfApportion())).eq(ObjectUtils.isNotEmpty((Object)reqDto.getBillingFeeFlag()), (Object)"billing_fee_flag", (Object)reqDto.getBillingFeeFlag())).list();
        return BeanUtil.copyToList((Collection)eoList, FinLogisticDetailRespDto.class);
    }

    @Override
    public List<FinLogisticDetailRespDto> queryMergeMasterOrderList(List<String> mergeOrderList) {
        logger.info("\u6839\u636e\u5408\u5355\u5355\u53f7\u67e5\u8be2\u6bcd\u5355\u5355\u636e\uff1a{}", (Object)JSON.toJSONString(mergeOrderList));
        return Collections.emptyList();
    }

    private List<FinLogisticsReportDto> setData(List<FinLogisticDetailEo> finLogisticDetailEoList) {
        ArrayList<FinLogisticsReportDto> reportDtoList = new ArrayList<FinLogisticsReportDto>();
        if (CollectionUtils.isNotEmpty(finLogisticDetailEoList)) {
            DtoHelper.eoList2DtoList(finLogisticDetailEoList, reportDtoList, FinLogisticsReportDto.class);
        }
        return reportDtoList;
    }
}

