/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.exception.ExampleExceptionCode;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseChargingService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseJobService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.dao.das.ISortingExpenseDetailDas;
import com.dtyunxi.tcbj.dao.das.SortingExpenseDas;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseChargingEo;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportStockApportionDomain;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportStockApportionStatusEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportStockApportionEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SortingExpenseJobServiceImpl
implements ISortingExpenseJobService {
    private final Logger LOGGER = LoggerFactory.getLogger(SortingExpenseJobServiceImpl.class);
    @Resource
    private ISortingExpenseDetailDas das;
    @Resource
    private SortingExpenseDas sortingExpenseDas;
    @Resource
    private ISortingExpenseChargingService sortingExpenseChargingService;
    @Resource
    private ISortingExpenseDetailDas sortingExpenseDetailDas;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService costBelongDetailService;
    @Resource
    private IDailyDeliveryReportStockApportionDomain reportStockApportionDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBySortingFee(DailyDeliveryReportStockApportionDto reqDto) {
        this.LOGGER.info("\u5206\u62e3\u8d39\u7528\u751f\u6210\u80a1\u4efd\u5206\u644a\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        String bookkeepingMonth = reqDto.getBookkeepingMonth();
        Pair<String, String> datePair = DateTimeUtils.getByMonthStr(bookkeepingMonth);
        List detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().between((Object)"out_warehouse_time", datePair.getKey(), datePair.getValue())).eq((Object)"if_apportion", (Object)1)).list();
        if (CollUtil.isEmpty((Collection)detailEos)) {
            this.LOGGER.info("\u5206\u62e3\u8d39\u7528\u65e0\u5339\u914d\u6570\u636e");
            return;
        }
        List apportionDtos = detailEos.stream().map(detailEo -> {
            DailyDeliveryReportStockApportionEo apportionDto = new DailyDeliveryReportStockApportionEo();
            apportionDto.setBookkeepingMonth(DateTimeUtils.formatDate(detailEo.getOutWarehouseTime(), "yyyy-MM"));
            apportionDto.setReportId(detailEo.getLinkDailyReportId());
            apportionDto.setFeeId(detailEo.getId());
            apportionDto.setDetailId(detailEo.getReportDetailId());
            apportionDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
            apportionDto.setApportionStatus("NOT_APPORTION");
            apportionDto.setApportionTotal(detailEo.getDoneQuantity());
            apportionDto.setApportionAlready(BigDecimal.ZERO);
            return apportionDto;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(apportionDtos)) {
            this.reportStockApportionDomain.insertBatch(apportionDtos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBySortingFee(FeeGenerateReqDto reqDto) {
        this.generateBySortingFee(reqDto, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBySortingFee(FeeGenerateReqDto reqDto, Boolean generateNotApportion) {
        List sortingExpenseList;
        this.LOGGER.info("\u751f\u6210\u5206\u62e3\u8d39\u8ba1\u8d39\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}  {}", (Object)JSON.toJSONString((Object)reqDto), (Object)generateNotApportion);
        if (ObjectUtil.hasNull((Object[])new Object[]{reqDto.getStartDate(), reqDto.getEndDate()})) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u6709\u8bef\uff0c\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List costTypeList = reqDto.getCostTypeList();
        List chargingEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDetailDas.filter().ge(Objects.nonNull(reqDto.getStartDate()), (Object)"out_warehouse_time", (Object)reqDto.getStartDate())).le(Objects.nonNull(reqDto.getEndDate()), (Object)"out_warehouse_time", (Object)reqDto.getEndDate())).in(CollUtil.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)costTypeList), (Object)"cost_type", (Collection)costTypeList)).eq(ObjectUtil.isNotEmpty((Object)reqDto.getStockApportionId()), (Object)"id", (Object)reqDto.getStockApportionId())).list();
        if (CollUtil.isNotEmpty((Collection)chargingEos)) {
            boolean exists = chargingEos.stream().anyMatch(chargingEo -> Objects.equals(chargingEo.getPlacedFlag(), 1));
            if (exists) {
                throw new BizException(ExampleExceptionCode.PLACED_FLAG_EXC.getCode(), "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
            }
            List delIds = chargingEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.LOGGER.info("\u5220\u9664\u65e7\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(delIds));
            this.sortingExpenseDetailDas.logicDeleteByIds(delIds);
        }
        if ((CollUtil.isEmpty((Collection)costTypeList) || costTypeList.contains(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) && CollUtil.isNotEmpty((Collection)(sortingExpenseList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().ge(Objects.nonNull(reqDto.getStartDate()), (Object)"out_warehouse_time", (Object)reqDto.getStartDate())).le(Objects.nonNull(reqDto.getEndDate()), (Object)"out_warehouse_time", (Object)reqDto.getEndDate())).in(CollUtil.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).eq((Object)"if_apportion", (Object)0)).eq((Object)"billing_fee_flag", (Object)1)).list()))) {
            List expenseChargingEos = sortingExpenseList.stream().map(expenseEo -> {
                SortingExpenseChargingEo detailEo = new SortingExpenseChargingEo();
                BeanUtil.copyProperties((Object)expenseEo, (Object)detailEo, (String[])new String[]{"id"});
                detailEo.setFeeId(expenseEo.getId());
                detailEo.setBillingOrgCode(expenseEo.getExpenseOrganizationId());
                detailEo.setBillingOrgName(expenseEo.getExpenseOrganizationName());
                detailEo.setAllocationQuantity(expenseEo.getDoneQuantity());
                detailEo.setApportionFee(expenseEo.getSortingNum());
                detailEo.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
                return detailEo;
            }).collect(Collectors.toList());
            this.das.insertBatch(expenseChargingEos);
        }
        if (generateNotApportion.booleanValue()) {
            int pageNum = 1;
            DailyDeliveryReportCostBelongDetailDto belongDetailDto = new DailyDeliveryReportCostBelongDetailDto();
            belongDetailDto.setPageSize(Integer.valueOf(2000));
            belongDetailDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
            belongDetailDto.setOrderShippingTimeStart(DateUtil.formatDateTime((Date)reqDto.getStartDate()));
            belongDetailDto.setOrderShippingTimeEnd(DateUtil.formatDateTime((Date)reqDto.getEndDate()));
            belongDetailDto.setPhysicalWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
            belongDetailDto.setStockApportionId(reqDto.getStockApportionId());
            belongDetailDto.setCostTypeList(costTypeList);
            while (true) {
                belongDetailDto.setPageNum(Integer.valueOf(pageNum));
                this.LOGGER.info("\u5206\u9875\u67e5\u8be2\u8d39\u7528\u5f52\u5c5e\u6570\u636e pageNum\uff1a {}", (Object)pageNum);
                PageInfo pageInfo = this.costBelongDetailService.queryPage(belongDetailDto);
                List costBelongDetailList = pageInfo.getList();
                if (CollUtil.isEmpty((Collection)costBelongDetailList)) {
                    this.LOGGER.info("\u8d39\u7528\u5f52\u5c5e\u6570\u636e\u4e3a\u7a7a pageNum\uff1a {}", (Object)pageNum);
                    break;
                }
                ++pageNum;
                Set notCalculationFeeIds = costBelongDetailList.stream().filter(belongDetail -> !Objects.equals(belongDetail.getApportionStatus(), DailyDeliveryReportStockApportionStatusEnum.ALREADY_APPORTION.getType())).map(DailyDeliveryReportCostBelongDetailDto::getFeeId).filter(Objects::nonNull).collect(Collectors.toSet());
                List feeIds = costBelongDetailList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).filter(Objects::nonNull).filter(feeId -> !notCalculationFeeIds.contains(feeId)).collect(Collectors.toList());
                if (CollUtil.isEmpty(feeIds)) {
                    this.LOGGER.info("\u8d39\u7528\u5f52\u5c5e\u6570\u636e\u65e0\u8d39\u7528\u539f\u59cbid pageNum\uff1a {}", (Object)pageNum);
                    continue;
                }
                List sortingExpenseEos = ((ExtQueryChainWrapper)this.sortingExpenseDas.filter().in((Object)"id", feeIds)).list();
                Map sortingExpenseEoMap = sortingExpenseEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v2));
                Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> feeIdMap = costBelongDetailList.stream().filter(belongDetail -> Objects.nonNull(belongDetail.getFeeId())).collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
                ArrayList expenseEos = Lists.newArrayList();
                for (List<DailyDeliveryReportCostBelongDetailDto> costBelongDetails : feeIdMap.values()) {
                    Long feeId2 = costBelongDetails.get(0).getFeeId();
                    SortingExpenseEo sortingExpenseEo = (SortingExpenseEo)sortingExpenseEoMap.get(feeId2);
                    if (Objects.isNull(sortingExpenseEo)) {
                        this.LOGGER.info("\u5206\u62e3\u539f\u59cb\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728 feeId\uff1a {}", (Object)feeId2);
                        continue;
                    }
                    Iterator<DailyDeliveryReportCostBelongDetailDto> belongDetailIterator = costBelongDetails.iterator();
                    BigDecimal totalSortingNum = sortingExpenseEo.getSortingNum();
                    BigDecimal allFreight = BigDecimal.ZERO;
                    while (belongDetailIterator.hasNext()) {
                        DailyDeliveryReportCostBelongDetailDto belongDetail2 = belongDetailIterator.next();
                        SortingExpenseChargingEo expenseEo2 = (SortingExpenseChargingEo)BeanUtil.copyProperties((Object)sortingExpenseEo, SortingExpenseChargingEo.class, (String[])new String[]{"id"});
                        expenseEo2.setCostType(belongDetail2.getCostType());
                        expenseEo2.setFeeId(sortingExpenseEo.getId());
                        expenseEo2.setAllocationQuantity(belongDetail2.getApportionNum());
                        expenseEo2.setExpenseOrganizationId(belongDetail2.getCostOrgCode());
                        expenseEo2.setExpenseOrganizationName(belongDetail2.getCostOrgName());
                        expenseEo2.setBillingOrgName(belongDetail2.getCostOrgCode());
                        expenseEo2.setBillingOrgName(belongDetail2.getCostOrgName());
                        expenseEo2.setApportionFee(this.apportionSortingExpense(sortingExpenseEo, belongDetail2));
                        if (!belongDetailIterator.hasNext()) {
                            expenseEo2.setApportionFee(NumberUtil.sub((Number)totalSortingNum, (Number)allFreight));
                        }
                        allFreight = allFreight.add(expenseEo2.getApportionFee());
                        expenseEos.add(expenseEo2);
                    }
                }
                this.das.insertBatch((List)expenseEos);
            }
        }
    }

    private BigDecimal apportionSortingExpense(SortingExpenseEo sortingExpenseEo, DailyDeliveryReportCostBelongDetailDto costBelongDetailDto) {
        if (Objects.isNull(sortingExpenseEo) || Objects.isNull(costBelongDetailDto)) {
            return BigDecimal.ZERO;
        }
        BigDecimal doneQuantity = sortingExpenseEo.getDoneQuantity();
        BigDecimal sortingNum = sortingExpenseEo.getSortingNum();
        if (BigDecimalUtils.leZero((BigDecimal)doneQuantity).booleanValue() || BigDecimalUtils.leZero((BigDecimal)sortingNum).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal apportionNum = costBelongDetailDto.getApportionNum();
        if (BigDecimalUtils.leZero((BigDecimal)apportionNum).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sortingTotal = NumberUtil.mul((Number)sortingNum, (Number)apportionNum);
        return NumberUtil.div((Number)sortingTotal, (Number)doneQuantity, (int)2);
    }
}

