/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDocumentTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailChargingDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailChargingService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailService;
import com.dtyunxi.tcbj.dao.das.FinLogisticDetailChargingDas;
import com.dtyunxi.tcbj.dao.eo.FinLogisticDetailChargingEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinLogisticDetailChargingServiceImpl
implements IFinLogisticDetailChargingService {
    private final Logger logger = LoggerFactory.getLogger(FinLogisticDetailChargingServiceImpl.class);
    @Resource
    private FinLogisticDetailChargingDas das;
    @Resource
    private IFinLogisticDetailService finLogisticDetailService;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService dailyDeliveryReportCostBelongDetailService;

    @Override
    public void batchAdd(List<FinLogisticDetailChargingDto> dtoList) {
        this.logger.info("\u6279\u91cf\u65b0\u589e\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List finLogisticDetailChargingEoList = BeanUtil.copyToList(dtoList, FinLogisticDetailChargingEo.class);
        this.das.insertBatch(finLogisticDetailChargingEoList);
    }

    @Override
    public PageInfo<FinLogisticDetailChargingDto> queryPage(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = this.das.queryPage(dto);
        if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(info -> {
                info.setBillTypeStr(DailyDeliveryReportCostBelongDetailCostTypeEnum.getDesc((String)info.getBillType()));
                if (StringUtils.isNotBlank((CharSequence)info.getChargeMode())) {
                    try {
                        ChargeModeEnum chargeModeEnum = ChargeModeEnum.getChargeMode((Integer)Integer.valueOf(info.getChargeMode()));
                        if (null != chargeModeEnum) {
                            info.setChargeModeName(chargeModeEnum.getName());
                        }
                    }
                    catch (Exception e) {
                        info.setChargeModeName(info.getChargeMode());
                    }
                }
            });
        }
        return pageInfo;
    }

    @Override
    public FinLogisticDetailChargingDto queryFlagCount(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u5f02\u5e38\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return this.das.queryFlagCount(dto);
    }

    @Override
    public FinLogisticDetailChargingDto queryDataCount(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u6570\u636e\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        return this.das.queryDataCount(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBillingOrg(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u4fee\u6539\u8ba1\u8d39\u7ec4\u7ec7: {}", (Object)JSON.toJSONString((Object)dto));
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)dto.getIds()), (String)"\u8bf7\u6c42\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a");
        List finLogisticDetailChargingEoList = this.das.selectByIds(dto.getIds());
        AssertUtil.isFalse((boolean)CollectionUtil.isEmpty((Collection)finLogisticDetailChargingEoList), (String)"\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        finLogisticDetailChargingEoList.forEach(eo -> {
            FinLogisticDetailChargingEo updateEo = new FinLogisticDetailChargingEo();
            updateEo.setId(eo.getId());
            updateEo.setBillingOrgCode(dto.getBillingOrgCode());
            updateEo.setBillingOrgName(dto.getBillingOrgName());
            this.das.updateSelective((BaseEo)updateEo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateLogisticDetailCharging(FinLogisticDetailChargingDto reqDto) {
        this.logger.info("\u751f\u6210\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)reqDto.getBookkeepingDate()), (String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        this.logicDel(reqDto);
        if (StringUtils.isBlank((CharSequence)reqDto.getBillType()) || reqDto.getBillType().equals(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            this.generateLogisticDetailChargingForGeneral(reqDto);
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getBillType()) || !reqDto.getBillType().equals(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            this.generateLogisticDetailChargingForCostBelongDetail(reqDto);
        }
    }

    public void generateLogisticDetailChargingForGeneral(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u751f\u6210\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff0c\u5e38\u89c4\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        FinLogisticsDetailReqDto detailReqDto = (FinLogisticsDetailReqDto)BeanUtil.copyProperties((Object)dto, FinLogisticsDetailReqDto.class, (String[])new String[0]);
        detailReqDto.setIfApportion(YesOrNoEnum.NO.getCode());
        detailReqDto.setBillingFeeFlag(YesOrNoEnum.YES.getCode());
        List<FinLogisticDetailRespDto> finLogisticDetailRespDtoList = this.finLogisticDetailService.queryList(detailReqDto);
        if (CollectionUtils.isEmpty(finLogisticDetailRespDtoList)) {
            this.logger.info("\u65e0\u7269\u6d41\u539f\u59cb\u660e\u7ec6\u6570\u636e");
            return;
        }
        List<FinLogisticDetailChargingDto> chargingReqDtoList = finLogisticDetailRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getCostBelongOrgName())).map(detailDto -> {
            FinLogisticDetailChargingDto chargingReqDto = (FinLogisticDetailChargingDto)BeanUtil.copyProperties((Object)detailDto, FinLogisticDetailChargingDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
            chargingReqDto.setFeeId(detailDto.getId());
            chargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            chargingReqDto.setBillingOrgCode(detailDto.getCostBelongOrgCode());
            chargingReqDto.setBillingOrgName(detailDto.getCostBelongOrgName());
            chargingReqDto.setApportionNum(detailDto.getQuantity());
            chargingReqDto.setApportionVolume(detailDto.getTotalVolume());
            chargingReqDto.setApportionWeight(detailDto.getTotalWeight());
            chargingReqDto.setOrgTotalTransportAmount(detailDto.getTotalTransportAmount());
            return chargingReqDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(chargingReqDtoList)) {
            this.batchAdd(chargingReqDtoList);
        }
    }

    public void generateLogisticDetailChargingForCostBelongDetail(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u751f\u6210\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff0c\u5185\u90e8\u4ea4\u6613/\u4eba\u5de5\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        DailyDeliveryReportCostBelongDetailDto queryDto = new DailyDeliveryReportCostBelongDetailDto();
        queryDto.setBookkeepingMonth(dto.getBookkeepingDate());
        queryDto.setType(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        queryDto.setPhysicalWarehouseCodeList(dto.getWarehouseCodeList());
        queryDto.setShipmentEnterpriseCodeList(dto.getLogisticCompanyCodeList());
        queryDto.setTransportStyleList(dto.getTransportTypeList());
        this.logger.info("\u67e5\u8be2\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        List costBelongDetailDtoList = this.dailyDeliveryReportCostBelongDetailService.queryList(queryDto);
        if (CollectionUtils.isEmpty((Collection)costBelongDetailDtoList)) {
            this.logger.info("\u65e0\u751f\u6210\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\uff0c\u4eba\u5de5\u5206\u644a/\u5185\u90e8\u4ea4\u6613\u6570\u636e");
            return;
        }
        this.logger.info("\u67e5\u8be2\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)costBelongDetailDtoList));
        Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> belongDetailMap = costBelongDetailDtoList.stream().collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
        List feeIds = costBelongDetailDtoList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).distinct().collect(Collectors.toList());
        FinLogisticsDetailReqDto detailReqDto = new FinLogisticsDetailReqDto();
        detailReqDto.setIds(feeIds);
        List<FinLogisticDetailRespDto> logisticDetailRespDtoList = this.finLogisticDetailService.queryList(detailReqDto);
        if (CollectionUtils.isEmpty(logisticDetailRespDtoList)) {
            this.logger.info("\u65e0\u4fdd\u8d39\u660e\u7ec6\u539f\u59cb\u8d39\u7528\u4fe1\u606f\u6570\u636e");
            return;
        }
        this.logger.info("\u67e5\u8be2\u539f\u59cb\u8d39\u7528\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(logisticDetailRespDtoList));
        ArrayList<FinLogisticDetailChargingDto> generateChargingDtoList = new ArrayList<FinLogisticDetailChargingDto>();
        List<FinLogisticDetailRespDto> notMergeOrderList = logisticDetailRespDtoList.stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_OTHER.getCode().toString())).collect(Collectors.toList());
        notMergeOrderList.forEach(detail -> {
            List belongDetailDtoList = (List)belongDetailMap.get(detail.getId());
            Map<String, List<DailyDeliveryReportCostBelongDetailDto>> collect = belongDetailDtoList.stream().collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getCostOrgName));
            ArrayList<FinLogisticDetailChargingDto> chargingDtoList = new ArrayList<FinLogisticDetailChargingDto>();
            collect.forEach((k, v) -> {
                BigDecimal apportionNum = v.stream().map(DailyDeliveryReportCostBelongDetailDto::getApportionNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal apportionVolume = v.stream().map(DailyDeliveryReportCostBelongDetailDto::getApportionVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal apportionWeight = v.stream().map(DailyDeliveryReportCostBelongDetailDto::getApportionWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                FinLogisticDetailChargingDto chargingDto = (FinLogisticDetailChargingDto)BeanUtil.copyProperties((Object)detail, FinLogisticDetailChargingDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
                chargingDto.setFeeId(detail.getId());
                chargingDto.setReportId(detail.getReportId());
                chargingDto.setApportionNum(apportionNum);
                chargingDto.setApportionVolume(apportionVolume);
                chargingDto.setApportionWeight(apportionWeight);
                chargingDto.setBillingOrgCode(((DailyDeliveryReportCostBelongDetailDto)v.get(0)).getCostOrgCode());
                chargingDto.setBillingOrgName(((DailyDeliveryReportCostBelongDetailDto)v.get(0)).getCostOrgName());
                chargingDto.setBillType(((DailyDeliveryReportCostBelongDetailDto)v.get(0)).getCostType());
                chargingDtoList.add(chargingDto);
            });
            this.calApportionTransportAmount((List<FinLogisticDetailChargingDto>)chargingDtoList, (FinLogisticDetailRespDto)detail);
            generateChargingDtoList.addAll(chargingDtoList);
        });
        List<String> mergeCodeList = logisticDetailRespDtoList.stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && StringUtils.isNotBlank((CharSequence)f.getMergeCode())).map(FinLogisticDetailRespDto::getMergeCode).distinct().collect(Collectors.toList());
        List<FinLogisticDetailRespDto> mergeLogisticDetailRespDtoList = this.finLogisticDetailService.queryMergeMasterOrderList(mergeCodeList);
        mergeLogisticDetailRespDtoList.forEach(mergeOrder -> {
            List<FinLogisticDetailRespDto> childOrderList = logisticDetailRespDtoList.stream().filter(f -> f.getMergeCode().equals(mergeOrder.getMergeCode())).collect(Collectors.toList());
            ArrayList chargingDtoList = new ArrayList();
            childOrderList.forEach(childOrder -> {
                List childCostBelongDetailDtoList = (List)belongDetailMap.get(childOrder.getId());
                Map<String, List<DailyDeliveryReportCostBelongDetailDto>> collect = childCostBelongDetailDtoList.stream().collect(Collectors.groupingBy(g -> g.getCostOrgName()));
                collect.forEach((k, v) -> {
                    BigDecimal apportionNum = v.stream().map(DailyDeliveryReportCostBelongDetailDto::getApportionNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal apportionVolume = v.stream().map(DailyDeliveryReportCostBelongDetailDto::getApportionVolume).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal apportionWeight = v.stream().map(DailyDeliveryReportCostBelongDetailDto::getApportionWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                    FinLogisticDetailChargingDto chargingDto = (FinLogisticDetailChargingDto)BeanUtil.copyProperties((Object)childOrder, FinLogisticDetailChargingDto.class, (String[])new String[]{"id", "createTime", "createPerson", "updatePerson", "updateTime"});
                    chargingDto.setFeeId(childOrder.getId());
                    chargingDto.setReportId(childOrder.getReportId());
                    chargingDto.setApportionNum(apportionNum);
                    chargingDto.setApportionVolume(apportionVolume);
                    chargingDto.setApportionWeight(apportionWeight);
                    chargingDto.setBillingOrgCode(((DailyDeliveryReportCostBelongDetailDto)v.get(0)).getCostOrgCode());
                    chargingDto.setBillingOrgName(((DailyDeliveryReportCostBelongDetailDto)v.get(0)).getCostOrgName());
                    chargingDto.setBillType(((DailyDeliveryReportCostBelongDetailDto)v.get(0)).getCostType());
                    chargingDtoList.add(chargingDto);
                });
                this.calApportionTransportAmount(chargingDtoList, (FinLogisticDetailRespDto)mergeOrder);
                generateChargingDtoList.addAll(chargingDtoList);
            });
        });
        this.batchAdd(generateChargingDtoList);
    }

    private void calApportionTransportAmount(List<FinLogisticDetailChargingDto> chargingDtoList, FinLogisticDetailRespDto logisticDetail) {
        this.logger.info("\u8ba1\u7b97\u5206\u644a\u8fd0\u8d39\uff1a{}", (Object)JSON.toJSONString(chargingDtoList));
        this.logger.info("\u8ba1\u7b97\u5206\u644a\u8fd0\u8d39\u539f\u5355\uff1a{}", (Object)JSON.toJSONString((Object)logisticDetail));
        if (chargingDtoList.size() <= 1) {
            chargingDtoList.get(0).setOrgTotalTransportAmount(logisticDetail.getTotalTransportAmount());
        }
        int count = 0;
        BigDecimal alreadyApportionTransportAmount = BigDecimal.ZERO;
        block3: for (FinLogisticDetailChargingDto chargingDto : chargingDtoList) {
            boolean isLast;
            boolean bl = isLast = ++count == chargingDtoList.size();
            if (isLast) {
                BigDecimal subtract = logisticDetail.getTotalTransportAmount().subtract(alreadyApportionTransportAmount);
                chargingDto.setOrgTotalTransportAmount(subtract);
                continue;
            }
            if (!ObjectUtil.isNotEmpty((Object)logisticDetail.getChargeMode())) continue;
            switch (ChargeModeEnum.getChargeMode((Integer)Integer.valueOf(logisticDetail.getChargeMode()))) {
                case WEIGHT: {
                    BigDecimal weightProportion = chargingDto.getApportionWeight().divide(logisticDetail.getTotalWeight(), 6, RoundingMode.HALF_UP);
                    BigDecimal weightTransportAmount = weightProportion.multiply(logisticDetail.getTotalTransportAmount());
                    chargingDto.setOrgTotalTransportAmount(weightTransportAmount);
                    continue block3;
                }
            }
            BigDecimal volumeProportion = chargingDto.getApportionVolume().divide(logisticDetail.getTotalVolume(), 6, RoundingMode.HALF_UP);
            BigDecimal volumeTransportAmount = volumeProportion.multiply(logisticDetail.getTotalTransportAmount());
            chargingDto.setOrgTotalTransportAmount(volumeTransportAmount);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logicDel(FinLogisticDetailChargingDto dto) {
        this.logger.info("\u903b\u8f91\u5220\u9664\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        FinLogisticDetailChargingDto delReqDto = (FinLogisticDetailChargingDto)BeanUtil.copyProperties((Object)dto, FinLogisticDetailChargingDto.class, (String[])new String[0]);
        if (StringUtils.isBlank((CharSequence)delReqDto.getBillType())) {
            delReqDto.setBillTypeList(null);
        } else if (delReqDto.getBillType().equals(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            delReqDto.setBillTypeList(Arrays.asList(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType()));
        } else {
            delReqDto.setBillTypeList(Arrays.asList(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType(), DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType()));
        }
        delReqDto.setBillType(null);
        List finLogisticDetailChargingDtoList = this.das.queryList(delReqDto);
        if (CollectionUtils.isNotEmpty((Collection)finLogisticDetailChargingDtoList)) {
            List ids = finLogisticDetailChargingDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
            this.das.logicDeleteByIds(ids);
        }
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        this.logger.info("\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u66f4\u65b0\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)updateReqDto));
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u7269\u6d41\u8ba1\u8d39\u660e\u7ec6\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        FinLogisticDetailChargingEo updateEo = new FinLogisticDetailChargingEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List finLogisticDetailChargingEoList = this.das.selectByIds(updateReqDto.getModuleRecordIdList());
        List list = finLogisticDetailChargingEoList.stream().filter(e -> e.getPlacedFlag() == null || e.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.das.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        this.logger.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }
}

