/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.tcbj.api.dto.ExpressPeakSeasonDto;
import com.dtyunxi.tcbj.biz.dto.express.WeightRatioExtDto;
import com.dtyunxi.tcbj.dao.das.ExpressCostAreaDas;
import com.dtyunxi.tcbj.dao.das.ItemExtendDas;
import com.dtyunxi.tcbj.dao.das.OutResultOrderDetailDas;
import com.dtyunxi.tcbj.dao.eo.ExpressCostAreaEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostContractEo;
import com.dtyunxi.tcbj.dao.eo.ExpressCostDetailEo;
import com.dtyunxi.tcbj.dao.eo.ItemExtendEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderDetailEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCostReportService {
    private static Logger logger = LoggerFactory.getLogger(AbstractCostReportService.class);
    @Resource
    private ExpressCostAreaDas expressCostAreaDas;
    @Resource
    private OutResultOrderDetailDas outResultOrderDetailDas;
    @Resource
    private ItemExtendDas itemExtendDas;

    public abstract ExpressCostDetailEo calculationData(ExpressCostDetailEo var1);

    public void setAbnormalCauses(ExpressCostDetailEo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getAbnormalCauses())) {
            msgDto.setAbnormalCauses(errorMsg);
        } else {
            msgDto.setAbnormalCauses(String.format("%s\u3001%s", msgDto.getAbnormalCauses(), errorMsg));
        }
        msgDto.setAbnormal(Integer.valueOf(1));
    }

    public ExpressCostAreaEo getAppointArea(ExpressCostDetailEo eo) {
        if (ObjectUtils.isNotEmpty((Object)eo.getExpressCostAreaEo())) {
            return eo.getExpressCostAreaEo();
        }
        return this.selectAppointArea(eo.getContractId(), eo.getProvince(), eo.getCity(), eo.getArea());
    }

    public ExpressCostAreaEo selectAppointArea(Long contractId, String province, String city, String area) {
        if (contractId == null || StringUtils.isBlank((CharSequence)province)) {
            return null;
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).likeRight((Object)"province", (Object)province);
        if (StringUtils.isNotBlank((CharSequence)city) && StringUtils.isNotBlank((CharSequence)area)) {
            ExpressCostAreaEo eo = (ExpressCostAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)filter.likeRight((Object)"city", (Object)city)).likeRight((Object)"area", (Object)area)).last("limit 1")).one();
            if (eo != null) {
                return eo;
            }
            eo = (ExpressCostAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).likeRight((Object)"province", (Object)province)).likeRight((Object)"city", (Object)city)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"area")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one();
            if (eo != null) {
                return eo;
            }
            eo = (ExpressCostAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).likeRight((Object)"province", (Object)province)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"city")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"city", (Object)"");
                });
            })).and(n -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)n.isNull((Object)"area")).or(m -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)m.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one();
            if (eo != null) {
                return eo;
            }
        } else {
            ExpressCostAreaEo eo;
            if (StringUtils.isNotBlank((CharSequence)city) && StringUtils.isBlank((CharSequence)area) && (eo = (ExpressCostAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).eq((Object)"province", (Object)province)).eq((Object)"city", (Object)city)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"area")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one()) != null) {
                return eo;
            }
            eo = (ExpressCostAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.expressCostAreaDas.filter().eq((Object)"contract_id", (Object)contractId)).eq((Object)"province", (Object)province)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)"city")).or(j -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)j.eq((Object)"city", (Object)"");
                });
            })).and(n -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)n.isNull((Object)"area")).or(m -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)m.eq((Object)"area", (Object)"");
                });
            })).last("limit 1")).one();
            if (eo != null) {
                return eo;
            }
        }
        return null;
    }

    public void setWeightRange(ExpressCostDetailEo eo) {
        BigDecimal weight = ObjectUtils.isNotEmpty((Object)eo.getChargedWeight()) ? eo.getChargedWeight() : BigDecimal.ZERO;
        BigDecimal volumeWeight = eo.getVolumeWeight() != null ? eo.getVolumeWeight() : BigDecimal.ZERO;
        BigDecimal calculateWeight = weight;
        if (volumeWeight.compareTo(weight) > 0) {
            calculateWeight = volumeWeight;
        }
        if (calculateWeight.compareTo(BigDecimal.ZERO) > 0 && calculateWeight.compareTo(new BigDecimal(0.5)) <= 0) {
            eo.setWeightRange("0\uff1cX\u22640.5");
        } else if (calculateWeight.compareTo(new BigDecimal(0.5)) > 0 && calculateWeight.compareTo(BigDecimal.ONE) <= 0) {
            eo.setWeightRange("0.5\uff1cX\u22641");
        } else if (calculateWeight.compareTo(BigDecimal.ONE) > 0 && calculateWeight.compareTo(BigDecimal.valueOf(2L)) <= 0) {
            eo.setWeightRange("1\uff1cX\u22642");
        } else if (calculateWeight.compareTo(BigDecimal.valueOf(2L)) > 0 && calculateWeight.compareTo(BigDecimal.valueOf(3L)) <= 0) {
            eo.setWeightRange("2\uff1cX\u22643");
        } else if (calculateWeight.compareTo(BigDecimal.valueOf(3L)) > 0) {
            eo.setWeightRange("\uff1e3");
        }
        eo.setCalculationWeight(calculateWeight);
    }

    protected void setCalculationInfo(ExpressCostDetailEo eo, ExpressCostContractEo contractEo, ExpressCostAreaEo expressCostAreaEo) {
        eo.setContractAreaInfo(JSON.toJSONString((Object)expressCostAreaEo));
        eo.setContractInfo(JSON.toJSONString((Object)contractEo));
        eo.setPackingFreight(contractEo.getPackingPrice());
    }

    protected void calculationPremium(ExpressCostDetailEo eo, ExpressCostContractEo contractEo) {
        logger.info("\u8ba1\u7b97\u4fdd\u8d39calculationPremium\uff1a{}", (Object)JSON.toJSONString((Object)eo));
        logger.info("\u8ba1\u7b97\u4fdd\u8d39\u5408\u540ccalculationPremium\uff1a{}", (Object)JSON.toJSONString((Object)contractEo));
        if (ObjectUtils.isNotEmpty((Object)contractEo.getPremiumType()) && contractEo.getPremiumType().equals(1)) {
            eo.setPremium(contractEo.getPremiumAmount());
            return;
        }
        if (contractEo.getPremiumRatio() == null || contractEo.getInsureDiscount() == null || !eo.getCalculationPremiumFlag().booleanValue()) {
            return;
        }
        List detailEos = ((ExtQueryChainWrapper)this.outResultOrderDetailDas.filter().eq((Object)"document_no", (Object)eo.getOutboundCode())).list(Integer.valueOf(10000));
        Set longCodes = detailEos.stream().map(OutResultOrderDetailEo::getSkuCode).collect(Collectors.toSet());
        List extendEos = ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", (Collection)Lists.newArrayList(longCodes))).list(Integer.valueOf(longCodes.size()));
        BigDecimal itemAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)extendEos)) {
            Map itemMap = extendEos.stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity(), (k1, k2) -> k1));
            for (OutResultOrderDetailEo detailEo : detailEos) {
                if (itemMap.containsKey(detailEo.getSkuCode())) {
                    BigDecimal recommendPrice;
                    ItemExtendEo itemExtendEo = (ItemExtendEo)itemMap.get(detailEo.getSkuCode());
                    BigDecimal bigDecimal = recommendPrice = itemExtendEo.getRecommendPrice() != null ? itemExtendEo.getRecommendPrice() : itemExtendEo.getClaimPrice();
                    if (recommendPrice == null) {
                        this.setAbnormalCauses(eo, String.format("\u3010%s\u3011\u96f6\u552e\u4ef7\u683c\u4e3a\u7a7a\u4e0d\u80fd\u8ba1\u7b97\u6295\u4fdd\u91d1\u989d\u548c\u4fdd\u8d39", detailEo.getSkuCode()));
                        continue;
                    }
                    itemAmount = itemAmount.add(detailEo.getQuantity().multiply(recommendPrice));
                    continue;
                }
                this.setAbnormalCauses(eo, String.format("\u3010%s\u3011\u96f6\u552e\u4ef7\u683c\u4e3a\u7a7a\u4e0d\u80fd\u8ba1\u7b97\u6295\u4fdd\u91d1\u989d\u548c\u4fdd\u8d39", detailEo.getSkuCode()));
            }
        } else {
            this.setAbnormalCauses(eo, String.format("\u3010%s\u3011\u96f6\u552e\u4ef7\u683c\u4e3a\u7a7a\u4e0d\u80fd\u8ba1\u7b97\u6295\u4fdd\u91d1\u989d\u548c\u4fdd\u8d39", longCodes.stream().collect(Collectors.joining("\u3001"))));
        }
        if (Objects.equals(eo.getAbnormal(), 0)) {
            BigDecimal insureAmount = itemAmount.multiply(contractEo.getInsureDiscount());
            eo.setInsureAmount(insureAmount);
            BigDecimal premium = insureAmount;
            if (contractEo.getPremiumRatio() != null) {
                premium = premium.multiply(contractEo.getPremiumRatio()).divide(new BigDecimal("100"));
            }
            if (ObjectUtils.isNotEmpty((Object)contractEo.getAscentRatio())) {
                premium = premium.multiply(contractEo.getAscentRatio().divide(BigDecimal.valueOf(100L)));
            }
            eo.setPremium(premium);
        }
    }

    protected void calculationAmount(ExpressCostDetailEo eo) {
        if (Objects.equals(0, eo.getAbnormal())) {
            BigDecimal totalFreight;
            BigDecimal continuedFreight = BigDecimal.ZERO;
            if (eo.getContinuedOne() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedOne());
            }
            if (eo.getContinuedTwo() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedTwo());
            }
            if (eo.getContinuedThree() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedThree());
            }
            if (eo.getContinuedFour() != null) {
                continuedFreight = continuedFreight.add(eo.getContinuedFour());
            }
            if (continuedFreight.compareTo(BigDecimal.ZERO) > 0) {
                eo.setContinuedFreight(continuedFreight);
            }
            BigDecimal bigDecimal = totalFreight = eo.getFirstPrice() != null ? eo.getFirstPrice() : BigDecimal.ZERO;
            if (eo.getContinuedFreight() != null) {
                totalFreight = totalFreight.add(eo.getContinuedFreight());
            }
            if (eo.getFloatAmount() != null) {
                totalFreight = totalFreight.add(eo.getFloatAmount());
            }
            if (eo.getPackingFreight() != null) {
                totalFreight = totalFreight.add(eo.getPackingFreight());
            }
            if (eo.getReturnFee() != null) {
                totalFreight = totalFreight.add(eo.getReturnFee());
            }
            if (eo.getIncrementFreight() != null) {
                totalFreight = totalFreight.add(eo.getIncrementFreight());
            }
            if (eo.getPremium() != null) {
                totalFreight = totalFreight.add(eo.getPremium());
            }
            if (eo.getAdjustmentAmount() != null) {
                totalFreight = Objects.equals(eo.getAdjustmentType(), "1") ? totalFreight.add(eo.getAdjustmentAmount()) : totalFreight.subtract(eo.getAdjustmentAmount());
            }
            if (totalFreight.compareTo(BigDecimal.ZERO) > 0) {
                eo.setTotalFreight(totalFreight);
            }
        }
    }

    protected BigDecimal calculateWeight(BigDecimal weight) {
        weight = weight.compareTo(BigDecimal.TEN) < 0 ? weight.setScale(1, 4) : (weight.compareTo(BigDecimal.valueOf(100L)) > 0 ? weight.setScale(0, 4) : this.estimateWeight(weight));
        return weight;
    }

    private BigDecimal estimateWeight(BigDecimal weight) {
        String[] split = (weight = weight.setScale(1, 1)).toString().split("\\.");
        String num = split[1];
        weight = Integer.valueOf(num) > 5 ? (Integer.valueOf(num) >= 8 ? new BigDecimal(split[0]).add(BigDecimal.ONE) : new BigDecimal(split[0]).add(new BigDecimal(0.5))) : (Integer.valueOf(num) >= 3 ? new BigDecimal(split[0]).add(new BigDecimal(0.5)) : new BigDecimal(split[0]));
        return weight;
    }

    protected void converWeight(ExpressCostDetailEo returnEo, ExpressCostContractEo costContractEo) {
        BigDecimal volume = returnEo.getVolume();
        BigDecimal volumeWeight = BigDecimal.ZERO;
        BigDecimal weight = returnEo.getWeight();
        if (costContractEo.getWeightRatio() != null) {
            BigDecimal multiply = volume.multiply(new BigDecimal("1000000"));
            volumeWeight = multiply.divide(costContractEo.getWeightRatio(), 6, RoundingMode.HALF_UP);
        }
        returnEo.setVolumeWeight(volumeWeight);
        returnEo.setWeight(weight);
        if (ObjectUtils.isNotEmpty((Object)returnEo.getExpressWeight()) && returnEo.getExpressWeight().compareTo(BigDecimal.ZERO) > 0 && (BigDecimalUtils.subtract((BigDecimal)returnEo.getExpressWeight(), (BigDecimal)returnEo.getChargedWeight()).compareTo(BigDecimal.valueOf(1L)) > 0 || BigDecimalUtils.subtract((BigDecimal)returnEo.getExpressWeight(), (BigDecimal)returnEo.getChargedWeight()).compareTo(BigDecimal.valueOf(-1L)) < 0)) {
            this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e0e\u5feb\u9012\u8ba1\u8d39\u91cd\u91cf\u5dee\u503c\u8d85\u8fc71kg");
        }
    }

    protected void converWeightThree(ExpressCostDetailEo returnEo, ExpressCostContractEo costContractEo) {
        BigDecimal volume = returnEo.getVolume();
        volume = volume.multiply(new BigDecimal("1000000"));
        BigDecimal volumeWeight = BigDecimal.ZERO;
        BigDecimal weight = returnEo.getWeight();
        if (costContractEo.getWeightType().equals(1) && volume != null && costContractEo.getWeightRatio() != null) {
            volumeWeight = volume.divide(costContractEo.getWeightRatio(), 6, RoundingMode.HALF_UP);
        } else if (costContractEo.getWeightType().equals(2) && StringUtils.isNotBlank((CharSequence)costContractEo.getWeightRatioExt())) {
            WeightRatioExtDto dto = (WeightRatioExtDto)JSON.parseObject((String)costContractEo.getWeightRatioExt(), WeightRatioExtDto.class);
            if (dto.getComparator().equals("\u5c0f\u4e8e\u7b49\u4e8e") && weight.compareTo(new BigDecimal(dto.getLimitWeight())) <= 0) {
                volumeWeight = BigDecimalUtils.divide((BigDecimal)volume, (BigDecimal)new BigDecimal(dto.getOneRatio()), (int)6);
            } else if (dto.getComparator().equals("\u5c0f\u4e8e\u7b49\u4e8e") && weight.compareTo(new BigDecimal(dto.getLimitWeight())) > 0) {
                volumeWeight = BigDecimalUtils.divide((BigDecimal)volume, (BigDecimal)new BigDecimal(dto.getTwoRatio()), (int)6);
            } else if (dto.getComparator().equals("\u5c0f\u4e8e") && weight.compareTo(new BigDecimal(dto.getLimitWeight())) < 0) {
                volumeWeight = BigDecimalUtils.divide((BigDecimal)volume, (BigDecimal)new BigDecimal(dto.getOneRatio()), (int)6);
            } else if (dto.getComparator().equals("\u5c0f\u4e8e") && weight.compareTo(new BigDecimal(dto.getLimitWeight())) >= 0) {
                volumeWeight = BigDecimalUtils.divide((BigDecimal)volume, (BigDecimal)new BigDecimal(dto.getTwoRatio()), (int)6);
            }
        }
        BigDecimal chargedWeight = Optional.ofNullable(volumeWeight).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(weight).orElse(BigDecimal.ZERO)) > 0 ? volumeWeight : weight;
        returnEo.setVolumeWeight(volumeWeight);
        returnEo.setWeight(weight);
        BigDecimal expressWeight = Optional.ofNullable(returnEo.getExpressWeight()).orElse(BigDecimal.ZERO);
        if (expressWeight.compareTo(BigDecimal.ZERO) > 0 && (BigDecimalUtils.subtract((BigDecimal)expressWeight, (BigDecimal)returnEo.getChargedWeight()).compareTo(BigDecimal.valueOf(1L)) > 0 || BigDecimalUtils.subtract((BigDecimal)expressWeight, (BigDecimal)returnEo.getChargedWeight()).compareTo(BigDecimal.valueOf(-1L)) < 0)) {
            this.setAbnormalCauses(returnEo, "\u8ba1\u8d39\u91cd\u91cf\u4e0e\u5feb\u9012\u8ba1\u8d39\u91cd\u91cf\u5dee\u503c\u8d85\u8fc71kg");
        }
    }

    protected boolean ifPeakSeasonHit(String peakSeason, Date date) {
        logger.info("\u5224\u65ad\u51fa\u5e93\u65f6\u95f4\u662f\u5426\u547d\u4e2d\u65fa\u5b63\uff1a{}\uff0c{}", (Object)peakSeason, (Object)date);
        if (StringUtils.isBlank((CharSequence)peakSeason) || ObjectUtils.isEmpty((Object)date)) {
            return false;
        }
        try {
            List peakSeasonDtoList = JSONArray.parseArray((String)peakSeason, ExpressPeakSeasonDto.class);
            if (CollectionUtils.isEmpty((Collection)peakSeasonDtoList)) {
                return false;
            }
            logger.info("\u65fa\u5b63\u65e5\u671fJSON\uff1a{}", (Object)JSON.toJSONString((Object)peakSeasonDtoList));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int moth = calendar.get(2) + 1;
            int day = calendar.get(5);
            for (ExpressPeakSeasonDto dto : peakSeasonDtoList) {
                if (!ObjectUtils.isNotEmpty((Object)dto.getMonth()) || !CollectionUtils.isNotEmpty((Collection)dto.getDays()) || moth != dto.getMonth() || !dto.getDays().contains(day)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u51fa\u5e93\u65f6\u95f4\u662f\u5426\u547d\u4e2d\u6de1\u65fa\u5b63\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected void calculateOcsSystemWeight(ExpressCostDetailEo returnEo) {
        if (ObjectUtils.isEmpty((Object)returnEo)) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)returnEo.getWeight()) && ObjectUtils.isEmpty((Object)returnEo.getVolumeWeight())) {
            returnEo.setOcsSystemWeight(null);
        } else if (ObjectUtils.isNotEmpty((Object)returnEo.getWeight()) && ObjectUtils.isNotEmpty((Object)returnEo.getVolumeWeight())) {
            returnEo.setOcsSystemWeight(returnEo.getWeight().compareTo(returnEo.getVolumeWeight()) >= 0 ? returnEo.getWeight() : returnEo.getVolumeWeight());
        } else if (ObjectUtils.isNotEmpty((Object)returnEo.getWeight())) {
            returnEo.setOcsSystemWeight(returnEo.getWeight());
        } else if (ObjectUtils.isNotEmpty((Object)returnEo.getVolumeWeight())) {
            returnEo.setOcsSystemWeight(returnEo.getVolumeWeight());
        } else {
            returnEo.setOcsSystemWeight(null);
        }
    }

    protected void calculateIncrementFreight(ExpressCostDetailEo detailEo, ExpressCostContractEo costContractEo) {
        List pcpRegionRespDtoList;
        logger.info("\u589e\u503c\u8d39\u8ba1\u7b97\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)detailEo), (Object)JSON.toJSONString((Object)costContractEo));
        if (ObjectUtils.isEmpty((Object)costContractEo.getAccretionAmount()) || StringUtils.isBlank((CharSequence)costContractEo.getRemoteArea())) {
            logger.info("\u65e0\u589e\u503c\u8d39\u6216\u65e0\u504f\u8fdc\u5730\u533a");
            return;
        }
        List regionRespDtoList = JSONArray.parseArray((String)costContractEo.getRemoteArea(), PcpRegionRespDto.class);
        if (CollectionUtils.isEmpty((Collection)regionRespDtoList)) {
            logger.info("\u65e0\u504f\u8fdc\u5730\u533a\u6570\u636e ");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)detailEo.getProvince()) && CollectionUtils.isNotEmpty(pcpRegionRespDtoList = regionRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getName()) && f.getName().equals(detailEo.getProvince())).collect(Collectors.toList()))) {
            detailEo.setIncrementFreight(costContractEo.getAccretionAmount());
            logger.info("\u7701\u5339\u914d\u6210\u529f");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)detailEo.getProvince()) && StringUtils.isNotBlank((CharSequence)detailEo.getCity()) && CollectionUtils.isNotEmpty(pcpRegionRespDtoList = regionRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getName()) && f.getName().equals(detailEo.getCity()) && StringUtils.isNotBlank((CharSequence)f.getParentName()) && f.getParentName().equals(detailEo.getProvince())).collect(Collectors.toList()))) {
            detailEo.setIncrementFreight(costContractEo.getAccretionAmount());
            logger.info("\u57ce\u5339\u914d\u6210\u529f");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)detailEo.getArea()) && StringUtils.isNotBlank((CharSequence)detailEo.getCity()) && CollectionUtils.isNotEmpty(pcpRegionRespDtoList = regionRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getName()) && f.getName().equals(detailEo.getArea()) && StringUtils.isNotBlank((CharSequence)f.getParentName()) && f.getParentName().equals(detailEo.getCity())).collect(Collectors.toList()))) {
            detailEo.setIncrementFreight(costContractEo.getAccretionAmount());
            logger.info("\u533a\u5339\u914d\u6210\u529f");
            return;
        }
        logger.info("\u975e\u504f\u8fdc\u5730\u533a");
    }
}

