/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.dtyunxi.tcbj.api.dto.request.ClaimOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.ClaimOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.CommonAddrRespDto;
import com.dtyunxi.tcbj.api.dto.response.PlatformOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.tcbj.biz.service.IPlatformOrderService;
import com.dtyunxi.tcbj.dao.das.PlatformOrderDas;
import com.dtyunxi.tcbj.dao.eo.PlatformOrderEo;
import com.dtyunxi.tcbj.dao.vo.PlatformOrderRespVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlatformOrderServiceImpl
implements IPlatformOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PlatformOrderServiceImpl.class);
    @Resource
    private PlatformOrderDas platformOrderDas;

    @Override
    public Long addPlatformOrder(PlatformOrderReqDto addReqDto) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)platformOrderEo);
        this.platformOrderDas.insert((BaseEo)platformOrderEo);
        return platformOrderEo.getId();
    }

    @Override
    public void modifyPlatformOrder(PlatformOrderReqDto modifyReqDto) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)platformOrderEo);
        this.platformOrderDas.updateSelective((BaseEo)platformOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePlatformOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.platformOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PlatformOrderRespDto queryById(Long id) {
        PlatformOrderEo platformOrderEo = (PlatformOrderEo)this.platformOrderDas.selectByPrimaryKey(id);
        PlatformOrderRespDto platformOrderRespDto = new PlatformOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderEo, (BaseVo)platformOrderRespDto);
        return platformOrderRespDto;
    }

    @Override
    public PageInfo<PlatformOrderRespDto> queryByPage(PlatformOrderReqDto filter) {
        Page platformOrderRespVos = this.platformOrderDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)platformOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List platformOrderRespVoList = platformOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)platformOrderRespVoList)) {
            Map<Long, PlatformOrderRespVo> platformOrderRespVoMap = platformOrderRespVoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (a1, a2) -> a2));
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)platformOrderRespVoList, PlatformOrderRespDto.class);
            for (PlatformOrderRespDto dto : respDto) {
                CommonAddrRespDto orderAddress = new CommonAddrRespDto();
                PlatformOrderRespVo platformOrderRespVo = platformOrderRespVoMap.get(dto.getId());
                if (platformOrderRespVo != null) {
                    CubeBeanUtils.copyProperties((Object)orderAddress, (Object)platformOrderRespVo, (String[])new String[0]);
                }
                dto.setOrderAddress(orderAddress);
            }
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public PlatformOrderCountRespDto queryByCount(PlatformOrderReqDto filter) {
        if (StringUtils.isNotBlank((CharSequence)filter.getType()) && filter.getType().equals(BusinessTypeCodeEnum.COMPENSATION_ORDER.getCode())) {
            return this.platformOrderDas.queryCompensationOrderByCount(filter);
        }
        return this.platformOrderDas.queryByCount(filter);
    }

    @Override
    public PageInfo<ClaimOrderDetailRespDto> claimOrderDetailReportPage(ClaimOrderDetailReqDto req) {
        logger.info("\u7d22\u8d54\u8ba2\u5355\u660e\u7ec6\u62a5\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        return this.platformOrderDas.claimOrderDetailReportPage(req);
    }
}

